/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.ECFPGenerator;
import chemaxon.descriptors.ECFPParameters;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDParameters;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.Metrics;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.struc.Molecule;
import java.text.ParseException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class ECFP
extends MolecularDescriptor
implements Licensable {
    protected int[] ids = null;
    protected int[] fp = null;
    protected int brightness;
    private static final String[] metrics = new String[]{"Tanimoto", "Euclidean"};
    private static final float[] defaultThresholds = new float[]{0.5f, 10.0f};
    private int defaultMetricIndex = 0;
    private String licenseEnvironment = "";

    public ECFP() {
    }

    public ECFP(ECFPParameters params) {
        super(params);
        this.clear();
    }

    public ECFP(String params) {
        this.setParameters(params);
    }

    public ECFP(ECFP ecfp) {
        super(ecfp.params);
        if (ecfp.ids != null) {
            this.ids = new int[ecfp.ids.length];
            System.arraycopy(ecfp.ids, 0, this.ids, 0, this.ids.length);
        } else {
            this.ids = null;
        }
        this.fp = null;
    }

    @Override
    public ECFP clone() {
        return new ECFP(this);
    }

    private void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("ECFP/FCFP", this.licenseEnvironment);
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("ECFP/FCFP", this.licenseEnvironment);
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    @Override
    public String getName() {
        return "ECFP fingerprint";
    }

    @Override
    public String getShortName() {
        return "ECFP";
    }

    @Override
    public String getParametersClassName() {
        return "chemaxon.descriptors.ECFPParameters";
    }

    @Override
    public void setParameters(MDParameters parameters) throws MDParametersException {
        super.setParameters(parameters);
        this.clear();
    }

    @Override
    public void setParameters(String parameters) throws MDParametersException {
        if (this.params == null) {
            super.setParameters(new ECFPParameters(parameters));
        } else {
            this.params.fromString(parameters);
        }
        this.clear();
    }

    public void clear() {
        this.ids = new int[0];
        this.fp = null;
    }

    @Override
    public byte[] toData() {
        byte[] d = new byte[4 + this.ids.length * 4];
        int n = this.ids.length;
        for (int j = 3; j >= 0; --j) {
            d[j] = (byte)(n & 0xFF);
            n >>>= 8;
        }
        for (int i = 0; i < this.ids.length; ++i) {
            int v = this.ids[i];
            for (int j = 3; j >= 0; --j) {
                d[4 + i * 4 + j] = (byte)(v & 0xFF);
                v >>>= 8;
            }
        }
        return d;
    }

    @Override
    public void fromData(byte[] data) {
        this.checkLicense();
        int n = 0;
        for (int j = 0; j < 4; ++j) {
            n <<= 8;
            n |= data[j] & 0xFF;
        }
        this.ids = new int[n];
        for (int i = 0; i < this.ids.length; ++i) {
            int v = 0;
            for (int j = 0; j < 4; ++j) {
                v <<= 8;
                v |= data[4 + i * 4 + j] & 0xFF;
            }
            this.ids[i] = v;
        }
        this.fp = null;
    }

    @Override
    public final String toString() {
        return this.toDecimalString();
    }

    @Override
    public final String toDecimalString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.ids.length; ++i) {
            if (i > 0) {
                sb.append('\t');
            }
            sb.append(this.ids[i]);
        }
        return sb.toString();
    }

    @Override
    public String toBinaryString() {
        this.requireBinaryVector();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.params.getLength(); ++i) {
            sb.append(this.get(i));
            if ((i + 1) % 8 != 0) continue;
            sb.append('|');
        }
        return sb.toString();
    }

    @Override
    public final void fromString(String ecfp) throws ParseException {
        this.checkLicense();
        try {
            StringTokenizer st = new StringTokenizer(ecfp, "\t ");
            int n = st.countTokens();
            this.ids = new int[n];
            for (int i = 0; i < n; ++i) {
                this.ids[i] = Integer.parseInt(st.nextToken());
            }
        }
        catch (NullPointerException npe) {
            throw new ParseException(ecfp + " too short", 0);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(ecfp + " contains invalid numbers", 0);
        }
        this.fp = null;
    }

    @Override
    public float[] toFloatArray() {
        float[] array = new float[this.ids.length * 2];
        for (int i = 0; i != this.ids.length; ++i) {
            array[i * 2] = this.ids[i] >> 16;
            array[i * 2 + 1] = this.ids[i] & 0xFFFF;
        }
        return array;
    }

    @Override
    public void fromFloatArray(float[] descr) {
        this.checkLicense();
        this.ids = new int[descr.length / 2];
        for (int i = 0; i != this.ids.length; ++i) {
            this.ids[i] = (int)descr[i * 2] << 16 | (int)descr[i * 2 + 1] & 0xFFFF;
        }
        this.fp = null;
    }

    public int[] toIntArray() {
        return (int[])this.ids.clone();
    }

    public void fromIntArray(int[] array) {
        this.checkLicense();
        this.ids = (int[])array.clone();
        Arrays.sort(this.ids);
        this.fp = null;
    }

    public Set<Integer> toIdentiferSet() {
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int f : this.ids) {
            set.add(f);
        }
        return set;
    }

    public void fromIdentiferSet(Set<Integer> set) {
        this.checkLicense();
        this.ids = new int[set.size()];
        int i = 0;
        for (Integer x : set) {
            this.ids[i++] = x;
        }
        this.fp = null;
    }

    public Set<Integer> toFeatureSet() {
        return this.toIdentiferSet();
    }

    public void fromFeatureSet(Set<Integer> set) {
        this.fromIdentiferSet(set);
    }

    public BitSet toBitSet() {
        this.requireBinaryVector();
        BitSet bitSet = new BitSet(this.fp.length * 32);
        for (int i = 0; i != this.fp.length; ++i) {
            int x = this.fp[i];
            for (int j = 31; j >= 0; --j) {
                if ((x & 1) != 0) {
                    bitSet.set(i * 32 + j);
                }
                x >>= 1;
            }
        }
        return bitSet;
    }

    public int getIdentiferCount() {
        return this.ids.length;
    }

    public int getFeatureCount() {
        return this.ids.length;
    }

    public int getBrightness() {
        this.requireBinaryVector();
        return this.brightness;
    }

    protected void requireBinaryVector() {
        if (this.fp == null) {
            this.fp = new int[this.params.getInternalSize()];
            Arrays.fill(this.fp, 0);
            for (int f : this.ids) {
                int pos = ECFPGenerator.getBitPosition(f, (ECFPParameters)this.params);
                int n = pos / 32;
                this.fp[n] = this.fp[n] | 1 << 31 - pos % 32;
            }
            this.brightness = 0;
            for (int i : this.fp) {
                this.brightness += Metrics.calcBitCount(i);
            }
        }
    }

    public void dropBinaryVector() {
        this.fp = null;
    }

    private int get(int cellIndex) {
        this.requireBinaryVector();
        return (this.fp[cellIndex / 32] & 1 << 31 - cellIndex % 32) == 0 ? 0 : 1;
    }

    @Override
    public String[] generate(Molecule m) throws MDGeneratorException {
        try {
            return ((ECFPParameters)this.params).generate(m, this);
        }
        catch (NullPointerException ne) {
            ne.printStackTrace();
            throw new MDGeneratorException("Parameters are not set properly.");
        }
    }

    @Override
    public String[] getDissimilarityMetrics() {
        return metrics;
    }

    @Override
    public float[] getDefaultDissimilarityMetricThresholds() {
        return defaultThresholds;
    }

    @Override
    public int getDefaultMetricIndex() {
        return this.defaultMetricIndex;
    }

    @Override
    public float getDefaultThreshold(int metricIndex) {
        return defaultThresholds[metricIndex];
    }

    private int getCommonBitCount(ECFP f) {
        this.requireBinaryVector();
        f.requireBinaryVector();
        int x = 0;
        for (int i = 0; i < this.fp.length; ++i) {
            x += Metrics.calcBitCount(this.fp[i] & f.fp[i]);
        }
        return x;
    }

    public float getTanimoto(ECFP f) {
        this.requireBinaryVector();
        f.requireBinaryVector();
        int x = 0;
        int y = this.brightness;
        int z = f.brightness;
        for (int i = 0; i < this.fp.length; ++i) {
            x += Metrics.calcBitCount(this.fp[i] & f.fp[i]);
        }
        if (this.params.isAsymmetric()) {
            float alpha = this.params.getAsymmetryFactor();
            return 1.0f - (float)x / (alpha * (float)(y - x) + (1.0f - alpha) * (float)(z - x) + (float)x);
        }
        return y + z - x == 0 ? 0.0f : 1.0f - (float)x / (float)(y + z - x);
    }

    public float getEuclidean(ECFP f) {
        this.requireBinaryVector();
        f.requireBinaryVector();
        boolean norm = this.params.isNormalized();
        int x = 0;
        int y = 0;
        int z = 0;
        for (int i = 0; i < this.fp.length; ++i) {
            x += Metrics.calcBitCount(this.fp[i] ^ f.fp[i]);
            if (!norm) continue;
            y += Metrics.calcBitCount(this.fp[i]);
            z += Metrics.calcBitCount(f.fp[i]);
        }
        return norm ? (float)(Math.sqrt(x) / (Math.sqrt(y) + Math.sqrt(z))) : (float)Math.sqrt(x);
    }

    public float getWeightedEuclidean(ECFP f) {
        this.requireBinaryVector();
        f.requireBinaryVector();
        boolean norm = this.params.isNormalized();
        float x = 0.0f;
        int y = 0;
        int z = 0;
        float[] w = this.params.getWeights();
        for (int i = 0; i < this.fp.length; ++i) {
            int fi = this.fp[i] ^ f.fp[i];
            for (int bi = 31; bi >= 0; --bi) {
                x += w[i * 32 + bi] * (float)(fi & 1);
                fi >>= 1;
            }
            if (!norm) continue;
            y += Metrics.calcBitCount(this.fp[i]);
            z += Metrics.calcBitCount(f.fp[i]);
        }
        return norm ? (float)(Math.sqrt(x) / (Math.sqrt(y) + Math.sqrt(z))) : (float)Math.sqrt(x);
    }

    public float getAsymmetricEuclidean(ECFP f) {
        this.requireBinaryVector();
        f.requireBinaryVector();
        boolean norm = this.params.isNormalized();
        float x = 0.0f;
        int y = 0;
        int z = 0;
        float a = this.params.getAsymmetryFactor();
        for (int i = 0; i < this.fp.length; ++i) {
            int f1i = this.fp[i];
            int f2i = f.fp[i];
            for (int bi = 31; bi >= 0; --bi) {
                int b1 = f1i & 1;
                int b2 = f2i & 1;
                f1i >>= 1;
                f2i >>= 1;
                if (b1 == b2) continue;
                x += b1 == 1 ? a : 1.0f - a;
            }
            if (!norm) continue;
            y += Metrics.calcBitCount(this.fp[i]);
            z += Metrics.calcBitCount(f.fp[i]);
        }
        return norm ? (float)(Math.sqrt(x) / (Math.sqrt(y) + Math.sqrt(z))) : (float)Math.sqrt(x);
    }

    public float getWeightedAsymmetricEuclidean(ECFP f) {
        this.requireBinaryVector();
        f.requireBinaryVector();
        boolean norm = this.params.isNormalized();
        float x = 0.0f;
        int y = 0;
        int z = 0;
        float[] w = this.params.getWeights();
        float a = this.params.getAsymmetryFactor();
        for (int i = 0; i < this.fp.length; ++i) {
            int f1i = this.fp[i];
            int f2i = f.fp[i];
            for (int bi = 31; bi >= 0; --bi) {
                int b1 = f1i & 1;
                int b2 = f2i & 1;
                f1i >>= 1;
                f2i >>= 1;
                if (b1 == b2) continue;
                x += w[i * 32 + bi] * (b1 == 1 ? a : 1.0f - a);
            }
            if (!norm) continue;
            y += Metrics.calcBitCount(this.fp[i]);
            z += Metrics.calcBitCount(f.fp[i]);
        }
        return norm ? (float)(Math.sqrt(x) / (Math.sqrt(y) + Math.sqrt(z))) : (float)Math.sqrt(x);
    }

    @Override
    public float getDissimilarity(MolecularDescriptor other) {
        return this.getDissimilarity(other, this.params.getCurrentMetricIndex());
    }

    @Override
    public float getDissimilarity(MolecularDescriptor other, int metricIndex) {
        this.params.setCurrentParametrizedMetric(metricIndex);
        int mi = this.params.getInternalMetricIndex();
        switch (mi) {
            case 0: {
                return this.getTanimoto((ECFP)other);
            }
            case 1: {
                boolean w = this.params.isWeighted();
                boolean a = this.params.isAsymmetric();
                if (!w && !a) {
                    return this.getEuclidean((ECFP)other);
                }
                if (w && !a) {
                    return this.getWeightedEuclidean((ECFP)other);
                }
                if (!w && a) {
                    return this.getAsymmetricEuclidean((ECFP)other);
                }
                if (!w || !a) break;
                return this.getWeightedAsymmetricEuclidean((ECFP)other);
            }
        }
        throw new IllegalArgumentException("Invalid metricIndex (" + metricIndex + ") passed to ECFP.getDissimilarity()");
    }
}

