/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.ECFPFeatureLookup;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class ECFPFeature {
    private MolAtom centerAtom;
    private int diameter;
    private int identifier;
    private int bitPos;
    private Molecule origMol;

    ECFPFeature(Molecule mol, MolAtom atom, int diameter, int identifier, int bitPos) {
        this.origMol = mol;
        this.centerAtom = atom;
        this.diameter = diameter;
        this.identifier = identifier;
        this.bitPos = bitPos;
    }

    public MolAtom getCenterAtom() {
        return this.centerAtom;
    }

    public int getDiameter() {
        return this.diameter;
    }

    public Molecule getSubstructure() {
        return ECFPFeatureLookup.getAtomNeighborhood(this.origMol, this.centerAtom, this.diameter);
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public int getBitPosition() {
        return this.bitPos;
    }
}

