/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.core.calculations.BondClassifier;
import chemaxon.descriptors.ECFP;
import chemaxon.descriptors.ECFPParameters;
import chemaxon.descriptors.MDGenerator;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.jep.ChemJEP;
import chemaxon.jep.context.AtomContext;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.util.iterator.IteratorFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;

public class ECFPGenerator
extends MDGenerator
implements Licensable {
    private int maxIter;
    private int atomCount;
    private int bondCount;
    private boolean smallFeatures;
    private int[] nbCount;
    private Feature[] features;
    private ArrayList<Feature> filteredFeatures;
    private BondClassifier classifier;
    private IteratorFactory itFactory;
    private String licenseEnvironment = "";

    private void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("ECFP/FCFP", this.licenseEnvironment);
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("ECFP/FCFP", this.licenseEnvironment);
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    @Override
    public String[] generate(Molecule mol, MolecularDescriptor descr) throws MDGeneratorException {
        ECFPParameters params = (ECFPParameters)descr.getParameters();
        ECFP ecfp = (ECFP)descr;
        Molecule stdMol = params.standardize(mol);
        this.generateECFP(stdMol, ecfp, params);
        if (this.createStatistics) {
            this.updateStatistics(descr);
        }
        return null;
    }

    static int getBitPosition(int id, ECFPParameters params) {
        return (int)(((long)id & 0xFFFFFFFFL) % (long)params.getModulo());
    }

    @Override
    protected int calcFreqCount(MolecularDescriptor d) {
        ECFP ecfp = (ECFP)d;
        ecfp.requireBinaryVector();
        for (int i = 0; i < ecfp.fp.length; ++i) {
            int bi = 1;
            for (int b = 31; b >= 0; --b) {
                if ((ecfp.fp[i] & bi) != 0) {
                    int n = 32 * i + b;
                    this.freqCount[n] = this.freqCount[n] + 1;
                }
                bi <<= 1;
            }
        }
        return ecfp.getBrightness();
    }

    private static int getHashCode(int[] array) {
        int result = array.length;
        for (int i : array) {
            result = result * 691 ^ i;
        }
        return result;
    }

    private static int getHashCode(ArrayList<Integer> array) {
        int result = array.size();
        for (Integer i : array) {
            result = result * 691 ^ i;
        }
        return result;
    }

    private int getStandardAtomProperty(int i, MolAtom a, int ix) {
        switch (i) {
            case 0: {
                return a.getAtno();
            }
            case 1: {
                return this.nbCount[ix] + a.getImplicitHcount();
            }
            case 2: {
                return this.nbCount[ix] - a.getExplicitHcount();
            }
            case 3: {
                return a.getExplicitHcount() + a.getImplicitHcount();
            }
            case 4: {
                return a.getValence();
            }
            case 5: {
                return a.getCharge();
            }
            case 6: {
                return (int)a.getMass();
            }
            case 7: {
                return a.getMassno();
            }
            case 8: {
                return a.hasAromaticBond() ? 1 : 0;
            }
            case 9: {
                return this.nbCount[ix] == 1 ? 1 : 0;
            }
            case 10: {
                return this.classifier.isRingAtom(ix) ? 1 : 0;
            }
            case 11: {
                int mask = 64;
                return (a.getFlags() & mask) != 0 ? 1 : 0;
            }
        }
        return 0;
    }

    private int getCustomAtomProperty(ChemJEP jep, Molecule m, int ix) {
        AtomContext ctx = new AtomContext();
        ctx.setMolecule(m);
        ctx.setAtom(ix);
        double val = 0.0;
        try {
            val = jep.evaluate_double(ctx);
        }
        catch (Exception e) {
            // empty catch block
        }
        return (int)val;
    }

    private void startInitialAtomIdCalc(Molecule mol, ECFPParameters params) {
        for (Integer i : params.stdProperties) {
            if (i != 10) continue;
            this.classifier = new BondClassifier();
            this.classifier.classify(mol);
            break;
        }
    }

    private int getInitialAtomId(Molecule mol, MolAtom atom, int index, ECFPParameters params) {
        ArrayList<Integer> array = new ArrayList<Integer>();
        for (Integer i : params.stdProperties) {
            array.add(this.getStandardAtomProperty(i, atom, index));
        }
        for (ChemJEP jep : params.customProperties) {
            array.add(this.getCustomAtomProperty(jep, mol, index));
        }
        return ECFPGenerator.getHashCode(array);
    }

    private boolean generateInitialIdentifiers(Molecule mol, ECFPParameters params) {
        this.checkLicense();
        this.maxIter = params.getDiameter() / 2;
        this.atomCount = mol.getAtomCount();
        this.bondCount = mol.getBondCount();
        boolean bl = this.smallFeatures = this.bondCount <= 64;
        if (this.atomCount <= 0 || this.maxIter < 0) {
            return false;
        }
        this.itFactory = new IteratorFactory(mol, 14, 0);
        this.features = new Feature[(this.maxIter + 1) * this.atomCount];
        Arrays.fill(this.features, null);
        this.nbCount = new int[this.atomCount];
        Arrays.fill(this.nbCount, 0);
        this.startInitialAtomIdCalc(mol, params);
        IteratorFactory.AtomIterator ait = this.itFactory.createAtomIterator();
        while (ait.hasNext()) {
            MolAtom a = ait.next();
            int i = mol.indexOf(a);
            int cnt = 0;
            IteratorFactory.BondNeighbourIterator nit = this.itFactory.createBondNeighbourIterator(a);
            while (nit.hasNext()) {
                ++cnt;
                nit.next();
            }
            this.nbCount[i] = cnt;
            int initId = this.getInitialAtomId(mol, a, i, params);
            if (this.smallFeatures) {
                this.features[i] = new SmallFeature(0, i, initId);
                continue;
            }
            this.features[i] = new GeneralFeature(0, i, initId);
        }
        return true;
    }

    private void performIterations(Molecule mol) {
        int iter = 1;
        int base = 0;
        int curr = this.atomCount;
        while (iter <= this.maxIter) {
            IteratorFactory.AtomIterator ait = this.itFactory.createAtomIterator();
            while (ait.hasNext()) {
                MolAtom a = ait.next();
                int i = mol.indexOf(a);
                Object[] ldata = new LigandData[this.nbCount[i]];
                int nc = 0;
                IteratorFactory.BondNeighbourIterator nit = this.itFactory.createBondNeighbourIterator(a);
                while (nit.hasNext()) {
                    MolBond nb = nit.next();
                    MolAtom na = nb.getOtherAtom(a);
                    ldata[nc++] = new LigandData(nb.getType(), this.features[base + mol.indexOf((MolAtom)na)].value);
                }
                Arrays.sort(ldata);
                int[] hdata = new int[2 + 2 * ldata.length];
                hdata[0] = iter;
                hdata[1] = this.features[base + i].value;
                for (int j = 0; j != ldata.length; ++j) {
                    hdata[2 * j + 2] = ((LigandData)ldata[j]).bond;
                    hdata[2 * j + 3] = ((LigandData)ldata[j]).id;
                }
                this.features[curr + i] = this.smallFeatures ? new SmallFeature(iter, i, ECFPGenerator.getHashCode(hdata)) : new GeneralFeature(iter, i, ECFPGenerator.getHashCode(hdata));
                IteratorFactory.BondNeighbourIterator nit2 = this.itFactory.createBondNeighbourIterator(a);
                while (nit2.hasNext()) {
                    MolBond nb = nit2.next();
                    MolAtom na = nb.getOtherAtom(a);
                    this.features[curr + i].addToSet(mol.indexOf(nb));
                    this.features[curr + i].addToSet(this.features[base + mol.indexOf(na)]);
                }
            }
            ++iter;
            base += this.atomCount;
            curr += this.atomCount;
        }
        this.nbCount = null;
        this.classifier = null;
    }

    private void removeSetDuplications() {
        int fcount = 0;
        for (Feature f : this.features) {
            if (f == null) continue;
            ++fcount;
        }
        if (!this.smallFeatures) {
            for (Feature f : this.features) {
                if (f == null) continue;
                ((GeneralFeature)f).updateHashCode();
            }
        }
        Object[] sortedFeatures = null;
        if (fcount == this.features.length) {
            sortedFeatures = this.features;
        } else {
            sortedFeatures = new Feature[fcount];
            fcount = 0;
            for (Feature f : this.features) {
                if (f == null) continue;
                sortedFeatures[fcount++] = f;
            }
        }
        Arrays.sort(sortedFeatures);
        this.filteredFeatures = new ArrayList();
        if (sortedFeatures.length == 0) {
            return;
        }
        if (this.smallFeatures) {
            int cnt = 0;
            this.filteredFeatures.add((Feature)sortedFeatures[0]);
            ++cnt;
            for (int i = 1; i != sortedFeatures.length; ++i) {
                Object cf = sortedFeatures[i];
                if (((Feature)cf).iter != 0 && ((SmallFeature)cf).set == ((SmallFeature)this.filteredFeatures.get((int)(cnt - 1))).set) continue;
                this.filteredFeatures.add((Feature)cf);
                ++cnt;
            }
        } else {
            int cnt = 0;
            int block = 0;
            this.filteredFeatures.add((Feature)sortedFeatures[0]);
            ++cnt;
            for (int i = 1; i != sortedFeatures.length; ++i) {
                Object cf = sortedFeatures[i];
                if (((GeneralFeature)cf).hash == ((GeneralFeature)this.filteredFeatures.get((int)block)).hash) {
                    if (((Feature)cf).iter == 0) {
                        this.filteredFeatures.add((Feature)cf);
                        ++cnt;
                        continue;
                    }
                    boolean ins = true;
                    for (int j = block; j != cnt; ++j) {
                        if (!((GeneralFeature)cf).set.equals(((GeneralFeature)this.filteredFeatures.get((int)j)).set)) continue;
                        ins = false;
                        break;
                    }
                    if (!ins) continue;
                    this.filteredFeatures.add((Feature)cf);
                    ++cnt;
                    continue;
                }
                block = cnt++;
                this.filteredFeatures.add((Feature)cf);
            }
        }
    }

    private Set<Integer> removeValueDuplications() {
        TreeSet<Integer> idSet = new TreeSet<Integer>();
        for (int i = 0; i != this.filteredFeatures.size(); ++i) {
            idSet.add(this.filteredFeatures.get((int)i).value);
        }
        return idSet;
    }

    private void generateECFP(Molecule mol, ECFP ecfp, ECFPParameters params) {
        boolean valid = this.generateInitialIdentifiers(mol, params);
        if (valid) {
            this.performIterations(mol);
            this.removeSetDuplications();
            if (params.getKeepCounts()) {
                int[] ids = new int[this.filteredFeatures.size()];
                for (int i = 0; i < ids.length; ++i) {
                    ids[i] = this.filteredFeatures.get((int)i).value;
                }
                ecfp.fromIntArray(ids);
            } else {
                ecfp.fromIdentiferSet(this.removeValueDuplications());
            }
        } else {
            ecfp.fromIntArray(new int[0]);
        }
    }

    Integer[][] generateIdentifiers(Molecule mol, ECFPParameters params) {
        boolean valid = this.generateInitialIdentifiers(mol, params);
        if (valid) {
            this.performIterations(mol);
            this.removeSetDuplications();
            Integer[][] ids = new Integer[this.maxIter + 1][];
            for (int i = 0; i <= this.maxIter; ++i) {
                ids[i] = new Integer[this.atomCount];
                Arrays.fill(ids[i], null);
            }
            for (Feature f : this.filteredFeatures) {
                ids[f.iter][f.atom] = f.value;
            }
            return ids;
        }
        if (this.maxIter < 0) {
            return new Integer[0][];
        }
        Integer[][] ids = new Integer[this.maxIter + 1][];
        for (int i = 0; i <= this.maxIter; ++i) {
            ids[i] = new Integer[0];
        }
        return ids;
    }

    private static class SmallFeature
    extends Feature {
        long set = 0L;

        public SmallFeature(int iter, int atom, int value) {
            super(iter, atom, value);
        }

        @Override
        public void addToSet(int bond) {
            this.set |= 1L << bond;
        }

        @Override
        public void addToSet(Feature other) {
            this.set |= ((SmallFeature)other).set;
        }

        @Override
        public int compareTo(Object o) {
            SmallFeature other = (SmallFeature)o;
            if (this.set != other.set) {
                return this.set < other.set ? -1 : 1;
            }
            if (this.iter != other.iter) {
                return this.iter - other.iter;
            }
            if (this.value != other.value) {
                return this.value < other.value ? -1 : 1;
            }
            return 0;
        }
    }

    private static class GeneralFeature
    extends Feature {
        TreeSet<Integer> set = new TreeSet();
        int hash = 0;

        public GeneralFeature(int iter, int atom, int value) {
            super(iter, atom, value);
        }

        @Override
        public void addToSet(int bond) {
            this.set.add(bond);
        }

        @Override
        public void addToSet(Feature other) {
            this.set.addAll(((GeneralFeature)other).set);
        }

        @Override
        public int compareTo(Object o) {
            GeneralFeature other = (GeneralFeature)o;
            if (this.hash != other.hash) {
                return this.hash < other.hash ? -1 : 1;
            }
            if (this.iter != other.iter) {
                return this.iter - other.iter;
            }
            if (this.value != other.value) {
                return this.value < other.value ? -1 : 1;
            }
            return 0;
        }

        public void updateHashCode() {
            this.hash = this.set.size();
            for (Integer x : this.set) {
                this.hash = this.hash * 691 ^ x;
            }
        }
    }

    private static class Feature
    implements Comparable {
        int iter;
        int atom;
        int value;

        public Feature(int iter, int atom, int value) {
            this.iter = iter;
            this.atom = atom;
            this.value = value;
        }

        public void addToSet(int bond) {
        }

        public void addToSet(Feature other) {
        }

        public int compareTo(Object o) {
            return 0;
        }
    }

    private static class LigandData
    implements Comparable {
        int bond;
        int id;

        public LigandData(int bond, int id) {
            this.bond = bond;
            this.id = id;
        }

        public int compareTo(Object o) {
            LigandData other = (LigandData)o;
            if (this.bond != other.bond) {
                return this.bond - other.bond;
            }
            if (this.id != other.id) {
                return this.id < other.id ? -1 : 1;
            }
            return 0;
        }
    }
}

