/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.ECFP;
import chemaxon.descriptors.ECFPGenerator;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDParameters;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.jep.ChemJEP;
import chemaxon.jep.Evaluator;
import chemaxon.jep.context.AtomContext;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.struc.Molecule;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dom4j.Element;

public class ECFPParameters
extends MDParameters {
    public static final int DEFAULT_LENGTH = 1024;
    public static final int DEFAULT_DIAMETER = 4;
    private static final String DEFAULT_STANDARDIZER_XML_CONFIG = "    <StandardizerConfiguration Version=\"0.1\">\n        <Actions>\n            <Action ID=\"aromatize\" Act=\"aromatize\"/>\n            <RemoveExplicitH ID=\"RemoveExplicitH\" Groups=\"target\"/>\n        </Actions>\n    </StandardizerConfiguration>\n";
    private static final String DEFAULT_XML_CONFIG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ECFPConfiguration Version=\"0.1\" schemaLocation=\"\">\n    <Parameters Length=\"1024\" Diameter=\"4\" Counts=\"no\"/>\n    <StandardizerConfiguration Version=\"0.1\">\n        <Actions>\n            <Action ID=\"aromatize\" Act=\"aromatize\"/>\n            <RemoveExplicitH ID=\"RemoveExplicitH\" Groups=\"target\"/>\n        </Actions>\n    </StandardizerConfiguration>\n    <IdentifierConfiguration>\n        <Property Name=\"AtomicNumber\" Value=\"1\"></Property>\n        <Property Name=\"ConnectionCount\" Value=\"0\"></Property>\n        <Property Name=\"HeavyNeighborCount\" Value=\"1\"></Property>\n        <Property Name=\"HCount\" Value=\"1\"></Property>\n        <Property Name=\"Valence\" Value=\"0\"></Property>\n        <Property Name=\"FormalCharge\" Value=\"1\"></Property>\n        <Property Name=\"Mass\" Value=\"0\"></Property>\n        <Property Name=\"MassNumber\" Value=\"0\"></Property>\n        <Property Name=\"HasAromaticBond\" Value=\"0\"></Property>\n        <Property Name=\"IsTerminalAtom\" Value=\"0\"></Property>\n        <Property Name=\"IsRingAtom\" Value=\"1\"></Property>\n        <Property Name=\"IsStereoAtom\" Value=\"0\"></Property>\n    </IdentifierConfiguration>\n    <ScreeningConfiguration>\n       <ParametrizedMetrics>\n            <ParametrizedMetric Name=\"Tanimoto\" ActiveFamily=\"Generic\"\n                 Metric=\"Tanimoto\" Threshold=\"0.5\"/>\n            <ParametrizedMetric Name=\"Euclidean\" ActiveFamily=\"Generic\"\n                 Metric=\"Euclidean\" Threshold=\"10\"/>\n       </ParametrizedMetrics>\n    </ScreeningConfiguration>\n</ECFPConfiguration>\n";
    private static final String[] standardPropertyNames = new String[]{"AtomicNumber", "ConnectionCount", "HeavyNeighborCount", "HCount", "Valence", "FormalCharge", "Mass", "MassNumber", "HasAromaticBond", "IsTerminalAtom", "IsRingAtom", "IsStereoAtom"};
    static final int IS_RING_ATOM_PROPERTY_INDEX = 10;
    private int diameter = 4;
    private boolean keepCounts = false;
    private int modulo;
    private Element parameters = null;
    private List propertyNodes;
    ArrayList<Integer> stdProperties = null;
    ArrayList<ChemJEP> customProperties = null;

    public ECFPParameters() {
        this.init();
        this.setLength(1024);
    }

    public ECFPParameters(File configFile) throws MDParametersException {
        this.init();
        this.readFromXmlFile(configFile, false, true);
        this.initParameters();
        this.initGenerator();
    }

    public ECFPParameters(String XMLconfig) throws MDParametersException {
        this.init();
        this.readFromXmlString(XMLconfig, false, true);
        this.initParameters();
        this.initGenerator();
    }

    @Override
    public void fromString(String parameterString) throws MDParametersException {
        super.fromString(parameterString);
        this.initGenerator();
    }

    @Override
    public void fromFile(File parameterFile) throws MDParametersException {
        super.fromFile(parameterFile);
        this.initGenerator();
    }

    @Override
    public void setLength(int length) throws MDParametersException {
        if (length % 32 != 0) {
            throw new MDParametersException("Fingerprint length should be multiple of 32.");
        }
        super.setLength(length);
        this.initParameters();
        this.initGenerator();
        if (this.parameters != null) {
            this.parameters.addAttribute("Length", Integer.toString(length));
        }
    }

    public void setDiameter(int diameter) {
        this.diameter = diameter;
        if (this.parameters != null) {
            this.parameters.addAttribute("Diameter", Integer.toString(diameter));
        }
    }

    public int getDiameter() {
        return this.diameter;
    }

    public void setKeepCounts(boolean keepCounts) {
        this.keepCounts = keepCounts;
        if (this.parameters != null) {
            this.parameters.addAttribute("Counts", keepCounts ? "yes" : "no");
        }
    }

    public boolean getKeepCounts() {
        return this.keepCounts;
    }

    int getModulo() {
        return this.modulo;
    }

    protected void initGenerator() throws MDParametersException {
        this.generator = new ECFPGenerator();
    }

    protected void init() {
        this.md = new ECFP();
    }

    @Override
    protected void initParameters() {
        super.initParameters();
        this.internalSize = this.length / 32;
        this.modulo = ECFPParameters.computeModulo(this.length);
        this.data = null;
    }

    static int computeModulo(int length) {
        switch (length) {
            case 32: {
                return 31;
            }
            case 64: {
                return 61;
            }
            case 128: {
                return 127;
            }
            case 256: {
                return 251;
            }
            case 512: {
                return 509;
            }
            case 1024: {
                return 1021;
            }
            case 2048: {
                return 2039;
            }
            case 4096: {
                return 4093;
            }
            case 8192: {
                return 8191;
            }
        }
        int p = length;
        while (--p > 2) {
            boolean pr = true;
            int i = 2;
            while ((double)i <= Math.sqrt(p)) {
                if (p % i == 0) {
                    pr = false;
                    break;
                }
                ++i;
            }
            if (!pr) continue;
            return p;
        }
        return 2;
    }

    protected String[] generate(Molecule m, MolecularDescriptor ecfp) throws MDGeneratorException {
        return this.generator.generate(m, ecfp);
    }

    @Override
    protected int getNumberOfWeights(int parametrizedMetricIndex) throws IllegalArgumentException {
        int dissimilarityMetricIndex = (Integer)this.metricIndexes.get(this.currentMetricIndex);
        switch (dissimilarityMetricIndex) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.getLength();
            }
        }
        throw new IllegalArgumentException("Invalid metric index " + dissimilarityMetricIndex);
    }

    @Override
    public String getDefaultDocumentFrame() {
        return DEFAULT_XML_CONFIG;
    }

    public static String getDefaultStandardizerConfiguration() {
        return DEFAULT_STANDARDIZER_XML_CONFIG;
    }

    @Override
    protected void processDocument(boolean all) throws MDParametersException {
        this.checkDocumentVersion("ECFPConfiguration", VersionInfo.JCHEM_VERSION);
        if (all) {
            this.parameters = (Element)this.document.selectSingleNode("//ECFPConfiguration/Parameters");
            if (this.parameters == null) {
                throw new MDParametersException("ECFP configuration error: missing <Parameters>");
            }
            Element idConfig = (Element)this.document.selectSingleNode("//ECFPConfiguration/IdentifierConfiguration");
            if (idConfig == null) {
                throw new MDParametersException("ECFP configuration error: missing <IdentifierConfiguration>");
            }
            this.propertyNodes = idConfig.selectNodes("Property");
        }
        super.processDocument(all);
    }

    @Override
    protected void readValues(boolean all) throws MDParametersException {
        if (all) {
            String p = this.parameters.attributeValue("Length");
            this.setLength(p != null ? Integer.parseInt(p) : 1024);
            p = this.parameters.attributeValue("Diameter");
            if (p != null) {
                this.diameter = Integer.parseInt(p);
            }
            if ((p = this.parameters.attributeValue("Counts")) != null) {
                this.keepCounts = p.equals("1") || p.equalsIgnoreCase("yes");
            }
            this.stdProperties = new ArrayList();
            this.customProperties = new ArrayList();
            ArrayList<String> customPropertyNames = new ArrayList<String>();
            try {
                for (int i = 0; i != this.propertyNodes.size(); ++i) {
                    Element prop = (Element)this.propertyNodes.get(i);
                    if (Integer.parseInt(prop.attributeValue("Value")) == 0) continue;
                    String name = prop.attributeValue("Name");
                    boolean std = false;
                    for (int j = 0; j != standardPropertyNames.length; ++j) {
                        if (!name.equalsIgnoreCase(standardPropertyNames[j])) continue;
                        String text = prop.getText();
                        if (text != null && text.trim().length() > 0) {
                            throw new MDParametersException("ECFP configuration error: non-empty Property tag with a built-in property name '" + name + "'");
                        }
                        std = true;
                        this.stdProperties.add(j);
                        break;
                    }
                    if (std) continue;
                    String text = prop.getText();
                    if (text == null || text.trim().length() == 0) {
                        throw new MDParametersException("ECFP configuration error: empty Chemical Terms expression for property '" + name + "'");
                    }
                    customPropertyNames.add(text.trim());
                }
            }
            catch (NullPointerException ne) {
                throw new MDParametersException("ECFP configuration error: missing attribute");
            }
            Collections.sort(this.stdProperties);
            Collections.sort(customPropertyNames, String.CASE_INSENSITIVE_ORDER);
            for (String text : customPropertyNames) {
                try {
                    Evaluator evaluator = new Evaluator();
                    this.customProperties.add(evaluator.compile(text, AtomContext.class));
                }
                catch (ParseException pe) {
                    throw new MDParametersException("ECFP configuration error: invalid Chemical Terms expression: '" + text + "'");
                }
            }
        }
        this.readMetricParameters();
    }
}

