/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.CFParameters;
import chemaxon.descriptors.ChemicalFingerprint;
import chemaxon.descriptors.MDArrayReader;
import chemaxon.descriptors.MDFileReader;
import chemaxon.descriptors.MDHitEvaluator;
import chemaxon.descriptors.MDHypothesisCreator;
import chemaxon.descriptors.MDHypothesisGenerator;
import chemaxon.descriptors.MDMedHypothesisGenerator;
import chemaxon.descriptors.MDMinHypothesisGenerator;
import chemaxon.descriptors.MDParameters;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.MDReader;
import chemaxon.descriptors.MDReaderException;
import chemaxon.descriptors.MDSet;
import chemaxon.descriptors.MDSetParameters;
import chemaxon.descriptors.MDSimilarity;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.descriptors.PFParameters;
import chemaxon.descriptors.PharmacophoreFingerprint;
import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.struc.Molecule;
import chemaxon.util.ArgumentException;
import chemaxon.util.CmdLine;
import chemaxon.util.MolHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class HitStatistics {
    private static final String NL = System.getProperty("line.separator");
    private static final String UserHome = System.getProperty("user.home");
    private static final String FileSep = System.getProperty("file.separator");
    private static final String PrgName = "HitStatistics";
    private static final String PrgHeader = NL + "HitStatistics" + " - " + "Molecular Descriptor Screening Statistics " + VersionInfo.JCHEM_VERSION + "," + NL + "(C) 2002-2012 ChemAxon Ltd." + NL;
    private static final String UsageInfo = PrgHeader + "Calculates performance statistics of a given screen of target molecules." + NL + "" + NL + "Usage: hitstatistics <target file> <test file> <query file> [options]" + NL + "" + NL + "General options: " + NL + "  -h, --help               this help message" + NL + "  -x, --expert-help        advanced options for expert users" + NL + "  -v, --verbose            verbose" + NL + "" + NL + "Output options:" + NL + "  -o, --output <filepath>  statistics output file name with full path" + NL + "  -T, --target-hit-output" + NL + "                           output target molecule hits into molecule files" + NL + "                             separately for each descriptor and metric with" + NL + "                             automatic file naming." + NL + "  -e, --precision <prec>   number of decimal places after the decimal point" + NL + "" + NL + "Descriptor options: " + NL + "  -k, --descriptor <type> <common descriptor options> <type specific flags> " + NL + "                           use/generate descriptors of the given type " + NL + "                             according to the type specific flags (see below)" + NL + "                             Supported types are: CF, PF" + NL + "" + NL + "Common descriptor options: " + NL + "  -c, --config <configfile> " + NL + "                           path and name of the XML configuration file" + NL + "  -t, --use-tag [<name>]   use existing descriptor data" + NL + "  -M, --metric {<name>}    use the metric <name> as specified in the config file" + NL + "" + NL + "Descriptor type specific options: " + NL + "" + NL + "2D pharmacophore fingerprint options:" + NL + "  -z, --fuzzy <smoothing factor> " + NL + "                           generate fuzzy fingerprints with the given" + NL + "                              fuzzy smoothing factor " + NL + "" + NL + "Similarity options:" + NL + "  -Q, --compare-queries    compare against query pharmacophores" + NL + "  -H, --compare-hypothesis [<name> [C]]" + NL + "                           compare against hypothesis <name>" + NL + "                             Valid names are: Minimum, Average, Median." + NL + "                             Default hypothesis type is Minimum." + NL + "                             'C' indicates consensus fingerprint." + NL + "                             This flag may occur more than once with different" + NL + "                             hypothesis types." + NL + "" + NL + "Statistics options:" + NL + "  -b, --by-metrics         calculate statistics by each descriptor and metric" + NL + "                             separately" + NL + "  -d, --by-descriptors     calculate statistics by each descriptor separately" + NL + "  -a, --by-all             calculate overall statistics" + NL + "  -s, --metric-distribution <lower bound> <upper bound> <histogram count>" + NL + "                           generate information about the distribution of" + NL + "                             metric values. Histogram count determines the" + NL + "                             number of histograms to be generated (resolution)." + NL + "                             From these histograms two gather the number of" + NL + "                             dissimilarity values below and above the given" + NL + "                             lower and upper bounds." + NL + "  -f, --memory-safe-mode   for cases when large number of molecules are to be" + NL + "                             processed, in this case dissimilarity values are" + NL + "                             not stored, but recalculated, if necessary." + NL + "" + NL + "";
    private static final String ExpertOptions = "" + NL + "Advanced options for expert users:" + NL + "" + NL + "2D pharmacophore fingerprint options:" + NL + "  -P, --PMAP-tag [<name>]  use existing PMAP data" + NL + "  -G, --Gaussian-cutoff <value> " + NL + "                           not smoothing outside <value>*sigma" + NL + "  -B, --smoothing-bound <value> " + NL + "                           lower bound for fuzzy smoothing " + NL + "  -A, --asymmetrical-smoothing" + NL + "                           do not smooth left side" + NL + "  -R, --ignore-rotomers   do not take into accound the effect of rotatable" + NL + "                             bonds" + NL + "" + NL + "Similarity options:" + NL + "  -r, --descriptors-and    thresholds for all descriptors, default is any" + NL + "  -m, --metrics-and        thresholds for all metrics, default is any" + NL + "  -Z, --zero-threshold     percentage threshold for zero limit in median" + NL + "                             hypothesis" + NL + "" + NL + "Statistics options:" + NL + "  -l, --selectivity-asymmetry <value>" + NL + "                           asymmetry factor for evaluator function selectivity" + NL + "                           effectiveness. Default is 0.5 (no asymmetry)." + NL + "" + NL + "";
    private static PrintStream outFile = System.out;
    private static CmdLine cmdLine = null;
    private static boolean verbose = false;
    private static String targetFileName = null;
    private static String testSetFileName = null;
    private static String queryFileName = null;
    private static boolean descrInput = false;
    private static boolean targetHitOutput = false;
    private static int descriptorCount = 0;
    private static MolecularDescriptor[] descriptors = null;
    private static String[] tagNames = null;
    private static String[] descrNames = null;
    private static int[][] metricIndices = null;
    private static int precision = 2;
    private static ArrayList hypoNames = new ArrayList();
    private static float zeroThreshold = -1.0f;
    private static MDReader queryReader = null;
    private static MDReader testSetReader = null;
    private static MDReader targetReader = null;
    private static int scalingHypoIndex = -1;
    private static boolean memorySafeMode = false;
    private static float alpha = 0.5f;
    private static boolean compareQueries = false;
    private static boolean andDescriptors = false;
    private static boolean andMetrics = false;
    private static boolean byMetrics = false;
    private static boolean byDescriptors = false;
    private static boolean byAll = false;
    private static boolean metricDistribution = false;
    private static float lowerBound = 0.0f;
    private static float upperBound = 1.0f;
    private static int nHistograms = 100;
    private static MDSimilarity similarity = new MDSimilarity();
    private static MDHitEvaluator evaluator = null;
    private static MDSet mdSet = null;
    private static int maxAllowed = Integer.MAX_VALUE;

    public static void main(String[] args) {
        HitStatistics.clearAllVariables();
        try {
            if (args != null && args[0].equals("config")) {
                args = HitStatistics.getArgsFromXML(args);
            }
            cmdLine = new CmdLine(args);
            if (HitStatistics.processCmdLineOptions()) {
                mdSet = new MDSet(descriptorCount);
                mdSet.setDescriptors(descriptors);
                MDSetParameters mdSetPar = new MDSetParameters(descriptorCount);
                mdSet.setParameters(mdSetPar);
                HitStatistics.initSources();
                HitStatistics.initEvaluator();
                HitStatistics.verboseMsg(NL + "Processing started at " + new GregorianCalendar().getTime() + NL);
                HitStatistics.calcStatistics();
                queryReader.close();
                targetReader.close();
                testSetReader.close();
                HitStatistics.verboseMsg("Processing finished at " + new GregorianCalendar().getTime() + NL);
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    private static void clearAllVariables() {
        outFile = System.out;
        cmdLine = null;
        verbose = false;
        targetFileName = null;
        testSetFileName = null;
        queryFileName = null;
        descrInput = false;
        targetHitOutput = false;
        descriptorCount = 0;
        descriptors = null;
        tagNames = null;
        descrNames = null;
        metricIndices = null;
        precision = 2;
        hypoNames = new ArrayList();
        queryReader = null;
        testSetReader = null;
        targetReader = null;
        scalingHypoIndex = -1;
        memorySafeMode = false;
        alpha = 0.5f;
        compareQueries = false;
        andDescriptors = false;
        andMetrics = false;
        byMetrics = false;
        byDescriptors = false;
        byAll = false;
        metricDistribution = false;
        lowerBound = 0.0f;
        upperBound = 1.0f;
        nHistograms = 100;
        similarity = new MDSimilarity();
        evaluator = null;
        mdSet = null;
        maxAllowed = Integer.MAX_VALUE;
    }

    private static void calcStatistics() throws MDReaderException {
        MDReader tReader = targetReader;
        MDReader tsReader = testSetReader;
        similarity.setComponentWise(true);
        if (!memorySafeMode) {
            evaluator.calcDissimilarity(tsReader, tReader);
        } else {
            tsReader = new MDArrayReader(testSetReader);
            tReader = new MDArrayReader(targetReader);
        }
        HitStatistics.initOutFile();
        boolean firstTime = true;
        if (byMetrics) {
            if (!memorySafeMode) {
                HitStatistics.writeHeaderToOutFile();
            }
            for (int d = 0; d < descriptorCount; ++d) {
                String descrName = descrNames[d];
                MolecularDescriptor descr = descriptors[d];
                MDParameters params = descr.getParameters();
                params.setOutputPrecision(precision);
                for (int m = 0; m < metricIndices[d].length; ++m) {
                    float[] E;
                    int index = metricIndices[d][m];
                    params.setCurrentParametrizedMetric(index);
                    if (!memorySafeMode) {
                        E = evaluator.screen(d, index, params.getThreshold());
                    } else {
                        E = evaluator.screen(d, index, params.getThreshold(), tsReader, tReader);
                        if (firstTime) {
                            HitStatistics.writeMoleculeNumbersToOutFile();
                            HitStatistics.writeHeaderToOutFile();
                            firstTime = false;
                        }
                    }
                    HitStatistics.writeEvaluatorValuesToOutFile(d, index, E);
                }
            }
        }
        if (byDescriptors) {
            // empty if block
        }
        if (byAll) {
            // empty if block
        }
        if (metricDistribution) {
            HitStatistics.writeDistributionHeaderToOutFile();
            for (int d = 0; d < descriptorCount; ++d) {
                String descrName = descrNames[d];
                MolecularDescriptor descr = descriptors[d];
                MDParameters params = descr.getParameters();
                params.setOutputPrecision(precision);
                HitStatistics.writeDescrToOutFile(descrName);
                for (int m = 0; m < metricIndices[d].length; ++m) {
                    int[] distr;
                    int index = metricIndices[d][m];
                    params.setCurrentParametrizedMetric(index);
                    float[] values = new float[nHistograms + 1];
                    if (!memorySafeMode) {
                        distr = evaluator.calcMetricDistribution(d, index, lowerBound, upperBound, nHistograms, values);
                    } else {
                        distr = evaluator.calcMetricDistribution(d, index, lowerBound, upperBound, nHistograms, values, tsReader, tReader);
                        if (firstTime) {
                            HitStatistics.writeMoleculeNumbersToOutFile();
                            firstTime = false;
                        }
                    }
                    HitStatistics.writeDistributionToOutFile(d, values, distr);
                }
            }
        }
        outFile.close();
    }

    private static void initOutFile() {
        outFile.println("Target file name\t" + targetFileName);
        outFile.println("Test set file name\t" + testSetFileName);
        outFile.println("Query file name\t" + queryFileName);
        outFile.println();
        outFile.println("Number of queries\t" + similarity.getNrOfQueries());
        if (!memorySafeMode) {
            outFile.println("Number of test set elements\t" + evaluator.getNumberOfSimilars());
            outFile.println("Number of targets\t" + evaluator.getNumberOfDissimilars());
            outFile.println();
        }
    }

    private static void writeHeaderToOutFile() {
        outFile.print("Descr\tMetric\t");
        for (int i = 0; i < HitStatistics.evaluator.evaluatorFunctions.length; ++i) {
            outFile.print(HitStatistics.evaluator.evaluatorFunctions[i] + "\t");
        }
        outFile.println("Threshold\tTest Hits\tTarget Hits\tBefore actives");
    }

    private static void writeDescrToOutFile(String descrName) {
        outFile.println(descrName);
    }

    private static void writeMoleculeNumbersToOutFile() {
        outFile.println("Number of test set elements\t" + evaluator.getNumberOfSimilars());
        outFile.println("Number of targets\t" + evaluator.getNumberOfDissimilars());
        outFile.println();
    }

    private static void writeEvaluatorValuesToOutFile(int descrIndex, int metricIndex, float[] E) throws MDReaderException {
        int i;
        DecimalFormat decFormat = descriptors[descrIndex].getParameters().getDecForm();
        outFile.print(descrNames[descrIndex] + "\t" + descriptors[descrIndex].getMetricName() + "\t");
        for (int i2 = 0; i2 < E.length; ++i2) {
            if (Float.isNaN(E[i2])) {
                outFile.print(E[i2] + "\t");
                continue;
            }
            outFile.print(decFormat.format(E[i2]) + "\t");
        }
        int nDissimilarHits = evaluator.getNumberOfDissimilarHits();
        ArrayList[] dissimilars = evaluator.getInsertedDissimilars();
        int nInsertedDissimilars = 0;
        for (i = 0; i < dissimilars.length; ++i) {
            nInsertedDissimilars += dissimilars[i].size();
        }
        outFile.print(decFormat.format(evaluator.getThreshold(descrIndex, metricIndex)) + "\t" + evaluator.getNumberOfSimilarHits() + "\t" + nDissimilarHits + "\t" + nInsertedDissimilars);
        outFile.print("\t" + dissimilars[0].size());
        for (i = 1; i < dissimilars.length; ++i) {
            outFile.print(", " + dissimilars[i].size());
        }
        outFile.println();
        if (targetHitOutput) {
            int[] targetHitIds = new int[nDissimilarHits];
            for (int i3 = 0; i3 < nDissimilarHits; ++i3) {
                targetHitIds[i3] = evaluator.getNextDissimilarHit();
            }
            int nDissimilars = evaluator.getNumberOfDissimilars();
            int hitCounter = 0;
            String fn = targetFileName + "-" + queryFileName + "-" + descrNames[descrIndex] + "-" + descriptors[descrIndex].getMetricName();
            for (int i4 = 0; i4 < hypoNames.size(); ++i4) {
                fn = fn + "-" + (String)hypoNames.get(i4);
            }
            try {
                String outFormat;
                BufferedInputStream inFile = new BufferedInputStream(new FileInputStream(targetFileName));
                MolImporter molImp = new MolImporter(new MolInputStream(inFile));
                String inFormat = molImp.getFormat();
                String string = outFormat = inFormat.equals("mol") ? "sdf" : inFormat;
                String outExtension = inFormat.equals("mol") ? ".sdf" : (MolHandler.isDaylightFormat(inFormat) ? ".smiles" : "." + inFormat);
                String sep = MolHandler.isDaylightFormat(inFormat) ? "\n" : "";
                fn = fn + outExtension;
                PrintStream targetHitFile = new PrintStream(new BufferedOutputStream(new FileOutputStream(fn)));
                Molecule molecule = molImp.read();
                for (int i5 = 0; i5 < nDissimilars && hitCounter < nDissimilarHits; ++i5) {
                    if (i5 == targetHitIds[hitCounter]) {
                        targetHitFile.print(molecule.toFormat(outFormat) + sep);
                        ++hitCounter;
                    }
                    molecule = molImp.read();
                }
                targetHitFile.close();
            }
            catch (IOException ioe) {
                System.err.println("Failed to create file " + fn);
            }
        }
    }

    private static void writeDistributionToOutFile(int descrIndex, float[] values, int[] distr) {
        DecimalFormat decFormat = descriptors[descrIndex].getParameters().getDecForm();
        outFile.println("\t" + descriptors[descrIndex].getMetricName());
        for (int i = 0; i < nHistograms; ++i) {
            outFile.println("\t\t\t[" + decFormat.format(values[i]) + ", " + decFormat.format(values[i + 1]) + "]\t" + distr[i]);
        }
    }

    private static void writeDistributionHeaderToOutFile() {
        outFile.println("\nMetric Distributions\n");
    }

    private static void initEvaluator() throws MDReaderException {
        MDArrayReader qar = new MDArrayReader(queryReader);
        if (compareQueries) {
            similarity.addQueries(qar);
            qar.reset();
        }
        for (int h = 0; h < hypoNames.size(); ++h) {
            MDHypothesisGenerator hypoGen = MDHypothesisCreator.create((String)hypoNames.get(h));
            if (hypoGen instanceof MDMedHypothesisGenerator && zeroThreshold >= 0.0f) {
                ((MDMedHypothesisGenerator)hypoGen).setZeroPercentageThreshold(zeroThreshold);
            }
            MDSet query = qar.next();
            while (query != null) {
                hypoGen.add(query);
                query = qar.next();
            }
            qar.reset();
            MDSet hypothesis = hypoGen.generate();
            similarity.addQuery(hypothesis);
            if (h != scalingHypoIndex) continue;
            for (int d = 0; d < hypothesis.size(); ++d) {
                MolecularDescriptor component = hypothesis.getDescriptor(d);
                component.getParameters().setScalingHypothesis(component);
            }
        }
        if (scalingHypoIndex == -1) {
            MDMinHypothesisGenerator hypoGen = new MDMinHypothesisGenerator();
            MDSet query = qar.next();
            while (query != null) {
                hypoGen.add(query);
                query = qar.next();
            }
            qar.reset();
            MDSet hypothesis = hypoGen.generate();
            for (int d = 0; d < mdSet.size(); ++d) {
                MolecularDescriptor component = hypothesis.getDescriptor(d);
                component.getParameters().setScalingHypothesis(component);
            }
        }
        for (int d = 0; d < descriptorCount; ++d) {
            for (int m = 0; m < metricIndices[d].length; ++m) {
                similarity.useMetric(d, metricIndices[d][m], Float.MAX_VALUE);
            }
        }
        if (andMetrics) {
            similarity.passWithAllMetrics();
        } else {
            similarity.passWithOneMetric();
        }
        if (andDescriptors) {
            similarity.passWithAllDescriptors();
        } else {
            similarity.passWithOneDescriptor();
        }
        evaluator = new MDHitEvaluator(similarity);
        evaluator.setSelectivityAsymmetryFactor(alpha);
    }

    private static boolean processCmdLineOptions() throws ArgumentException, FileNotFoundException, IOException, ParseException, MDReaderException, MDParametersException {
        if (cmdLine.isEmpty() || cmdLine.find('h', "help") != -1) {
            System.out.println(UsageInfo);
            return false;
        }
        if (cmdLine.find('x', "expert-help") != -1) {
            System.out.println(UsageInfo + ExpertOptions);
            return false;
        }
        HitStatistics.getInputFileNames();
        HitStatistics.alloc();
        verbose = cmdLine.find('v', "verbose") != -1;
        HitStatistics.verboseMsg(PrgHeader + NL);
        HitStatistics.processOutputOptions();
        HitStatistics.processDescriptorOptions();
        HitStatistics.processSimilarityOptions();
        HitStatistics.processStatisticsOptions();
        HitStatistics.processRemaining();
        return true;
    }

    private static void getInputFileNames() throws ArgumentException {
        targetFileName = cmdLine.getFileName(0);
        if (targetFileName == null) {
            throw new ArgumentException("Missing target, similar and query file names");
        }
        testSetFileName = cmdLine.getFileName(1);
        if (testSetFileName == null) {
            throw new ArgumentException("Missing similar and query file names");
        }
        queryFileName = cmdLine.getFileName(2);
        if (queryFileName == null) {
            throw new ArgumentException("Missing query file name");
        }
    }

    private static void alloc() throws ArgumentException {
        descriptorCount = cmdLine.countFlag('k', "descriptor");
        if (descriptorCount == 0) {
            throw new ArgumentException("At least one molecular descriptor should be specified");
        }
        descriptors = new MolecularDescriptor[descriptorCount];
        metricIndices = new int[descriptorCount][];
        tagNames = new String[descriptorCount];
        descrNames = new String[descriptorCount];
    }

    private static void processOutputOptions() throws ArgumentException, FileNotFoundException {
        int outPos;
        int precPos = cmdLine.find('e', "precision", 1);
        if (precPos != -1) {
            precision = cmdLine.getInt(precPos + 1);
        }
        if ((outPos = cmdLine.find('o', "output", 1)) != -1) {
            String fn = cmdLine.getString(outPos + 1);
            try {
                outFile = new PrintStream(new BufferedOutputStream(new FileOutputStream(fn)));
            }
            catch (IOException ioe) {
                System.err.println("Failed to create file " + fn);
            }
        }
        targetHitOutput = cmdLine.find('T', "target-hit-oputput") != -1;
    }

    private static void processDescriptorOptions() throws ArgumentException, IOException, ParseException, MDParametersException {
        for (int i = 0; i < descriptorCount; ++i) {
            cmdLine.lockDynamicBlock('k', "descriptor");
            String descrType = cmdLine.getParamString('k', "descriptor");
            if (descrType == null) {
                throw new ArgumentException("Missing descriptor type name");
            }
            HitStatistics.descrNames[i] = descrType;
            HitStatistics.processCommonDescriptorOptions(i, descrType);
            if (descrType.equals("PF") || descrType.equals("PharmacophoreFingerprint")) {
                HitStatistics.processPFOptions(i);
                HitStatistics.processCommonMetricOptions(i);
            } else if (descrType.equals("CF") || descrType.equals("ChemicalFingerprint")) {
                HitStatistics.processCFOptions(i);
                HitStatistics.processCommonMetricOptions(i);
            } else {
                MolecularDescriptor md = MolecularDescriptor.newInstance(descrType);
                int cPos = cmdLine.find('c', "config", 1);
                if (cPos == -1 && md.needsConfig()) {
                    throw new ArgumentException("Missing -c flag. A valid XML configuration file has to be provided.");
                }
                String paramName = md.getParametersClassName();
                try {
                    Class<?> p = Class.forName(paramName);
                    MDParameters params = (MDParameters)p.newInstance();
                    if (md.needsConfig()) {
                        params.fromFile(new File(cmdLine.getString(cPos + 1)));
                    }
                    md.setParameters(params);
                    HitStatistics.descriptors[i] = md;
                    HitStatistics.processCommonMetricOptions(i);
                }
                catch (Exception cnfe) {
                    cnfe.printStackTrace();
                    throw new ArgumentException("Wrong name: custom MolecularDescriptor " + descrType + " is not available. Failed to access MDParameters" + " subclass " + paramName + ".");
                }
            }
            cmdLine.unlockDynamicBlock();
        }
    }

    private static void processCommonDescriptorOptions(int descrId, String defaultTagName) throws ArgumentException {
        int tPos = cmdLine.find('t', "use-tag", 0, 1);
        if (tPos != -1) {
            HitStatistics.tagNames[descrId] = cmdLine.getParamCount(tPos) == 0 ? defaultTagName : cmdLine.getString(tPos + 1);
        }
    }

    private static void processCommonMetricOptions(int descrId) throws ArgumentException {
        MolecularDescriptor md = descriptors[descrId];
        MDParameters params = md.getParameters();
        int metrPos = cmdLine.find('M', "metric", 0, md.getNumberOfMetrics());
        if (metrPos != -1) {
            int mp = cmdLine.getParamCount(metrPos);
            if (mp == 0) {
                throw new ArgumentException("Missing metric name after the --metric option");
            }
            HitStatistics.metricIndices[descrId] = new int[mp];
            for (int i = 1; i <= mp; ++i) {
                HitStatistics.metricIndices[descrId][i - 1] = md.getMetricIndex(cmdLine.getString(metrPos + i));
            }
        } else {
            HitStatistics.verboseMsg("No metric selected for descriptor " + descrNames[descrId] + ", using all available metrics." + NL);
            HitStatistics.metricIndices[descrId] = new int[md.getNumberOfMetrics()];
            for (int mi = 0; mi < md.getNumberOfMetrics(); ++mi) {
                HitStatistics.metricIndices[descrId][mi] = mi;
            }
        }
    }

    private static void processPFOptions(int descrId) throws ArgumentException, IOException, ParseException, MDParametersException {
        int pPos;
        int rPos;
        int aPos;
        int bPos;
        int gPos;
        int cPos = cmdLine.find('c', "config", 1);
        if (cPos == -1) {
            throw new ArgumentException("Missing PF configuration");
        }
        PFParameters params = new PFParameters(new File(cmdLine.getString(cPos + 1)));
        int zPos = cmdLine.find('z', "fuzzy", 1);
        if (zPos != -1) {
            int pc = cmdLine.getParamCount(zPos);
            params.setFuzzySmoothingFactor(cmdLine.getFloat(zPos + 1));
        }
        if ((gPos = cmdLine.find('G', "Gaussian-cutoff", 1)) != -1) {
            params.setFuzzyCutOff(cmdLine.getFloat(gPos + 1));
        }
        if ((bPos = cmdLine.find('B', "smoothing-bound", 1)) != -1) {
            params.setFuzzyLowerBound(cmdLine.getInt(bPos + 1));
        }
        if ((aPos = cmdLine.find('A', "asymmetrical-smoothing")) != -1) {
            params.setSymmetricalFuzzy(false);
        }
        if ((rPos = cmdLine.find('R', "ignore-rotomers")) != -1) {
            params.setIgnoreRotatableBonds(true);
        }
        if ((pPos = cmdLine.find('P', "PMAP-tag", 0, 1)) != -1) {
            params.setUsePMAP(cmdLine.getString(pPos + 1));
        }
        HitStatistics.descriptors[descrId] = new PharmacophoreFingerprint(params.toString());
    }

    private static void processCFOptions(int descrId) throws ArgumentException, MDParametersException {
        int cPos = cmdLine.find('c', "config", 1);
        if (cPos == -1) {
            throw new ArgumentException("Missing CF configuration");
        }
        CFParameters params = null;
        params = new CFParameters(new File(cmdLine.getString(cPos + 1)));
        HitStatistics.descriptors[descrId] = new ChemicalFingerprint(params);
    }

    private static void processSimilarityOptions() throws ArgumentException {
        Object hypoGen = null;
        int hypoPos = cmdLine.find('H', "compare-hypothesis", 0, 2);
        while (hypoPos != -1) {
            if (cmdLine.getParamCount(hypoPos) == 0) {
                HitStatistics.verboseMsg("Using Minimum hypothesis" + NL);
                hypoNames.add("Minimum");
                scalingHypoIndex = hypoNames.size() - 1;
            } else {
                for (int h = 0; h < MDHypothesisCreator.typeNames.length; ++h) {
                    if (!cmdLine.getString(hypoPos + 1).equals(MDHypothesisCreator.typeNames[h])) continue;
                    hypoNames.add(MDHypothesisCreator.typeNames[h]);
                    if (cmdLine.getParamCount(hypoPos) != 2) continue;
                    if (cmdLine.getString(hypoPos + 2).equals("C")) {
                        scalingHypoIndex = hypoNames.size() - 1;
                        continue;
                    }
                    System.err.println("Invalid option " + cmdLine.getString(hypoPos + 2));
                }
                if (hypoNames.size() == 0) {
                    System.err.println("Missing or bad hypothesis name, using Minimum");
                    hypoNames.add("Minimum");
                    scalingHypoIndex = 0;
                }
            }
            hypoPos = cmdLine.find('H', "compare-hypothesis", 0, 2);
        }
        int zeroThreshPos = cmdLine.find('Z', "zero-threshold", 1, 1);
        if (zeroThreshPos != -1 && ((zeroThreshold = cmdLine.getFloat(zeroThreshPos + 1)) <= 0.0f || zeroThreshold > 100.0f)) {
            throw new ArgumentException("Zero threshold percentage should be a value in (0.0, 100.0]");
        }
        boolean bl = compareQueries = cmdLine.find('Q', "compare-queries") != -1;
        if (hypoNames.size() == 0 && !compareQueries) {
            System.err.println("Comparing against all individual queries");
            compareQueries = true;
        }
        andDescriptors = cmdLine.find('r', "descriptors-and") != -1;
        andMetrics = cmdLine.find('m', "metrics-and") != -1;
    }

    private static void processStatisticsOptions() throws ArgumentException {
        int selectivityPos;
        byDescriptors = cmdLine.find('d', "by-descriptors") != -1;
        byAll = cmdLine.find('a', "by-all") != -1;
        byMetrics = cmdLine.find('b', "by-metrics") != -1;
        int metricDistPos = cmdLine.find('s', "metric-distribution", 3);
        if (metricDistPos != -1) {
            metricDistribution = true;
            lowerBound = cmdLine.getFloat(metricDistPos + 1);
            upperBound = cmdLine.getFloat(metricDistPos + 2);
            nHistograms = cmdLine.getInt(metricDistPos + 3);
        }
        if (byDescriptors) {
            HitStatistics.notYetImplemented('d', "by-descriptors");
            byDescriptors = false;
        }
        if (byAll) {
            HitStatistics.notYetImplemented('a', "by-all");
            byAll = false;
        }
        boolean bl = memorySafeMode = cmdLine.find('f', "memory-safe-mode") != -1;
        if (!(byDescriptors || byMetrics || byAll || metricDistribution)) {
            byMetrics = true;
        }
        if ((selectivityPos = cmdLine.find('l', "selectivity-effectiveness", 1)) != -1) {
            alpha = cmdLine.getFloat(selectivityPos + 1);
        }
    }

    private static void processRemaining() {
        String unprocessed = cmdLine.getUnused();
        while (unprocessed != null) {
            System.err.println(unprocessed);
            unprocessed = cmdLine.getUnused();
        }
    }

    private static void initSources() throws MDReaderException {
        targetReader = HitStatistics.initFileReader(targetFileName, descrInput);
        testSetReader = HitStatistics.initFileReader(testSetFileName, false);
        queryReader = HitStatistics.initFileReader(queryFileName, false);
        targetReader.setGenerateId(true);
        targetReader.setCloneResult(false);
        testSetReader.setGenerateId(true);
        testSetReader.setCloneResult(false);
        queryReader.setGenerateId(true);
        queryReader.setCloneResult(false);
    }

    private static MDReader initFileReader(String fn, boolean descrInput) throws MDReaderException {
        if (descrInput) {
            return new MDFileReader(descrNames);
        }
        MDFileReader r = new MDFileReader(fn, mdSet);
        for (int i = 0; i < descriptorCount; ++i) {
            if (tagNames[i] == null) continue;
            r.setTakeTag(i, tagNames[i]);
        }
        return r;
    }

    private static void notYetImplemented(char shortForm, String longForm) {
        System.err.println("Option -" + shortForm + ", --" + longForm + " is not yet implemented, ignored");
    }

    private static void verboseMsg(String msg) {
        if (verbose) {
            System.out.print(msg);
        }
    }

    private static void verboseDone() {
        if (verbose) {
            System.out.println(" done");
        }
    }

    private static String[] getArgsFromXML(String[] args) throws DocumentException, IOException {
        int j;
        String xmlFileName = args[1];
        SAXReader reader = new SAXReader();
        Document doc = reader.read(new File(xmlFileName));
        StringBuffer sb = new StringBuffer();
        boolean inputInXml = HitStatistics.transformInput(sb, doc);
        HitStatistics.transformOutput(sb, doc);
        HitStatistics.transformDescriptors(sb, doc);
        HitStatistics.transformSimilarityOptions(sb, doc);
        HitStatistics.transformStatisticsOptions(sb, doc);
        StringTokenizer stk = new StringTokenizer(sb.toString());
        String[] newArgs = new String[stk.countTokens() + args.length - 2];
        int i = 0;
        if (!inputInXml) {
            for (j = 2; j < args.length; ++j) {
                newArgs[i++] = args[j];
            }
        }
        while (stk.hasMoreTokens()) {
            newArgs[i++] = stk.nextToken();
        }
        if (inputInXml) {
            for (j = 2; j < args.length; ++j) {
                newArgs[i++] = args[j];
            }
        }
        return newArgs;
    }

    private static boolean transformInput(StringBuffer sb, Document doc) {
        Element inp = (Element)doc.selectSingleNode("//*/Input");
        if (inp == null) {
            return false;
        }
        sb.append(inp.attributeValue("TargetFile")).append(' ').append(inp.attributeValue("TestFile")).append(' ').append(inp.attributeValue("QueryFile")).append(' ');
        return true;
    }

    private static void transformOutput(StringBuffer sb, Document doc) {
        String targetHitOut;
        String prec;
        Element out = (Element)doc.selectSingleNode("//*/Output");
        if (out == null) {
            return;
        }
        String fn = out.attributeValue("FileName");
        if (fn != null) {
            sb.append(" -o ").append(fn).append(' ');
        }
        if ((prec = out.attributeValue("Precision")) != null) {
            sb.append(" -e ").append(prec).append(' ');
        }
        if ((targetHitOut = out.attributeValue("TargetHitOutput")) != null && targetHitOut.equals("true")) {
            sb.append(" -T ");
        }
    }

    private static void transformDescriptors(StringBuffer sb, Document doc) {
        List l = doc.selectNodes("//*/Descriptors/Descriptor");
        for (Element e : l) {
            String type = e.attributeValue("Type");
            sb.append(" -k ").append(type).append(" -c ").append(e.attributeValue("ConfigFile"));
            String tag = e.attributeValue("UseTag");
            if (tag != null) {
                sb.append(" -t ").append(tag);
            }
            HitStatistics.appendOptional(sb, e, "FuzzySmoothingFactor", "-z");
            HitStatistics.appendOptional(sb, e, "FuzzySmoothingVector", "-z");
            HitStatistics.appendOptional(sb, e, "GaussianCutoff", "-G");
            HitStatistics.appendOptional(sb, e, "SmoothingBound", "-B");
            HitStatistics.appendOptional(sb, e, "AsymmetricalSmoothing", "-A");
            HitStatistics.appendOptional(sb, e, "IgnoreRotatableBonds", "-R");
            HitStatistics.transformMetrics(sb, e.selectNodes("Metrics/Metric"));
        }
    }

    private static void transformMetrics(StringBuffer sb, List metrics2) {
        boolean first = true;
        for (Element e : metrics2) {
            if (first) {
                sb.append(" -M ");
                first = false;
            }
            sb.append(e.attributeValue("Name"));
        }
    }

    private static void transformSimilarityOptions(StringBuffer sb, Document doc) {
        Element inp = (Element)doc.selectSingleNode("//*/SimilarityOptions");
        if (inp != null) {
            if (inp.attributeValue("CompareQueries") != null && inp.attributeValue("CompareQueries").equals("true")) {
                sb.append(" -Q ");
            }
            if (inp.attributeValue("MetricsAnd") != null && inp.attributeValue("MetricsAnd").equals("true")) {
                sb.append(" -m ");
            }
            if (inp.attributeValue("DescriptorsAnd") != null && inp.attributeValue("DescriptorsAnd").equals("true")) {
                sb.append(" -r ");
            }
            List l = inp.selectNodes("Hypotheses/Hypothesis");
            for (Element e : l) {
                sb.append(" -H ").append(e.attributeValue("Type"));
                if (e.attributeValue("Consensus") == null || !e.attributeValue("Consensus").equals("true")) continue;
                sb.append(" C ");
            }
            if (inp.attributeValue("ZeroThreshold") != null) {
                sb.append(" -Z ").append(inp.attributeValue("ZeroThreshold"));
            }
        }
    }

    private static void transformStatisticsOptions(StringBuffer sb, Document doc) {
        Element inp = (Element)doc.selectSingleNode("//*/StatisticsOptions");
        if (inp == null) {
            return;
        }
        if (inp.attributeValue("ByMetrics") != null && inp.attributeValue("ByMetrics").equals("true")) {
            sb.append(" -b ");
        }
        if (inp.attributeValue("ByDescriptors") != null && inp.attributeValue("ByDescriptors").equals("true")) {
            sb.append(" -d ");
        }
        if (inp.attributeValue("ByAll") != null && inp.attributeValue("ByAll").equals("true")) {
            sb.append(" -a ");
        }
        if (inp.attributeValue("MemorySafeMode") != null && inp.attributeValue("MemorySafeMode").equals("true")) {
            sb.append(" -f ");
        }
        List l = inp.selectNodes("MetricDistribution");
        for (Element e : l) {
            sb.append(" -s ").append(e.attributeValue("LowerBound")).append(' ').append(e.attributeValue("UpperBound")).append(' ').append(e.attributeValue("HistogramCount"));
        }
        List s = inp.selectNodes("SelectivityAsymmetry");
        for (Element e : l) {
            sb.append(" -l ").append(e.attributeValue("AsymmeteryRatio"));
        }
    }

    private static void append(StringBuffer sb, Element n, String attr, String flag) {
        sb.append(' ').append(flag).append(' ').append(n.attributeValue(attr));
    }

    private static void appendOptional(StringBuffer sb, Element n, String attr, String flag) {
        if (n.attributeValue(attr) != null) {
            sb.append(' ').append(flag).append(' ').append(n.attributeValue(attr));
        }
    }
}

