/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.InHouseGeneratorParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InHouseDefaultParser
implements InHouseGeneratorParser<int[]> {
    BufferedReader b;
    String lastLine;
    private static Logger logger = Logger.getLogger(InHouseDefaultParser.class.getName());

    public InHouseDefaultParser() {
        logger.setLevel(Level.FINEST);
    }

    @Override
    public void setReader(BufferedReader b) {
        this.b = b;
    }

    @Override
    public int[] readLine() throws IOException, ParseException {
        int[] a = null;
        this.lastLine = null;
        this.lastLine = this.b.readLine();
        if (logger.getLevel() == Level.FINEST) {
            logger.finest("Line to be parsed from output: \n" + this.lastLine);
        }
        if (this.lastLine == null) {
            return null;
        }
        a = InHouseDefaultParser.string2IntArray(this.lastLine);
        return a;
    }

    public static int[] string2IntArray(String s) throws ParseException {
        int i;
        int length = s.length() / 32;
        if (s.length() % 32 > 0) {
            ++length;
        }
        int[] ret = new int[length];
        for (i = 0; i < ret.length; ++i) {
            ret[i] = 0;
        }
        for (i = 0; i < s.length(); ++i) {
            char val = s.charAt(i);
            if (val != '0' && val != '1') {
                throw new ParseException(s, i);
            }
            if (val != '1') continue;
            int pos = 31 - i % 32;
            int n = i / 32;
            ret[n] = ret[n] | 1 << pos;
        }
        if (ret.length == 0) {
            logger.severe("Fingerprint length is 0 . ");
        }
        return ret;
    }

    public static String intArray2String(int[] a) {
        String s = "";
        for (int i = 0; i < a.length; ++i) {
            int k = a[i];
            char[] ch = new char[32];
            int c = 0;
            for (int j = 0; j < 32; ++j) {
                int m = 1;
                ch[c++] = (k & (m <<= j)) == m ? 49 : 48;
            }
            for (int ic = ch.length - 1; ic >= 0; --ic) {
                s = s + ch[ic];
            }
        }
        return s;
    }

    @Override
    public String getLastLine() {
        return this.lastLine;
    }
}

