/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDHypothesisGenerator;
import chemaxon.descriptors.MDSet;

public class MDAvgHypothesisGenerator
implements MDHypothesisGenerator {
    private MDSet hypothesisMD = null;
    private float[][] floatHypothesis;
    private int nComponents = 0;

    @Override
    public void add(MDSet hypothesisComponent) {
        if (this.hypothesisMD == null) {
            this.hypothesisMD = new MDSet(hypothesisComponent);
            this.floatHypothesis = new float[this.hypothesisMD.size()][];
            for (int i = 0; i < this.hypothesisMD.size(); ++i) {
                this.floatHypothesis[i] = this.hypothesisMD.getDescriptor(i).toFloatArray();
            }
            ++this.nComponents;
            return;
        }
        for (int i = 0; i < this.floatHypothesis.length; ++i) {
            this.addDescriptors(this.floatHypothesis[i], hypothesisComponent.getDescriptor(i).toFloatArray());
        }
        ++this.nComponents;
    }

    @Override
    public MDSet generate() {
        if (this.hypothesisMD == null) {
            throw new RuntimeException("Bad usage. No components have been added yet.");
        }
        MDSet toReturn = new MDSet(this.hypothesisMD);
        for (int d = 0; d < this.floatHypothesis.length; ++d) {
            this.scaleDescriptor(this.floatHypothesis[d], this.nComponents);
            toReturn.getDescriptor(d).fromFloatArray(this.floatHypothesis[d]);
        }
        return toReturn;
    }

    @Override
    public String getTypeName() {
        return "Average";
    }

    private void addDescriptors(float[] addTo, float[] addIt) {
        for (int i = 0; i < addTo.length; ++i) {
            int n = i;
            addTo[n] = addTo[n] + addIt[i];
        }
    }

    private void scaleDescriptor(float[] descr, float scale) {
        int i = 0;
        while (i < descr.length) {
            int n = i++;
            descr[n] = descr[n] / scale;
        }
    }
}

