/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDParameters;
import chemaxon.descriptors.MDWriter;
import chemaxon.descriptors.MDWriterException;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.jchem.db.MDTableHandler;
import chemaxon.struc.Molecule;
import chemaxon.util.ConnectionHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class MDDBWriter
extends MDWriter {
    private String strucTableName = null;
    private Connection con = null;
    private ConnectionHandler conh = null;
    private PreparedStatement[] psmt = new PreparedStatement[20];
    private boolean updateMode = false;
    MolecularDescriptor[] descriptors = null;
    private boolean indexTable = false;

    public MDDBWriter() {
    }

    public MDDBWriter(boolean indexTable) {
        this.indexTable = indexTable;
    }

    public void setConnectionHandler(ConnectionHandler ch) {
        this.conh = ch;
        this.con = this.conh.getConnection();
    }

    public ConnectionHandler getConnectionHandler() {
        return this.conh;
    }

    public void setStructureTable(String strucTableName) {
        this.strucTableName = strucTableName;
    }

    public String getStructureTable() {
        return this.strucTableName;
    }

    public void setMDNames(String[] mdNames) {
        this.mdNames = mdNames;
    }

    public String[] getMDNames() {
        return this.mdNames;
    }

    @Override
    public MDParameters getMDParameters(int id) {
        if (this.descriptors == null) {
            try {
                this.initDescriptors();
            }
            catch (SQLException e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.descriptors[id].getParameters();
    }

    public void setUpdateMode(boolean updateMode) {
        this.updateMode = updateMode;
    }

    private PreparedStatement createPreparedStatementForInsert(String tableName) throws SQLException {
        String sql = "INSERT INTO " + tableName + " ( CD_ID, MD_DATA ) VALUES" + " ( ?, ? )";
        return this.con.prepareStatement(sql);
    }

    private PreparedStatement createPreparedStatementForUpdate(String tableName) throws SQLException {
        String sql = "UPDATE " + tableName + " SET MD_DATA=? WHERE CD_ID=?";
        return this.con.prepareStatement(sql);
    }

    public void put(String molString, int id) throws MDWriterException {
        this.put(molString, false, id);
    }

    @Override
    public void put(Molecule mol, int id) throws MDWriterException {
        this.put(mol, true, id);
    }

    private void put(Object molRep, boolean molRepIsMoculeObj, int id) throws MDWriterException {
        try {
            int x;
            if (this.descriptors == null) {
                this.initDescriptors();
            }
            if (molRepIsMoculeObj) {
                for (x = 0; x < this.descriptors.length; ++x) {
                    this.descriptors[x].generate((Molecule)molRep);
                }
            } else {
                for (x = 0; x < this.descriptors.length; ++x) {
                    this.descriptors[x].generate((String)molRep);
                }
            }
            if (this.updateMode) {
                this.update(id);
                return;
            }
            for (int i = 0; i < this.descriptors.length; ++i) {
                if (this.psmt[i] == null) {
                    this.psmt[i] = this.createPreparedStatementForInsert(MDTableHandler.getMDTableName(this.strucTableName, this.mdNames[i]));
                }
                this.psmt[i].setInt(1, id);
                byte[] data = this.descriptors[i].toData();
                this.psmt[i].setObject(2, data);
                this.psmt[i].execute();
            }
        }
        catch (MDGeneratorException e) {
            System.err.println("Descriptor generation error at cd_id: " + id);
            e.printStackTrace();
            throw new MDWriterException(e.getMessage(), e);
        }
        catch (SQLException e) {
            throw new MDWriterException(e.getMessage(), e);
        }
    }

    private void initDescriptors() throws SQLException {
        if (this.descriptors != null) {
            return;
        }
        MDTableHandler mdth = new MDTableHandler(this.conh, this.strucTableName, this.indexTable);
        this.descriptors = new MolecularDescriptor[this.mdNames.length];
        for (int x = 0; x < this.descriptors.length; ++x) {
            String type = mdth.getMDType(this.mdNames[x]);
            String settings = mdth.getMDSettings(this.mdNames[x]);
            MolecularDescriptor descriptor = MolecularDescriptor.newInstance(type);
            descriptor.setParameters(settings);
            this.descriptors[x] = descriptor;
        }
    }

    private void update(int id) throws MDWriterException {
        try {
            for (int i = 0; i < this.descriptors.length; ++i) {
                if (this.psmt[i] == null) {
                    this.psmt[i] = this.createPreparedStatementForUpdate(MDTableHandler.getMDTableName(this.strucTableName, this.mdNames[i]));
                }
                byte[] data = this.descriptors[i].toData();
                this.psmt[i].setObject(1, data);
                this.psmt[i].setInt(2, id);
                this.psmt[i].execute();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new MDWriterException(e.getMessage(), e);
        }
    }

    @Override
    public void close() throws MDWriterException {
        try {
            if (!this.con.getAutoCommit()) {
                this.con.commit();
            }
            for (int x = 0; x < this.psmt.length; ++x) {
                if (this.psmt[x] == null) continue;
                this.psmt[x].close();
            }
        }
        catch (SQLException e) {
            throw new MDWriterException(e.getMessage(), e);
        }
    }
}

