/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.struc.Molecule;

public abstract class MDGenerator {
    protected boolean createStatistics = false;
    protected int molCount = 0;
    protected float minNonEmptyPercent = 1.0f;
    protected int minNonEmptyId = -1;
    protected float maxNonEmptyPercent = 0.0f;
    protected int maxNonEmptyId = -1;
    protected float sumNonEmptyPercent = 0.0f;
    protected int[] freqCount = null;
    protected int[] density = new int[11];

    public abstract String[] generate(Molecule var1, MolecularDescriptor var2) throws MDGeneratorException;

    public void setCreateStatistics(boolean createStatistics) {
        this.createStatistics = createStatistics;
    }

    protected void updateStatistics(MolecularDescriptor d) {
        if (this.freqCount == null) {
            this.freqCount = new int[d.getParameters().getLength()];
        }
        ++this.molCount;
        float nz = (float)this.calcFreqCount(d) / (float)d.getParameters().getLength();
        if (nz < this.minNonEmptyPercent) {
            this.minNonEmptyPercent = nz;
            this.minNonEmptyId = this.molCount;
        }
        if (nz > this.maxNonEmptyPercent) {
            this.maxNonEmptyPercent = nz;
            this.maxNonEmptyId = this.molCount;
        }
        this.sumNonEmptyPercent += nz;
        int n = (int)(10.0f * nz);
        this.density[n] = this.density[n] + 1;
    }

    protected int calcFreqCount(MolecularDescriptor d) {
        return 0;
    }

    public int getMoleculeCount() {
        return this.molCount;
    }

    public float getAverageNonZeroRatio() {
        return this.sumNonEmptyPercent / (float)this.molCount;
    }

    public float getMaximumBitRatio() {
        return this.maxNonEmptyPercent;
    }

    public int getBrightestMolId() {
        return this.maxNonEmptyId;
    }

    public float getMinimumBitRatio() {
        return this.minNonEmptyPercent;
    }

    public int getDarkestMolId() {
        return this.minNonEmptyId;
    }

    public int[] getDensityCounts() {
        return this.density;
    }

    public int[] getFrequencyCounts() {
        return this.freqCount;
    }
}

