/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDReader;
import chemaxon.descriptors.MDReaderException;
import chemaxon.descriptors.MDSet;
import chemaxon.descriptors.MDSimilarity;
import java.util.ArrayList;
import java.util.Arrays;

public class MDHitEvaluator {
    public String[] evaluatorFunctions = new String[]{"Enrichment", "SelectivityEffectiveness", "ActiveHitDistribution"};
    private MDSimilarity similarity;
    private MDSet sample;
    private ArrayList similars = null;
    private ArrayList dissimilars = null;
    private ArrayList similarCoeffs = null;
    private ArrayList dissimilarCoeffs = null;
    private CoeffId[] sortedSimilars = null;
    private ArrayList[] insertedDissimilars = null;
    private int nSimilarHits = 0;
    private int nSimilars = 0;
    private int nDissimilars = 0;
    private ArrayList dissimilarHits = null;
    private float[][] thresholds = null;
    private int lastSimilarReturned = -1;
    private int lastDissimilarReturned = -1;
    private boolean dissimilarityCalculated = false;
    private int evaluatorIndex = 0;
    private float alpha = 0.5f;
    private float[][][] allCoeffs = null;
    private float[] metricCoeffs = null;

    public MDHitEvaluator(MDSimilarity similarity) {
        this.similarity = similarity;
        this.similars = new ArrayList(10);
        this.dissimilars = new ArrayList(10);
        this.similarCoeffs = new ArrayList(10);
        this.dissimilarCoeffs = new ArrayList(10);
        this.dissimilarHits = new ArrayList(10);
        this.sample = similarity.getQuery(0);
        this.thresholds = new float[this.sample.size()][];
        this.allCoeffs = new float[similarity.getNrOfQueries()][this.sample.size()][];
        this.metricCoeffs = new float[similarity.getNrOfQueries()];
        for (int d = 0; d < this.thresholds.length; ++d) {
            this.thresholds[d] = new float[this.sample.getDescriptor(d).getNumberOfMetrics()];
        }
    }

    public void setCurrentEvaluatorFunction(int index) {
        this.evaluatorIndex = index;
    }

    public int getCurrentEvaluatorFunction() {
        return this.evaluatorIndex;
    }

    public int getEvaluatorFunctionIndex(String name) throws IllegalArgumentException {
        for (int i = 0; i < this.evaluatorFunctions.length; ++i) {
            if (!this.evaluatorFunctions[i].equalsIgnoreCase(name)) continue;
            return i;
        }
        throw new IllegalArgumentException("Invalid evaluator name " + name);
    }

    public String getEvaluatorFunctionName(int index) {
        return this.evaluatorFunctions[index];
    }

    public void setSelectivityAsymmetryFactor(float alpha) throws IllegalArgumentException {
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException("Illegal selectivity asymmetry factor value");
        }
        this.alpha = alpha;
    }

    public float getSelectivityAsymmetryFactor() {
        return this.alpha;
    }

    public void calcDissimilarity(MDReader similarSetReader, MDReader dissimilarSetReader) throws MDReaderException {
        this.lastSimilarReturned = -1;
        this.lastDissimilarReturned = -1;
        this.similars.clear();
        this.similarCoeffs.clear();
        this.dissimilars.clear();
        this.dissimilarCoeffs.clear();
        this.dissimilarHits.clear();
        this.nSimilarHits = 0;
        MDSet target = similarSetReader.next();
        while (target != null) {
            this.similarCoeffs.add(this.calcDissimilarityCoeffs(target, true));
            this.similars.add(new Integer(target.getId()));
            target = similarSetReader.next();
        }
        similarSetReader.reset();
        target = dissimilarSetReader.next();
        while (target != null) {
            this.dissimilarCoeffs.add(this.calcDissimilarityCoeffs(target, true));
            this.dissimilars.add(new Integer(target.getId()));
            target = dissimilarSetReader.next();
        }
        dissimilarSetReader.reset();
        this.nSimilars = this.similars.size();
        this.nDissimilars = this.dissimilars.size();
        if (this.sortedSimilars == null || this.sortedSimilars.length != this.nSimilars) {
            this.sortedSimilars = new CoeffId[this.nSimilars];
            this.insertedDissimilars = new ArrayList[this.nSimilars];
            for (int i = 0; i < this.sortedSimilars.length; ++i) {
                this.sortedSimilars[i] = new CoeffId();
                this.insertedDissimilars[i] = new ArrayList();
            }
        }
        this.dissimilarityCalculated = true;
    }

    public float[] screen(int descrIndex, int metricIndex, float threshold) {
        int s;
        if (!this.dissimilarityCalculated) {
            throw new RuntimeException("Dissimilarities should be calculated first.");
        }
        if (this.nSimilars == 0) {
            throw new RuntimeException("At least one similar molecule should be defined.");
        }
        this.lastSimilarReturned = -1;
        this.lastDissimilarReturned = -1;
        this.sortSimilars(descrIndex, metricIndex);
        this.thresholds[descrIndex][metricIndex] = threshold;
        for (s = 0; s < this.nSimilars && this.sortedSimilars[s].coeff <= threshold; ++s) {
        }
        this.nSimilarHits = s;
        this.dissimilarHits.clear();
        for (int ds = 0; ds < this.nDissimilars; ++ds) {
            float[][][] dissimCoeffs = (float[][][])this.dissimilarCoeffs.get(ds);
            float minDissimCoeff = Float.MAX_VALUE;
            for (int hq = 0; hq < dissimCoeffs.length; ++hq) {
                minDissimCoeff = Math.min(dissimCoeffs[hq][descrIndex][metricIndex], minDissimCoeff);
            }
            if (minDissimCoeff <= this.thresholds[descrIndex][metricIndex]) {
                this.dissimilarHits.add(this.dissimilars.get(ds));
            }
            this.insertDissimilarBetweenSimilars((Integer)this.dissimilars.get(ds), minDissimCoeff);
        }
        return this.evaluateAll(this.nSimilarHits, this.dissimilarHits.size());
    }

    public float[] screen(int descrIndex, int metricIndex, float threshold, MDReader similarSetReader, MDReader dissimilarSetReader) throws MDReaderException {
        int s;
        this.lastSimilarReturned = -1;
        this.lastDissimilarReturned = -1;
        this.initDissimilarityCalc();
        this.sortSimilars(descrIndex, metricIndex, similarSetReader);
        this.thresholds[descrIndex][metricIndex] = threshold;
        for (s = 0; s < this.nSimilars && this.sortedSimilars[s].coeff <= threshold; ++s) {
        }
        this.nSimilarHits = s;
        this.dissimilarHits.clear();
        MDSet target = dissimilarSetReader.next();
        this.nDissimilars = 0;
        while (target != null) {
            float[] dissimCoeffs = this.calcDissimilarityCoeffs(descrIndex, metricIndex, target, false);
            float minDissimCoeff = Float.MAX_VALUE;
            for (int hq = 0; hq < dissimCoeffs.length; ++hq) {
                minDissimCoeff = Math.min(dissimCoeffs[hq], minDissimCoeff);
            }
            if (minDissimCoeff <= this.thresholds[descrIndex][metricIndex]) {
                this.dissimilarHits.add(new Integer(target.getId()));
            }
            this.insertDissimilarBetweenSimilars(target.getId(), minDissimCoeff);
            target = dissimilarSetReader.next();
            ++this.nDissimilars;
        }
        dissimilarSetReader.reset();
        this.dissimilarityCalculated = false;
        return this.evaluateAll(this.nSimilarHits, this.dissimilarHits.size());
    }

    public float evaluateByMetric(int descrIndex, int metricIndex, int nSimilarHits) {
        if (!this.dissimilarityCalculated) {
            throw new RuntimeException("Dissimilarities should be calculated first.");
        }
        if (nSimilarHits < 1 || this.nSimilars == 0) {
            throw new RuntimeException("At least one similar molecule should be defined and required to be a hit.");
        }
        this.lastSimilarReturned = -1;
        this.lastDissimilarReturned = -1;
        this.sortSimilars(descrIndex, metricIndex);
        this.thresholds[descrIndex][metricIndex] = this.sortedSimilars[nSimilarHits - 1].coeff;
        this.nSimilarHits = nSimilarHits;
        this.dissimilarHits.clear();
        for (int ds = 0; ds < this.nDissimilars; ++ds) {
            boolean pass = false;
            float[][][] dissimCoeffs = (float[][][])this.dissimilarCoeffs.get(ds);
            if (this.evaluatorIndex < 2) {
                for (int hq = 0; !pass && hq < dissimCoeffs.length; ++hq) {
                    pass = dissimCoeffs[hq][descrIndex][metricIndex] <= this.thresholds[descrIndex][metricIndex];
                }
                if (!pass) continue;
                this.dissimilarHits.add(this.dissimilars.get(ds));
                continue;
            }
            if (this.evaluatorIndex != 2) continue;
            float minDissimCoeff = Float.MAX_VALUE;
            for (int hq = 0; hq < dissimCoeffs.length; ++hq) {
                minDissimCoeff = Math.min(dissimCoeffs[hq][descrIndex][metricIndex], minDissimCoeff);
            }
            if (minDissimCoeff <= this.thresholds[descrIndex][metricIndex]) {
                this.dissimilarHits.add(this.dissimilars.get(ds));
            }
            this.insertDissimilarBetweenSimilars((Integer)this.dissimilars.get(ds), minDissimCoeff);
        }
        return this.evaluate(nSimilarHits, this.dissimilarHits.size());
    }

    public float evaluateByMetric(int descrIndex, int metricIndex, int nSimilarHits, MDReader similarSetReader, MDReader dissimilarSetReader) throws MDReaderException {
        if (nSimilarHits < 1) {
            throw new RuntimeException("At least one similar molecule should be required to be a hit.");
        }
        this.lastSimilarReturned = -1;
        this.lastDissimilarReturned = -1;
        this.initDissimilarityCalc();
        this.sortSimilars(descrIndex, metricIndex, similarSetReader);
        this.thresholds[descrIndex][metricIndex] = this.sortedSimilars[nSimilarHits - 1].coeff;
        this.nSimilarHits = nSimilarHits;
        this.dissimilarHits.clear();
        MDSet target = dissimilarSetReader.next();
        this.nDissimilars = 0;
        while (target != null) {
            int hq;
            float[] dissimCoeffs = this.calcDissimilarityCoeffs(descrIndex, metricIndex, target, false);
            if (this.evaluatorIndex < 2) {
                boolean pass = false;
                for (hq = 0; !pass && hq < dissimCoeffs.length; ++hq) {
                    pass = dissimCoeffs[hq] <= this.thresholds[descrIndex][metricIndex];
                }
                if (pass) {
                    this.dissimilarHits.add(new Integer(target.getId()));
                }
            } else if (this.evaluatorIndex == 2) {
                float minDissimCoeff = Float.MAX_VALUE;
                for (hq = 0; hq < dissimCoeffs.length; ++hq) {
                    minDissimCoeff = Math.min(dissimCoeffs[hq], minDissimCoeff);
                }
                if (minDissimCoeff <= this.thresholds[descrIndex][metricIndex]) {
                    this.dissimilarHits.add(new Integer(target.getId()));
                }
                this.insertDissimilarBetweenSimilars(target.getId(), minDissimCoeff);
            }
            target = dissimilarSetReader.next();
            ++this.nDissimilars;
        }
        dissimilarSetReader.reset();
        this.dissimilarityCalculated = false;
        return this.evaluate(nSimilarHits, this.dissimilarHits.size());
    }

    public float evaluateByMetric(int descrIndex, int metricIndex, int fromNSimilarHits, int toNSimilarHits) {
        if (!this.dissimilarityCalculated) {
            throw new RuntimeException("Dissimilarities should be calculated first.");
        }
        if (fromNSimilarHits < 1 || this.nSimilars == 0) {
            throw new RuntimeException("At least one similar molecule should be defined and required to be a hit.");
        }
        this.lastSimilarReturned = -1;
        this.lastDissimilarReturned = -1;
        this.sortSimilars(descrIndex, metricIndex);
        return this.findDissimilarHits(descrIndex, metricIndex, fromNSimilarHits, toNSimilarHits);
    }

    public float evaluateByMetric(int descrIndex, int metricIndex, float minPercentageOfSimilarHits) {
        int fromNSimilarHits = (int)Math.ceil(minPercentageOfSimilarHits / 100.0f * (float)this.nSimilars);
        int toNSimilarHits = this.nSimilars;
        return this.evaluateByMetric(descrIndex, metricIndex, fromNSimilarHits, toNSimilarHits);
    }

    public float evaluateByMetric(int descrIndex, int metricIndex, int fromNSimilarHits, int toNSimilarHits, MDReader similarSetReader, MDReader dissimilarSetReader) throws MDReaderException {
        if (fromNSimilarHits < 1) {
            throw new RuntimeException("At least one similar molecule should be required to be a hit.");
        }
        this.lastSimilarReturned = -1;
        this.lastDissimilarReturned = -1;
        this.initDissimilarityCalc();
        this.sortSimilars(descrIndex, metricIndex, similarSetReader);
        return this.findDissimilarHits(descrIndex, metricIndex, fromNSimilarHits, toNSimilarHits, dissimilarSetReader);
    }

    public float evaluateByMetric(int descrIndex, int metricIndex, float minPercentageOfSimilarHits, MDReader similarSetReader, MDReader dissimilarSetReader) throws MDReaderException {
        if (minPercentageOfSimilarHits <= 0.0f || minPercentageOfSimilarHits > 100.0f) {
            throw new RuntimeException("Minimal required percentage of similar hits should be int the interval (0, 100]");
        }
        this.lastSimilarReturned = -1;
        this.lastDissimilarReturned = -1;
        this.initDissimilarityCalc();
        this.sortSimilars(descrIndex, metricIndex, similarSetReader);
        int fromNSimilarHits = (int)Math.ceil(minPercentageOfSimilarHits / 100.0f * (float)this.nSimilars);
        int toNSimilarHits = this.nSimilars;
        return this.findDissimilarHits(descrIndex, metricIndex, fromNSimilarHits, toNSimilarHits, dissimilarSetReader);
    }

    public float evaluateByDescriptor(int descrIndex, int nSimilarHits) {
        return 0.0f;
    }

    public float evaluateByDescriptor(int descrIndex, int fromNSimilarHits, int toNSimilarHits) {
        return 0.0f;
    }

    public float evaluateByAll(int nSimilarHits) {
        return 0.0f;
    }

    public float evaluateByAll(int fromNSimilarHits, int toNSimilarHits) {
        return 0.0f;
    }

    public int getNumberOfSimilars() {
        return this.nSimilars;
    }

    public int getNumberOfDissimilars() {
        return this.nDissimilars;
    }

    public int getNumberOfSimilarHits() {
        return this.nSimilarHits;
    }

    public int getNumberOfDissimilarHits() {
        return this.dissimilarHits.size();
    }

    public void resetSimilarHits() {
        this.lastSimilarReturned = -1;
    }

    public void resetDissimilarHits() {
        this.lastDissimilarReturned = -1;
    }

    public int getNextSimilarHit() {
        if (++this.lastSimilarReturned < this.nSimilarHits) {
            return (Integer)this.similars.get(this.sortedSimilars[this.lastSimilarReturned].id);
        }
        return -1;
    }

    public int getNextDissimilarHit() {
        if (++this.lastDissimilarReturned < this.dissimilarHits.size()) {
            return (Integer)this.dissimilarHits.get(this.lastDissimilarReturned);
        }
        return -1;
    }

    public float getThreshold(int descrIndex, int metricIndex) {
        return this.thresholds[descrIndex][metricIndex];
    }

    public ArrayList[] getInsertedDissimilars() {
        return this.insertedDissimilars;
    }

    public int[] calcMetricDistribution(int descrIndex, int metricIndex, float lowerBound, float upperBound, int nHistograms, float[] metricValues) {
        float z;
        int q;
        int t;
        if (!this.dissimilarityCalculated) {
            throw new RuntimeException("Dissimilarities should be calculated first.");
        }
        if (nHistograms < 3) {
            throw new RuntimeException("Number of histograms should be at least 3");
        }
        if (metricValues.length != nHistograms + 1) {
            throw new RuntimeException("Length of metricValues array should be equal to number of histograms plus 1");
        }
        int[] histogramValues = new int[nHistograms];
        for (int i = 0; i < nHistograms; ++i) {
            histogramValues[i] = 0;
        }
        float histogramSize = (upperBound - lowerBound) / (float)(nHistograms - 2);
        metricValues[0] = Float.MAX_VALUE;
        metricValues[nHistograms] = -3.4028235E38f;
        for (int i = 0; i < nHistograms - 1; ++i) {
            metricValues[i + 1] = lowerBound + (float)i * histogramSize;
        }
        for (t = 0; t < this.similarCoeffs.size(); ++t) {
            float[][][] simCoeffsByTarget = (float[][][])this.similarCoeffs.get(t);
            for (q = 0; q < simCoeffsByTarget.length; ++q) {
                z = simCoeffsByTarget[q][descrIndex][metricIndex];
                if (z == upperBound) {
                    int n = nHistograms - 2;
                    histogramValues[n] = histogramValues[n] + 1;
                    continue;
                }
                if (z >= lowerBound && z < upperBound) {
                    int n = (int)Math.floor((z - lowerBound) / histogramSize) + 1;
                    histogramValues[n] = histogramValues[n] + 1;
                    continue;
                }
                if (z < lowerBound) {
                    histogramValues[0] = histogramValues[0] + 1;
                    metricValues[0] = Math.min(metricValues[0], z);
                    continue;
                }
                int n = nHistograms - 1;
                histogramValues[n] = histogramValues[n] + 1;
                metricValues[nHistograms] = Math.max(metricValues[nHistograms], z);
            }
        }
        for (t = 0; t < this.dissimilarCoeffs.size(); ++t) {
            float[][][] dissimCoeffsByTarget = (float[][][])this.dissimilarCoeffs.get(t);
            for (q = 0; q < dissimCoeffsByTarget.length; ++q) {
                z = dissimCoeffsByTarget[q][descrIndex][metricIndex];
                if (z == upperBound) {
                    int n = nHistograms - 2;
                    histogramValues[n] = histogramValues[n] + 1;
                    continue;
                }
                if (z >= lowerBound && z < upperBound) {
                    int n = (int)Math.floor((z - lowerBound) / histogramSize) + 1;
                    histogramValues[n] = histogramValues[n] + 1;
                    continue;
                }
                if (z < lowerBound) {
                    histogramValues[0] = histogramValues[0] + 1;
                    metricValues[0] = Math.min(metricValues[0], z);
                    continue;
                }
                int n = nHistograms - 1;
                histogramValues[n] = histogramValues[n] + 1;
                metricValues[nHistograms] = Math.max(metricValues[nHistograms], z);
            }
        }
        if (metricValues[0] == Float.MAX_VALUE) {
            metricValues[0] = metricValues[1];
        }
        if (metricValues[nHistograms] == -3.4028235E38f) {
            metricValues[nHistograms] = metricValues[nHistograms - 1];
        }
        return histogramValues;
    }

    public int[] calcMetricDistribution(int descrIndex, int metricIndex, float lowerBound, float upperBound, int nHistograms, float[] metricValues, MDReader similarSetReader, MDReader dissimilarSetReader) throws MDReaderException {
        float z;
        int q;
        if (nHistograms < 3) {
            throw new RuntimeException("Number of histograms should be at least 3");
        }
        if (metricValues.length != nHistograms + 1) {
            throw new RuntimeException("Length of metricValues array should be equal to number of histograms plus 1");
        }
        int[] histogramValues = new int[nHistograms];
        for (int i = 0; i < nHistograms; ++i) {
            histogramValues[i] = 0;
        }
        float histogramSize = (upperBound - lowerBound) / (float)(nHistograms - 2);
        metricValues[0] = Float.MAX_VALUE;
        metricValues[nHistograms] = -3.4028235E38f;
        for (int i = 0; i < nHistograms - 1; ++i) {
            metricValues[i + 1] = lowerBound + (float)i * histogramSize;
        }
        MDSet target = similarSetReader.next();
        this.nSimilars = 0;
        while (target != null) {
            float[] simCoeffsByTarget = this.calcDissimilarityCoeffs(descrIndex, metricIndex, target, false);
            for (q = 0; q < simCoeffsByTarget.length; ++q) {
                z = simCoeffsByTarget[q];
                if (z == upperBound) {
                    int n = nHistograms - 2;
                    histogramValues[n] = histogramValues[n] + 1;
                    continue;
                }
                if (z >= lowerBound && z < upperBound) {
                    int n = (int)Math.floor((z - lowerBound) / histogramSize) + 1;
                    histogramValues[n] = histogramValues[n] + 1;
                    continue;
                }
                if (z < lowerBound) {
                    histogramValues[0] = histogramValues[0] + 1;
                    metricValues[0] = Math.min(metricValues[0], z);
                    continue;
                }
                int n = nHistograms - 1;
                histogramValues[n] = histogramValues[n] + 1;
                metricValues[nHistograms] = Math.max(metricValues[nHistograms], z);
            }
            target = similarSetReader.next();
            ++this.nSimilars;
        }
        similarSetReader.reset();
        target = dissimilarSetReader.next();
        this.nDissimilars = 0;
        while (target != null) {
            float[] dissimCoeffsByTarget = this.calcDissimilarityCoeffs(descrIndex, metricIndex, target, false);
            for (q = 0; q < dissimCoeffsByTarget.length; ++q) {
                z = dissimCoeffsByTarget[q];
                if (z == upperBound) {
                    int n = nHistograms - 2;
                    histogramValues[n] = histogramValues[n] + 1;
                    continue;
                }
                if (z >= lowerBound && z < upperBound) {
                    int n = (int)Math.floor((z - lowerBound) / histogramSize) + 1;
                    histogramValues[n] = histogramValues[n] + 1;
                    continue;
                }
                if (z < lowerBound) {
                    histogramValues[0] = histogramValues[0] + 1;
                    metricValues[0] = Math.min(metricValues[0], z);
                    continue;
                }
                int n = nHistograms - 1;
                histogramValues[n] = histogramValues[n] + 1;
                metricValues[nHistograms] = Math.max(metricValues[nHistograms], z);
            }
            target = dissimilarSetReader.next();
            ++this.nDissimilars;
        }
        dissimilarSetReader.reset();
        if (metricValues[0] == Float.MAX_VALUE) {
            metricValues[0] = metricValues[1];
        }
        if (metricValues[nHistograms] == -3.4028235E38f) {
            metricValues[nHistograms] = metricValues[nHistograms - 1];
        }
        this.dissimilarityCalculated = false;
        return histogramValues;
    }

    private float[][][] calcDissimilarityCoeffs(MDSet target, boolean toBeStored) {
        int nQ = this.similarity.getNrOfQueries();
        int nD = this.sample.size();
        float[][][] coeffs = toBeStored ? new float[nQ][nD][] : this.allCoeffs;
        this.similarity.compare(target);
        for (int q = 0; q < nQ; ++q) {
            for (int d = 0; d < nD; ++d) {
                coeffs[q][d] = (float[])this.similarity.getDissimilarityCoeffs(q, d).clone();
            }
        }
        return coeffs;
    }

    private float[] calcDissimilarityCoeffs(int descrIndex, int metricIndex, MDSet target, boolean toBeStored) {
        int nQ = this.similarity.getNrOfQueries();
        float[] coeffs = toBeStored ? new float[nQ] : this.metricCoeffs;
        this.similarity.compare(descrIndex, metricIndex, target);
        for (int q = 0; q < nQ; ++q) {
            coeffs[q] = this.similarity.getDissimilarityCoeff(q, descrIndex, metricIndex);
        }
        return coeffs;
    }

    private void sortSimilars(int descrIndex, int metricIndex) {
        for (int s = 0; s < this.sortedSimilars.length; ++s) {
            float[][][] simCoeffs = (float[][][])this.similarCoeffs.get(s);
            this.sortedSimilars[s].coeff = Float.MAX_VALUE;
            this.sortedSimilars[s].id = s;
            for (int hq = 0; hq < simCoeffs.length; ++hq) {
                this.sortedSimilars[s].coeff = Math.min(simCoeffs[hq][descrIndex][metricIndex], this.sortedSimilars[s].coeff);
            }
            this.insertedDissimilars[s].clear();
        }
        Arrays.sort(this.sortedSimilars);
    }

    private void initDissimilarityCalc() {
        this.similars.clear();
        this.similarCoeffs.clear();
        this.dissimilars.clear();
        this.dissimilarCoeffs.clear();
        this.dissimilarHits.clear();
        this.nSimilarHits = 0;
    }

    private void sortSimilars(int descrIndex, int metricIndex, MDReader similarSetReader) throws MDReaderException {
        ArrayList<CoeffId> simCoeffIdList = new ArrayList<CoeffId>();
        MDSet target = similarSetReader.next();
        this.nSimilars = 0;
        while (target != null) {
            float[] simCoeffs = this.calcDissimilarityCoeffs(descrIndex, metricIndex, target, false);
            CoeffId simListElement = new CoeffId();
            simListElement.coeff = Float.MAX_VALUE;
            simListElement.id = this.nSimilars;
            for (int hq = 0; hq < simCoeffs.length; ++hq) {
                simListElement.coeff = Math.min(simCoeffs[hq], simListElement.coeff);
            }
            simCoeffIdList.add(simListElement);
            target = similarSetReader.next();
            ++this.nSimilars;
        }
        similarSetReader.reset();
        if (this.sortedSimilars == null || this.sortedSimilars.length != simCoeffIdList.size()) {
            this.sortedSimilars = new CoeffId[simCoeffIdList.size()];
            this.insertedDissimilars = new ArrayList[this.sortedSimilars.length];
        }
        for (int i = 0; i < this.sortedSimilars.length; ++i) {
            this.sortedSimilars[i] = (CoeffId)simCoeffIdList.get(i);
            this.insertedDissimilars[i] = new ArrayList();
        }
        Arrays.sort(this.sortedSimilars);
    }

    private float findDissimilarHits(int descrIndex, int metricIndex, int fromNSimilarHits, int toNSimilarHits) {
        ArrayList actDHits = new ArrayList();
        this.dissimilarHits.clear();
        for (int ds = 0; ds < this.nDissimilars; ++ds) {
            float[][][] dissimCoeffs = (float[][][])this.dissimilarCoeffs.get(ds);
            float minDissimCoeff = Float.MAX_VALUE;
            for (int hq = 0; hq < dissimCoeffs.length; ++hq) {
                minDissimCoeff = Math.min(dissimCoeffs[hq][descrIndex][metricIndex], minDissimCoeff);
            }
            this.insertDissimilarBetweenSimilars((Integer)this.dissimilars.get(ds), minDissimCoeff);
        }
        for (int dk = 0; dk < fromNSimilarHits; ++dk) {
            this.dissimilarHits.addAll(this.insertedDissimilars[dk]);
        }
        float bestEvaluatorValue = this.evaluate(fromNSimilarHits, this.dissimilarHits.size());
        int actualNDissimilarHits = this.dissimilarHits.size();
        this.nSimilarHits = fromNSimilarHits;
        for (int sk = fromNSimilarHits; sk < toNSimilarHits; ++sk) {
            float evaluatorValue = this.evaluate(sk + 1, actualNDissimilarHits += this.insertedDissimilars[sk].size());
            if (!(evaluatorValue >= bestEvaluatorValue)) continue;
            bestEvaluatorValue = evaluatorValue;
            for (int i = this.nSimilarHits; i <= sk; ++i) {
                this.dissimilarHits.addAll(this.insertedDissimilars[i]);
            }
            this.nSimilarHits = sk + 1;
        }
        this.thresholds[descrIndex][metricIndex] = this.sortedSimilars[this.nSimilarHits - 1].coeff;
        return this.evaluate(this.nSimilarHits, this.dissimilarHits.size());
    }

    private float findDissimilarHits(int descrIndex, int metricIndex, int fromNSimilarHits, int toNSimilarHits, MDReader dissimilarSetReader) throws MDReaderException {
        this.dissimilarHits.clear();
        MDSet target = dissimilarSetReader.next();
        this.nDissimilars = 0;
        while (target != null) {
            float[] dissimCoeffs = this.calcDissimilarityCoeffs(descrIndex, metricIndex, target, false);
            float minDissimCoeff = Float.MAX_VALUE;
            for (int hq = 0; hq < dissimCoeffs.length; ++hq) {
                minDissimCoeff = Math.min(dissimCoeffs[hq], minDissimCoeff);
            }
            this.insertDissimilarBetweenSimilars(target.getId(), minDissimCoeff);
            target = dissimilarSetReader.next();
            ++this.nDissimilars;
        }
        dissimilarSetReader.reset();
        for (int dk = 0; dk < fromNSimilarHits; ++dk) {
            this.dissimilarHits.addAll(this.insertedDissimilars[dk]);
        }
        float bestEvaluatorValue = this.evaluate(fromNSimilarHits, this.dissimilarHits.size());
        int actualNDissimilarHits = this.dissimilarHits.size();
        this.nSimilarHits = fromNSimilarHits;
        for (int sk = fromNSimilarHits; sk < toNSimilarHits; ++sk) {
            float evaluatorValue = this.evaluate(sk + 1, actualNDissimilarHits += this.insertedDissimilars[sk].size());
            if (!(evaluatorValue >= bestEvaluatorValue)) continue;
            bestEvaluatorValue = evaluatorValue;
            for (int i = this.nSimilarHits; i <= sk; ++i) {
                this.dissimilarHits.addAll(this.insertedDissimilars[i]);
            }
            this.nSimilarHits = sk + 1;
        }
        this.thresholds[descrIndex][metricIndex] = this.sortedSimilars[this.nSimilarHits - 1].coeff;
        this.dissimilarityCalculated = false;
        return this.evaluate(this.nSimilarHits, this.dissimilarHits.size());
    }

    private void insertDissimilarBetweenSimilars(int id, float dissimCoeffValue) {
        if (dissimCoeffValue > this.sortedSimilars[this.nSimilars - 1].coeff) {
            return;
        }
        CoeffId dissimCoeff = new CoeffId();
        dissimCoeff.id = -1;
        dissimCoeff.coeff = dissimCoeffValue;
        int place = Arrays.binarySearch(this.sortedSimilars, dissimCoeff);
        if (place < 0) {
            this.insertedDissimilars[-place - 1].add(new Integer(id));
        } else {
            while (place > 0 && this.sortedSimilars[place - 1].coeff == dissimCoeffValue) {
                --place;
            }
            this.insertedDissimilars[place].add(new Integer(id));
        }
    }

    private float evaluate(int nSimilarHits, int nDissimilarHits) {
        switch (this.evaluatorIndex) {
            case 0: {
                return (float)(nSimilarHits * (this.nSimilars + this.nDissimilars)) / (float)(this.nSimilars * (nSimilarHits + nDissimilarHits));
            }
            case 1: {
                return this.alpha * (float)nSimilarHits / (float)this.nSimilars + (1.0f - this.alpha) * (float)(this.nDissimilars - nDissimilarHits) / (float)this.nDissimilars;
            }
            case 2: {
                int x = 0;
                for (int i = 0; i < this.nSimilars; ++i) {
                    x += (this.nSimilars - i) * this.insertedDissimilars[i].size();
                }
                return 1.0f - 2.0f * (float)x / (float)(this.nSimilars * this.nDissimilars);
            }
        }
        return -1.0f;
    }

    private float[] evaluateAll(int nSimilarHits, int nDissimilarHits) {
        float[] fValues = new float[this.evaluatorFunctions.length];
        this.evaluatorIndex = 0;
        while (this.evaluatorIndex < fValues.length) {
            fValues[this.evaluatorIndex] = this.evaluate(nSimilarHits, nDissimilarHits);
            ++this.evaluatorIndex;
        }
        return fValues;
    }

    private class CoeffId
    implements Comparable {
        public float coeff;
        public int id;

        private CoeffId() {
        }

        public int compareTo(Object o) {
            CoeffId oTypized = (CoeffId)o;
            if (this.coeff == oTypized.coeff) {
                return 0;
            }
            if (this.coeff > oTypized.coeff) {
                return 1;
            }
            return -1;
        }
    }
}

