/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDHypothesisGenerator;
import chemaxon.descriptors.MDSet;
import java.util.ArrayList;
import java.util.Arrays;

public class MDMedHypothesisGenerator
implements MDHypothesisGenerator {
    private ArrayList hypoComponents = null;
    private float zeroThreshold = 50.0f;

    @Override
    public void add(MDSet hypothesisComponent) {
        if (this.hypoComponents == null) {
            this.hypoComponents = new ArrayList();
        }
        this.hypoComponents.add(hypothesisComponent.clone());
    }

    public void setZeroPercentageThreshold(float threshold) {
        if (threshold < 0.0f || threshold > 100.0f) {
            throw new IllegalArgumentException("Median hypothesis zero threshold is out of bounds");
        }
        this.zeroThreshold = threshold;
    }

    public float getZeroPercentageThreshold() {
        return this.zeroThreshold;
    }

    @Override
    public MDSet generate() {
        if (this.hypoComponents == null) {
            throw new RuntimeException("Bad usage. No components have been added yet.");
        }
        MDSet sample = (MDSet)this.hypoComponents.get(0);
        int nDescriptors = sample.size();
        int nHypoComponents = this.hypoComponents.size();
        MDSet toReturn = new MDSet(sample);
        float[][] floatDescrs = new float[nHypoComponents][];
        for (int d = 0; d < nDescriptors; ++d) {
            for (int c = 0; c < nHypoComponents; ++c) {
                floatDescrs[c] = ((MDSet)this.hypoComponents.get(c)).getDescriptor(d).toFloatArray();
            }
            toReturn.getDescriptor(d).fromFloatArray(this.calcMedianValues(floatDescrs));
        }
        return toReturn;
    }

    @Override
    public String getTypeName() {
        return "Median";
    }

    private float[] calcMedianValues(float[][] descriptors) {
        int nDescriptors = descriptors.length;
        int nCells = descriptors[0].length;
        float[] toReturn = new float[nCells];
        float[] sortedCells = new float[nDescriptors];
        int nCountingZeros = (int)Math.ceil(this.zeroThreshold / 100.0f * (float)nDescriptors);
        for (int i = 0; i < nCells; ++i) {
            int nZeros;
            for (int j = 0; j < nDescriptors; ++j) {
                sortedCells[j] = descriptors[j][i];
            }
            Arrays.sort(sortedCells);
            for (nZeros = 0; nZeros < nDescriptors && sortedCells[nZeros] == 0.0f; ++nZeros) {
            }
            if (nZeros >= nCountingZeros) {
                toReturn[i] = 0.0f;
                continue;
            }
            int nNonZeros = nDescriptors - nZeros;
            int medIndex = nZeros + nNonZeros / 2;
            toReturn[i] = nNonZeros % 2 == 0 ? (sortedCells[medIndex - 1] + sortedCells[medIndex]) / 2.0f : sortedCells[medIndex];
        }
        return toReturn;
    }
}

