/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDHypothesisGenerator;
import chemaxon.descriptors.MDSet;
import chemaxon.descriptors.MolecularDescriptor;

public class MDMinHypothesisGenerator
implements MDHypothesisGenerator {
    private MDSet hypothesisMD = null;

    @Override
    public void add(MDSet hypothesisComponent) {
        if (this.hypothesisMD == null) {
            this.hypothesisMD = new MDSet(hypothesisComponent);
            return;
        }
        for (int d = 0; d < this.hypothesisMD.size(); ++d) {
            this.intersectDescriptors(this.hypothesisMD.getDescriptor(d), hypothesisComponent.getDescriptor(d));
        }
    }

    @Override
    public MDSet generate() {
        if (this.hypothesisMD == null) {
            throw new RuntimeException("Bad usage. No components have been added yet.");
        }
        return this.hypothesisMD;
    }

    @Override
    public String getTypeName() {
        return "Minimum";
    }

    private void intersectDescriptors(MolecularDescriptor d1, MolecularDescriptor d2) {
        float[] a = d1.toFloatArray();
        float[] b = d2.toFloatArray();
        for (int i = 0; i < a.length; ++i) {
            a[i] = a[i] < b[i] ? a[i] : b[i];
        }
        d1.fromFloatArray(a);
    }
}

