/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.MDReaderException;
import chemaxon.descriptors.MDSet;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public abstract class MDReader {
    protected int id = 1;
    protected int firstId = 1;
    protected boolean generateId = false;
    protected boolean generateDescriptor = false;
    protected Molecule lastReadMolecule = null;
    protected MDSet mdSet = null;
    protected boolean cloneResult = true;
    protected ArrayList takeTags = null;
    protected String idTagName = null;

    protected MDReader(MDSet mdSet) {
        this.mdSet = mdSet;
        this.takeTags = new ArrayList();
        this.generateDescriptor = true;
    }

    protected MDReader() {
        this.generateDescriptor = false;
    }

    public void setGenerateId(boolean generateId) {
        this.generateId = generateId;
    }

    public void setTakeTag(int cdSetComponent, String tagName) {
        this.takeTags.add(cdSetComponent, tagName);
    }

    public void setIdTagName(String tagName) {
        this.idTagName = tagName;
    }

    public void setFirstId(int firstId) {
        this.firstId = firstId;
        this.id = firstId;
    }

    public void setCloneResult(boolean cloneResult) {
        this.cloneResult = cloneResult;
    }

    public boolean getCloneResult() {
        return this.cloneResult;
    }

    public MDSet getMDSet() {
        return this.mdSet;
    }

    public void reset() throws MDReaderException {
        if (this.generateId) {
            this.id = this.firstId;
        }
    }

    public abstract MDSet next() throws MDReaderException;

    public Molecule getMolecule() throws MDReaderException {
        return null;
    }

    public abstract void close() throws MDReaderException;

    protected void createMDSetComponent(int i, String type, String settings) throws MDParametersException {
        MolecularDescriptor descriptor = MolecularDescriptor.newInstance(type);
        descriptor.setParameters(settings);
        this.mdSet.setDescriptor(i, descriptor);
    }
}

