/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDParameters;
import chemaxon.descriptors.MDSetParameters;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.struc.Molecule;
import java.io.File;

public class MDSet {
    public float dissim;
    private int id;
    private String naturalId = null;
    private MolecularDescriptor[] descriptors = null;
    private MDSetParameters parameters = null;
    private MDSet custom = null;

    public static MDSet newInstance(String[] componentTypes) {
        MDSet mdSet = new MDSet(componentTypes.length);
        for (int i = 0; i < mdSet.size(); ++i) {
            MolecularDescriptor md = MolecularDescriptor.newInstance(componentTypes[i]);
            mdSet.setDescriptor(i, md);
        }
        return mdSet;
    }

    public static MDSet newInstance(String[] componentTypes, String[] params) {
        MDSet mdSet = MDSet.newInstance(componentTypes);
        for (int i = 0; i < mdSet.size(); ++i) {
            MolecularDescriptor md = mdSet.getDescriptor(i);
            try {
                Class<?> p = Class.forName(md.getParametersClassName());
                MDParameters param = (MDParameters)p.newInstance();
                param.fromString(params[i]);
                md.setParameters(param);
                continue;
            }
            catch (ClassNotFoundException ce) {
                return null;
            }
            catch (InstantiationException ie) {
                return null;
            }
            catch (IllegalAccessException iae) {
                return null;
            }
        }
        return mdSet;
    }

    public static MDSet newInstance(String[] componentTypes, File[] params) {
        MDSet mdSet = MDSet.newInstance(componentTypes);
        for (int i = 0; i < mdSet.size(); ++i) {
            MolecularDescriptor md = mdSet.getDescriptor(i);
            try {
                Class<?> p = Class.forName(md.getParametersClassName());
                MDParameters param = (MDParameters)p.newInstance();
                if (params[i] != null) {
                    param.fromFile(params[i]);
                }
                md.setParameters(param);
                continue;
            }
            catch (ClassNotFoundException ce) {
                ce.printStackTrace();
                return null;
            }
            catch (InstantiationException ie) {
                ie.printStackTrace();
                return null;
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
                return null;
            }
        }
        return mdSet;
    }

    public MDSet() {
    }

    public MDSet(MDSet c) {
        this.dissim = c.dissim;
        this.id = c.id;
        this.naturalId = c.naturalId;
        this.parameters = c.parameters;
        this.descriptors = new MolecularDescriptor[c.descriptors.length];
        for (int i = 0; i < this.descriptors.length; ++i) {
            this.descriptors[i] = c.descriptors[i].clone();
        }
    }

    public MDSet(int nComponents) {
        this.descriptors = new MolecularDescriptor[nComponents];
        this.setParameters(new MDSetParameters(nComponents));
    }

    public MDSet(int nComponents, int nUserData) {
        this.descriptors = new MolecularDescriptor[nComponents];
        this.setParameters(new MDSetParameters(nComponents));
    }

    public Object clone() {
        return new MDSet(this);
    }

    public void setSize(int nComponents, int nUserData) {
        this.descriptors = new MolecularDescriptor[nComponents];
    }

    public void setSize(int nComponents) {
        this.descriptors = new MolecularDescriptor[nComponents];
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void setNaturalId(String id) {
        this.naturalId = id;
    }

    public String getNaturalId() {
        return this.naturalId;
    }

    public void setParameters(MDSetParameters params) {
        this.parameters = params;
    }

    public MDSetParameters getParameters() {
        return this.parameters;
    }

    public void addDescriptor(MolecularDescriptor descriptor) {
        if (this.parameters == null) {
            this.parameters = new MDSetParameters();
            this.parameters.setSize(1);
            this.parameters.setWeight(0, 1.0f);
        }
        this.descriptors = new MolecularDescriptor[1];
        this.descriptors[0] = descriptor;
    }

    public void setDescriptors(MolecularDescriptor[] descriptors) {
        this.descriptors = descriptors;
    }

    public void setDescriptor(int componentIndex, MolecularDescriptor md) {
        this.descriptors[componentIndex] = md;
    }

    public int size() {
        return this.descriptors == null ? 0 : this.descriptors.length;
    }

    public MolecularDescriptor getDescriptor(int index) {
        return this.descriptors[index];
    }

    public void generate(Molecule mol) throws MDGeneratorException {
        for (int i = 0; i < this.descriptors.length; ++i) {
            this.descriptors[i].generate(mol);
        }
    }

    public float getDissimilarity(MDSet o) {
        MDSet other = o;
        if (this.descriptors.length == 1) {
            return this.descriptors[0].getDissimilarity(other.descriptors[0]);
        }
        float d = 0.0f;
        for (int i = 0; i < this.descriptors.length; ++i) {
            float di = this.descriptors[i].getDissimilarity(other.descriptors[i]);
            d += this.parameters.weights[i] * di * di;
        }
        return d;
    }

    public float getLowerBound(Object o) {
        return 0.0f;
    }

    public void setUserData(float[] userData) {
    }

    public void setUserData(int dataIndex, float userData) {
    }

    public float getUserData(int index) {
        return 0.0f;
    }

    public float[] getUserData() {
        return null;
    }
}

