/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

public class MDSetParameters {
    protected float[] weights = null;
    protected float[] userDataWeights = null;
    protected int[] metricIndex = null;

    public MDSetParameters() {
    }

    public MDSetParameters(int nComponents) {
        this.weights = new float[nComponents];
        this.metricIndex = new int[nComponents];
        this.initWeights();
    }

    public MDSetParameters(int nComponents, int nUserData) {
        this.weights = new float[nComponents];
        this.userDataWeights = new float[nUserData];
        this.metricIndex = new int[nComponents];
        this.initWeights();
    }

    public MDSetParameters(float[] weights, int[] metricIndex) {
        this.weights = weights;
        this.metricIndex = metricIndex;
    }

    public MDSetParameters(float[] weights, float[] userDataWeights, int[] metricIndex) {
        this.weights = weights;
        this.userDataWeights = userDataWeights;
        this.metricIndex = metricIndex;
    }

    public void setSize(int nComponents) {
        this.weights = new float[nComponents];
        this.metricIndex = new int[nComponents];
    }

    public void setSize(int nComponents, int nUserData) {
        this.weights = new float[nComponents];
        this.metricIndex = new int[nComponents];
        this.userDataWeights = new float[nUserData];
    }

    public void setWeights(float[] weights) {
        this.weights = weights;
    }

    public void setUserDataWeights(float[] weights) {
        this.userDataWeights = this.userDataWeights;
    }

    public void setMetricIndices(int[] metricIndices) {
        this.metricIndex = metricIndices;
    }

    public void setWeight(int componentIndex, float w) {
        this.weights[componentIndex] = w;
    }

    public void setUserDataWeight(int index, float w) {
        this.userDataWeights[index] = w;
    }

    public void setMetricIndex(int componentIndex, int mi) {
        this.metricIndex[componentIndex] = mi;
    }

    public int size() {
        return this.weights.length;
    }

    public float getWeight(int index) {
        return this.weights[index];
    }

    public float getUserDataWeight(int index) {
        return this.userDataWeights[index];
    }

    public int getMetricIndex(int index) {
        return this.metricIndex[index];
    }

    private void initWeights() {
        int i;
        for (i = 0; i < this.weights.length; ++i) {
            this.weights[i] = 1.0f;
        }
        if (this.userDataWeights != null) {
            for (i = 0; i < this.userDataWeights.length; ++i) {
                this.userDataWeights[i] = 1.0f;
            }
        }
    }
}

