/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDSet;
import chemaxon.descriptors.MDSimilarity;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.struc.Molecule;
import java.io.PrintStream;
import java.util.ArrayList;

public abstract class MDSimilarityResultWriter {
    protected MDSimilarity similarity = null;
    protected PrintStream output = null;
    protected ArrayList queryNames = new ArrayList();
    protected boolean verbose = false;
    private int nProcessed = 0;
    private int verboseFreq = 1000;
    protected boolean writesMolecules = false;
    protected Molecule mol = null;
    protected ArrayList labels = null;

    public void setVerbosity(boolean verbose) {
        this.verbose = verbose;
    }

    public void setVerboseFrequency(int verboseFreq) {
        this.verboseFreq = verboseFreq;
    }

    public void setQueryName(int queryIndex, String queryName) {
        this.queryNames.add(queryIndex, queryName);
    }

    public boolean writesMolecules() {
        return this.writesMolecules;
    }

    public String getQueryName(int queryIndex) {
        return (String)this.queryNames.get(queryIndex);
    }

    public void open(MDSimilarity similarity) {
        this.similarity = similarity;
    }

    public void setMolecule(Molecule m) throws RuntimeException {
        if (!this.writesMolecules) {
            throw new RuntimeException("Bad usage: " + this.getClass().getName() + " cannot write molecules");
        }
        this.mol = m;
    }

    public abstract void write(MDSet var1, boolean var2);

    public void close() {
        this.output.close();
    }

    protected void count() {
        if (++this.nProcessed % this.verboseFreq == 0) {
            this.verboseMsg(this.nProcessed + " descriptor sets processed");
        }
    }

    protected void verboseMsg(String msg) {
        if (this.verbose) {
            System.out.println(msg);
        }
    }

    protected void createLabels(MDSet cds) {
        this.labels = new ArrayList();
        for (int q = 0; q < this.similarity.getNrOfQueries(); ++q) {
            if (this.similarity.isComponentWise()) {
                for (int d = 0; d < cds.size(); ++d) {
                    MolecularDescriptor descr = cds.getDescriptor(d);
                    String descrName = descr.getShortName();
                    for (int m = 0; m < descr.getNumberOfMetrics(); ++m) {
                        if (!this.similarity.isUsedMetric(d, m)) continue;
                        this.labels.add(new String(this.getQueryName(q) + "_" + descrName + "_" + descr.getMetricName(m).substring(0, 3)));
                    }
                }
                continue;
            }
            this.labels.add(new String(this.getQueryName(q)));
        }
    }
}

