/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDSet;
import chemaxon.descriptors.MDSimilarityResultWriter;
import chemaxon.descriptors.MolecularDescriptor;
import java.io.PrintStream;

public class MDSimilaritySDfileWriter
extends MDSimilarityResultWriter {
    public MDSimilaritySDfileWriter(PrintStream output) {
        this.output = output;
        this.writesMolecules = true;
    }

    @Override
    public void write(MDSet descr, boolean passed) {
        if (passed && this.mol != null) {
            if (this.labels == null) {
                this.createLabels(descr);
            }
            this.storeResults(descr);
            this.output.print(this.mol.toFormat("sdf"));
        }
        this.count();
    }

    @Override
    public void close() {
        this.output.close();
    }

    private void storeResults(MDSet cds) {
        int pi = 0;
        for (int q = 0; q < this.similarity.getNrOfQueries(); ++q) {
            if (this.similarity.isComponentWise()) {
                for (int d = 0; d < cds.size(); ++d) {
                    MolecularDescriptor descr = cds.getDescriptor(d);
                    for (int m = 0; m < descr.getNumberOfMetrics(); ++m) {
                        if (!this.similarity.isUsedMetric(d, m)) continue;
                        this.mol.setProperty((String)this.labels.get(pi++), "" + this.similarity.getDissimilarityCoeff(q, d, m));
                    }
                }
                continue;
            }
            this.mol.setProperty((String)this.labels.get(pi++), "" + this.similarity.getDissimilarityCoeff(q, 0, 0));
        }
    }
}

