/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

public class Metrics {
    private static int[] bitCount = null;

    public static final float euclidean(float[] v1, float[] v2) {
        double d = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            double df = v1[i] - v2[i];
            d += df * df;
        }
        return (float)Math.sqrt(d);
    }

    public static final float normalizedEuclidean(float[] v1, float[] v2) {
        double d = 0.0;
        double a = 0.0;
        double b = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            double df = v1[i] - v2[i];
            d += df * df;
            a += (double)(v1[i] * v1[i]);
            b += (double)(v2[i] * v2[i]);
        }
        double sqrtD = Math.sqrt(d);
        return (float)(sqrtD / (Math.sqrt(a) + Math.sqrt(b)));
    }

    public static final float asymmetricEuclidean(float[] v1, float[] v2, double asymmetryFactor) {
        double k1 = asymmetryFactor;
        double k2 = 1.0 - k1;
        double d = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            double df = v1[i] - v2[i];
            d += (df >= 0.0 ? k1 : k2) * (df * df);
        }
        return (float)Math.sqrt(d);
    }

    public static final float asymmetricNormalizedEuclidean(float[] v1, float[] v2, double asymmetryFactor) {
        double k1 = asymmetryFactor;
        double k2 = 1.0 - k1;
        double d = 0.0;
        double a = 0.0;
        double b = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            double df = v1[i] - v2[i];
            d += (df >= 0.0 ? k1 : k2) * (df * df);
            a += (double)(v1[i] * v1[i]);
            b += (double)(v2[i] * v2[i]);
        }
        double sqrtD = Math.sqrt(d);
        return (float)(sqrtD / (Math.sqrt(a) + Math.sqrt(b)));
    }

    public static final float weightedEuclidean(float[] v1, float[] v2, float[] weights) {
        double d = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            double df = v1[i] - v2[i];
            d += (double)weights[i] * (df * df);
        }
        return (float)Math.sqrt(d);
    }

    public static final float weightedNormalizedEuclidean(float[] v1, float[] v2, float[] weights) {
        double d = 0.0;
        double a = 0.0;
        double b = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            double df = v1[i] - v2[i];
            d += (double)weights[i] * (df * df);
            a += (double)(v1[i] * v1[i]);
            b += (double)(v2[i] * v2[i]);
        }
        double sqrtD = (float)Math.sqrt(d);
        return (float)(sqrtD / (Math.sqrt(a) + Math.sqrt(b)));
    }

    public static final float weightedAsymmetricEuclidean(float[] v1, float[] v2, float[] weights, float asymmetryFactor) {
        double k1 = asymmetryFactor;
        double k2 = 1.0 - k1;
        double d = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            double df = v1[i] - v2[i];
            d += (df >= 0.0 ? k1 : k2) * (double)weights[i] * (df * df);
        }
        return (float)Math.sqrt(d);
    }

    public static final float weightedAsymmetricNormalizedEuclidean(float[] v1, float[] v2, float[] weights, float asymmetryFactor) {
        double k1 = asymmetryFactor;
        double k2 = 1.0 - k1;
        double d = 0.0;
        double a = 0.0;
        double b = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            double df = v1[i] - v2[i];
            d += (df >= 0.0 ? k1 : k2) * (double)weights[i] * (df * df);
            a += (double)(v1[i] * v1[i]);
            b += (double)(v2[i] * v2[i]);
        }
        double sqrtD = (float)Math.sqrt(d);
        return (float)(sqrtD / (Math.sqrt(a) + Math.sqrt(b)));
    }

    public static final float tanimoto(float[] v1, float[] v2) {
        float[] xyz = new float[3];
        Metrics.calculateXYZ(v1, v2, xyz);
        return 1.0f - xyz[0] / (xyz[1] + xyz[2] - xyz[0]);
    }

    public static final float tversky(float[] v1, float wv1, float[] v2, float wv2) {
        if (v1.length != v2.length) {
            throw new UnsupportedOperationException("fingerprint length mismatch");
        }
        float common = 0.0f;
        float onlyV1 = 0.0f;
        float onlyV2 = 0.0f;
        float diff = 0.0f;
        for (int i = 0; i < v1.length; ++i) {
            common += Math.min(v1[i], v2[i]);
            diff = v1[i] - v2[i];
            if (diff > 0.0f) {
                onlyV1 += diff;
                continue;
            }
            if (!(diff < 0.0f)) continue;
            onlyV2 -= diff;
        }
        float denominator = wv1 * onlyV1 + wv2 * onlyV2 + common;
        if (denominator == 0.0f) {
            return 1.0f;
        }
        return 1.0f - common / denominator;
    }

    public static final float asymmetricTanimoto(float[] v1, float[] v2, float asymmetryFactor) {
        float[] xyz = new float[3];
        Metrics.calculateXYZ(v1, v2, xyz);
        return 1.0f - xyz[0] / (asymmetryFactor * (xyz[1] - xyz[0]) + (1.0f - asymmetryFactor) * (xyz[2] - xyz[0]) + xyz[0]);
    }

    public static final float scaledTanimoto(float[] v1, float[] v2, float[] hypothesis, float scaleFactor) {
        if (hypothesis == null) {
            return Metrics.tanimoto(v1, v2);
        }
        float[] xyz = new float[3];
        Metrics.calculateXYZ(v1, v2, hypothesis, scaleFactor, xyz);
        return 1.0f - xyz[0] / (xyz[1] + xyz[2] - xyz[0]);
    }

    public static final float scaledAsymmetricTanimoto(float[] v1, float[] v2, float[] hypothesis, float scaleFactor, float asymmetryFactor) {
        if (hypothesis == null) {
            return Metrics.tanimoto(v1, v2);
        }
        float[] xyz = new float[3];
        Metrics.calculateXYZ(v1, v2, hypothesis, scaleFactor, xyz);
        return 1.0f - xyz[0] / (asymmetryFactor * (xyz[1] - xyz[0]) + (1.0f - asymmetryFactor) * (xyz[2] - xyz[0]) + xyz[0]);
    }

    private static void calculateXYZ(float[] v1, float[] v2, float[] xyz) {
        xyz[2] = 0.0f;
        xyz[1] = 0.0f;
        xyz[0] = 0.0f;
        for (int i = 0; i < v1.length; ++i) {
            xyz[0] = xyz[0] + Math.min(v1[i], v2[i]);
            xyz[1] = xyz[1] + v1[i];
            xyz[2] = xyz[2] + v2[i];
        }
    }

    private static void calculateXYZ(float[] v1, float[] v2, float[] hypothesis, float scaleFactor, float[] xyz) {
        xyz[2] = 0.0f;
        xyz[1] = 0.0f;
        xyz[0] = 0.0f;
        for (int i = 0; i < v1.length; ++i) {
            float csf = hypothesis[i] == 0.0f ? 1.0f : scaleFactor * hypothesis[i];
            xyz[0] = xyz[0] + Math.min(v1[i], v2[i]) * csf;
            xyz[1] = xyz[1] + v1[i] * csf;
            xyz[2] = xyz[2] + v2[i] * csf;
        }
    }

    public static final float euclidean(int[] v1, int[] v2) {
        double d = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            double df = v1[i] - v2[i];
            d += df * df;
        }
        return (float)Math.sqrt(d);
    }

    public static final float normalizedEuclidean(int[] v1, int[] v2) {
        double d = 0.0;
        double a = 0.0;
        double b = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            int df = v1[i] - v2[i];
            d += (double)(df * df);
            a += (double)(v1[i] * v1[i]);
            b += (double)(v2[i] * v2[i]);
        }
        double sqrtD = Math.sqrt(d);
        return (float)(sqrtD / (Math.sqrt(a) + Math.sqrt(b)));
    }

    public static final float asymmetricEuclidean(int[] v1, int[] v2, double asymmetryFactor) {
        double k1 = asymmetryFactor;
        double k2 = 1.0 - k1;
        double d = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            int df = v1[i] - v2[i];
            d += (df >= 0 ? k1 : k2) * (double)(df * df);
        }
        return (float)Math.sqrt(d);
    }

    public static final float asymmetricNormalizedEuclidean(int[] v1, int[] v2, double asymmetryFactor) {
        double k1 = asymmetryFactor;
        double k2 = 1.0 - k1;
        double d = 0.0;
        double a = 0.0;
        double b = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            int df = v1[i] - v2[i];
            d += (df >= 0 ? k1 : k2) * (double)(df * df);
            a += (double)(v1[i] * v1[i]);
            b += (double)(v2[i] * v2[i]);
        }
        double sqrtD = Math.sqrt(d);
        return (float)(sqrtD / (Math.sqrt(a) + Math.sqrt(b)));
    }

    public static final float weightedEuclidean(int[] v1, int[] v2, float[] weights) {
        double d = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            int df = v1[i] - v2[i];
            d += (double)weights[i] * (double)(df * df);
        }
        return (float)Math.sqrt(d);
    }

    public static final float weightedNormalizedEuclidean(int[] v1, int[] v2, float[] weights) {
        double d = 0.0;
        double a = 0.0;
        double b = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            int df = v1[i] - v2[i];
            d += (double)weights[i] * (double)(df * df);
            a += (double)(v1[i] * v1[i]);
            b += (double)(v2[i] * v2[i]);
        }
        double sqrtD = (float)Math.sqrt(d);
        return (float)(sqrtD / (Math.sqrt(a) + Math.sqrt(b)));
    }

    public static final float weightedAsymmetricEuclidean(int[] v1, int[] v2, float[] weights, float asymmetryFactor) {
        double k1 = asymmetryFactor;
        double k2 = 1.0 - k1;
        double d = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            int df = v1[i] - v2[i];
            d += (df >= 0 ? k1 : k2) * (double)weights[i] * (double)(df * df);
        }
        return (float)Math.sqrt(d);
    }

    public static final float weightedAsymmetricNormalizedEuclidean(int[] v1, int[] v2, float[] weights, float asymmetryFactor) {
        double k1 = asymmetryFactor;
        double k2 = 1.0 - k1;
        double d = 0.0;
        double a = 0.0;
        double b = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            int df = v1[i] - v2[i];
            d += (df >= 0 ? k1 : k2) * (double)weights[i] * (double)(df * df);
            a += (double)(v1[i] * v1[i]);
            b += (double)(v2[i] * v2[i]);
        }
        double sqrtD = (float)Math.sqrt(d);
        return (float)(sqrtD / (Math.sqrt(a) + Math.sqrt(b)));
    }

    public static final float tanimoto(int[] v1, int[] v2) {
        int[] xyz = new int[3];
        Metrics.calculateXYZ(v1, v2, xyz);
        return 1.0f - (float)xyz[0] / (float)(xyz[1] + xyz[2] - xyz[0]);
    }

    public static final float tversky(int[] v1, float wv1, int[] v2, float wv2) {
        if (v1.length != v2.length) {
            throw new UnsupportedOperationException("fingerprint length mismatch");
        }
        int common = 0;
        int onlyV1 = 0;
        int onlyV2 = 0;
        int diff = 0;
        for (int i = 0; i < v1.length; ++i) {
            common += Math.min(v1[i], v2[i]);
            diff = v1[i] - v2[i];
            if (diff > 0) {
                onlyV1 += diff;
                continue;
            }
            if (diff >= 0) continue;
            onlyV2 -= diff;
        }
        float denominator = wv1 * (float)onlyV1 + wv2 * (float)onlyV2 + (float)common;
        if (denominator == 0.0f) {
            return 1.0f;
        }
        return 1.0f - (float)common / denominator;
    }

    public static final float asymmetricTanimoto(int[] v1, int[] v2, float asymmetryFactor) {
        int[] xyz = new int[3];
        Metrics.calculateXYZ(v1, v2, xyz);
        return 1.0f - (float)xyz[0] / (asymmetryFactor * (float)(xyz[1] - xyz[0]) + (1.0f - asymmetryFactor) * (float)(xyz[2] - xyz[0]) + (float)xyz[0]);
    }

    public static final float scaledTanimoto(int[] v1, int[] v2, float[] hypothesis, float scaleFactor) {
        if (hypothesis == null) {
            return Metrics.tanimoto(v1, v2);
        }
        int[] xyz = new int[3];
        Metrics.calculateXYZ(v1, v2, hypothesis, scaleFactor, xyz);
        return 1 - xyz[0] / (xyz[1] + xyz[2] - xyz[0]);
    }

    public static final float scaledAsymmetricTanimoto(int[] v1, int[] v2, float[] hypothesis, float scaleFactor, float asymmetryFactor) {
        if (hypothesis == null) {
            return Metrics.tanimoto(v1, v2);
        }
        int[] xyz = new int[3];
        Metrics.calculateXYZ(v1, v2, hypothesis, scaleFactor, xyz);
        return 1.0f - (float)xyz[0] / (asymmetryFactor * (float)(xyz[1] - xyz[0]) + (1.0f - asymmetryFactor) * (float)(xyz[2] - xyz[0]) + (float)xyz[0]);
    }

    private static void calculateXYZ(int[] v1, int[] v2, int[] xyz) {
        xyz[2] = 0;
        xyz[1] = 0;
        xyz[0] = 0;
        for (int i = 0; i < v1.length; ++i) {
            xyz[0] = xyz[0] + Math.min(v1[i], v2[i]);
            xyz[1] = xyz[1] + v1[i];
            xyz[2] = xyz[2] + v2[i];
        }
    }

    private static void calculateXYZ(int[] v1, int[] v2, float[] hypothesis, float scaleFactor, int[] xyz) {
        xyz[2] = 0;
        xyz[1] = 0;
        xyz[0] = 0;
        for (int i = 0; i < v1.length; ++i) {
            float csf = hypothesis[i] == 0.0f ? 1.0f : scaleFactor * hypothesis[i];
            xyz[0] = (int)((float)xyz[0] + (float)Math.min(v1[i], v2[i]) * csf);
            xyz[1] = (int)((float)xyz[1] + (float)v1[i] * csf);
            xyz[2] = (int)((float)xyz[2] + (float)v2[i] * csf);
        }
    }

    public static int calcBitCount(int i) {
        int bc = bitCount[i & 0xFF];
        bc += bitCount[(i >>= 8) & 0xFF];
        bc += bitCount[(i >>= 8) & 0xFF];
        return bc += bitCount[(i >>= 8) & 0xFF];
    }

    public static int calcBitCount(int[] v) {
        int bc = 0;
        for (int j = 0; j < v.length; ++j) {
            bc += Metrics.calcBitCount(v[j]);
        }
        return bc;
    }

    public static float binaryEuclidean(int[] v1, int[] v2) {
        int x = 0;
        boolean y = false;
        boolean z = false;
        for (int i = 0; i < v1.length; ++i) {
            x += Metrics.calcBitCount(v1[i] ^ v2[i]);
        }
        return (float)Math.sqrt(x);
    }

    public static float binaryNormalizedEuclidean(int[] v1, int[] v2) {
        int x = 0;
        int y = 0;
        int z = 0;
        for (int i = 0; i < v1.length; ++i) {
            x += Metrics.calcBitCount(v1[i] ^ v2[i]);
            y += Metrics.calcBitCount(v1[i]);
            z += Metrics.calcBitCount(v2[i]);
        }
        return (float)(Math.sqrt(x) / (Math.sqrt(y) + Math.sqrt(z)));
    }

    public static float binaryNormalizedEuclidean(int[] v1, int oneCount1, int[] v2, int oneCount2) {
        int x = 0;
        boolean y = false;
        boolean z = false;
        for (int i = 0; i < v1.length; ++i) {
            x += Metrics.calcBitCount(v1[i] ^ v2[i]);
        }
        return (float)(Math.sqrt(x) / (Math.sqrt(oneCount1) + Math.sqrt(oneCount2)));
    }

    public static float binaryWeightedEuclidean(int[] v1, int[] v2, float[] weights) {
        float x = 0.0f;
        for (int i = 0; i < v1.length; ++i) {
            int fi = v1[i] ^ v2[i];
            for (int bi = 31; bi >= 0; --bi) {
                x += weights[i * 32 + bi] * (float)(fi & 1);
                fi >>= 1;
            }
        }
        return (float)Math.sqrt(x);
    }

    public static float binaryWeightedNormalizedEuclidean(int[] v1, int[] v2, float[] weights) {
        float x = 0.0f;
        int y = 0;
        int z = 0;
        for (int i = 0; i < v1.length; ++i) {
            int fi = v1[i] ^ v2[i];
            for (int bi = 31; bi >= 0; --bi) {
                x += weights[i * 32 + bi] * (float)(fi & 1);
                fi >>= 1;
            }
            y += Metrics.calcBitCount(v1[i]);
            z += Metrics.calcBitCount(v2[i]);
        }
        return (float)(Math.sqrt(x) / (Math.sqrt(y) + Math.sqrt(z)));
    }

    public static float binaryWeightedNormalizedEuclidean(int[] v1, int oneCount1, int[] v2, int oneCount2, int[] weights) {
        float x = 0.0f;
        for (int i = 0; i < v1.length; ++i) {
            int fi = v1[i] ^ v2[i];
            for (int bi = 31; bi >= 0; --bi) {
                x += (float)(weights[i * 32 + bi] * (fi & 1));
                fi >>= 1;
            }
        }
        return (float)(Math.sqrt(x) / (Math.sqrt(oneCount1) + Math.sqrt(oneCount2)));
    }

    public static float binaryAsymmetricEuclidean(int[] v1, int[] v2, float asymmetryFactor) {
        float x = 0.0f;
        for (int i = 0; i < v1.length; ++i) {
            int f1i = v1[i];
            int f2i = v2[i];
            for (int bi = 31; bi >= 0; --bi) {
                int b1 = f1i & 1;
                int b2 = f2i & 1;
                f1i >>= 1;
                f2i >>= 1;
                if (b1 == b2) continue;
                x += b1 == 1 ? asymmetryFactor : 1.0f - asymmetryFactor;
            }
        }
        return (float)Math.sqrt(x);
    }

    public static float binaryAsymmetricNormalizedEuclidean(int[] v1, int[] v2, float asymmetryFactor) {
        float x = 0.0f;
        int y = 0;
        int z = 0;
        for (int i = 0; i < v1.length; ++i) {
            int f1i = v1[i];
            int f2i = v2[i];
            for (int bi = 31; bi >= 0; --bi) {
                int b1 = f1i & 1;
                int b2 = f2i & 1;
                f1i >>= 1;
                f2i >>= 1;
                if (b1 == b2) continue;
                x += b1 == 1 ? asymmetryFactor : 1.0f - asymmetryFactor;
            }
            y += Metrics.calcBitCount(v1[i]);
            z += Metrics.calcBitCount(v2[i]);
        }
        return (float)(Math.sqrt(x) / (Math.sqrt(y) + Math.sqrt(z)));
    }

    public static float binaryAsymmetricNormalizedEuclidean(int[] v1, int oneCount1, int[] v2, int oneCount2, float asymmetryFactor) {
        float x = 0.0f;
        for (int i = 0; i < v1.length; ++i) {
            int f1i = v1[i];
            int f2i = v2[i];
            for (int bi = 31; bi >= 0; --bi) {
                int b1 = f1i & 1;
                int b2 = f2i & 1;
                f1i >>= 1;
                f2i >>= 1;
                if (b1 == b2) continue;
                x += b1 == 1 ? asymmetryFactor : 1.0f - asymmetryFactor;
            }
        }
        return (float)(Math.sqrt(x) / (Math.sqrt(oneCount1) + Math.sqrt(oneCount2)));
    }

    public static float binaryWeightedAsymmetricEuclidean(int[] v1, int[] v2, float[] weights, float asymmetryFactor) {
        float x = 0.0f;
        for (int i = 0; i < v1.length; ++i) {
            int f1i = v1[i];
            int f2i = v2[i];
            for (int bi = 31; bi >= 0; --bi) {
                int b1 = f1i & 1;
                int b2 = f2i & 1;
                f1i >>= 1;
                f2i >>= 1;
                if (b1 == b2) continue;
                x += weights[i * 32 + bi] * (b1 == 1 ? asymmetryFactor : 1.0f - asymmetryFactor);
            }
        }
        return (float)Math.sqrt(x);
    }

    public static float binaryWeightedAsymmetricNormalizedEuclidean(int[] v1, int[] v2, float[] weights, float asymmetryFactor) {
        float x = 0.0f;
        int y = 0;
        int z = 0;
        for (int i = 0; i < v1.length; ++i) {
            int f1i = v1[i];
            int f2i = v2[i];
            for (int bi = 31; bi >= 0; --bi) {
                int b1 = f1i & 1;
                int b2 = f2i & 1;
                f1i >>= 1;
                f2i >>= 1;
                if (b1 == b2) continue;
                x += weights[i * 32 + bi] * (b1 == 1 ? asymmetryFactor : 1.0f - asymmetryFactor);
            }
            y += Metrics.calcBitCount(v1[i]);
            z += Metrics.calcBitCount(v2[i]);
        }
        return (float)(Math.sqrt(x) / (Math.sqrt(y) + Math.sqrt(z)));
    }

    public static float binaryWeightedAsymmetricNormalizedEuclidean(int[] v1, int oneCount1, int[] v2, int oneCount2, float[] weights, float asymmetryFactor) {
        float x = 0.0f;
        for (int i = 0; i < v1.length; ++i) {
            int f1i = v1[i];
            int f2i = v2[i];
            for (int bi = 31; bi >= 0; --bi) {
                int b1 = f1i & 1;
                int b2 = f2i & 1;
                f1i >>= 1;
                f2i >>= 1;
                if (b1 == b2) continue;
                x += weights[i * 32 + bi] * (b1 == 1 ? asymmetryFactor : 1.0f - asymmetryFactor);
            }
        }
        return (float)(Math.sqrt(x) / (Math.sqrt(oneCount1) + Math.sqrt(oneCount2)));
    }

    public static float binaryTanimoto(int[] v1, int[] v2) {
        int x = 0;
        int y = Metrics.calcBitCount(v1);
        int z = Metrics.calcBitCount(v2);
        for (int i = 0; i < v1.length; ++i) {
            x += Metrics.calcBitCount(v1[i] & v2[i]);
        }
        return y + z - x == 0 ? 0.0f : 1.0f - (float)x / (float)(y + z - x);
    }

    public static float binaryTversky(int[] v1, float wv1, int[] v2, float wv2) {
        if (v1.length != v2.length) {
            throw new UnsupportedOperationException("The two fingerprint length is not equal.");
        }
        int common = 0;
        int onlyV1 = 0;
        int onlyV2 = 0;
        int xor = 0;
        for (int i = 0; i < v1.length; ++i) {
            common += Metrics.calcBitCount(v1[i] & v2[i]);
            xor = v1[i] ^ v2[i];
            onlyV1 += Metrics.calcBitCount(xor & v1[i]);
            onlyV2 += Metrics.calcBitCount(xor & v2[i]);
        }
        float denominator = wv1 * (float)onlyV1 + wv2 * (float)onlyV2 + (float)common;
        if (denominator == 0.0f) {
            return 1.0f;
        }
        return 1.0f - (float)common / denominator;
    }

    public static float binaryAsymmetricTanimoto(int[] v1, int[] v2, float asymmetryFactor) {
        int x = 0;
        int y = Metrics.calcBitCount(v1);
        int z = Metrics.calcBitCount(v2);
        for (int i = 0; i < v1.length; ++i) {
            x += Metrics.calcBitCount(v1[i] & v2[i]);
        }
        return y + z - x == 0 ? 0.0f : 1.0f - (float)x / (asymmetryFactor * (float)(y - x) + (1.0f - asymmetryFactor) * (float)(z - x) + (float)x);
    }

    public static float binaryTanimoto(int[] v1, int oneCount1, int[] v2, int oneCount2) {
        int x = 0;
        int y = oneCount1;
        int z = oneCount2;
        for (int i = 0; i < v1.length; ++i) {
            x += Metrics.calcBitCount(v1[i] & v2[i]);
        }
        return y + z - x == 0 ? 0.0f : 1.0f - (float)x / (float)(y + z - x);
    }

    public static float binaryAsymmetricTanimoto(int[] v1, int oneCount1, int[] v2, int oneCount2, float asymmetryFactor) {
        int x = 0;
        int y = oneCount1;
        int z = oneCount2;
        for (int i = 0; i < v1.length; ++i) {
            x += Metrics.calcBitCount(v1[i] & v2[i]);
        }
        return y + z - x == 0 ? 0.0f : 1.0f - (float)x / (asymmetryFactor * (float)(y - x) + (1.0f - asymmetryFactor) * (float)(z - x) + (float)x);
    }

    static {
        bitCount = new int[256];
        for (int i = 0; i < 256; ++i) {
            int k = i;
            Metrics.bitCount[i] = 0;
            for (int j = 0; j < 8; ++j) {
                int n = i;
                bitCount[n] = bitCount[n] + (k & 1);
                k >>= 1;
            }
        }
    }
}

