/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.SimilarityCalculatorFactory;

public enum MetricsType {
    TANIMOTO(new Parameter[0], 0.5, "Classic Tanimoto metric, ranges 0..1"),
    TVERSKY(new Parameter[]{new Parameter("queryWeight", "0..1", 0.5), new Parameter("targetWeight", "0..1", 0.5)}, 0.5, "Tversky metric. Ranges 0..1"),
    DICE(new Parameter[0], 0.5, "Dice metric is a special case of Tversky having the two parameters both 0.5 . Ranges 0..1"),
    EUCLIDEAN(new Parameter[0], 0.5, "The Eucledian norm between the two fingerprints. Note that by its nature only dissimilarity is available. Ranges 0..oo"),
    NORMALIZED_EUCLIDEAN(new Parameter[0], 0.5, "Like Eucledian norm but both dissimilarity and similiarity are available. Ranges 0..1"),
    SUBSTRUCTURE(new Parameter[0], 0.5, "SUBSTRUCTURE is a special case of Tversky having the queryWeight=1.0 and the targetWeight=0.0 . Ranges 0..1"),
    SUPERSTRUCTURE(new Parameter[0], 0.5, "SUBSTRUCTURE is a special case of Tversky having the queryWeight=0.0 and the targetWeight=1.0 . Ranges 0..1"),
    DEFAULT(new Parameter[0], 0.5, "Classic Tanimoto metric. Ranges 0..1");

    private final Parameter[] params;
    private final String helpText;
    private final double defaultThreshold;
    public static final String SEPARATOR = ":";

    private MetricsType(Parameter[] params, double defaultThreshold, String helpText) {
        this.params = params;
        this.helpText = helpText;
        this.defaultThreshold = defaultThreshold;
    }

    public String getSimpleParamString() {
        int i;
        String ret = "" + this.params.length + SEPARATOR;
        for (i = 0; i < this.params.length; ++i) {
            ret = ret + this.params[i].name;
            if (i == this.params.length - 1) continue;
            ret = ret + SimilarityCalculatorFactory.SEPARATOR;
        }
        ret = ret + SEPARATOR;
        for (i = 0; i < this.params.length; ++i) {
            ret = ret + this.params[i].range;
            if (i == this.params.length - 1) continue;
            ret = ret + SimilarityCalculatorFactory.SEPARATOR;
        }
        ret = ret + SEPARATOR;
        for (i = 0; i < this.params.length; ++i) {
            ret = ret + this.params[i].defaultValue;
            if (i == this.params.length - 1) continue;
            ret = ret + SimilarityCalculatorFactory.SEPARATOR;
        }
        ret = ret + SEPARATOR + this.defaultThreshold + SEPARATOR + this.helpText;
        return ret;
    }

    private static final class Parameter {
        String name;
        String range;
        double defaultValue;

        public Parameter(String name, String range, double defaultValue) {
            this.name = name;
            this.range = range;
            this.defaultValue = defaultValue;
        }
    }
}

