/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.BCUT;
import chemaxon.descriptors.ChemicalFingerprint;
import chemaxon.descriptors.ECFP;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDParameters;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.MarkushDescriptor;
import chemaxon.descriptors.PharmacophoreFingerprint;
import chemaxon.descriptors.ReactionFingerprint;
import chemaxon.descriptors.SDParameters;
import chemaxon.descriptors.ShapeDescriptor;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.text.ParseException;

public abstract class MolecularDescriptor
implements Cloneable {
    protected MDParameters params = null;

    public static final MolecularDescriptor newInstance(String descriptorTypeName, String parameters) {
        MolecularDescriptor md = MolecularDescriptor.newInstance(descriptorTypeName);
        md.setParameters(parameters);
        return md;
    }

    public static final MolecularDescriptor newInstance(String descriptorTypeName) {
        if (descriptorTypeName.equalsIgnoreCase("PF") || descriptorTypeName.equalsIgnoreCase("PFP") || descriptorTypeName.equalsIgnoreCase("PharmacophoreFingerprint") || descriptorTypeName.equalsIgnoreCase("Pharmacophore Fingerprint") || descriptorTypeName.equalsIgnoreCase("2D Pharmacophore Fingerprint")) {
            return new PharmacophoreFingerprint();
        }
        if (descriptorTypeName.equalsIgnoreCase("CF") || descriptorTypeName.equalsIgnoreCase("CFP") || descriptorTypeName.equalsIgnoreCase("ChemicalFingerprint") || descriptorTypeName.equalsIgnoreCase("Chemical Fingerprint")) {
            return new ChemicalFingerprint();
        }
        if (descriptorTypeName.equalsIgnoreCase("ECFP") || descriptorTypeName.equalsIgnoreCase("ECFP fingerprint") || descriptorTypeName.equalsIgnoreCase("ECFP descriptor")) {
            return new ECFP();
        }
        if (descriptorTypeName.equalsIgnoreCase("RF") || descriptorTypeName.equalsIgnoreCase("RFP") || descriptorTypeName.equalsIgnoreCase("ReactionFingerprint") || descriptorTypeName.equalsIgnoreCase("Reaction Fingerprint")) {
            return new ReactionFingerprint();
        }
        if (descriptorTypeName.equalsIgnoreCase("BCUT") || descriptorTypeName.equalsIgnoreCase("BCUT descriptor")) {
            return new BCUT();
        }
        if (descriptorTypeName.equalsIgnoreCase("Shape") || descriptorTypeName.equalsIgnoreCase("Shape descriptor") || descriptorTypeName.equalsIgnoreCase("3D shape descriptor")) {
            return new ShapeDescriptor();
        }
        if (descriptorTypeName.equalsIgnoreCase("mscr") || descriptorTypeName.equalsIgnoreCase("MarkushDescriptor") || descriptorTypeName.equalsIgnoreCase("Markush descriptor") || descriptorTypeName.equalsIgnoreCase("Markush screen descriptor")) {
            return new MarkushDescriptor();
        }
        Class descrClass = MolecularDescriptor.getClassFromDescriptorName(descriptorTypeName);
        try {
            Object d = descrClass.newInstance();
            if (d instanceof MolecularDescriptor) {
                return (MolecularDescriptor)d;
            }
            throw new RuntimeException("Class " + descriptorTypeName + " is not subclass of MolecularDescriptor.");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot instantiate class " + descrClass.getName());
        }
    }

    private static final Class getClassFromDescriptorName(String descriptorTypeName) {
        Class<?> descrClass = null;
        try {
            descrClass = Class.forName("chemaxon.descriptors.scalars." + descriptorTypeName);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            descrClass = Class.forName("chemaxon.descriptors." + descriptorTypeName);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (descrClass == null) {
                descrClass = Class.forName(descriptorTypeName);
            }
        }
        catch (ClassNotFoundException e2) {
            e2.printStackTrace();
            throw new RuntimeException(e2.getMessage() + "\nInvalid or missing Molecular Descriptor type: " + descriptorTypeName);
        }
        return descrClass;
    }

    public static final MolecularDescriptor newInstanceFromXML(String parameters) {
        String descriptorTypeName = MDParameters.getDescriptorTypeName(parameters);
        if (descriptorTypeName.equals("ScalarDescriptor")) {
            SDParameters sdp = new SDParameters(parameters);
            descriptorTypeName = sdp.getType();
        }
        return descriptorTypeName != null ? MolecularDescriptor.newInstance(descriptorTypeName, parameters) : null;
    }

    public MolecularDescriptor(MDParameters parameters) {
        this.params = parameters;
    }

    public MolecularDescriptor() {
    }

    public MolecularDescriptor(MolecularDescriptor c) {
        this.params = c.params;
    }

    public abstract MolecularDescriptor clone();

    public String getName() {
        return "Molecular descriptor";
    }

    public String getShortName() {
        return "MD";
    }

    public String getParametersClassName() {
        return "chemaxon.descriptors.MDParameters";
    }

    public void setParameters(MDParameters parameters) {
        this.params = parameters;
    }

    public abstract void setParameters(String var1) throws MDParametersException;

    public MDParameters getParameters() {
        return this.params;
    }

    public boolean needsConfig() {
        return true;
    }

    public void setScreeningConfiguration(String config) throws MDParametersException {
        this.params.setParameters(config);
    }

    public abstract byte[] toData();

    public abstract void fromData(byte[] var1);

    public abstract String toString();

    public abstract String toDecimalString();

    public String toBinaryString() {
        return "";
    }

    public abstract void fromString(String var1) throws ParseException;

    public abstract float[] toFloatArray();

    public abstract void fromFloatArray(float[] var1);

    public String[] generate(Molecule m) throws MDGeneratorException {
        throw new MDGeneratorException("Implement generate method.");
    }

    public String[] generate(String molRepr) throws MDGeneratorException {
        try {
            Molecule m = MolImporter.importMol(molRepr);
            return this.generate(m);
        }
        catch (MolFormatException ex) {
            throw new MDGeneratorException(ex.getCause());
        }
    }

    public Color[] getAtomSetColors() {
        return null;
    }

    public String[] getAtomSetNames() {
        return null;
    }

    public int[] getAtomSetIndexes(Molecule m) {
        return null;
    }

    public abstract String[] getDissimilarityMetrics();

    public abstract float[] getDefaultDissimilarityMetricThresholds();

    public int getDissimilarityMetricIndex(String metricName) throws IllegalArgumentException {
        String[] mets = this.getDissimilarityMetrics();
        for (int i = 0; i < mets.length; ++i) {
            if (!metricName.equals(mets[i]) && !this.capitalEqual(mets[i], metricName)) continue;
            return i;
        }
        throw new IllegalArgumentException("Metric " + metricName + " is not defined for " + this.getClass().getName());
    }

    public int getNumberOfWeights(String dissimilarityMetricName) throws IllegalArgumentException {
        return this.params.getNumberOfWeights(this.getDissimilarityMetricIndex(dissimilarityMetricName));
    }

    public int getNumberOfMetrics() {
        return this.params.getNumberOfMetrics();
    }

    public int getMetricIndex(String metricName) throws IllegalArgumentException {
        int mi = this.params.getMetricIndex(metricName);
        if (mi == -1) {
            throw new IllegalArgumentException("Invalid metric name " + metricName);
        }
        return mi;
    }

    public float getDefaultThreshold(int metricIndex) {
        return this.params.getThreshold(metricIndex);
    }

    public float getThreshold(int metricIndex) {
        return this.params.getThreshold(metricIndex);
    }

    public float getThreshold() {
        return this.params.getThreshold();
    }

    private boolean capitalEqual(String s, String pattern) {
        int i = 0;
        for (int j = 0; j < pattern.length(); ++j) {
            while (i < s.length() && pattern.charAt(j) != s.charAt(i)) {
                ++i;
            }
            if (i != s.length()) continue;
            return false;
        }
        return true;
    }

    public String getMetricName() {
        return this.params.getMetricName();
    }

    public String getMetricName(int metricIndex) {
        return this.params.getMetricName(metricIndex);
    }

    public int getDefaultMetricIndex() {
        return this.params.getCurrentMetricIndex();
    }

    public abstract float getDissimilarity(MolecularDescriptor var1);

    public abstract float getDissimilarity(MolecularDescriptor var1, int var2);

    public float getLowerBound(MolecularDescriptor other) {
        return 0.0f;
    }

    public static void main(String[] args) {
        MolecularDescriptor md = MolecularDescriptor.newInstanceFromXML(args[0]);
        System.out.println("md.name =" + md.getName());
    }
}

