/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.CFParameters;
import chemaxon.descriptors.ChemicalFingerprint;
import chemaxon.descriptors.MDArrayReader;
import chemaxon.descriptors.MDFileReader;
import chemaxon.descriptors.MDHitEvaluator;
import chemaxon.descriptors.MDHypothesisCreator;
import chemaxon.descriptors.MDHypothesisGenerator;
import chemaxon.descriptors.MDMedHypothesisGenerator;
import chemaxon.descriptors.MDMetricOptimizer;
import chemaxon.descriptors.MDMinHypothesisGenerator;
import chemaxon.descriptors.MDParameters;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.MDReader;
import chemaxon.descriptors.MDReaderException;
import chemaxon.descriptors.MDSet;
import chemaxon.descriptors.MDSetParameters;
import chemaxon.descriptors.MDSimilarity;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.descriptors.PFParameters;
import chemaxon.descriptors.PharmacophoreFingerprint;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.util.ArgumentException;
import chemaxon.util.CmdLine;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class OptimizeMetrics {
    private static final String NL = System.getProperty("line.separator");
    private static final String UserHome = System.getProperty("user.home");
    private static final String FileSep = System.getProperty("file.separator");
    private static final String PrgName = "OptimizeMetrics";
    private static final String PrgHeader = NL + "OptimizeMetrics" + " - " + "Molecular Descriptor Dissimilarity Metrics Optimizer " + VersionInfo.JCHEM_VERSION + "," + NL + "(C) 2002-2012 ChemAxon Ltd." + NL;
    private static final String UsageInfo = PrgHeader + "Generates parameter values for metrics used in similarity comparisons." + NL + "" + NL + "Usage: optimizemetrics <target file> <test file> <query file> [options]" + NL + "" + NL + "General options: " + NL + "  -h, --help               this help message" + NL + "  -x, --expert-help        advanced options for expert users" + NL + "  -v, --verbose            verbose" + NL + "" + NL + "Output options:" + NL + "  -e, --precision <prec>   number of decimal places after the decimal point" + NL + "" + NL + "Descriptor options: " + NL + "  -k, --descriptor <type> <common descriptor options> <type specific flags> " + NL + "                           use descriptors of the given type " + NL + "                             according to the type specific flags (see below)" + NL + "                             Supported types are: ChemicalFingerprint, PharmacophoreFingerprint" + NL + "" + NL + "Common descriptor options: " + NL + "  -c, --config <configfile> " + NL + "                           path and name of the XML configuration file" + NL + "  -o, --output <filepath>  output xml file path and name" + NL + "  -t, --use-tag [<name>]   use existing descriptor data" + NL + "  -M, --metric <name> <type-name> <metric specific flags>" + NL + "                           configure a parametrized metric with name <name>" + NL + "                             as specified in the metric specific flags." + NL + "                             Supported type names are: Tanimoto, Euclidean." + NL + "                             This option may appear more than once." + NL + "" + NL + "Descriptor type specific flags: " + NL + "" + NL + "2D pharmacophore fingerprint options:" + NL + "  -z, --fuzzy <smoothing factor> " + NL + "                           generate fuzzy fingerprints with the given" + NL + "                             fuzzy smoothing factor " + NL + "" + NL + "Metric specific flags: " + NL + "  -w, --weights            metric is weighted, generate optimized weights." + NL + "  -W, --cell-weights       weights for Euclidean metric of pharmacophore" + NL + "                           fingerprints is optimized separately for each" + NL + "                           fingerprint cell. Valid only for descriptor" + NL + "                           PharmacophoreFingerprint and metric Euclidean." + NL + "  -s, --scale-factor       metric is scaled, generate optimized scale factor." + NL + "  -a, --asymmetry-factor   metric is asymmetric, generate optimized" + NL + "                             asymmetry factor." + NL + "  -n, --normalize          normalize metric to have dissimilarity values" + NL + "                             as floats between 0 and 1. " + NL + "" + NL + "Similarity options:" + NL + "  -Q, --compare-queries    compare against query descriptor sets" + NL + "  -H, --compare-hypothesis [<name> [C]]" + NL + "                           compare against hypothesis <name>" + NL + "                             Valid names are: Minimum, Average, Median." + NL + "                             Default hypothesis type is Minimum." + NL + "                             'C' indicates consensus fingerprint." + NL + "                             This flag may occur more than once with different" + NL + "                             hypothesis types." + NL + "" + NL + "Parameter optimization options:" + NL + "  -p, --percentage <value> minimal percentage of similar molecules required" + NL + "                             to be hits. Default value is 80." + NL + "  -f, --evaluator-function <name> <asymmetry-factor>" + NL + "                           use the specified evaluator function as the goal" + NL + "                             function of optimization. Allowed types are:" + NL + "                             Enrichment, SelectivityEffectiveness," + NL + "                             ActiveHitDistribution. " + NL + "                             Asymmetry-factor should be specified only for" + NL + "                             function SelectivityEffectiveness. Its default" + NL + "                             value is 0.5 (no asymmetry)." + NL + "                             Default function is Enrichment. Only one goal" + NL + "                             can be specified at a time." + NL + "" + NL + "";
    private static final String ExpertOptions = "" + NL + "Advanced options for expert users:" + NL + "" + NL + "2D pharmacophore fingerprint options:" + NL + "  -P, --PMAP-tag [<name>]  use existing PMAP data" + NL + "" + NL + "Similarity options:" + NL + "  -Z, --zero-threshold    percentage threshold for zero limit in median" + NL + "                             hypothesis" + NL + "" + NL + "Output options:" + NL + "  -l, --split-output       split output configuration file by metrics" + NL + "" + NL + "";
    private static String licenseEnvironment = "";
    private static CmdLine cmdLine = null;
    private static boolean verbose = false;
    private static String targetFileName = null;
    private static String similarFileName = null;
    private static String queryFileName = null;
    private static boolean descrInput = false;
    private static int descriptorCount = 0;
    private static MolecularDescriptor[] descriptors = null;
    private static String[] tagNames = null;
    private static String[] descrNames = null;
    private static boolean splitOutput = false;
    private static int precision = 2;
    private static ArrayList hypoNames = new ArrayList();
    private static float zeroThreshold = -1.0f;
    private static MDReader queryReader = null;
    private static MDReader similarReader = null;
    private static MDReader targetReader = null;
    private static MDArrayReader sReader = null;
    private static MDArrayReader dReader = null;
    private static PrintStream[] outFiles = null;
    private static int scalingHypoIndex = -1;
    private static float percentage = 80.0f;
    private static float alpha = 0.5f;
    private static int[][] metricIndices = null;
    private static boolean compareQueries = false;
    private static String evaluatorFunctionName = "Enrichment";
    private static MDSimilarity similarity = new MDSimilarity();
    private static MDHitEvaluator evaluator = null;
    private static MDMetricOptimizer optimizer = null;
    private static MDSet mdSet = null;

    public static void main(String[] args) {
        OptimizeMetrics.clearAllVariables();
        try {
            if (args.length > 0 && args[0].equals("config")) {
                args = OptimizeMetrics.getArgsFromXML(args);
            }
            cmdLine = new CmdLine(args);
            if (OptimizeMetrics.processCmdLineOptions()) {
                mdSet = new MDSet(descriptorCount);
                mdSet.setDescriptors(descriptors);
                MDSetParameters mdSetPar = new MDSetParameters(descriptorCount);
                mdSet.setParameters(mdSetPar);
                OptimizeMetrics.initSources();
                OptimizeMetrics.initOptimizer();
                OptimizeMetrics.checkLicense();
                OptimizeMetrics.verboseMsg(NL + "Processing started at " + new GregorianCalendar().getTime() + NL);
                for (int d = 0; d < descriptorCount; ++d) {
                    MolecularDescriptor descr = descriptors[d];
                    MDParameters params = descr.getParameters();
                    params.setOutputPrecision(precision);
                    for (int m = 0; m < metricIndices[d].length; ++m) {
                        int index = metricIndices[d][m];
                        params.setCurrentParametrizedMetric(index);
                        String metricName = params.getMetricName();
                        if (verbose) {
                            String messageHeader = NL + "Optimizing parameters for descriptor " + descrNames[d] + ", metric " + metricName;
                            String message = "";
                            message = message + OptimizeMetrics.parameterMessage(message, params.isWeighted(), "weighted");
                            message = message + OptimizeMetrics.parameterMessage(message, params.isScaled(), "scaled");
                            message = message + OptimizeMetrics.parameterMessage(message, params.isAsymmetric(), "asymmetric");
                            message = message + OptimizeMetrics.parameterMessage(message, params.isNormalized(), "normalized");
                            message = message + (message.length() == 0 ? "" : ")");
                            OptimizeMetrics.verboseMsg(messageHeader + message + NL);
                        }
                        optimizer.optimizeParameters(d, index, sReader, dReader);
                        sReader.reset();
                        dReader.reset();
                        OptimizeMetrics.evaluateOptimization(d, index, sReader, dReader);
                        sReader.reset();
                        dReader.reset();
                        if (!splitOutput) continue;
                        OptimizeMetrics.writeSplitOutput(descr, metricName);
                    }
                    String xmlString = descr.getParameters().toString();
                    outFiles[d].println(xmlString);
                    outFiles[d].close();
                }
                queryReader.close();
                sReader.close();
                dReader.close();
                OptimizeMetrics.verboseMsg(NL + "Processing finished at " + new GregorianCalendar().getTime() + NL);
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    private static void clearAllVariables() {
        cmdLine = null;
        verbose = false;
        targetFileName = null;
        similarFileName = null;
        queryFileName = null;
        descrInput = false;
        descriptorCount = 0;
        descriptors = null;
        tagNames = null;
        descrNames = null;
        splitOutput = false;
        precision = 2;
        hypoNames = new ArrayList();
        queryReader = null;
        similarReader = null;
        targetReader = null;
        sReader = null;
        dReader = null;
        outFiles = null;
        scalingHypoIndex = -1;
        percentage = 80.0f;
        alpha = 0.5f;
        metricIndices = null;
        compareQueries = false;
        evaluatorFunctionName = "Enrichment";
        similarity = new MDSimilarity();
        evaluator = null;
        optimizer = null;
        mdSet = null;
    }

    private static String parameterMessage(String message, boolean isParameterSet, String messageToAdd) {
        if (isParameterSet) {
            if (message.length() == 0) {
                return " (" + messageToAdd;
            }
            return ", " + messageToAdd;
        }
        return "";
    }

    private static void evaluateOptimization(int descrIndex, int metricIndex, MDReader sReader, MDReader dReader) throws MDReaderException {
        int nSimilars = evaluator.getNumberOfSimilars();
        float E = evaluator.evaluateByMetric(descrIndex, metricIndex, percentage, sReader, dReader);
        OptimizeMetrics.verboseMsg("Maximal " + evaluatorFunctionName + " reached " + E + NL);
        OptimizeMetrics.verboseMsg("Number of similar hits        " + evaluator.getNumberOfSimilarHits() + NL);
        OptimizeMetrics.verboseMsg("Number of target hits         " + evaluator.getNumberOfDissimilarHits() + NL);
        float threshold = evaluator.getThreshold(descrIndex, metricIndex);
        OptimizeMetrics.verboseMsg("Threshold                     " + threshold + NL);
        descriptors[descrIndex].getParameters().setThreshold(threshold);
    }

    private static void initOptimizer() throws MDReaderException {
        sReader = new MDArrayReader(similarReader);
        similarReader.close();
        dReader = new MDArrayReader(targetReader);
        targetReader.close();
        MDArrayReader qReader = new MDArrayReader(queryReader);
        if (compareQueries) {
            similarity.addQueries(qReader);
            qReader.reset();
        }
        for (int h = 0; h < hypoNames.size(); ++h) {
            MDHypothesisGenerator hypoGen = MDHypothesisCreator.create((String)hypoNames.get(h));
            if (hypoGen instanceof MDMedHypothesisGenerator && zeroThreshold >= 0.0f) {
                ((MDMedHypothesisGenerator)hypoGen).setZeroPercentageThreshold(zeroThreshold);
            }
            MDSet query = qReader.next();
            while (query != null) {
                hypoGen.add(query);
                query = qReader.next();
            }
            qReader.reset();
            MDSet hypothesis = hypoGen.generate();
            similarity.addQuery(hypothesis);
            if (h != scalingHypoIndex) continue;
            for (int d = 0; d < hypothesis.size(); ++d) {
                MolecularDescriptor component = hypothesis.getDescriptor(d);
                component.getParameters().setScalingHypothesis(component);
            }
        }
        if (scalingHypoIndex == -1) {
            MDMinHypothesisGenerator hypoGen = new MDMinHypothesisGenerator();
            MDSet query = qReader.next();
            while (query != null) {
                hypoGen.add(query);
                query = qReader.next();
            }
            qReader.reset();
            MDSet hypothesis = hypoGen.generate();
            for (int d = 0; d < mdSet.size(); ++d) {
                MolecularDescriptor component = hypothesis.getDescriptor(d);
                component.getParameters().setScalingHypothesis(component);
            }
        }
        for (int d = 0; d < descriptorCount; ++d) {
            for (int m = 0; m < metricIndices[d].length; ++m) {
                similarity.useMetric(d, metricIndices[d][m], Float.MAX_VALUE);
            }
        }
        similarity.passWithOneMetric();
        similarity.passWithOneDescriptor();
        similarity.setComponentWise(true);
        evaluator = new MDHitEvaluator(similarity);
        int evaluatorIndex = evaluator.getEvaluatorFunctionIndex(evaluatorFunctionName);
        evaluator.setCurrentEvaluatorFunction(evaluatorIndex);
        evaluator.setSelectivityAsymmetryFactor(alpha);
        optimizer = new MDMetricOptimizer(evaluator);
        OptimizeMetrics.optimizer.percentage = percentage;
    }

    private static boolean processCmdLineOptions() throws ArgumentException, FileNotFoundException, IOException, ParseException, MDReaderException, SQLException, MDParametersException {
        if (cmdLine.isEmpty() || cmdLine.find('h', "help") != -1) {
            System.out.println(UsageInfo);
            return false;
        }
        if (cmdLine.find('x', "expert-help") != -1) {
            System.out.println(UsageInfo + ExpertOptions);
            return false;
        }
        OptimizeMetrics.alloc();
        OptimizeMetrics.getInputFileNames();
        verbose = cmdLine.find('v', "verbose") != -1;
        OptimizeMetrics.verboseMsg(PrgHeader + NL);
        OptimizeMetrics.processSDFileOptions();
        OptimizeMetrics.processOutputOptions();
        OptimizeMetrics.processDescriptorOptions();
        OptimizeMetrics.processSimilarityOptions();
        OptimizeMetrics.processOptimizerOptions();
        OptimizeMetrics.processRemaining();
        return true;
    }

    private static void getInputFileNames() throws ArgumentException {
        targetFileName = cmdLine.getFileName(0);
        if (targetFileName == null) {
            throw new ArgumentException("Missing target, similar and query file names");
        }
        similarFileName = cmdLine.getFileName(1);
        if (similarFileName == null) {
            throw new ArgumentException("Missing similar and query file names");
        }
        queryFileName = cmdLine.getFileName(2);
        if (queryFileName == null) {
            throw new ArgumentException("Missing query file name");
        }
    }

    private static void alloc() throws ArgumentException {
        descriptorCount = cmdLine.countFlag('k', "descriptor");
        if (descriptorCount == 0) {
            throw new ArgumentException("At least one molecular descriptor should be specified");
        }
        descriptors = new MolecularDescriptor[descriptorCount];
        tagNames = new String[descriptorCount];
        descrNames = new String[descriptorCount];
        metricIndices = new int[descriptorCount][];
        outFiles = new PrintStream[descriptorCount];
    }

    private static void processSDFileOptions() throws ArgumentException {
    }

    private static void processOutputOptions() throws ArgumentException, FileNotFoundException {
        int precPos = cmdLine.find('e', "precision", 1);
        if (precPos != -1) {
            precision = cmdLine.getInt(precPos + 1);
        }
        splitOutput = cmdLine.find('l', "split-output") != -1;
    }

    private static void processDescriptorOptions() throws ArgumentException, IOException, ParseException, SQLException, MDParametersException {
        for (int i = 0; i < descriptorCount; ++i) {
            cmdLine.lockDynamicBlock('k', "descriptor");
            String descrType = cmdLine.getParamString('k', "descriptor");
            if (descrType == null) {
                throw new ArgumentException("Missing descriptor type or descriptor name");
            }
            OptimizeMetrics.descrNames[i] = descrType;
            OptimizeMetrics.processCommonDescriptorOptions(i, descrType);
            if (descrType.equals("PharmacophoreFingerprint") || descrType.equals("PF")) {
                OptimizeMetrics.processPharmacophoreFingerprintOptions(i);
                OptimizeMetrics.processCommonMetricOptions(i);
                OptimizeMetrics.processPharmacophoreFingerprintMetricOptions(i);
            } else if (descrType.equals("ChemicalFingerprint") || descrType.equals("CF")) {
                OptimizeMetrics.processChemicalFingerprintOptions(i);
                OptimizeMetrics.processCommonMetricOptions(i);
            } else {
                MolecularDescriptor md = MolecularDescriptor.newInstance(descrType);
                int cPos = cmdLine.find('c', "config", 1);
                if (cPos == -1 && md.needsConfig()) {
                    throw new ArgumentException("Missing -c flag. A valid XML configuration file has to be provided.");
                }
                String paramName = md.getParametersClassName();
                try {
                    Class<?> p = Class.forName(paramName);
                    MDParameters params = (MDParameters)p.newInstance();
                    if (md.needsConfig()) {
                        params.fromFile(new File(cmdLine.getString(cPos + 1)));
                    }
                    md.setParameters(params);
                    OptimizeMetrics.descriptors[i] = md;
                    OptimizeMetrics.processCommonMetricOptions(i);
                }
                catch (Exception cnfe) {
                    cnfe.printStackTrace();
                    throw new ArgumentException("Wrong name: custom MolecularDescriptor " + descrType + " is not available. Failed to access MDParameters" + " subclass " + paramName + ".");
                }
            }
            cmdLine.unlockDynamicBlock();
        }
    }

    private static void processCommonDescriptorOptions(int descrId, String defaultTagName) throws ArgumentException {
        int tPos = cmdLine.find('t', "use-tag", 0, 1);
        if (tPos != -1) {
            OptimizeMetrics.tagNames[descrId] = cmdLine.getParamCount(tPos) == 0 ? defaultTagName : cmdLine.getString(tPos + 1);
        }
        OptimizeMetrics.outFiles[descrId] = System.out;
        int outPos = cmdLine.find('o', "output", 1);
        if (outPos != -1) {
            String fn = cmdLine.getString(outPos + 1);
            try {
                OptimizeMetrics.outFiles[descrId] = new PrintStream(new BufferedOutputStream(new FileOutputStream(fn)));
            }
            catch (IOException ioe) {
                System.err.println("Failed to create file " + fn);
            }
        }
    }

    private static void processCommonMetricOptions(int descrId) throws ArgumentException, IllegalArgumentException, MDParametersException {
        MolecularDescriptor md = descriptors[descrId];
        MDParameters params = md.getParameters();
        int nMetrics = cmdLine.countFlag('M', "metric");
        if (nMetrics == 0) {
            throw new ArgumentException("At least one metric should be specified for descriptor " + descrNames[descrId]);
        }
        OptimizeMetrics.metricIndices[descrId] = new int[nMetrics];
        for (int m = 0; m < nMetrics; ++m) {
            int nWeights;
            cmdLine.lockDynamicBlock('M', "metric");
            int metrPos = cmdLine.find('M', "metric", 1, 2);
            if (metrPos == -1) {
                throw new ArgumentException("Incorrect number of parameters in metric specification of descriptor " + descrNames[descrId]);
            }
            String metricName = null;
            String metricType = null;
            int mp = cmdLine.getParamCount(metrPos);
            if (mp == 1) {
                metricType = cmdLine.getString(metrPos + 1);
            } else {
                metricName = cmdLine.getString(metrPos + 1);
                metricType = cmdLine.getString(metrPos + 2);
            }
            OptimizeMetrics.metricIndices[descrId][m] = params.addParametrizedMetric(metricName, metricType, queryFileName);
            params.setCurrentParametrizedMetric(metricIndices[descrId][m]);
            if (cmdLine.find('w', "weights") != -1) {
                if (md instanceof PharmacophoreFingerprint && metricType.equals("Euclidean")) {
                    params.setCellwiseWeights(false);
                    int nFeatures = ((PFParameters)params).getNumberOfFeatures();
                    int nDistances = ((PFParameters)params).getNDists();
                    float[] featureWeights = new float[nFeatures];
                    float[] distanceWeights = new float[nDistances];
                    for (int f = 0; f < nFeatures; ++f) {
                        featureWeights[f] = 1.0f;
                    }
                    for (int d = 0; d < nDistances; ++d) {
                        distanceWeights[d] = 1.0f;
                    }
                    ((PFParameters)params).setWeights(featureWeights, distanceWeights);
                } else {
                    nWeights = params.getNumberOfWeights();
                    float[] weights = new float[nWeights];
                    for (int w = 0; w < weights.length; ++w) {
                        weights[w] = 1.0f;
                    }
                    params.setWeights(weights);
                    if (metricType.equals("FBPA")) {
                        ((PFParameters)params).setFuzzinessFactor(22.0f);
                    }
                }
            } else if (cmdLine.find('W', "cell-weights") != -1) {
                if (!(md instanceof PharmacophoreFingerprint) || !metricType.equals("Euclidean")) {
                    throw new ArgumentException("Option '-w' ('--cell-weights') is not available for metric " + metricType + " and descriptor " + descrNames[descrId]);
                }
                params.setCellwiseWeights(true);
                nWeights = params.getNumberOfWeights();
                float[] weights = new float[nWeights];
                for (int w = 0; w < weights.length; ++w) {
                    weights[w] = 1.0f;
                }
                params.setWeights(weights);
            }
            if (cmdLine.find('s', "scale-factor") != -1) {
                params.setScaleFactor(1.0f);
            }
            if (cmdLine.find('a', "asymmetry-factor") != -1) {
                params.setAsymmetryFactor(0.0f);
            }
            if (cmdLine.find('n', "normalize") != -1) {
                params.setNormalized(true);
            }
            cmdLine.unlockDynamicBlock();
        }
    }

    private static void processPharmacophoreFingerprintOptions(int descrId) throws ArgumentException, IOException, ParseException, SQLException, MDParametersException {
        int cPos = cmdLine.find('c', "config", 1);
        if (cPos == -1) {
            throw new ArgumentException("Missing PharmacophoreFingerprint configuration");
        }
        PFParameters params = new PFParameters(new File(cmdLine.getString(cPos + 1)));
        int pPos = cmdLine.find('P', "PMAP-tag", 0, 1);
        if (pPos != -1) {
            params.setUsePMAP(cmdLine.getString(pPos + 1));
        }
        OptimizeMetrics.descriptors[descrId] = new PharmacophoreFingerprint(params.toString());
    }

    private static void processChemicalFingerprintOptions(int descrId) throws ArgumentException, MDParametersException, SQLException {
        int cPos = cmdLine.find('c', "config", 1);
        if (cPos == -1) {
            throw new ArgumentException("Missing ChemicalFingerprint configuration");
        }
        CFParameters params = new CFParameters(new File(cmdLine.getString(cPos + 1)));
        OptimizeMetrics.descriptors[descrId] = new ChemicalFingerprint(params);
    }

    private static void processPharmacophoreFingerprintMetricOptions(int descrId) throws ArgumentException {
        PharmacophoreFingerprint md = (PharmacophoreFingerprint)descriptors[descrId];
    }

    private static void processSimilarityOptions() throws ArgumentException {
        Object hypoGen = null;
        int hypoPos = cmdLine.find('H', "compare-hypothesis", 0, 2);
        while (hypoPos != -1) {
            if (cmdLine.getParamCount(hypoPos) == 0) {
                OptimizeMetrics.verboseMsg("Using Minimum hypothesis" + NL);
                hypoNames.add("Minimum");
                scalingHypoIndex = 0;
            } else {
                for (int h = 0; h < MDHypothesisCreator.typeNames.length; ++h) {
                    if (!cmdLine.getString(hypoPos + 1).equals(MDHypothesisCreator.typeNames[h])) continue;
                    hypoNames.add(MDHypothesisCreator.typeNames[h]);
                    if (cmdLine.getParamCount(hypoPos) != 2) continue;
                    if (cmdLine.getString(hypoPos + 2).equals("C")) {
                        scalingHypoIndex = hypoNames.size() - 1;
                        continue;
                    }
                    System.err.println("Invalid option " + cmdLine.getString(hypoPos + 2));
                }
                if (hypoNames.size() == 0) {
                    System.err.println("Missing or bad hypothesis name, using Minimum");
                    hypoNames.add("Minimum");
                }
                if (scalingHypoIndex == -1) {
                    scalingHypoIndex = 0;
                }
            }
            hypoPos = cmdLine.find('H', "compare-hypothesis", 0, 2);
        }
        int zeroThreshPos = cmdLine.find('Z', "zero-threshold", 1, 1);
        if (zeroThreshPos != -1 && ((zeroThreshold = cmdLine.getFloat(zeroThreshPos + 1)) <= 0.0f || zeroThreshold > 100.0f)) {
            throw new ArgumentException("Zero threshold percentage should be a value in (0.0, 100.0]");
        }
        boolean bl = compareQueries = cmdLine.find('Q', "compare-queries") != -1;
        if (hypoNames.size() == 0 && !compareQueries) {
            OptimizeMetrics.verboseMsg("Comparing against all individual queries");
            compareQueries = true;
        }
    }

    private static void processOptimizerOptions() throws ArgumentException {
        int percentPos = cmdLine.find('p', "percentage", 1);
        if (percentPos != -1 && ((percentage = cmdLine.getFloat(percentPos + 1)) <= 0.0f || percentage > 100.0f)) {
            throw new ArgumentException("Hit percentage should be a value in (0.0, 100.0]");
        }
        int evaluatorPos = cmdLine.find('f', "evaluator-function", 1, 2);
        if (evaluatorPos != -1 && (evaluatorFunctionName = cmdLine.getString(evaluatorPos + 1)).equalsIgnoreCase("SelectivityEffectiveness") && cmdLine.getParamCount(evaluatorPos) == 2) {
            alpha = cmdLine.getFloat(evaluatorPos + 2);
        }
    }

    private static void processRemaining() {
        String unprocessed = cmdLine.getUnused();
        while (unprocessed != null) {
            System.err.println(unprocessed);
            unprocessed = cmdLine.getUnused();
        }
    }

    private static void initSources() throws MDReaderException {
        targetReader = OptimizeMetrics.initFileReader(targetFileName, descrInput);
        similarReader = OptimizeMetrics.initFileReader(similarFileName, false);
        queryReader = OptimizeMetrics.initFileReader(queryFileName, false);
        targetReader.setGenerateId(true);
        targetReader.setCloneResult(false);
        similarReader.setGenerateId(true);
        similarReader.setCloneResult(false);
        queryReader.setGenerateId(true);
        queryReader.setCloneResult(false);
    }

    private static MDReader initFileReader(String fn, boolean descrInput) throws MDReaderException {
        if (descrInput) {
            return new MDFileReader(descrNames);
        }
        MDFileReader r = new MDFileReader(fn, mdSet);
        for (int i = 0; i < descriptorCount; ++i) {
            if (tagNames[i] == null) continue;
            r.setTakeTag(i, tagNames[i]);
        }
        return r;
    }

    private static void notYetImplemented(char shortForm, String longForm) {
        System.err.println("Option -" + shortForm + ", --" + longForm + " is not yet implemented, ignored");
    }

    private static void verboseMsg(String msg) {
        if (verbose) {
            System.out.print(msg);
        }
    }

    private static void verboseDone() {
        if (verbose) {
            System.out.println(" done");
        }
    }

    private static void writeSplitOutput(MolecularDescriptor descr, String metricName) throws FileNotFoundException {
        PFParameters p;
        MDParameters params = descr.getParameters();
        String fn = descr.getClass().getName();
        fn = fn.substring(fn.lastIndexOf(46) + 1);
        if (descr instanceof PharmacophoreFingerprint && (p = (PFParameters)params).isFuzzyFingerprint()) {
            fn = fn + "fuzzy" + p.getFuzzySmoothingFactor();
        }
        PrintStream f = new PrintStream(new BufferedOutputStream(new FileOutputStream(fn + metricName + ".xml")));
        f.println(params.getScreeningConfigurationString("ParametrizedMetric", "Name", metricName));
        f.close();
    }

    private static String[] getArgsFromXML(String[] args) throws DocumentException, IOException {
        int j;
        String xmlFileName = args[1];
        SAXReader reader = new SAXReader();
        Document doc = reader.read(new File(xmlFileName));
        StringBuffer sb = new StringBuffer();
        boolean inputInXml = OptimizeMetrics.transformInput(sb, doc);
        OptimizeMetrics.transformDescriptors(sb, doc);
        OptimizeMetrics.transformSimilarityOptions(sb, doc);
        OptimizeMetrics.transformParameterOptimizationOptions(sb, doc);
        StringTokenizer stk = new StringTokenizer(sb.toString());
        String[] newArgs = new String[stk.countTokens() + args.length - 2];
        int i = 0;
        if (!inputInXml) {
            for (j = 2; j < 5; ++j) {
                newArgs[i++] = args[j];
            }
        }
        while (stk.hasMoreTokens()) {
            newArgs[i++] = stk.nextToken();
        }
        int n = j = inputInXml ? 2 : 5;
        while (j < args.length) {
            newArgs[i++] = args[j];
            ++j;
        }
        return newArgs;
    }

    private static boolean transformInput(StringBuffer sb, Document doc) {
        Element inp = (Element)doc.selectSingleNode("//*/Input");
        if (inp == null) {
            return false;
        }
        sb.append(inp.attributeValue("TargetFile")).append(' ').append(inp.attributeValue("TestFile")).append(' ').append(inp.attributeValue("QueryFile")).append(' ');
        return true;
    }

    private static void transformDescriptors(StringBuffer sb, Document doc) {
        List l = doc.selectNodes("//*/Descriptors/Descriptor");
        for (Element e : l) {
            String type = e.attributeValue("Type");
            sb.append(" -k ").append(type).append(" -c ").append(e.attributeValue("ConfigFile")).append(" -o ").append(e.attributeValue("OutputFile"));
            OptimizeMetrics.appendOptional(sb, e, "FuzzySmoothingFactor", "-z");
            OptimizeMetrics.appendOptional(sb, e, "FuzzySmoothingVector", "-z");
            OptimizeMetrics.appendOptional(sb, e, "GaussianCutoff", "-G");
            OptimizeMetrics.appendOptional(sb, e, "SmoothingBound", "-B");
            OptimizeMetrics.appendOptional(sb, e, "AsymmetricalSmoothing", "-A");
            OptimizeMetrics.appendOptional(sb, e, "IgnoreRotatableBonds", "-R");
            OptimizeMetrics.transformMetrics(sb, e.selectNodes("Metrics/Metric"));
        }
    }

    private static void transformMetrics(StringBuffer sb, List metrics2) {
        for (Element e : metrics2) {
            sb.append(" -M ").append(e.attributeValue("Name")).append(' ').append(e.attributeValue("BaseMetric"));
            if (e.attributeValue("Weighted") != null && e.attributeValue("Weighted").equals("true")) {
                sb.append(" -w ");
            } else if (e.attributeValue("WeightedCellwise") != null && e.attributeValue("WeightedCellwise").equals("true")) {
                sb.append(" -W ");
            }
            if (e.attributeValue("Scaled") != null && e.attributeValue("Scaled").equals("true")) {
                sb.append(" -s ");
            }
            if (e.attributeValue("Asymmetric") != null && e.attributeValue("Asymmetric").equals("true")) {
                sb.append(" -a ");
            }
            if (e.attributeValue("Normalized") == null || !e.attributeValue("Normalized").equals("true")) continue;
            sb.append(" -n ");
        }
    }

    private static void transformSimilarityOptions(StringBuffer sb, Document doc) {
        Element inp = (Element)doc.selectSingleNode("//*/SimilarityOptions");
        if (inp != null) {
            if (inp.attributeValue("CompareQueries") != null && inp.attributeValue("CompareQueries").equals("true")) {
                sb.append(" -Q ");
            }
            List l = inp.selectNodes("Hypotheses/Hypothesis");
            for (Element e : l) {
                sb.append(" -H ").append(e.attributeValue("Type"));
                if (e.attributeValue("Consensus") == null || !e.attributeValue("Consensus").equals("true")) continue;
                sb.append(" C ");
            }
            if (inp.attributeValue("ZeroThreshold") != null) {
                sb.append(" -Z ").append(inp.attributeValue("ZeroThreshold"));
            }
        }
    }

    private static void transformParameterOptimizationOptions(StringBuffer sb, Document doc) {
        Element inp = (Element)doc.selectSingleNode("//*/ParameterOptimizationOptions");
        if (inp != null) {
            if (inp.attributeValue("Percentage") != null) {
                sb.append(" -p ").append(inp.attributeValue("Percentage"));
            }
            List l = inp.selectNodes("EvaluatorFunction");
            for (Element e : l) {
                sb.append(" -f ").append(e.attributeValue("Name"));
                if (e.attributeValue("AsymmetryFactor") == null) continue;
                sb.append(e.attributeValue("AsymmetryFactor"));
            }
        }
    }

    private static void append(StringBuffer sb, Element n, String attr, String flag) {
        sb.append(' ').append(flag).append(' ').append(n.attributeValue(attr));
    }

    private static void appendOptional(StringBuffer sb, Element n, String attr, String flag) {
        if (n.attributeValue(attr) != null) {
            sb.append(' ').append(flag).append(' ').append(n.attributeValue(attr));
        }
    }

    public static boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("Optimize Metrics", licenseEnvironment);
    }

    private static void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("Optimize Metrics", licenseEnvironment);
    }

    public static void setLicenseEnvironment(String env) {
        licenseEnvironment = env;
    }
}

