/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDGenerator;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.descriptors.PFParameters;
import chemaxon.descriptors.PharmacophoreFingerprint;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.pharmacophore.PMap;
import chemaxon.pharmacophore.PMapper;
import chemaxon.pharmacophore.PSymbols;
import chemaxon.pharmacophore.RotBondCounter;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.Molecule;
import chemaxon.util.ShortestPath;

public class PFGenerator
extends MDGenerator {
    private ShortestPath sp = null;
    private PMapper pm = null;
    private PMap pmap = null;
    private boolean usePMAP = false;
    private String pMapTagName = "PMAP";
    private String[] newTags = new String[]{this.pMapTagName};
    private RotBondCounter bc = null;
    private int[] nodes1 = null;
    private int[] nodes2 = null;
    private int[] minPath = null;

    public PFGenerator(PMapper pmapper) {
        this.pm = pmapper;
        this.sp = new ShortestPath();
        this.bc = new RotBondCounter();
    }

    public void setUsePMAP(boolean use) {
        this.usePMAP = use;
    }

    public void setPMAPTagName(String tagName) {
        this.newTags[0] = this.pMapTagName = tagName;
    }

    public String getPMAPTagName() {
        return this.pMapTagName;
    }

    @Override
    public String[] generate(Molecule m, MolecularDescriptor d) throws MDGeneratorException {
        PFParameters params = (PFParameters)d.getParameters();
        try {
            Molecule stdMol = params.standardize(m);
            if (!this.usePMAP || m.getProperty(this.pMapTagName) == null) {
                this.pmap = this.pm.createFeatureMap(stdMol);
                stdMol.setProperty(this.pMapTagName, this.pmap.toString(params.getPSymbols()));
            } else {
                this.pmap = PMap.create(m.getProperty(this.pMapTagName), params.getPSymbols());
                stdMol.setProperty(this.pMapTagName, m.getProperty(this.pMapTagName));
            }
            this.sp.calculate(stdMol);
            if (params.isFuzzyFingerprint()) {
                this.bc.setMolecule(stdMol);
            }
            this.alloc(stdMol.getAtomCount());
            this.generate(stdMol.getAtomCount(), (PharmacophoreFingerprint)d, params);
            if (this.createStatistics) {
                this.updateStatistics(d);
            }
            return this.newTags;
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            throw new MDGeneratorException("Mapping pharmacophore types failed, reason: " + pe.getMessage());
        }
        catch (SearchException se) {
            se.printStackTrace();
            throw new MDGeneratorException("Mapping pharmacophore types failed, reason: " + se.getMessage());
        }
    }

    private void generate(int nAtoms, PharmacophoreFingerprint pfGen, PFParameters params) {
        pfGen.startGeneration();
        pfGen.clear();
        boolean fuzzy = params.isFuzzyFingerprint();
        boolean gaussian = params.isGaussianSmoothing();
        int nf = params.getNumberOfFeatures();
        for (int fa = 0; fa < nf; ++fa) {
            int nn1 = this.pmap.getAtoms(fa, this.nodes1);
            for (int i = 0; i < nn1; ++i) {
                int a = this.nodes1[i];
                for (int fb = 0; fb < nf; ++fb) {
                    int nn2 = this.pmap.getAtoms(fb, this.nodes2);
                    for (int j = 0; j < nn2; ++j) {
                        int b = this.nodes2[j];
                        if (b <= a) continue;
                        int dist = this.sp.minDist(a, b);
                        if (fuzzy) {
                            if (gaussian && (float)dist >= params.getFuzzyLowerBound()) {
                                int pl = this.sp.getPath(a, b, this.minPath);
                                pfGen.inc(fa, fb, dist, params.getIgnoreRotatableBonds() ? 0 : this.bc.calcRotBonds(this.minPath, pl));
                                continue;
                            }
                            if (gaussian) continue;
                            pfGen.inc(fa, fb, dist, params.getCustomFuzzyIncrements(fa, fb));
                            continue;
                        }
                        pfGen.inc(fa, fb, dist);
                    }
                }
            }
        }
    }

    public String getPMap(Molecule m, PSymbols pSym) throws MDGeneratorException {
        if (m.getProperty(this.pMapTagName) != null) {
            return m.getProperty(this.pMapTagName);
        }
        try {
            PMap map = this.pm.createFeatureMap(m);
            String ms = map.toString(pSym);
            m.setProperty(this.pMapTagName, ms);
            return ms;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MDGeneratorException("Pharmacophore point perception failed.");
        }
    }

    @Override
    protected int calcFreqCount(MolecularDescriptor d) {
        PharmacophoreFingerprint pf = (PharmacophoreFingerprint)d;
        int nz = 0;
        for (int i = 0; i < pf.fp.length; ++i) {
            if (pf.fp[i] == 0.0f) continue;
            int n = i;
            this.freqCount[n] = this.freqCount[n] + 1;
            ++nz;
        }
        return nz;
    }

    private void alloc(int nAtoms) {
        int nl;
        if (this.nodes1 != null && this.nodes1.length > nAtoms) {
            return;
        }
        int n = nl = this.nodes1 != null ? this.nodes1.length : 16;
        while (nl < nAtoms) {
            nl <<= 1;
        }
        this.nodes1 = new int[nAtoms];
        this.nodes2 = new int[nAtoms];
        this.minPath = new int[nAtoms];
    }
}

