/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDParameters;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.descriptors.PFGenerator;
import chemaxon.descriptors.PharmacophoreFingerprint;
import chemaxon.formats.MFileFormatUtil;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.pharmacophore.ColorDecoder;
import chemaxon.pharmacophore.PMapper;
import chemaxon.pharmacophore.PSymbols;
import chemaxon.struc.Molecule;
import chemaxon.util.StringUtil;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class PFParameters
extends MDParameters {
    public static final int DEFAULT_RESOLUTION = 1;
    public static final float DEFAULT_FUZZINESS_FACTOR = 1.0f;
    public static final float DEFAULT_FUZZY_CUTOFF = 10.0f;
    public static final int DEFAULT_FUZZY_LOWER_BOUND = 1;
    public static final String DEFAULT_XML_CONFIG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!-- Pharmacophore configuration file -->\n<PharmacophoreFingerprintConfiguration Version =\"0.3\" schemaLocation=\"pharmacophores.xsd\">\n     <PharmacophoreDefinition>\n        <Search StereoCareChecking=\"false\"/>\n        <Mols>\n            <Mol ID=\"pos\" Structure=\"[*+]\"/>\n            <Mol ID=\"nitro\" Structure=\"[O:2]~[N:1]=[O:3]\"/>\n            <Mol ID=\"amine\" Structure=\"C[N:1]\"/>\n            <Mol ID=\"tertamine\" Structure=\"C[N:1](C)C\"/>\n            <Mol ID=\"aniline\" Structure=\"c[N:1]\"/>\n            <Mol ID=\"amide\" Structure=\"[#7:1][C,P,S:2]=O\"/>\n            <Mol ID=\"hydrazine\" Structure=\"NN\"/>\n            <Mol ID=\"phenylhydrazine\" Structure=\"c[N:1][N:2]\"/>\n            <Mol ID=\"hydrazide\" Structure=\"[#7:1]NC=O\"/>\n            <Mol ID=\"amidine\" Structure=\"[#7:2][C,P,S:1]=[N:3]\"/>\n            <Mol ID=\"neg\" Structure=\"[*-]\"/>\n            <Mol ID=\"carbox\" Structure=\"[H][O:3][C:1]=[O:2]\"/>\n            <Mol ID=\"carboxylate\" Structure=\"[O-3][C:1]=[O:2]\"/>\n            <Mol ID=\"sulfonyl\" Structure=\"[H][O:3][S:1](=[O:2])=[O:4]\"/>\n            <Mol ID=\"sulfonate\" Structure=\"[O-:3][S:1](=[O:4])=[O:2]\"/>\n            <Mol ID=\"phosphonyl\" Structure=\"[H][O:4][P:1]([O:2])=[O:3]\"/>\n            <Mol ID=\"phosphonate\" Structure=\"[O:4][P:1]([O-:2])=[O:3]\"/>\n            <Mol ID=\"arom\" Structure=\"[*;a]\"/>\n            <Mol ID=\"cx\" Structure=\"[C,F,Cl,Br,I,At]\"/>\n            <Mol ID=\"nos\" Structure=\"[#7,#8,#16]\"/>\n            <Mol ID=\"pyr\" Structure=\"[nX3]\"/>\n            <Mol ID=\"qh\" Structure=\"[!#1!#6:1][H]\"/>\n        </Mols>\n        <Pharmacophores>\n            <AtomSet ID=\"Aromatic\" Symbol=\"r\">arom</AtomSet>\n            <AtomSet ID=\"Cationic\" Symbol=\"+\">\n                <![CDATA[ !neg && ((pos && !nitro:1) || ((amine:1 || hydrazine || amidine:2,3) && !(tertamine:1 || amide:1 || nitro:1 || aniline:1 || phenylhydrazine:2))) ]]>\n            </AtomSet>\n            <AtomSet ID=\"Anionic\" Symbol=\"-\">\n                <![CDATA[ !pos && ((neg && !nitro:2,3) || carbox:2,3 || carboxylate:2,3 || sulfonyl:2,3,4 || sulfonate || phosphonyl:2,3,4 || phosphonate) ]]>\n            </AtomSet>\n            <AtomSet ID=\"HydrogenBondDonor\" Symbol=\"d\">\n                <![CDATA[ qh:1 || tertamine:1 && !{Anionic}]]>\n            </AtomSet>\n            <AtomSet ID=\"HydrogenBondAcceptor\" Symbol=\"a\">\n                <![CDATA[ nos && !tertamine:1 && !pyr && !amide:1,2 && !aniline:1 && !sulfonyl:1 && !sulfonate:1 && !{Cationic} && !nitro:1 ]]>\n            </AtomSet>\n            <AtomSet ID=\"Hydrophobic\" Symbol=\"h\">\n                <![CDATA[ cx && !{Aromatic} && !{Cationic} && !{Anionic} && !{HydrogenBondDonor} && !{HydrogenBondAcceptor} ]]>\n            </AtomSet>\n        </Pharmacophores>\n        <PharmacophoreFingerprintParameters MinimalDistance=\"1\" MaximalDistance=\"10\" />\n    </PharmacophoreDefinition>\n    <StandardizerConfiguration Version =\"0.1\">\n        <Actions>              \n            <Removal ID=\"keepOne\" Method=\"keepLargest\" Measure=\"molMass\"/>\n            <Action ID=\"aromatize\" Act=\"aromatize\"/>\n        </Actions>\n    </StandardizerConfiguration>\n    <ScreeningConfiguration>\n        <PharmacophorePointColors>\n            <Color Symbol=\"+\" Value=\"red\"/>\n            <Color Symbol=\"-\" Value=\"blue\"/>\n            <Color Symbol=\"r\" Value=\"green\"/>\n            <Color Symbol=\"h\" Value=\"black\"/>\n            <Color Symbol=\"d\" Value=\"navy\"/>\n            <Color Symbol=\"a\" Value=\"maroon\"/>\n            <Color Symbol=\"a/d\" Value=\"purple\"/>\n            <Color Symbol=\"+/d\" Value=\"lime\"/>\n            <Color Symbol=\"-/a\" Value=\"aqua\"/>\n            <Color Symbol=\"empty\" Value=\"gray\"/>\n            <Color Symbol=\"other\" Value=\"fuchsia\"/>\n        </PharmacophorePointColors>        \n        <ParametrizedMetrics>\n            <ParametrizedMetric Name=\"Tanimoto\" ActiveFamily=\"Generic\" \n                Metric=\"Tanimoto\" Threshold=\"0.2\"/>\n            <ParametrizedMetric Name=\"Euclidean\" ActiveFamily=\"Generic\" \n                Metric=\"Euclidean\" Threshold=\"15\" />\n            <ParametrizedMetric Name=\"Tversky\" ActiveFamily=\"Generic\"\n                     Metric=\"Tversky\" Threshold=\"0.5\" TverskyAlpha=\"1\" TverskyBeta=\"1\"/>\n            <ParametrizedMetric Name=\"UnityTversky\" ActiveFamily=\"Generic\"\n                     Metric=\"Tversky\" Threshold=\"0.5\" TverskyAlpha=\"0.\" TverskyBeta=\"0.\"/>\n        </ParametrizedMetrics>\n    </ScreeningConfiguration>\n</PharmacophoreFingerprintConfiguration>\n";
    private Element pharmacophoreDefinitionNode = null;
    private List molNodes = null;
    private List atomSetNodes = null;
    private Element fingerprintNode = null;
    private Element pharmacophorePointColorsNode = null;
    private List colorNodes = null;
    private PSymbols ppSymbols = null;
    private PMapper pmapper = null;
    private int minDist = -1;
    private int maxDist = -1;
    private int resolution = 1;
    private int nDist = -1;
    private int nFeatures = 0;
    private float fuzzySmoothingFactor = 0.0f;
    private float[][][] fuzzySmoothingVector = null;
    private float fuzzyCutOff = 10.0f;
    private int fuzzyLowerBound = 1;
    private boolean symmetricalFuzzy = true;
    private boolean ignoreRotatableBonds = false;
    protected ArrayList fuzzinessFactors = new ArrayList();
    protected float[][] fuzzyExp = null;
    protected ColorDecoder colDec = null;
    protected String[] pptNames = null;
    protected float[][] gFuzzyIncrements = null;
    protected float[][][] svFuzzyIncrements = null;
    protected byte[][] compressedData = null;
    public float[] xyz = null;
    public float asymmetricXYZSum = 0.0f;

    public PFParameters() {
        this.init();
        this.fromString(DEFAULT_XML_CONFIG);
    }

    public PFParameters(File configFile) throws MDParametersException {
        this.init();
        this.readFromXmlFile(configFile, false, true);
        this.initParameters();
    }

    public PFParameters(String XMLconfig) throws MDParametersException {
        this.init();
        this.readFromXmlString(XMLconfig, false, true);
        this.initParameters();
    }

    @Override
    public void fromString(String parameterString) throws MDParametersException {
        super.fromString(parameterString);
        this.initGenerator();
    }

    @Override
    public void fromFile(File parameterFile) throws MDParametersException {
        super.fromFile(parameterFile);
        this.initGenerator();
    }

    @Override
    public String toString() {
        try {
            this.writeMols();
            return super.toString();
        }
        catch (MDParametersException p) {
            return null;
        }
    }

    @Override
    public void setParameters(String parametersString) throws MDParametersException {
        super.setParameters(parametersString);
        if (this.generator != null) {
            this.makePPTNames();
        }
    }

    @Override
    public void setParameters(File parametersFile) throws MDParametersException {
        super.setParameters(parametersFile);
        this.initParameters();
        if (this.generator != null) {
            this.makePPTNames();
        }
    }

    protected void init() {
        this.cellSize = 32;
        this.xyz = new float[3];
        this.md = new PharmacophoreFingerprint();
        this.fuzzinessFactors = new ArrayList();
    }

    protected void initGenerator() throws MDParametersException {
        if (this.pharmacophoreDefinitionNode == null) {
            return;
        }
        try {
            this.pmapper = new PMapper(this.pharmacophoreDefinitionNode, this.configFilePath);
            this.generator = new PFGenerator(this.pmapper);
            this.makePPTNames();
        }
        catch (IOException io) {
            io.printStackTrace();
            throw new MDParametersException("Error in configuration file: " + io.getMessage());
        }
        catch (ParseException ce) {
            throw new MDParametersException("Bad expression in the pharmacophore configuration string." + ce.getMessage());
        }
    }

    @Override
    protected void initParameters() {
        super.initParameters();
        this.setLength(this.nDist * (this.nFeatures * (this.nFeatures + 1) / 2));
        this.internalSize = this.length;
        this.data = new byte[this.internalSize * 4 + 1];
        this.compressedData = new byte[this.length * 4 + 1][];
        if (this.fuzzySmoothingFactor != 0.0f) {
            this.calculateGFuzzyIncrements();
        } else if (this.fuzzySmoothingVector != null) {
            this.calculateSVFuzzyIncrements();
        }
        this.initGenerator();
    }

    protected String[] generate(Molecule m, MolecularDescriptor cd) throws MDGeneratorException {
        return this.generator.generate(m, cd);
    }

    @Override
    public void setCurrentParametrizedMetric(int metricIndex) {
        if (this.currentMetricIndex == metricIndex) {
            return;
        }
        super.setCurrentParametrizedMetric(metricIndex);
        Float ff = (Float)this.fuzzinessFactors.get(metricIndex);
        if (ff != null) {
            this.calculateFuzzyExponents(ff.floatValue());
        }
    }

    public void setFuzzySmoothingFactor(float fsf) {
        this.fuzzySmoothingFactor = fsf;
        this.calculateGFuzzyIncrements();
        this.fingerprintNode.addAttribute("FuzzySmoothingFactor", Float.toString(fsf));
    }

    public void setFuzzyCutOff(float fco) {
        this.fuzzyCutOff = fco;
        this.calculateGFuzzyIncrements();
        this.fingerprintNode.addAttribute("FuzzyCutOff", Float.toString(fco));
    }

    public void setFuzzyLowerBound(int flb) {
        this.fuzzyLowerBound = flb;
        this.fingerprintNode.addAttribute("FuzzyLowerBound", Integer.toString(flb));
    }

    public void setSymmetricalFuzzy(boolean sf) {
        this.symmetricalFuzzy = sf;
        this.calculateGFuzzyIncrements();
        this.fingerprintNode.addAttribute("FuzzySymmetrical", "" + sf);
    }

    public void setIgnoreRotatableBonds(boolean irb) {
        this.ignoreRotatableBonds = irb;
        this.calculateGFuzzyIncrements();
        this.fingerprintNode.addAttribute("FuzzyIgnoreRotatableBonds", "" + irb);
    }

    public void setFuzzinessFactor(float alpha) {
        this.fuzzinessFactors.set(this.currentMetricIndex, new Float(alpha));
        this.writeMetricParameter(this.fuzzinessFactors, "FuzzinessFactor", this.currentMetricIndex, true);
    }

    public void setUsePMAP(String pmapTagName) {
        ((PFGenerator)this.generator).setPMAPTagName(pmapTagName);
        ((PFGenerator)this.generator).setUsePMAP(true);
    }

    public void setPMAPTagName(String tagName) {
        ((PFGenerator)this.generator).setPMAPTagName(tagName);
    }

    public void setWeights(float[] featureWeights, float[] distanceWeights) {
        this.setCellwiseWeights(false);
        Element pm = (Element)this.parametrizedMetricNodes.get(this.currentMetricIndex);
        Element weightsNode = pm.elements().size() == 0 ? this.addWeightsNode(pm) : this.findWeightsNode(pm);
        List ws = weightsNode.elements();
        for (int i = 0; i < ws.size(); ++i) {
            Element w = (Element)ws.get(i);
            String typeSymbol = w.attributeValue("TypeSymbol");
            if (typeSymbol != null) {
                float v = featureWeights[this.ppSymbols.getIndex(typeSymbol)];
                w.addAttribute("Value", this.decForm.format(v));
                continue;
            }
            String distance = w.attributeValue("Distance");
            float v = distanceWeights[Integer.parseInt(distance) - this.minDist];
            w.addAttribute("Value", this.decForm.format(v));
        }
        float[] w = new float[this.getLength()];
        for (int f1 = 0; f1 < this.nFeatures; ++f1) {
            for (int f2 = 0; f2 <= f1; ++f2) {
                for (int d = this.minDist; d <= this.maxDist; ++d) {
                    w[this.tripletIndex((int)f1, (int)f2, (int)d)] = featureWeights[f1] * featureWeights[f2] * distanceWeights[d - this.minDist];
                }
            }
        }
        this.weights.set(this.currentMetricIndex, w);
    }

    private Element addWeightsNode(Element metricNode) {
        int i;
        Element weightsNode = metricNode.addText("\n").addElement("Weights");
        for (i = 0; i < this.nFeatures; ++i) {
            weightsNode.addElement("Weight").addAttribute("TypeSymbol", this.ppSymbols.getSymbol(i)).addText("\n");
        }
        for (i = 0; i < this.getNDists(); ++i) {
            weightsNode.addElement("Weight").addAttribute("Distance", Integer.toString(this.minDist + i)).addText("\n");
        }
        return weightsNode;
    }

    private Element findWeightsNode(Element metricNode) {
        return (Element)metricNode.selectSingleNode("Weights");
    }

    public int getNumberOfFeatures() {
        return this.nFeatures;
    }

    public PSymbols getPSymbols() {
        return this.ppSymbols;
    }

    public String getSymbol(int i) {
        if (this.ppSymbols == null) {
            return null;
        }
        return this.ppSymbols.getSymbol(i);
    }

    public int getSymbolIndex(String symbol) throws IllegalArgumentException {
        if (this.ppSymbols == null) {
            throw new IllegalArgumentException("Pharmacophore point symbols have not yet been defined.");
        }
        return this.ppSymbols.getIndex(symbol);
    }

    public int getMinDist() {
        return this.minDist;
    }

    public int getMaxDist() {
        return this.maxDist;
    }

    public int getResolution() {
        return this.resolution;
    }

    public int getNDists() {
        return this.nDist;
    }

    @Override
    protected int getNumberOfWeights(int parametrizedMetricIndex) throws IllegalArgumentException {
        int dissimilarityMetricIndex = (Integer)this.metricIndexes.get(this.currentMetricIndex);
        switch (dissimilarityMetricIndex) {
            case 0: {
                return 0;
            }
            case 1: {
                boolean cellwise = (Boolean)this.cellwiseWeights.get(parametrizedMetricIndex);
                return cellwise ? this.getLength() : this.nFeatures + this.nDist;
            }
            case 2: {
                return this.nFeatures + this.nDist;
            }
        }
        throw new IllegalArgumentException("Invalid metric index " + dissimilarityMetricIndex);
    }

    public boolean isFuzzyFingerprint() {
        return this.fuzzySmoothingFactor != 0.0f || this.fuzzySmoothingVector != null;
    }

    public boolean isGaussianSmoothing() {
        return this.gFuzzyIncrements != null;
    }

    public float getFuzzySmoothingFactor() {
        return this.fuzzySmoothingFactor;
    }

    public boolean isSymmetricalFuzzy() {
        return this.symmetricalFuzzy;
    }

    public boolean getIgnoreRotatableBonds() {
        return this.ignoreRotatableBonds;
    }

    public float getFuzzyLowerBound() {
        return this.fuzzyLowerBound;
    }

    public static String getDefaultStandardizerConfiguration() {
        return "<StandardizerConfiguration Version =\"0.1\" > <Actions> <Removal ID=\"keepOne\" Method=\"keepLargest\" Measure=\"molMass\"/> <Action ID=\"aromatize\" Act=\"aromatize\"/> </Actions> </StandardizerConfiguration> ";
    }

    @Override
    public String getDefaultDocumentFrame() {
        return DEFAULT_XML_CONFIG;
    }

    public float[][] getGaussianFuzzyIncrements() {
        return this.gFuzzyIncrements;
    }

    public float[] getCustomFuzzyIncrements(int fa, int fb) {
        return this.svFuzzyIncrements[fa][fb];
    }

    public float[][] getFuzzyExponents() {
        return this.fuzzyExp;
    }

    public Color[] getAtomSetColors() {
        return this.colDec != null ? this.colDec.getColors() : null;
    }

    public String[] getAtomSetNames() {
        return this.pptNames;
    }

    public int[] getAtomSetIndexes(Molecule m, PharmacophoreFingerprint pfp) {
        if (this.colDec == null) {
            return null;
        }
        PFGenerator g = (PFGenerator)this.generator;
        String pmapName = g.getPMAPTagName();
        String pmap = m.getProperty(pmapName);
        if (pmap == null) {
            try {
                this.standardize(m);
                pmap = g.getPMap(m, this.ppSymbols);
            }
            catch (MDGeneratorException e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.colDec.getAtomSetIndexes(pmap);
    }

    private void calculateGFuzzyIncrements() {
        int rb;
        if (this.fuzzySmoothingFactor == 0.0f) {
            return;
        }
        if (this.gFuzzyIncrements == null) {
            this.gFuzzyIncrements = new float[this.nDist][this.nDist];
        }
        double[] weights = new double[this.nDist];
        for (rb = 0; rb < this.nDist; ++rb) {
            int b;
            double sigma = (float)(rb + 1) * this.fuzzySmoothingFactor;
            double nom = sigma * Math.sqrt(Math.PI * 2);
            double sum = 0.0;
            for (b = 0; b < this.nDist; ++b) {
                double w = Math.exp(-((double)(b * b)) / (2.0 * sigma * sigma)) / nom;
                sum += b == 0 ? w : 2.0 * w;
                weights[b] = (double)b <= (double)this.fuzzyCutOff * sigma ? w : 0.0;
            }
            for (b = 0; b < this.nDist; ++b) {
                this.gFuzzyIncrements[rb][b] = (float)(weights[b] / sum);
            }
            if (this.ignoreRotatableBonds) break;
        }
        if (this.ignoreRotatableBonds) {
            for (rb = 1; rb < this.nDist; ++rb) {
                for (int b = 0; b < this.nDist; ++b) {
                    this.gFuzzyIncrements[rb][b] = this.gFuzzyIncrements[0][b];
                }
            }
        }
    }

    private void calculateSVFuzzyIncrements() {
        int nSyms = this.ppSymbols.getSymbolCount();
        if (this.svFuzzyIncrements == null) {
            this.svFuzzyIncrements = new float[nSyms][nSyms][];
        }
        for (int fa = 0; fa < nSyms; ++fa) {
            for (int fb = 0; fb <= fa; ++fb) {
                if (this.fuzzySmoothingVector[fa][fb] == null) continue;
                this.svFuzzyIncrements[fa][fb] = new float[2 * this.nDist + 1];
                this.svFuzzyIncrements[fb][fa] = this.svFuzzyIncrements[fa][fb];
                int displacement = this.nDist - this.fuzzySmoothingVector[fa][fb].length / 2;
                for (int d = 0; d < this.fuzzySmoothingVector[fa][fb].length; ++d) {
                    this.svFuzzyIncrements[fa][fb][displacement + d] = this.fuzzySmoothingVector[fa][fb][d];
                }
            }
        }
    }

    private void calculateFuzzyExponents(float fuzzinessFactor) {
        if (this.fuzzyExp == null || this.fuzzyExp.length < this.maxDist + 1) {
            this.fuzzyExp = new float[this.maxDist + 1][this.maxDist + 1];
        }
        for (int d1 = 0; d1 <= this.maxDist; ++d1) {
            for (int d2 = 0; d2 <= d1; ++d2) {
                int dds = (d1 - d2) * (d1 - d2);
                float f = (float)Math.exp(-fuzzinessFactor * (float)dds);
                this.fuzzyExp[d2][d1] = f;
                this.fuzzyExp[d1][d2] = f;
            }
        }
    }

    @Override
    protected void processDocument(boolean all) throws MDParametersException {
        this.checkDocumentVersion("PharmacophoreFingerprintConfiguration", VersionInfo.JCHEM_VERSION);
        try {
            if (all) {
                this.pharmacophoreDefinitionNode = (Element)this.document.selectSingleNode("//PharmacophoreFingerprintConfiguration/PharmacophoreDefinition");
                this.molNodes = this.pharmacophoreDefinitionNode.selectNodes("Mols/Mol");
                this.atomSetNodes = this.pharmacophoreDefinitionNode.selectNodes("Pharmacophores/AtomSet");
                this.fingerprintNode = (Element)this.pharmacophoreDefinitionNode.selectSingleNode("PharmacophoreFingerprintParameters");
            }
            this.pharmacophorePointColorsNode = (Element)this.document.selectSingleNode("//PharmacophoreFingerprintConfiguration/ScreeningConfiguration/PharmacophorePointColors");
            this.colorNodes = this.pharmacophorePointColorsNode.selectNodes("Color");
            super.processDocument(all);
        }
        catch (NullPointerException ne) {
            throw new MDParametersException("Pharmacophore Fingerprint parameter configuration error. ");
        }
    }

    @Override
    protected void readValues(boolean all) throws MDParametersException {
        if (all) {
            this.readMols();
            this.readPharmacophoreSymbols();
            this.nFeatures = this.ppSymbols.getSymbolCount();
            this.readFingerprintParameters();
        }
        this.readColors();
        this.readMetricParameters();
    }

    private void readPharmacophoreSymbols() {
        ArrayList<String> pharmacophores = new ArrayList<String>();
        for (int i = 0; i < this.atomSetNodes.size(); ++i) {
            Element ppNode = (Element)this.atomSetNodes.get(i);
            pharmacophores.add(ppNode.attributeValue("Symbol"));
        }
        this.ppSymbols = new PSymbols(pharmacophores);
    }

    private void readFingerprintParameters() throws MDParametersException {
        try {
            String fir;
            String fs;
            String flb;
            this.minDist = Integer.parseInt(this.fingerprintNode.attributeValue("MinimalDistance"));
            this.maxDist = Integer.parseInt(this.fingerprintNode.attributeValue("MaximalDistance"));
            if (this.fingerprintNode.attributeValue("Resolution") != null) {
                this.resolution = Integer.parseInt(this.fingerprintNode.attributeValue("Resolution"));
            }
            this.nDist = (int)Math.ceil((double)(this.maxDist - this.minDist + 1) / (double)this.resolution);
            String fsf = this.fingerprintNode.attributeValue("FuzzySmoothingFactor");
            if (fsf != null) {
                this.fuzzySmoothingFactor = Float.parseFloat(fsf);
            } else {
                List l = this.document.selectNodes("FuzzySmoothingVector");
                if (l.size() != 0) {
                    int nSyms = this.ppSymbols.getSymbolCount();
                    this.fuzzySmoothingVector = new float[nSyms][nSyms][];
                }
                for (int i = 0; i < l.size(); ++i) {
                    String pp = ((Element)l.get(i)).attributeValue("PointPair");
                    String fsv = ((Element)l.get(i)).attributeValue("Values");
                    if (fsv == null) {
                        throw new MDParametersException("Missing smoothing Values attribute.");
                    }
                    if (pp == null) {
                        if (i != 0 && l.size() != 1) {
                            throw new MDParametersException("FuzzySmoothingVector without a PointPair specification should be the first.");
                        }
                        this.setFuzzySmoothingVectors(fsv);
                        continue;
                    }
                    this.setFuzzySmoothingVector(pp, fsv);
                }
            }
            this.fuzzyCutOff = 10.0f;
            this.fuzzyLowerBound = 1;
            this.symmetricalFuzzy = true;
            this.ignoreRotatableBonds = false;
            String fco = this.fingerprintNode.attributeValue("FuzzyCutOff");
            if (fco != null) {
                this.fuzzyCutOff = Float.parseFloat(fco);
            }
            if ((flb = this.fingerprintNode.attributeValue("FuzzyLowerBound")) != null) {
                this.fuzzyLowerBound = Integer.parseInt(flb);
            }
            if ((fs = this.fingerprintNode.attributeValue("FuzzySymmetrical")) != null) {
                this.symmetricalFuzzy = Boolean.getBoolean(fs);
            }
            if ((fir = this.fingerprintNode.attributeValue("FuzzyIgnoreRotatableBonds")) != null) {
                this.ignoreRotatableBonds = Boolean.valueOf(fir);
            }
        }
        catch (NullPointerException np) {
            throw new MDParametersException("Missing fingerprint parameters");
        }
    }

    private void setFuzzySmoothingVectors(String fsv) throws MDParametersException {
        int nSyms = this.ppSymbols.getSymbolCount();
        for (int fa = 0; fa < nSyms; ++fa) {
            for (int fb = 0; fb < nSyms; ++fb) {
                this.setFuzzySmoothingVector(fa, fb, fsv);
            }
        }
    }

    private void setFuzzySmoothingVector(String pp, String fsv) throws MDParametersException {
        StringTokenizer stok = new StringTokenizer(pp, " ");
        if (stok.countTokens() != 2) {
            throw new MDParametersException("Bad pharmacophore point type pair format.");
        }
        String fas = stok.nextToken();
        String fbs = stok.nextToken();
        try {
            int fa = this.ppSymbols.getIndex(fas);
            int fb = this.ppSymbols.getIndex(fbs);
            this.setFuzzySmoothingVector(fa, fb, fsv);
        }
        catch (IllegalArgumentException iae) {
            throw new MDParametersException("Bad pharmacophore point type symbol.");
        }
    }

    private void setFuzzySmoothingVector(int fa, int fb, String fsv) throws MDParametersException {
        int ffa = fa >= fb ? fa : fb;
        int ffb = fa >= fb ? fb : fa;
        StringTokenizer stok = new StringTokenizer(fsv, " ");
        int vl = stok.countTokens();
        this.fuzzySmoothingVector[ffa][ffb] = new float[vl];
        for (int i = 0; i < vl; ++i) {
            this.fuzzySmoothingVector[ffa][ffb][i] = Float.parseFloat(stok.nextToken());
        }
    }

    private void readColors() {
        if (this.colorNodes == null) {
            return;
        }
        ArrayList<String> symbols = new ArrayList<String>();
        ArrayList<String> colorNames = new ArrayList<String>();
        for (int i = 0; i < this.colorNodes.size(); ++i) {
            Element col = (Element)this.colorNodes.get(i);
            symbols.add(col.attributeValue("Symbol"));
            colorNames.add(col.attributeValue("Value"));
        }
        this.colDec = new ColorDecoder(symbols, colorNames);
    }

    @Override
    protected void readMetricParameters() throws MDParametersException {
        super.readMetricParameters();
        for (int i = 0; i < this.parametrizedMetricNodes.size(); ++i) {
            Element mp = (Element)this.parametrizedMetricNodes.get(i);
            String name = mp.attributeValue("Name");
            int mi = this.parametrizedMetrics.indexOf(name);
            String ff = mp.attributeValue("FuzzinessFactor");
            this.fuzzinessFactors.set(mi, ff != null ? new Float(ff) : null);
        }
    }

    @Override
    protected void readMetricWeights(Element parametrizedMetric, int metricIndex) throws MDParametersException {
        Node weightsNode = parametrizedMetric.selectSingleNode("Weights");
        if (weightsNode == null) {
            super.readMetricWeights(parametrizedMetric, metricIndex);
            return;
        }
        this.setCellwiseWeights(true);
        float[] featureWeights = new float[this.nFeatures];
        float[] distanceWeights = new float[this.nDist];
        try {
            List weights = weightsNode.selectNodes("Weight");
            for (Element we : weights) {
                if (we.attributeValue("TypeSymbol") != null) {
                    featureWeights[this.ppSymbols.getIndex((String)we.attributeValue((String)"TypeSymbol"))] = Float.parseFloat(we.attributeValue("Value"));
                    continue;
                }
                if (we.attributeValue("Distance") == null) continue;
                int d = Integer.parseInt(we.attributeValue("Distance"));
                if (d < this.minDist || d > this.maxDist) {
                    throw new MDParametersException("Invalid distance value in " + we);
                }
                distanceWeights[d - this.minDist] = Float.parseFloat(we.attributeValue("Value"));
            }
            float[] fws = new float[this.nDist * (this.nFeatures * (this.nFeatures + 1) / 2)];
            for (int f1 = 0; f1 < this.nFeatures; ++f1) {
                for (int f2 = 0; f2 <= f1; ++f2) {
                    for (int d = this.minDist; d <= this.maxDist; ++d) {
                        fws[this.tripletIndex((int)f1, (int)f2, (int)d)] = featureWeights[f1] * featureWeights[f2] * distanceWeights[d - this.minDist];
                    }
                }
            }
            weights.set(metricIndex, fws);
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
            throw new MDParametersException("XML configuration error: " + iae.getMessage());
        }
    }

    private void makePPTNames() {
        if (this.colorNodes == null) {
            return;
        }
        String[][] setProps = this.colDec.getSetProperties();
        this.pptNames = new String[setProps.length + 2];
        this.pptNames[0] = new String("No pharmacophoric property");
        for (int i = 0; i < setProps.length; ++i) {
            if (setProps[i] == null) continue;
            StringBuffer names = new StringBuffer();
            for (int j = 0; j < setProps[i].length; ++j) {
                String name;
                if (j != 0) {
                    names.append(" and ");
                }
                names.append((name = this.pmapper.getID(setProps[i][j])) == null ? setProps[i][j] : name);
            }
            this.pptNames[i + 1] = names.toString();
        }
        this.pptNames[63] = new String("Other");
    }

    private void readMols() {
        for (int i = 0; i < this.molNodes.size(); ++i) {
            Element mn = (Element)this.molNodes.get(i);
            String mol = mn.attributeValue("Structure");
            if (mol == null) continue;
            mol = StringUtil.replaceString(mol, "\\n", "\n");
            mn.addAttribute("Structure", mol);
        }
    }

    private void writeMols() {
        if (this.molNodes == null) {
            return;
        }
        for (int i = 0; i < this.molNodes.size(); ++i) {
            Element mn = (Element)this.molNodes.get(i);
            if ((mn.attributeValue("Type") == null || !mn.attributeValue("Type").equals("Path")) && !MFileFormatUtil.isURLOrFileName(mn.attributeValue("Structure"))) continue;
            Molecule m = this.pmapper.getMolConstant(mn.attributeValue("ID"));
            mn.addAttribute("Type", "String");
            mn.addAttribute("Structure", m.toFormat("smiles"));
        }
    }

    @Override
    protected int appendParametrizedMetric(String name, String metric) {
        int mi = super.appendParametrizedMetric(name, metric);
        this.fuzzinessFactors.add(mi, null);
        return mi;
    }

    @Override
    protected boolean importNodes(Document doc, boolean merge) {
        if (super.importNodes(doc, merge)) {
            this.fuzzinessFactors.clear();
        }
        try {
            Element newColorsNode = (Element)doc.selectSingleNode("//PharmacophoreFingerprintConfiguration/ScreeningConfiguration/PharmacophorePointColors");
            if (newColorsNode == null) {
                return true;
            }
            if (merge) {
                this.pharmacophorePointColorsNode.add(newColorsNode);
            } else {
                this.pharmacophorePointColorsNode.detach();
                ((Element)this.screeningConfigurationNode).add(newColorsNode);
                this.pharmacophorePointColorsNode = newColorsNode;
            }
        }
        catch (MDParametersException p) {
            p.printStackTrace();
        }
        return true;
    }

    public int tripletIndex(int f1, int f2, int d) {
        if (d > this.maxDist) {
            d = this.maxDist;
        }
        if (d < this.minDist) {
            d = this.minDist;
        }
        return (f1 * (f1 + 1) / 2 + f2) * this.nDist + (d - this.minDist) / this.resolution;
    }
}

