/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.core.calculations.Aromata;
import chemaxon.descriptors.CFParameters;
import chemaxon.descriptors.ChemicalFingerprint;
import chemaxon.descriptors.MDGenerator;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.descriptors.RFParameters;
import chemaxon.descriptors.ReactionFingerprint;
import chemaxon.marvin.modules.AutoMapper;
import chemaxon.marvin.modules.AutoMapperException;
import chemaxon.reaction.Reaction;
import chemaxon.reaction.ReactionException;
import chemaxon.reaction.ReactionUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.sgroup.SgroupAtom;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class RFGenerator
extends MDGenerator {
    private boolean reactionMappingIncomplete;

    @Override
    public String[] generate(Molecule m, MolecularDescriptor d) throws MDGeneratorException {
        int j;
        byte[] cfingerprint;
        int i;
        this.reactionMappingIncomplete = true;
        RFParameters params = (RFParameters)d.getParameters();
        ReactionFingerprint rf = (ReactionFingerprint)d;
        byte[] fingerprint = new byte[params.getLength() / 8];
        rf.clear();
        CFParameters cfp = new CFParameters();
        cfp.setLength(params.getLength() / 4);
        cfp.setBondCount(params.getBondCount());
        cfp.setBitCount(params.getBitCount());
        ChemicalFingerprint cf = new ChemicalFingerprint(cfp);
        if (!m.isReaction()) {
            throw new MDGeneratorException("Not a reaction: " + m.toFormat("smarts"));
        }
        RxnMolecule rxnmol = RxnMolecule.getReaction(m.cloneMolecule());
        Aromata ar = new Aromata();
        ar.setMol(rxnmol);
        ar.aromatize(true, true, 0, 0, 2, false);
        for (i = 0; i < rxnmol.getReactantCount(); ++i) {
            Molecule reactant = rxnmol.getReactant(i);
            cf.generate(reactant);
            cfingerprint = cf.toData();
            for (j = 0; j < fingerprint.length / 4; ++j) {
                int n = j;
                fingerprint[n] = (byte)(fingerprint[n] | cfingerprint[j]);
            }
        }
        for (i = 0; i < rxnmol.getAgentCount(); ++i) {
            Molecule agent = rxnmol.getAgent(i);
            cf.generate(agent);
            cfingerprint = cf.toData();
            for (j = 0; j < fingerprint.length / 4; ++j) {
                int n = j;
                fingerprint[n] = (byte)(fingerprint[n] | cfingerprint[j]);
            }
        }
        int shift = fingerprint.length / 4;
        for (int i2 = 0; i2 < rxnmol.getProductCount(); ++i2) {
            Molecule product = rxnmol.getProduct(i2);
            cf.generate(product);
            cfingerprint = cf.toData();
            for (int j2 = 0; j2 < shift; ++j2) {
                int n = shift + j2;
                fingerprint[n] = (byte)(fingerprint[n] | cfingerprint[j2]);
            }
        }
        this.createReactionCenterFingerprint(rxnmol, params, rf, fingerprint);
        rf.fromData(fingerprint);
        if (this.createStatistics) {
            this.updateStatistics(d);
        }
        return null;
    }

    private boolean createReactionCenterFingerprint(RxnMolecule rxnmol, RFParameters params, ReactionFingerprint rf, byte[] fingerprint) throws MDGeneratorException {
        CFParameters cfp = new CFParameters();
        cfp.setLength(params.getLength() / 4);
        cfp.setBondCount(params.getBondCount());
        cfp.setBitCount(params.getBitCount());
        ChemicalFingerprint cf = new ChemicalFingerprint(cfp);
        rxnmol.setGUIContracted(true);
        if (!ReactionUtil.areAllReactionComponentsMapped(rxnmol) || !ReactionUtil.areAllChangingAtomsMapped(rxnmol)) {
            AutoMapper mapper = new AutoMapper();
            mapper.setMappingStyle(2);
            mapper.setIgnoreH(true);
            try {
                this.reactionMappingIncomplete = mapper.map(rxnmol, false) != 2;
            }
            catch (AutoMapperException e) {
                rf.fromData(fingerprint);
                System.err.println("Unable to map reaction:: " + rxnmol.toFormat("smarts"));
                return false;
            }
        } else {
            this.reactionMappingIncomplete = false;
        }
        if (!this.isReactionMappingIncomplete()) {
            int i;
            int i2;
            int i3;
            Reaction reaction = new Reaction();
            try {
                reaction.setReaction(rxnmol, false, true, false);
            }
            catch (ReactionException e) {
                rf.clear();
                throw new MDGeneratorException("Not a reaction: " + rxnmol.toFormat("smarts"));
            }
            int[] changingReactantAtoms = reaction.getChangingAtoms(false, 1);
            int[] changingProductAtoms = reaction.getChangingAtoms(false, 2);
            int[][] changingBondData = reaction.getChangingBondData(false);
            HashSet<MolAtom> raset = new HashSet<MolAtom>();
            HashSet<MolBond> rbset = new HashSet<MolBond>();
            SelectionMolecule rselmol = new SelectionMolecule();
            for (i3 = 0; i3 < changingReactantAtoms.length; ++i3) {
                rselmol.add(rxnmol.getAtom(changingReactantAtoms[i3]));
                raset.add(rxnmol.getAtom(changingReactantAtoms[i3]));
            }
            for (i3 = 0; i3 < changingBondData.length; ++i3) {
                if (changingBondData[i3][0] == -1) continue;
                MolBond edge = rxnmol.getBond(changingBondData[i3][0]);
                rselmol.add(edge);
                rbset.add(edge);
            }
            Molecule rsmolBroad = new Molecule();
            rsmolBroad.fuse((SelectionMolecule)rselmol.clone());
            Molecule rsmolMedium = this.extendCenter(rselmol, raset, rbset);
            Molecule rsmolNarrow = this.extendCenter(rselmol, raset, rbset);
            HashSet<MolAtom> paset = new HashSet<MolAtom>();
            HashSet<MolBond> pbset = new HashSet<MolBond>();
            SelectionMolecule pselmol = new SelectionMolecule();
            for (i2 = 0; i2 < changingProductAtoms.length; ++i2) {
                pselmol.add(rxnmol.getAtom(changingProductAtoms[i2]));
                paset.add(rxnmol.getAtom(changingProductAtoms[i2]));
            }
            for (i2 = 0; i2 < changingBondData.length; ++i2) {
                if (changingBondData[i2][3] == -1) continue;
                MolBond edge = rxnmol.getBond(changingBondData[i2][3]);
                pselmol.add(edge);
                pbset.add(edge);
            }
            Molecule psmolBroad = new Molecule();
            psmolBroad.fuse((SelectionMolecule)pselmol.clone());
            Molecule psmolMedium = this.extendCenter(pselmol, paset, pbset);
            Molecule psmolNarrow = this.extendCenter(pselmol, paset, pbset);
            if (rsmolNarrow.getSgroupCount() != 0 || psmolNarrow.getSgroupCount() != 0) {
                RxnMolecule newRxn = new RxnMolecule();
                newRxn.addComponent(rsmolNarrow, 0);
                newRxn.addComponent(psmolNarrow, 1);
                return this.createReactionCenterFingerprint(RFGenerator.mapAndUngroupSgroups(newRxn), params, rf, fingerprint);
            }
            cfp.setLength(params.getLength() / 16);
            cf = new ChemicalFingerprint(cfp);
            cf.generate(rsmolBroad);
            byte[] cfingerprint = cf.toData();
            for (i = 0; i < fingerprint.length / 16; ++i) {
                fingerprint[fingerprint.length / 2 + i] = cfingerprint[i];
            }
            cfp.setLength(params.getLength() / 8);
            cf = new ChemicalFingerprint(cfp);
            cf.generate(psmolBroad);
            cfingerprint = cf.toData();
            for (i = 0; i < fingerprint.length / 16; ++i) {
                fingerprint[9 * fingerprint.length / 16 + i] = cfingerprint[i];
            }
            cf.generate(rsmolMedium);
            cfingerprint = cf.toData();
            for (i = 0; i < fingerprint.length / 16; ++i) {
                fingerprint[10 * fingerprint.length / 16 + i] = cfingerprint[i];
            }
            cf.generate(psmolMedium);
            cfingerprint = cf.toData();
            for (i = 0; i < fingerprint.length / 16; ++i) {
                fingerprint[11 * fingerprint.length / 16 + i] = cfingerprint[i];
            }
            cf.generate(rsmolNarrow);
            cfingerprint = cf.toData();
            for (i = 0; i < fingerprint.length / 8; ++i) {
                fingerprint[6 * fingerprint.length / 8 + i] = cfingerprint[i];
            }
            cf.generate(psmolNarrow);
            cfingerprint = cf.toData();
            for (i = 0; i < fingerprint.length / 8; ++i) {
                fingerprint[7 * fingerprint.length / 8 + i] = cfingerprint[i];
            }
            return true;
        }
        return false;
    }

    private Molecule extendCenter(SelectionMolecule selmol, HashSet<MolAtom> atomset, HashSet<MolBond> bondset) {
        HashSet rnodes = (HashSet)atomset.clone();
        for (MolAtom a : rnodes) {
            for (int l = 0; l < a.getBondCount(); ++l) {
                MolAtom rcnode = a.getLigand(l);
                if (!atomset.contains(rcnode)) {
                    selmol.add(rcnode);
                    atomset.add(rcnode);
                    selmol.add(a.getBond(l));
                    bondset.add(a.getBond(l));
                    continue;
                }
                if (!atomset.contains(rcnode) || bondset.contains(a.getBondTo(rcnode))) continue;
                selmol.add(a.getBond(l));
                bondset.add(a.getBond(l));
            }
        }
        Molecule smol = new Molecule();
        smol.fuse((SelectionMolecule)selmol.clone());
        return smol;
    }

    private static RxnMolecule mapAndUngroupSgroups(RxnMolecule rxn) {
        RFGenerator.mapAttachmentAtoms(rxn);
        rxn.ungroupSgroups();
        return rxn;
    }

    private static void mapAttachmentAtoms(RxnMolecule rxn) {
        int nextMap;
        int i;
        MolAtom[] productAttachAtoms;
        int largestMap = RFGenerator.getLargestMap(rxn);
        HashMap<Integer, MolAtom[]> reactantAtomsToMap = RFGenerator.getAttachmentAtomsToMap(rxn.getReactant(0));
        HashMap<Integer, MolAtom[]> productAtomsToMap = RFGenerator.getAttachmentAtomsToMap(rxn.getProduct(0));
        Iterator<Integer> reactantSgMapIterator = reactantAtomsToMap.keySet().iterator();
        Set<Integer> productSgMaps = productAtomsToMap.keySet();
        while (reactantSgMapIterator.hasNext()) {
            int map = reactantSgMapIterator.next();
            MolAtom[] reactantAttachAtoms = reactantAtomsToMap.get(map);
            productAttachAtoms = productAtomsToMap.get(map);
            for (i = 0; i < reactantAttachAtoms.length; ++i) {
                if (i == 0) {
                    reactantAttachAtoms[0].setAtomMap(map);
                    if (productAttachAtoms != null && i < productAttachAtoms.length) {
                        productAttachAtoms[0].setAtomMap(map);
                    }
                    productSgMaps.remove(map);
                    continue;
                }
                nextMap = ++largestMap;
                reactantAttachAtoms[i].setAtomMap(nextMap);
                if (productAttachAtoms == null || i >= productAttachAtoms.length) continue;
                productAttachAtoms[i].setAtomMap(nextMap);
            }
        }
        for (int map : productSgMaps) {
            productAttachAtoms = productAtomsToMap.get(map);
            if (productAttachAtoms == null) continue;
            for (i = 0; i < productAttachAtoms.length; ++i) {
                if (i == 0) {
                    productAttachAtoms[0].setAtomMap(map);
                    continue;
                }
                nextMap = ++largestMap;
                productAttachAtoms[i].setAtomMap(nextMap);
            }
        }
    }

    private static HashMap<Integer, MolAtom[]> getAttachmentAtomsToMap(Molecule mol) {
        HashMap<Integer, MolAtom[]> hm = new HashMap<Integer, MolAtom[]>();
        if (mol != null) {
            for (int i = 0; i < mol.getAtomCount(); ++i) {
                MolAtom atom = mol.getAtom(i);
                int map = atom.getAtomMap();
                if (atom.getAtno() != 135) continue;
                SgroupAtom sgatom = (SgroupAtom)atom;
                MolAtom[] attachAtoms = sgatom.getSgroup().getAttachAtoms();
                hm.put(map, attachAtoms);
            }
        }
        return hm;
    }

    private static int getLargestMap(Molecule mol) {
        int largestMap = 0;
        for (int i = 1; i < mol.getAtomCount(); ++i) {
            int map = mol.getAtom(i).getAtomMap();
            if (map <= largestMap) continue;
            largestMap = map;
        }
        return largestMap;
    }

    boolean isReactionMappingIncomplete() {
        return this.reactionMappingIncomplete;
    }

    @Override
    protected int calcFreqCount(MolecularDescriptor d) {
        ReactionFingerprint rf = (ReactionFingerprint)d;
        for (int i = 0; i < rf.fp.length; ++i) {
            int bi = 1;
            for (int b = 31; b >= 0; --b) {
                if ((rf.fp[i] & bi) != 0) {
                    int n = 32 * i + b;
                    this.freqCount[n] = this.freqCount[n] + 1;
                }
                bi <<= 1;
            }
        }
        return rf.getBrightness();
    }
}

