/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDParameters;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.descriptors.RFGenerator;
import chemaxon.descriptors.ReactionFingerprint;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.struc.Molecule;
import java.io.File;
import org.dom4j.Element;

public class RFParameters
extends MDParameters {
    public static final int DEFAULT_LENGTH = 2048;
    public static final int DEFAULT_BOND_COUNT = 6;
    public static final int DEFAULT_BITS_SET = 2;
    private int bondCount = 6;
    private int bitCount = 2;
    private Element parameters = null;
    private RFGenerator generator = null;
    private boolean reactionMappingIncomplete;

    public RFParameters() {
        this.init();
        this.setLength(2048);
    }

    public RFParameters(File configFile) throws MDParametersException {
        this.init();
        this.readFromXmlFile(configFile, false, true);
        this.initParameters();
        this.initGenerator();
    }

    public RFParameters(String XMLconfig) throws MDParametersException {
        this.init();
        this.readFromXmlString(XMLconfig, false, true);
        this.initParameters();
        this.initGenerator();
    }

    @Override
    public void fromString(String parameterString) throws MDParametersException {
        super.fromString(parameterString);
        this.initGenerator();
    }

    @Override
    public void fromFile(File parameterFile) throws MDParametersException {
        super.fromFile(parameterFile);
        this.initGenerator();
    }

    @Override
    public void setLength(int length) throws MDParametersException {
        if (length % 32 != 0) {
            throw new MDParametersException("Fingerprint length should be multiple of 32.");
        }
        super.setLength(length);
        this.initParameters();
        this.initGenerator();
        if (this.parameters != null) {
            this.parameters.addAttribute("Length", Integer.toString(length));
        }
    }

    public void setBondCount(int bondCount) {
        this.bondCount = bondCount;
        if (this.parameters != null) {
            this.parameters.addAttribute("BondCount", Integer.toString(bondCount));
        }
    }

    public void setBitCount(int bitCount) {
        this.bitCount = bitCount;
        if (this.parameters != null) {
            this.parameters.addAttribute("BitCount", Integer.toString(bitCount));
        }
    }

    protected void initGenerator() throws MDParametersException {
        this.generator = new RFGenerator();
    }

    protected void init() {
        this.md = new ReactionFingerprint();
    }

    @Override
    protected void initParameters() {
        super.initParameters();
        this.internalSize = this.length / 32;
        this.data = new byte[this.internalSize * 4 + 1];
    }

    protected String[] generate(Molecule m, MolecularDescriptor md) throws MDGeneratorException {
        String[] propertyNames = this.generator.generate(m, md);
        this.reactionMappingIncomplete = this.generator.isReactionMappingIncomplete();
        return propertyNames;
    }

    boolean isReactionMappingIncomplete() {
        return this.reactionMappingIncomplete;
    }

    public int getBondCount() {
        return this.bondCount;
    }

    public int getBitCount() {
        return this.bitCount;
    }

    @Override
    protected int getNumberOfWeights(int parametrizedMetricIndex) throws IllegalArgumentException {
        int dissimilarityMetricIndex = (Integer)this.metricIndexes.get(this.currentMetricIndex);
        switch (dissimilarityMetricIndex) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Invalid metric index " + dissimilarityMetricIndex);
    }

    @Override
    public String getDefaultDocumentFrame() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<ReactionFingerprintConfiguration Version =\"0.1\"\nschemaLocation=\"rfp.xsd\">\n<Parameters Length=\"2048\" BondCount=\"6\" BitCount=\"2\"/>\n<ScreeningConfiguration>\n   <ParametrizedMetrics>\n        <ParametrizedMetric Name=\"ReactantTanimoto\" ActiveFamily=\"Generic\"\n             Metric=\"ReactantTanimoto\" Threshold=\"0.2\"/>\n        <ParametrizedMetric Name=\"ProductTanimoto\" ActiveFamily=\"Generic\"\n             Metric=\"ProductTanimoto\" Threshold=\"0.2\"/>\n        <ParametrizedMetric Name=\"CoarseReactionTanimoto\" ActiveFamily=\"Generic\"\n             Metric=\"CoarseReactionTanimoto\" Threshold=\"0.2\"/>\n        <ParametrizedMetric Name=\"MediumReactionTanimoto\" ActiveFamily=\"Generic\"\n             Metric=\"MediumReactionTanimoto\" Threshold=\"0.2\"/>\n        <ParametrizedMetric Name=\"StrictReactionTanimoto\" ActiveFamily=\"Generic\"\n             Metric=\"StrictReactionTanimoto\" Threshold=\"0.2\"/>\n   </ParametrizedMetrics>\n</ScreeningConfiguration>\n</ReactionFingerprintConfiguration>\n";
    }

    @Override
    protected void processDocument(boolean all) throws MDParametersException {
        this.checkDocumentVersion("ReactionFingerprintConfiguration", VersionInfo.JCHEM_VERSION);
        if (all) {
            this.parameters = (Element)this.document.selectSingleNode("/ReactionFingerprintConfiguration/Parameters");
        }
        super.processDocument(all);
    }

    @Override
    protected void readValues(boolean all) throws MDParametersException {
        if (all) {
            String p = this.parameters.attributeValue("Length");
            this.setLength(p != null ? Integer.parseInt(p) : 2048);
            p = this.parameters.attributeValue("BondCount");
            if (p != null) {
                this.bondCount = Integer.parseInt(p);
            }
            if ((p = this.parameters.attributeValue("BitCount")) != null) {
                this.bitCount = Integer.parseInt(p);
            }
        }
        this.readMetricParameters();
    }
}

