/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDParameters;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.descriptors.SDParameters;
import chemaxon.struc.Molecule;
import java.text.ParseException;

public class ScalarDescriptor
extends MolecularDescriptor {
    protected float descrValue = 0.0f;
    private static final String[] metrics = new String[]{"AbsDiff"};
    private static final float[] defaultThresholds = new float[]{1000.0f};

    public ScalarDescriptor() {
    }

    public ScalarDescriptor(SDParameters params) {
        super(params);
        this.clear();
    }

    public ScalarDescriptor(String params) {
        this.setParameters(params);
        this.clear();
    }

    public ScalarDescriptor(ScalarDescriptor sd) {
        super(sd.params);
        this.descrValue = sd.descrValue;
    }

    @Override
    public MolecularDescriptor clone() {
        return new ScalarDescriptor(this);
    }

    @Override
    public String getName() {
        return "Scalar descriptor";
    }

    @Override
    public String getShortName() {
        return "SD";
    }

    @Override
    public String getParametersClassName() {
        return "chemaxon.descriptors.SDParameters";
    }

    @Override
    public void setParameters(MDParameters parameters) {
        super.setParameters(parameters);
        this.clear();
    }

    @Override
    public void setParameters(String parameters) throws MDParametersException {
        if (this.params == null) {
            super.setParameters(new SDParameters(parameters));
        } else {
            this.params.fromString(parameters);
        }
    }

    @Override
    public byte[] toData() {
        byte[] d = this.params.data;
        int v = Float.floatToIntBits(this.descrValue);
        for (int j = 3; j >= 0; --j) {
            d[j] = (byte)(v & 0xFF);
            v >>>= 8;
        }
        return d;
    }

    @Override
    public void fromData(byte[] dbRepr) {
        int v = 0;
        for (int j = 0; j < 4; ++j) {
            v <<= 8;
            v += (dbRepr[j] + 256) % 256;
        }
        this.descrValue = Float.intBitsToFloat(v);
    }

    @Override
    public final float[] toFloatArray() {
        float[] toReturn = new float[]{this.descrValue};
        return toReturn;
    }

    @Override
    public void fromFloatArray(float[] descr) throws RuntimeException {
        this.clear();
        this.descrValue = descr[0];
    }

    public void clear() {
        this.descrValue = 0.0f;
    }

    @Override
    public final String toString() {
        return this.toDecimalString();
    }

    @Override
    public String toDecimalString() {
        return Float.toString(this.descrValue);
    }

    @Override
    public final void fromString(String sd) throws ParseException {
        this.clear();
        try {
            this.descrValue = Float.parseFloat(sd);
        }
        catch (NullPointerException npe) {
            throw new ParseException(sd + " too short", 0);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(sd + " contains invalid numbers", 0);
        }
    }

    public void set(float newValue) {
        this.descrValue = newValue;
    }

    private float get() {
        return this.descrValue;
    }

    @Override
    public String[] generate(Molecule m) throws MDGeneratorException {
        m = this.params.standardize(m);
        return null;
    }

    @Override
    public String[] getDissimilarityMetrics() {
        return metrics;
    }

    @Override
    public float[] getDefaultDissimilarityMetricThresholds() {
        return defaultThresholds;
    }

    @Override
    public float getDefaultThreshold(int metricIndex) {
        return defaultThresholds[metricIndex];
    }

    @Override
    public float getDissimilarity(MolecularDescriptor sd) {
        return this.getDissimilarity(sd, 0);
    }

    @Override
    public float getDissimilarity(MolecularDescriptor sd, int metricIndex) {
        return Math.abs(((ScalarDescriptor)sd).descrValue - this.descrValue);
    }

    @Override
    public float getLowerBound(MolecularDescriptor sd) {
        return 0.0f;
    }
}

