/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.EnrichmentGraph;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolImporter;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.alignment.AlignmentAccuracyMode;
import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentMolecule;
import chemaxon.marvin.alignment.AlignmentMoleculeFactory;
import chemaxon.marvin.alignment.AlignmentProperties;
import chemaxon.marvin.alignment.PairwiseAlignment;
import chemaxon.marvin.alignment.PairwiseComparison;
import chemaxon.marvin.alignment.PairwiseSimilarity3D;
import chemaxon.marvin.io.MolExportException;
import chemaxon.struc.Molecule;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.DecimalFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Screen3D {
    private static Log log = LogFactory.getLog(Screen3D.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void screen(String serFileTarget, String serFileQuery, PairwiseComparison pairwise, String oformat, int from, int to) {
        String head = "seq Unnormalized3DScore 3DTanimoto t(ms) MW(target) n_rot_bonds(target)";
        DecimalFormat df = new DecimalFormat("0.00");
        String baseName = Screen3D.baseName(serFileTarget);
        String errorsFn = baseName + "_screenerrors.mrv";
        String strucFN = baseName + "_aligned." + oformat;
        if (log.isInfoEnabled()) {
            log.info((Object)"Similarity calculation is started");
            log.info((Object)("Query file : " + serFileQuery));
            log.info((Object)("Target file: " + serFileTarget));
            log.info((Object)("Will write aligned structures to: " + strucFN));
            if (from != -1) {
                log.info((Object)("From: " + from));
            }
            if (to != -1) {
                log.info((Object)("To: " + to));
            }
            log.info((Object)head);
        }
        ObjectInputStream in = null;
        FileOutputStream outMol = null;
        MolExporter me = null;
        BufferedWriter out = null;
        MolExporter error = null;
        boolean queryOK = false;
        try {
            in = new ObjectInputStream(new FileInputStream(serFileQuery));
            byte[] b = (byte[])in.readObject();
            pairwise.setQuery(AlignmentMolecule.create(b));
            queryOK = true;
        }
        catch (IOException ioe) {
            if (log.isFatalEnabled()) {
                log.fatal((Object)"Could not load query.", (Throwable)ioe);
            }
        }
        catch (ClassNotFoundException cl) {
            if (log.isFatalEnabled()) {
                log.fatal((Object)"Could not load query.", (Throwable)cl);
            }
        }
        catch (AlignmentException a) {
            if (log.isFatalEnabled()) {
                log.fatal((Object)"Could not load query.", (Throwable)a);
            }
        }
        finally {
            block56: {
                try {
                    in.close();
                }
                catch (IOException o) {
                    if (!log.isFatalEnabled()) break block56;
                    log.fatal((Object)"Could not load query.", (Throwable)o);
                }
            }
        }
        if (!queryOK) {
            if (log.isFatalEnabled()) {
                log.fatal((Object)"Query is missing");
            }
            return;
        }
        try {
            int seq = 0;
            in = new ObjectInputStream(new FileInputStream(serFileTarget));
            outMol = new FileOutputStream(strucFN);
            me = new MolExporter(outMol, oformat);
            out = new BufferedWriter(new FileWriter(baseName + "_screenOut.txt"));
            out.write(head + "\n");
            Object o = null;
            AlignmentMolecule t = null;
            while (!((o = in.readObject()) instanceof EOF)) {
                block58: {
                    if (to != -1 && seq > to) {
                        break;
                    }
                    if (!(from != -1 && seq < from || to != -1 && seq > to)) {
                        try {
                            t = null;
                            t = AlignmentMolecule.create((byte[])o);
                            long tNow = System.currentTimeMillis();
                            double similarity = pairwise.similarity(t);
                            long dt = System.currentTimeMillis() - tNow;
                            String s = seq + " " + df.format(-similarity) + " " + df.format(pairwise.getShapeTanimoto()) + " " + dt + " " + df.format(t.getMoleculeOrig().getExactMass()) + " " + t.getRotBondCount();
                            out.write(s + "\n");
                            if (log.isInfoEnabled()) {
                                log.info((Object)s);
                            }
                            Molecule res = pairwise.getAlignedMoleculesAsFragments();
                            res.setProperty("seq", "" + seq);
                            res.setProperty("similarity", "" + df.format(similarity));
                            res.setProperty("3DTanimoto", "" + df.format(pairwise.getShapeTanimoto()));
                            res.setProperty("time", "" + dt);
                            me.write(res);
                        }
                        catch (Exception e) {
                            if (t != null) {
                                error = Screen3D.handle(t.getMoleculeOrig(), e, error, errorsFn);
                            }
                            if (!log.isErrorEnabled()) break block58;
                            log.error((Object)"Exception at comparison: ", (Throwable)e);
                        }
                    }
                }
                ++seq;
            }
        }
        catch (IOException ioe) {
            if (log.isFatalEnabled()) {
                log.fatal((Object)"Could not load target file.", (Throwable)ioe);
            }
        }
        catch (ClassNotFoundException cl) {
            if (log.isFatalEnabled()) {
                log.fatal((Object)"Could not load query.", (Throwable)cl);
            }
        }
        finally {
            block59: {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (me != null) {
                        me.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                    if (error != null) {
                        error.close();
                    }
                }
                catch (IOException io2) {
                    if (!log.isFatalEnabled()) break block59;
                    log.fatal((Object)"Could not load target file.", (Throwable)io2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void concatenate(String serFileTarget, String listFile) {
        if (log.isInfoEnabled()) {
            log.info((Object)"Concatenate binary files");
        }
        BufferedReader lst = null;
        ObjectOutput ser = null;
        try {
            String serFile;
            lst = new BufferedReader(new FileReader(listFile));
            ObjectInputStream in = null;
            Object o = null;
            try {
                ser = new ObjectOutputStream(new FileOutputStream(serFileTarget));
            }
            catch (IOException io) {
                throw new IllegalStateException("Cannot acces file to write" + serFileTarget, io);
            }
            while ((serFile = lst.readLine()) != null) {
                in = null;
                try {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Read from file: " + serFile));
                    }
                    in = new ObjectInputStream(new FileInputStream(serFile));
                    while (!((o = in.readObject()) instanceof EOF)) {
                        byte[] b = (byte[])o;
                        try {
                            ser.writeObject(b);
                        }
                        catch (IOException io) {
                            throw new IllegalStateException("Cannot acces file to write" + serFileTarget, io);
                        }
                    }
                }
                catch (IOException ioe) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)("Cannot read file: " + serFile), (Throwable)ioe);
                }
                catch (ClassNotFoundException cl) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)("Cannot read file: " + serFile), (Throwable)cl);
                }
                catch (ClassCastException cc) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)("Cannot read file: " + serFile), (Throwable)cc);
                }
                finally {
                    try {
                        if (in == null) continue;
                        in.close();
                    }
                    catch (IOException e) {
                        if (!log.isFatalEnabled()) continue;
                        log.error((Object)"Could not load query.", (Throwable)e);
                    }
                }
            }
        }
        catch (IOException io2) {
            if (log.isFatalEnabled()) {
                log.fatal((Object)("Cannot read list file: " + listFile), (Throwable)io2);
            }
        }
        finally {
            block41: {
                if (ser != null) {
                    try {
                        ser.writeObject(new EOF());
                        ser.close();
                    }
                    catch (IOException io) {
                        if (!log.isFatalEnabled()) break block41;
                        log.fatal((Object)("Cannot access file: " + serFileTarget), (Throwable)io);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void similarityMatrix(String serFileTarget, PairwiseComparison pairwise) {
        ObjectInputStream in = null;
        FileOutputStream outMol = null;
        MolExporter me = null;
        BufferedWriter out = null;
        Exception thr = null;
        try {
            String baseName = "";
            String[] tmp = serFileTarget.split("[.]");
            for (int i = 0; i < tmp.length - 1; ++i) {
                baseName = baseName + tmp[i];
            }
            outMol = new FileOutputStream(baseName + "_alignedMx.mrv");
            me = new MolExporter(outMol, "mrv");
            out = new BufferedWriter(new FileWriter(baseName + "_screenOutMx.txt"));
            DecimalFormat df = new DecimalFormat("0.00");
            Molecule m = null;
            Object o = null;
            int queryPos = 0;
            String head = "seq. 3sim. 3DTanimoto t(ms)\n";
            out.write(head);
            System.err.print(head);
            boolean eof = false;
            while (!eof) {
                in = new ObjectInputStream(new FileInputStream(serFileTarget));
                for (int i = 0; i < queryPos; ++i) {
                    o = in.readObject();
                    if (!(o instanceof EOF)) continue;
                    eof = true;
                    break;
                }
                if (eof) continue;
                o = in.readObject();
                if (o instanceof EOF) {
                    eof = true;
                    continue;
                }
                pairwise.setQuery(AlignmentMolecule.create((byte[])o));
                int targetPos = queryPos + 1;
                while (!((o = in.readObject()) instanceof EOF)) {
                    AlignmentMolecule t = AlignmentMolecule.create((byte[])o);
                    try {
                        long tNow = System.currentTimeMillis();
                        double similarity = pairwise.similarity(t);
                        long dt = System.currentTimeMillis() - tNow;
                        String s = queryPos + " " + targetPos + " " + df.format(similarity) + " " + pairwise.getShapeTanimoto() + " t: " + dt + "\n";
                        out.write(s);
                        System.err.print(s);
                        Molecule res = pairwise.getAlignedMoleculesAsFragments();
                        res.setProperty("query", "" + queryPos);
                        res.setProperty("target", "" + targetPos);
                        res.setProperty("similarity", "" + df.format(similarity));
                        res.setProperty("shapeTanimoto", "" + df.format(pairwise.getShapeTanimoto()));
                        res.setProperty("time", "" + dt);
                        me.write(res);
                    }
                    catch (AlignmentException a) {
                        m.setProperty("seq", "" + targetPos);
                        m.setProperty("exception", a.getStackTrace().toString());
                        me.write(m);
                        System.err.println(targetPos + " Similarity: " + -1 + " " + -1 + " " + baseName);
                    }
                    ++targetPos;
                }
                in.close();
                ++queryPos;
            }
        }
        catch (AlignmentException al) {
            thr = al;
        }
        catch (ClassNotFoundException cl) {
            thr = cl;
        }
        catch (IOException io) {
            thr = io;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (me != null) {
                    me.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException io2) {
                io2.printStackTrace();
            }
        }
        if (thr != null) {
            thr.printStackTrace();
        }
    }

    private static MolExporter handle(Molecule m, Exception e, MolExporter errors, String errorsFn) throws MolExportException, IOException {
        if (log.isErrorEnabled()) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (errors == null) {
            errors = new MolExporter(new FileOutputStream(errorsFn), "mrv");
        }
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        m.setProperty("error", e.getMessage());
        m.setProperty("exception", sw.toString());
        errors.write(m);
        return errors;
    }

    private static String baseName(String fn) {
        String baseName = "";
        String[] tmp = fn.split("[.]");
        for (int i = 0; i < tmp.length - 1; ++i) {
            baseName = baseName + tmp[i];
        }
        return baseName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void preProcess(String fn, boolean flexible, boolean generateDistanceRanges, boolean extendedATT, String oFormat, int from, int to) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Preprocessing input structures : " + fn));
            if (from != -1) {
                log.info((Object)("From: " + from));
            }
            if (to != -1) {
                log.info((Object)("To: " + to));
            }
        }
        AlignmentMoleculeFactory amf = new AlignmentMoleculeFactory();
        AlignmentProperties.ColoringScheme c = AlignmentProperties.ColoringScheme.PHARMACOPHORE;
        if (extendedATT) {
            c = AlignmentProperties.ColoringScheme.EXTENDED_ATOMTYPES;
        }
        amf.setColor(c);
        amf.setDehidrogenize(true);
        amf.setAromatize(true);
        amf.setGenerateDistanceRanges(generateDistanceRanges);
        String baseName = Screen3D.baseName(fn);
        if (flexible) {
            baseName = baseName + "F";
        }
        int molCount = 0;
        int okCount = 0;
        int errorCount = 0;
        ObjectOutput ser = null;
        MolImporter molImport = null;
        Molecule m = null;
        MolExporter molExport = null;
        MolExporter error = null;
        String errorsFn = baseName + "_errors.mrv";
        try {
            ser = new ObjectOutputStream(new FileOutputStream(baseName + ".ser"));
            molImport = new MolImporter(fn);
            molExport = new MolExporter(new FileOutputStream(baseName + "_res." + oFormat), oFormat);
            while ((m = molImport.read()) != null) {
                if (to != -1 && molCount > to) {
                    break;
                }
                if (!(from != -1 && molCount < from || to != -1 && molCount > to)) {
                    long t = System.currentTimeMillis();
                    try {
                        if (m.getDim() != 3) {
                            m.clean(3, "");
                        }
                        if (m.getDim() != 3) {
                            throw new IllegalStateException("Generating 3D structure is failed for this molecule.");
                        }
                        AlignmentMolecule am = amf.generate(0, m, false, flexible);
                        byte[] b = am.toData();
                        ser.writeObject(b);
                        long dt = System.currentTimeMillis() - t;
                        Molecule res = amf.getResultMolecule();
                        res.setProperty("t", "" + dt);
                        res.setProperty("library", baseName);
                        if (res.getName().equals("")) {
                            res.setName(baseName + molCount);
                        }
                        molExport.write(res);
                        if (log.isInfoEnabled()) {
                            log.info((Object)(molCount + ". t: " + dt + " ms"));
                        }
                        ++okCount;
                    }
                    catch (Exception e) {
                        error = Screen3D.handle(m, e, error, errorsFn);
                        ++errorCount;
                    }
                }
                ++molCount;
            }
        }
        catch (IOException io) {
            if (log.isFatalEnabled()) {
                log.fatal((Object)io);
            }
        }
        finally {
            block33: {
                try {
                    if (molImport != null) {
                        molImport.close();
                    }
                    if (ser != null) {
                        ser.writeObject(new EOF());
                        ser.close();
                    }
                    if (molExport != null) {
                        molExport.close();
                    }
                    if (error != null) {
                        error.close();
                    }
                }
                catch (IOException io2) {
                    if (!log.isFatalEnabled()) break block33;
                    log.fatal((Object)"could not close files: ", (Throwable)io2);
                }
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Successful import count: " + okCount));
            if (errorCount > 0) {
                log.info((Object)("Problematic structure count:" + errorCount));
                log.info((Object)("The molecules that could not have been preprocessed is written to file: " + errorsFn));
                log.info((Object)"The error message is written to a molecular property field. ");
            }
        }
    }

    private static String[] testG() {
        return new String[]{"g", "allF_screenerrors.mrv", "-F"};
    }

    private static String[] testG2() {
        return new String[]{"g", "q.mrv", "-F"};
    }

    private static String[] test() {
        return new String[]{"s", "-t", "allF_screenerrorsF.ser", "-q", "qF.ser"};
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println(Screen3D.help());
            return;
        }
        LicenseHandler.getInstance().checkLicense("3D Screen", "");
        if (args[0].equalsIgnoreCase("c")) {
            String lst = null;
            String out = null;
            for (int i = 1; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-lst")) {
                    if (args.length == ++i) {
                        throw new IllegalArgumentException(Screen3D.help());
                    }
                    lst = args[i].trim();
                }
                if (!args[i].equalsIgnoreCase("-out")) continue;
                if (args.length == ++i) {
                    throw new IllegalArgumentException(Screen3D.help());
                }
                out = args[i].trim();
            }
            Screen3D.concatenate(out, lst);
            return;
        }
        if (args[0].equalsIgnoreCase("g")) {
            boolean flexible = false;
            boolean match = false;
            boolean extATT = true;
            String oformat = "mrv";
            int from = -1;
            int to = -1;
            for (int i = 1; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-f")) {
                    flexible = true;
                }
                if (args[i].equalsIgnoreCase("-match")) {
                    match = true;
                }
                if (args[i].equalsIgnoreCase("-pharm")) {
                    extATT = false;
                }
                if (args[i].equalsIgnoreCase("-oformat")) {
                    if (args.length == ++i) {
                        throw new IllegalArgumentException(Screen3D.help());
                    }
                    oformat = args[i].trim();
                }
                if (args[i].equalsIgnoreCase("-from")) {
                    if (args.length == ++i) {
                        throw new IllegalArgumentException(Screen3D.help());
                    }
                    from = Integer.parseInt(args[i]);
                }
                if (!args[i].equalsIgnoreCase("-to")) continue;
                if (args.length == ++i) {
                    throw new IllegalArgumentException(Screen3D.help());
                }
                to = Integer.parseInt(args[i]);
            }
            if (args.length < 2) {
                throw new IllegalArgumentException(Screen3D.help());
            }
            Screen3D.preProcess(args[1], flexible, match, extATT, oformat, from, to);
            return;
        }
        if (args[0].equalsIgnoreCase("s")) {
            PairwiseComparison pair = new PairwiseAlignment();
            String t = null;
            String q = null;
            String oformat = "mrv";
            int conf = -1;
            int from = -1;
            int to = -1;
            boolean forceQueryRigid = false;
            AlignmentAccuracyMode acc = AlignmentAccuracyMode.NORMAL;
            for (int i = 1; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-frq")) {
                    forceQueryRigid = true;
                }
                if (args[i].equalsIgnoreCase("-oformat")) {
                    if (args.length == ++i) {
                        throw new IllegalArgumentException(Screen3D.help());
                    }
                    oformat = args[i].trim();
                }
                if (args[i].equalsIgnoreCase("-match")) {
                    pair = new PairwiseSimilarity3D();
                }
                if (args[i].equalsIgnoreCase("-t")) {
                    if (args.length == ++i) {
                        throw new IllegalArgumentException(Screen3D.help());
                    }
                    t = args[i];
                }
                if (args[i].equalsIgnoreCase("-q")) {
                    if (args.length == ++i) {
                        throw new IllegalArgumentException(Screen3D.help());
                    }
                    q = args[i];
                }
                if (args[i].equalsIgnoreCase("-conf")) {
                    if (args.length == ++i) {
                        throw new IllegalArgumentException(Screen3D.help());
                    }
                    conf = Integer.parseInt(args[i]);
                }
                if (args[i].equalsIgnoreCase("-from")) {
                    if (args.length == ++i) {
                        throw new IllegalArgumentException(Screen3D.help());
                    }
                    from = Integer.parseInt(args[i]);
                }
                if (args[i].equalsIgnoreCase("-to")) {
                    if (args.length == ++i) {
                        throw new IllegalArgumentException(Screen3D.help());
                    }
                    to = Integer.parseInt(args[i]);
                }
                if (args[i].equalsIgnoreCase("-accurate")) {
                    acc = AlignmentAccuracyMode.ACCURATE;
                }
                if (!args[i].equalsIgnoreCase("-fast")) continue;
                acc = AlignmentAccuracyMode.FAST;
            }
            if (pair == null) {
                PairwiseAlignment pa = new PairwiseAlignment();
                pa.setMode(acc);
                pair = pa;
            }
            pair.setQueryRigidForced(forceQueryRigid);
            if (conf != -1) {
                pair.setCount(conf);
            }
            if (t == null) {
                throw new IllegalArgumentException(Screen3D.help());
            }
            if (q != null) {
                Screen3D.screen(t, q, pair, oformat, from, to);
            } else {
                Screen3D.similarityMatrix(t, pair);
            }
            return;
        }
        if (args[0].equalsIgnoreCase("e")) {
            if (args.length != 3) {
                throw new IllegalArgumentException(Screen3D.help());
            }
            EnrichmentGraph m = new EnrichmentGraph();
            m.readFile(args[1], true);
            m.readFile(args[2], false);
            m.graph(0);
            m.writeGeneralInfo();
            return;
        }
        System.err.println(Screen3D.help());
    }

    private static String help() {
        String s = "3D Screen - (C) 2008-2010 ChemAxon Ltd.\n";
        s = s + "3D similarity comparison between pairs of molecules in batch mode.\n";
        s = s + "\nGENERAL INFO\n";
        s = s + "============\n";
        s = s + " Input structures need not to be in 3D. If other found 3D structure is generated automatically.\n";
        s = s + " Use only single fragment molecule for flexible align. Multifragment molecules are excluded.\n";
        s = s + " Both the query and the target can be treated rigid or conformationally flexible.\n";
        s = s + " The calculation results in a similarity score and an orientation and conformation of the best alignment.\n";
        s = s + " The similarity calculation requires an input data generation step at the first time for each molecule.\n";
        s = s + " \nTwo types of 3D similarity algorithms are available:\n";
        s = s + " #1 SHAPE: uses molecular shape Tanimoto. The shape itself is colored by different atomic types: ";
        s = s + "  extended atomtypes (ForceField types) or pharmacophore types.\n";
        s = s + " #2 MATCH: Systematic matching of atoms to align\n";
        s = s + " The generation step is faster for #1 but the similarity calculation itself is faster for #2.\n";
        s = s + " Suggestion to improve enrichment at the \"MATCH\" mode:\n Keep targets and query flexible during the preprocessing step. If you wish to freeze the input conformation of the query during the similarity calculation use the -frq switch. \n";
        s = s + "\nINPUT DATA GENERATION:\n=====================";
        s = s + " screen3d g [molecule file name] [-F] [-match] [-pharm] \n";
        s = s + " Generates two files: a binary file for later use a molecule file to view 3D structures\n";
        s = s + " -F     : Optional. Treat molecule flexible if possible. Default is treat molecule rigid.\n";
        s = s + " -match : Optional. Generate input data for #2 algorithm. From this data #1 can also be started\n";
        s = s + " -pharm : Optional. Atom coloring by pharmacophoric properties. Default is extended atomtypes.\n";
        s = s + " -oformat fmt : Optional. Molecule file format for the aligned strucutures. Default is mrv.\n";
        s = s + "\nSCREEN:\n=======\n";
        s = s + " screen3d s -t [target molecules binary file] -q [query molecule binary file] [-a shape or match] [-c comment]\n";
        s = s + " -match : Similarity algorithm to use. Optional. The default is shape. If -match exists systematic atomic pairing is used\n";
        s = s + " -c comment : Optional. User comment of a single screen run.\n";
        s = s + " -conf      : Optional. Number of initial conformers to generate for #1. (default is 2). Or numeber of conformers to remember for #2.\n";
        s = s + " -oformat fmt : Optional. Molecule file format for the aligned strucutures. Default is mrv.\n";
        s = s + "#1 specific options:\n";
        s = s + " -accurate  : Optional. Alignment accuracy default is normal.\n";
        s = s + " -fast      : Optional. Alignment accuracy default is normal. Use only accurate OR fast at the same time.\n";
        s = s + " -frq       : Optional. Force query molecule rigid.\n";
        s = s + "\nPROCESSING SCREEN OUTPUT:\n=========================\n";
        s = s + " enrichment graph: screen3d e [text output of screen for actives] [text output of screen for inactives] \n";
        s = s + "\nALIGNMENT MATRIX:\n=================\n";
        s = s + "\nAll possible pairs of molecules in the file are aligned.\n";
        s = s + " screen3d s -t [molecules binary file] -a [shape or match]\n";
        s = s + "\nGENERAL UTILITIES:\n=================\n";
        s = s + "\nConcatenate binary screen input files.\n";
        s = s + " screen3d c -out [output molecules binary file] -lst [text file: single column file name list]\n";
        s = s + "\nEXAMPLES:\n==========\n";
        s = s + " screen3d g ada_ligands.mol2 -F -match\n";
        s = s + " screen3d g 1ndw_lig.mrv -match\n";
        s = s + " screen3d s -t ada_ligandsF.ser -q 1ndw_lig.ser -match -oformat mol2 \n";
        s = s + " screen3d e ada_ligandsF_screenOut.txt ada_decoysF_screenOut.txt\n";
        return s;
    }

    private static class EOF
    implements Serializable {
        private EOF() {
        }
    }
}

