/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDGenerator;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.descriptors.ShapeDescriptor;
import chemaxon.descriptors.ShapeParameters;
import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentMoleculeFactory;
import chemaxon.marvin.alignment.AlignmentProperties;
import chemaxon.struc.Molecule;

public class ShapeGenerator
extends MDGenerator {
    private AlignmentMoleculeFactory amf = new AlignmentMoleculeFactory();
    private boolean flexible = false;

    public ShapeGenerator() {
        this.amf.setGenerateDistanceRanges(true);
        this.amf.setNotSpecCase(AlignmentProperties.ColorNotSpecifiedCase.ACCEPT_ONLY_SAME);
        this.amf.setAromatize(false);
        this.amf.setDehidrogenize(false);
    }

    public void setFlexible(boolean flexible) {
        this.flexible = flexible;
    }

    public void setFlexibleRingSize(int size) {
        this.amf.setFlexibleRingSize(size);
    }

    public void setFlexibleRingRotatableBondCount(int bonds) {
        this.amf.setFlexibleRingRotatableBondCount(bonds);
    }

    public void setColoring(AlignmentProperties.ColoringScheme c) {
        this.amf.setColor(c);
    }

    @Override
    public String[] generate(Molecule m, MolecularDescriptor d) throws MDGeneratorException {
        ShapeDescriptor shape = (ShapeDescriptor)d;
        boolean enableTranslateAndRotate = false;
        try {
            if (m.getDim() != 3) {
                m.clean(3, null);
            }
            Molecule stdMol = ((ShapeParameters)d.getParameters()).standardize(m);
            shape.setAlignmentMolecule(this.amf.generate(0, stdMol, enableTranslateAndRotate, this.flexible));
        }
        catch (AlignmentException e) {
            throw new MDGeneratorException(e);
        }
        return null;
    }

    @Override
    protected void updateStatistics(MolecularDescriptor d) {
    }
}

