/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDParameters;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.ShapeDescriptor;
import chemaxon.descriptors.ShapeGenerator;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.marvin.alignment.AlignmentProperties;
import java.io.File;
import org.dom4j.Element;

public class ShapeParameters
extends MDParameters {
    private static final String DEFAULT_STANDARDIZER_XML_CONFIG = "    <StandardizerConfiguration Version =\"0.1\">\n        <Actions>\n            <Action ID=\"aromatize\" Act=\"aromatize:b\"/>\n            <RemoveExplicitH ID=\"RemoveExplicitH\" Groups=\"target\"/>\n        </Actions>\n    </StandardizerConfiguration>\n";
    private static final String DEFAULT_GENERATOR_XML_CONFIG = "    <Generator>\n        <FlexibleRingSize Value=\"8\" />\n        <FlexibleRingRotatableBondCount Value=\"4\"/>\n        <Coloring Value=\"EXTENDED_ATOMTYPES\"/>\n    </Generator>\n";
    private static final String DEFAULT_XML_CONFIG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ShapeConfiguration Version =\"0.1\" schemaLocation=\"\">\n    <StandardizerConfiguration Version =\"0.1\">\n        <Actions>\n            <Action ID=\"aromatize\" Act=\"aromatize:b\"/>\n            <RemoveExplicitH ID=\"RemoveExplicitH\" Groups=\"target\"/>\n        </Actions>\n    </StandardizerConfiguration>\n    <Generator>\n        <FlexibleRingSize Value=\"8\" />\n        <FlexibleRingRotatableBondCount Value=\"4\"/>\n        <Coloring Value=\"EXTENDED_ATOMTYPES\"/>\n    </Generator>\n    <ScreeningConfiguration>\n       <ParametrizedMetrics>\n            <ParametrizedMetric Name=\"Tanimoto\" ActiveFamily=\"Generic\"\n                 Metric=\"Tanimoto\" Threshold=\"0.2\"/>\n            <ParametrizedMetric Name=\"Euclidean\" ActiveFamily=\"Generic\"\n                 Metric=\"Euclidean\" Threshold=\"10\"/>\n       </ParametrizedMetrics>\n    </ScreeningConfiguration>\n</ShapeConfiguration>\n";
    private Element generatorConfig;

    public ShapeParameters() {
        this.initGenerator();
        this.initEmbeddedMD();
        this.currentMetricIndex = 0;
    }

    public ShapeParameters(File configFile) throws MDParametersException {
        this.initEmbeddedMD();
        this.initGenerator();
        this.readFromXmlFile(configFile, false, true);
        this.initParameters();
        this.currentMetricIndex = 0;
    }

    public ShapeParameters(String XMLconfig) throws MDParametersException {
        this.initEmbeddedMD();
        this.initGenerator();
        this.readFromXmlString(XMLconfig, false, true);
        this.initParameters();
        this.currentMetricIndex = 0;
    }

    @Override
    public void fromString(String parameterString) throws MDParametersException {
        this.initGenerator();
        super.fromString(parameterString);
    }

    public void setFlexible(boolean flexible) {
        ((ShapeGenerator)this.generator).setFlexible(flexible);
    }

    protected final void initGenerator() throws MDParametersException {
        this.generator = new ShapeGenerator();
    }

    @Override
    public void fromFile(File parameterFile) throws MDParametersException {
        this.initGenerator();
        super.fromFile(parameterFile);
    }

    protected final void initEmbeddedMD() {
        this.md = new ShapeDescriptor();
    }

    @Override
    public String getDefaultDocumentFrame() {
        return DEFAULT_XML_CONFIG;
    }

    public static String getDefaultStandardizerConfiguration() {
        return DEFAULT_STANDARDIZER_XML_CONFIG;
    }

    @Override
    protected void processDocument(boolean all) throws MDParametersException {
        this.checkDocumentVersion("ShapeConfiguration", VersionInfo.JCHEM_VERSION);
        if (all) {
            this.generatorConfig = (Element)this.document.selectSingleNode("//ShapeConfiguration/Generator");
            if (this.generatorConfig == null) {
                throw new MDParametersException("Shape configuration error: missing <Generator>");
            }
        }
        super.processDocument(all);
    }

    @Override
    protected void readValues(boolean all) throws MDParametersException {
        super.readValues(all);
        int size = Integer.parseInt(this.generatorConfig.element("FlexibleRingSize").attributeValue("Value"));
        ((ShapeGenerator)this.generator).setFlexibleRingSize(size);
        int bonds = Integer.parseInt(this.generatorConfig.element("FlexibleRingRotatableBondCount").attributeValue("Value"));
        ((ShapeGenerator)this.generator).setFlexibleRingRotatableBondCount(bonds);
        String color = this.generatorConfig.element("Coloring").attributeValue("Value");
        AlignmentProperties.ColoringScheme c = null;
        for (int i = 0; i < AlignmentProperties.ColoringScheme.values().length; ++i) {
            if (!color.equalsIgnoreCase(AlignmentProperties.ColoringScheme.values()[i].name())) continue;
            c = AlignmentProperties.ColoringScheme.values()[i];
        }
        if (c == null) {
            throw new MDParametersException("Invalid coloring scheme is defined in the xml: " + color);
        }
        ((ShapeGenerator)this.generator).setColoring(c);
    }
}

