/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors.scalars;

import chemaxon.calculations.Interaction;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.SDParameters;
import chemaxon.struc.Molecule;
import java.io.File;
import java.util.List;
import org.dom4j.Element;

public class HBParameters
extends SDParameters {
    public static final int DEFAULT_PH = 7;
    private Element hBondNode = null;
    private float pH = 7.0f;
    private char hbType = (char)68;
    private Interaction intaCalc = null;

    public HBParameters() {
        this.initParameters();
    }

    public HBParameters(File configFile) throws MDParametersException {
        super(configFile);
        this.initParameters();
    }

    public HBParameters(String XMLconfig) throws MDParametersException {
        super(XMLconfig);
        this.initParameters();
    }

    @Override
    public String toString() {
        try {
            return super.toString();
        }
        catch (MDParametersException p) {
            return null;
        }
    }

    @Override
    protected void initParameters() {
        super.initParameters();
        this.intaCalc = new Interaction();
    }

    protected float generate(Molecule m) throws MDGeneratorException {
        try {
            this.intaCalc.setMolecule(m);
            this.intaCalc.calcAcceptorDonorCount(this.pH);
            if (this.hbType == 'D') {
                return (float)this.intaCalc.getDonorAtomNumberOfMacroState();
            }
            return (float)this.intaCalc.getAcceptorAtomNumberOfMacroState();
        }
        catch (Exception ne) {
            ne.printStackTrace();
            throw new MDGeneratorException("Parameters are not set properly.");
        }
    }

    @Override
    protected void readValues(boolean all) throws MDParametersException {
        String atomType;
        super.readValues(all);
        List sdNodes = this.document.selectNodes("//ScalarDescriptorConfiguration/ScalarDescriptors/ScalarDescriptor");
        if (sdNodes == null) {
            throw new MDParametersException("Parameter configuration error.");
        }
        this.hBondNode = null;
        for (Element c : sdNodes) {
            if (!c.attributeValue("Name").equals("HBond")) continue;
            this.hBondNode = c;
            break;
        }
        if (this.hBondNode == null) {
            throw new MDParametersException("Missing HBond parameters");
        }
        String ph = this.hBondNode.attributeValue("pH");
        if (ph != null) {
            this.pH = Float.parseFloat(ph);
        }
        if ((atomType = this.hBondNode.attributeValue("AtomType")) == null) {
            throw new MDParametersException("Missing AtomType attribute in HBond element.");
        }
        if (atomType.equals("Donor")) {
            this.hbType = (char)68;
        } else if (atomType.equals("Acceptor")) {
            this.hbType = (char)65;
        } else {
            throw new MDParametersException("Invalid AtomType attribute in HBond element.");
        }
    }
}

