/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors.scalars;

import chemaxon.calculations.training.logp.LogPPredictor;
import chemaxon.calculations.training.logp.LogPPredictorFactory;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.descriptors.SDParameters;
import chemaxon.descriptors.ScalarDescriptor;
import chemaxon.struc.Molecule;

public class LogP
extends ScalarDescriptor {
    private LogPPredictor logPPredictor = LogPPredictorFactory.createLogPPredictor(LogPPredictor.MethodType.TRUE);

    public LogP() {
    }

    public LogP(SDParameters params) {
        super(params);
    }

    public LogP(String params) {
        super(params);
    }

    public LogP(ScalarDescriptor sd) {
        super(sd);
    }

    @Override
    public MolecularDescriptor clone() {
        return new LogP(this);
    }

    @Override
    public String getName() {
        return "LogP";
    }

    @Override
    public String getShortName() {
        return "LogP";
    }

    @Override
    public void setParameters(String parameters) throws MDParametersException {
        if (this.params == null) {
            super.setParameters(new SDParameters(parameters));
        } else {
            this.params.fromString(parameters);
        }
    }

    @Override
    public String getParametersClassName() {
        return "chemaxon.descriptors.SDParameters";
    }

    @Override
    public boolean needsConfig() {
        return false;
    }

    @Override
    public String[] generate(Molecule m) throws MDGeneratorException {
        super.generate(m);
        try {
            this.descrValue = (float)this.logPPredictor.predict(m);
            return null;
        }
        catch (NullPointerException ne) {
            ne.printStackTrace();
            throw new MDGeneratorException("Parameters are not set properly.");
        }
    }
}

