/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.drugdesign.fragment;

import chemaxon.drugdesign.fragment.FragmentConnectionTypes;
import chemaxon.drugdesign.fragment.FragmentationException;
import chemaxon.fragmenter.FragmenterConfig;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;

public class FragmentedMolecule
extends Molecule {
    private ArrayList attachments = new ArrayList();
    private ArrayList connections = new ArrayList();

    public FragmentedMolecule() {
    }

    public FragmentedMolecule(Molecule fragment, String name, FragmenterConfig fc, FragmentConnectionTypes fct) throws FragmentationException {
        this.fuse(fragment);
        String[] keys = fragment.properties().getKeys();
        for (int j = 0; j < keys.length; ++j) {
            String key = keys[j];
            this.setPropertyObject(key, fragment.getPropertyObject(key));
        }
        SuperatomSgroup sgroup = new SuperatomSgroup((Molecule)this, true);
        sgroup.setSubscript(name);
        SelectionMolecule smol = new SelectionMolecule();
        smol.fuse(this);
        sgroup.setSgroupGraph(smol);
        for (int i = this.getAtomCount() - 1; i >= 0; --i) {
            this.setSgroupParent(this.getAtom(i), sgroup, true);
        }
        this.addAttachmentsFromTag(fct, fc);
    }

    private void addAttachmentsFromTag(FragmentConnectionTypes fct, FragmenterConfig fc) throws FragmentationException {
        String reactionName = null;
        int reactionMap = 0;
        for (int atom = 0; atom < this.getAtomCount(); ++atom) {
            String connectionString = this.getConnectionString(atom);
            if (connectionString == null) continue;
            StringTokenizer tokenizer = new StringTokenizer(connectionString, ",", true);
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                if (token.equals(",")) continue;
                int colonPos = token.indexOf(58);
                reactionName = token.substring(0, colonPos);
                FragmentConnectionTypes.FCTRecord type = fct.searchType(reactionName, reactionMap = Integer.parseInt(token.substring(colonPos + 1)));
                if (type == null) {
                    throw new FragmentationException("Not found fragment type: " + reactionName + ":" + reactionMap);
                }
                this.addAttachment(this.getAtom(atom), type);
            }
        }
    }

    private String getConnectionString(int atomNo) {
        String aliasstr = this.getAtom(atomNo).getAliasstr();
        if (aliasstr == null) {
            return null;
        }
        int bInd = aliasstr.indexOf("_{");
        int lInd = aliasstr.indexOf("}");
        if (bInd == -1 || lInd == -1 || bInd + 2 > lInd) {
            return null;
        }
        return aliasstr.substring(bInd + 2, lInd);
    }

    public static FragmentedMolecule connect(FragmentedMolecule mol1, int ai1, FragmentedMolecule mol2, int ai2) throws FragmentationException {
        mol1 = (FragmentedMolecule)mol1.clone();
        mol2 = (FragmentedMolecule)mol2.clone();
        MolAtom atom1 = mol1.getAttachmentAtom(ai1);
        MolAtom atom2 = mol2.getAttachmentAtom(ai2);
        FragmentConnectionTypes.FCTRecord type1 = mol1.getAttachmentType(ai1);
        FragmentConnectionTypes.FCTRecord type2 = mol2.getAttachmentType(ai2);
        FragmentedMolecule mol = new FragmentedMolecule();
        mol.fuse(mol1);
        mol.fuse(mol2);
        mol.addConnection(atom1, type1, atom2, type2);
        return mol;
    }

    public static FragmentedMolecule[] cleave(FragmentedMolecule mol, int ci) throws FragmentationException {
        int i;
        mol = (FragmentedMolecule)mol.clone();
        MolBond bond = mol.getConnectionBond(ci);
        mol.removeBond(bond);
        ArrayList attachments = mol.attachments;
        ArrayList connections = mol.connections;
        MoleculeGraph[] halves = mol.findFrags(FragmentedMolecule.class);
        if (halves.length != 2) {
            throw new FragmentationException("Panic: number of halves: " + halves.length);
        }
        FragmentedMolecule mol1 = (FragmentedMolecule)halves[0];
        FragmentedMolecule mol2 = (FragmentedMolecule)halves[1];
        int size = attachments.size();
        for (i = 0; i < size; ++i) {
            Attachment attachment = (Attachment)attachments.get(i);
            if (mol1.indexOf(attachment.atom) != -1) {
                mol1.attachments.add(attachment);
                continue;
            }
            if (mol2.indexOf(attachment.atom) != -1) {
                mol2.attachments.add(attachment);
                continue;
            }
            throw new FragmentationException("Panic: non-existent attachment atom: " + attachment.atom);
        }
        size = connections.size();
        for (i = 0; i < size; ++i) {
            Connection connection = (Connection)connections.get(i);
            if (mol1.indexOf(connection.bond) != -1) {
                mol1.connections.add(connection);
                continue;
            }
            if (mol2.indexOf(connection.bond) != -1) {
                mol2.connections.add(connection);
                continue;
            }
            throw new FragmentationException("Panic: non-existent connection bond: " + connection.bond);
        }
        return new FragmentedMolecule[]{mol1, mol2};
    }

    public int getAttachmentCount() {
        return this.attachments.size();
    }

    public MolAtom getAttachmentAtom(int i) {
        return ((Attachment)this.attachments.get(i)).atom;
    }

    public FragmentConnectionTypes.FCTRecord getAttachmentType(int i) {
        return ((Attachment)this.attachments.get(i)).type;
    }

    public int getConnectionCount() {
        return this.connections.size();
    }

    public MolBond getConnectionBond(int i) {
        return ((Connection)this.connections.get(i)).bond;
    }

    public FragmentConnectionTypes.FCTRecord getConnectionType1(int i) {
        return ((Connection)this.connections.get(i)).type1;
    }

    public FragmentConnectionTypes.FCTRecord getConnectionType2(int i) {
        return ((Connection)this.connections.get(i)).type2;
    }

    public void addAttachment(MolAtom atom, FragmentConnectionTypes.FCTRecord type) {
        this.attachments.add(new Attachment(atom, type));
    }

    public MolBond addConnection(MolAtom atom1, FragmentConnectionTypes.FCTRecord type1, MolAtom atom2, FragmentConnectionTypes.FCTRecord type2) throws FragmentationException {
        Attachment attachment;
        int i;
        int order = -1;
        Vector types = type1.getCompatibleConnectionTypes();
        for (i = types.size() - 1; i >= 0; --i) {
            if (types.get(i) != type2) continue;
            order = type1.getCompatibleBondOrders().elementAt(i);
            break;
        }
        if (order == -1) {
            throw new FragmentationException("Incompatible types:" + type1 + " and " + type2);
        }
        for (i = 0; i < this.attachments.size(); ++i) {
            attachment = (Attachment)this.attachments.get(i);
            if (attachment.atom != atom1 || attachment.type != type1) continue;
            this.attachments.remove(i);
            break;
        }
        for (i = 0; i < this.attachments.size(); ++i) {
            attachment = (Attachment)this.attachments.get(i);
            if (attachment.atom != atom2 || attachment.type != type2) continue;
            this.attachments.remove(i);
            break;
        }
        MolBond bond = new MolBond(atom1, atom2);
        bond.setType(order);
        this.addConnection(bond, type1, type2);
        this.add(bond);
        return bond;
    }

    private void addConnection(MolBond bond, FragmentConnectionTypes.FCTRecord type1, FragmentConnectionTypes.FCTRecord type2) {
        this.connections.add(new Connection(bond, type1, type2));
    }

    @Override
    public void clonecopy(MoleculeGraph g) {
        super.clonecopy(g);
        if (g instanceof FragmentedMolecule) {
            int index;
            int i;
            FragmentedMolecule m = (FragmentedMolecule)g;
            m.attachments.clear();
            m.connections.clear();
            int size = this.attachments.size();
            for (i = 0; i < size; ++i) {
                Attachment attachment = (Attachment)this.attachments.get(i);
                index = this.indexOf(attachment.atom);
                m.addAttachment(m.getAtom(index), attachment.type);
            }
            size = this.connections.size();
            for (i = 0; i < size; ++i) {
                Connection connection = (Connection)this.connections.get(i);
                index = this.indexOf(connection.bond);
                m.addConnection(m.getBond(index), connection.type1, connection.type2);
            }
        }
    }

    @Override
    public void clonelesscopy(MoleculeGraph g) {
        super.clonelesscopy(g);
        if (g instanceof FragmentedMolecule) {
            FragmentedMolecule m = (FragmentedMolecule)g;
            m.attachments = (ArrayList)this.attachments.clone();
            m.connections = (ArrayList)this.connections.clone();
        }
    }

    @Override
    public Molecule cloneMolecule() {
        FragmentedMolecule m = new FragmentedMolecule();
        this.clonecopy(m);
        return m;
    }

    @Override
    protected void fuse0(MoleculeGraph graph, boolean check) {
        if (graph instanceof FragmentedMolecule) {
            FragmentedMolecule m = (FragmentedMolecule)graph;
            this.attachments.addAll(m.attachments);
            this.connections.addAll(m.connections);
        }
        super.fuse0(graph, check);
    }

    @Override
    public void mergeAtoms(MolAtom that, MolAtom a) {
        this.replaceAttachments(a, that);
        super.mergeAtoms(that, a);
    }

    @Override
    protected void setAtom0(int i, MolAtom node) {
        this.replaceAttachments(this.getAtom(i), node);
        super.setAtom0(i, node);
    }

    private boolean replaceAttachments(MolAtom from, MolAtom to) {
        boolean replaced = false;
        for (int i = this.attachments.size() - 1; i >= 0; --i) {
            Attachment attachment = (Attachment)this.attachments.get(i);
            if (attachment.atom != from) continue;
            attachment.atom = to;
            replaced = true;
        }
        return replaced;
    }

    private boolean removeAttachments(MolAtom atom) {
        int size = this.attachments.size();
        for (int i = size - 1; i >= 0; --i) {
            Attachment attachment = (Attachment)this.attachments.get(i);
            if (attachment.atom != atom) continue;
            this.attachments.remove(i);
        }
        return this.attachments.size() == size;
    }

    private boolean removeConnection(MolBond bond) {
        for (int i = this.connections.size() - 1; i >= 0; --i) {
            Connection connection = (Connection)this.connections.get(i);
            if (connection.bond != bond) continue;
            this.addAttachment(bond.getAtom1(), connection.type1);
            this.addAttachment(bond.getAtom2(), connection.type2);
            this.connections.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public void removeAtom(MolAtom node, int cleanupFlags) {
        super.removeAtom(node, cleanupFlags);
        this.removeAttachments(node);
    }

    @Override
    public void removeAtom(int i, int cleanupFlags) {
        MolAtom atom = this.getAtom(i);
        super.removeAtom(i, cleanupFlags);
        this.removeAttachments(atom);
    }

    @Override
    protected void removeBond(MolBond edge, int cleanupFlags) {
        this.removeConnection(edge);
        super.removeBond(edge, cleanupFlags);
    }

    @Override
    protected void removeBond(int i, int cleanupFlags) {
        this.removeConnection(this.getBond(i));
        super.removeBond(i, cleanupFlags);
    }

    @Override
    public void removeAllBonds() {
        for (int i = this.connections.size() - 1; i >= 0; --i) {
            Connection connection = (Connection)this.connections.get(i);
            this.addAttachment(connection.bond.getAtom1(), connection.type1);
            this.addAttachment(connection.bond.getAtom2(), connection.type2);
        }
        this.connections.clear();
        super.removeAllBonds();
    }

    @Override
    public void removeAll() {
        this.attachments.clear();
        this.connections.clear();
        super.removeAll();
    }

    @Override
    public void clear() {
        this.attachments.clear();
        super.clear();
    }

    @Override
    public void clearForImport(String format2) {
        this.connections.clear();
        super.clearForImport(format2);
    }

    @Override
    public MoleculeGraph newInstance() {
        FragmentedMolecule m = new FragmentedMolecule();
        this.makeItSimilar(m);
        return m;
    }

    public int getFragmentCount() {
        if (this.getAtomCount() > 0) {
            return this.getConnectionCount() + 1;
        }
        return 0;
    }

    public int getFirstAttachmentIndex(FragmentConnectionTypes.FCTRecord type) {
        int i = 0;
        for (Attachment a : this.attachments) {
            if (a.type == type) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getRandomCompAttachmentIdx(FragmentConnectionTypes.FCTRecord type) {
        int count = 0;
        Vector compTypes = type.getCompatibleConnectionTypes();
        for (Attachment a : this.attachments) {
            if (!compTypes.contains(a.type)) continue;
            ++count;
        }
        if (count == 0) {
            return -1;
        }
        int index = (int)(Math.random() * (double)count);
        int i = 0;
        for (Attachment a : this.attachments) {
            if (compTypes.contains(a.type)) {
                if (index == 0) {
                    return i;
                }
                --index;
            }
            ++i;
        }
        return -1;
    }

    static class Connection {
        private MolBond bond = null;
        private FragmentConnectionTypes.FCTRecord type1 = null;
        private FragmentConnectionTypes.FCTRecord type2 = null;

        Connection(MolBond bond, FragmentConnectionTypes.FCTRecord type1, FragmentConnectionTypes.FCTRecord type2) {
            this.bond = bond;
            this.type1 = type1;
            this.type2 = type2;
        }
    }

    static class Attachment {
        private MolAtom atom = null;
        private FragmentConnectionTypes.FCTRecord type = null;

        Attachment(MolAtom atom, FragmentConnectionTypes.FCTRecord type) {
            this.atom = atom;
            this.type = type;
        }
    }
}

