/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration;

import chemaxon.calculations.stereo.StereoRecognizer;
import chemaxon.common.util.ArrayTools;
import chemaxon.core.calculations.BondClassifier;
import chemaxon.core.calculations.FindAllRings;
import chemaxon.core.util.BondTable;
import chemaxon.enumeration.QueryMolEnumerator;
import chemaxon.sss.search.Search;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.QueryBond;
import chemaxon.util.BackTrack;
import chemaxon.util.IntArray;
import java.util.ArrayList;
import java.util.List;

public class AmbiguousAromaticEnumerator
extends QueryMolEnumerator {
    private Molecule mol = null;
    private BackTrack bt = null;
    private boolean first = false;
    private int ambigRingsNo = 0;
    private int[][] ambigRings;
    private int[][] ambigRingBonds = null;
    private boolean ligandsNeeded = true;
    private final int LEVEL_AMBIGAROM = 0;
    private final int LEVEL_ONE = 1;
    private final int LEVEL_TWO = 2;
    private int mode = 1;
    private static final int MASK = 16452;
    private ArrayList<int[]> singleLigands = null;
    private ArrayList<int[]> bridgeBonds = null;
    private boolean[] singleOrDoubleBond = null;
    private BondClassifier bc = null;
    private static final int RING_SIZE = 5;
    private static final int MAX_RINGS = 5;
    private boolean preCheck = false;
    private static final int NUM_OF_AMBIG_FOR_REMOVAL = 1;
    private Molecule molAr;
    private int[] bondTypes = new int[5];
    private int[] bondTypesAr = new int[5];
    private int[][] stereoDefinitions = null;

    public AmbiguousAromaticEnumerator() {
    }

    public AmbiguousAromaticEnumerator(Molecule molP) {
        this.setMol(molP);
    }

    @Override
    public void setMol(Molecule molP) {
        if (this.mol == molP) {
            return;
        }
        this.mol = molP;
        this.init();
    }

    @Override
    public Object clone() {
        AmbiguousAromaticEnumerator aae = null;
        try {
            aae = (AmbiguousAromaticEnumerator)super.clone();
            aae.mol = this.mol;
            aae.molAr = this.molAr;
            aae.ambigRings = this.ambigRings;
            aae.ambigRingBonds = this.ambigRingBonds;
            aae.ambigRingsNo = this.ambigRingsNo;
            aae.bondTypes = (int[])this.bondTypes.clone();
            aae.bondTypesAr = (int[])this.bondTypesAr.clone();
            aae.first = this.first;
            aae.bt = this.bt == null ? null : (BackTrack)this.bt.clone();
            aae.preCheck = this.preCheck;
            aae.ligandsNeeded = this.ligandsNeeded;
            aae.singleLigands = this.singleLigands;
            aae.bridgeBonds = this.bridgeBonds;
            aae.singleOrDoubleBond = this.singleOrDoubleBond;
            aae.bc = this.bc;
            aae.mode = this.mode;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return aae;
    }

    private void init() {
        int i;
        if (this.mol == null) {
            return;
        }
        this.first = true;
        this.bridgeBonds = null;
        this.singleLigands = null;
        this.molAr = null;
        this.stereoDefinitions = null;
        boolean[] ringBonds = null;
        boolean[] ringAtoms = null;
        int bondCount = this.mol.getBondCount();
        if (this.mode > 0) {
            ringAtoms = new boolean[this.mol.getAtomCount()];
            ringBonds = new boolean[bondCount];
        }
        int[][] rings = null;
        boolean found = false;
        if (this.mode < 2) {
            rings = (int[][])this.mol.getSSSR().clone();
            if (this.mode == 1) {
                BondTable btab = this.mol.getBondTable();
                for (i = 0; i < rings.length; ++i) {
                    for (int j = 0; j < rings[i].length; ++j) {
                        ringBonds[btab.getBondIndex((int)rings[i][j], (int)rings[i][(j + 1) % rings[i].length])] = true;
                        ringAtoms[rings[i][j]] = true;
                    }
                }
            }
            this.preCheck = true;
            this.ambigRings = this.filterRings(rings);
            boolean bl = found = this.ambigRings != null;
            if (found) {
                if (this.molAr == null) {
                    this.molAr = this.getAromatizedMolecule(this.mol);
                }
                this.preCheck = false;
                this.ambigRings = this.filterRings(this.ambigRings);
                boolean bl2 = found = this.ambigRings != null;
                if (found) {
                    this.ambigRingsNo = this.ambigRings.length;
                    this.ambigRingBonds = new int[this.ambigRingsNo][];
                    for (int i2 = 0; i2 < this.ambigRingsNo; ++i2) {
                        this.ambigRingBonds[i2] = this.getBondIndexes(this.ambigRings[i2]);
                    }
                    found = this.removeFusedToAromatic();
                    int[] d = new int[this.ambigRingsNo];
                    for (i = 0; i < this.ambigRingsNo; ++i) {
                        d[i] = 2;
                    }
                    this.bt = new BackTrack(d);
                }
            }
        }
        if (this.mode > 0) {
            this.bridgeBonds = new ArrayList();
            this.singleLigands = new ArrayList();
            this.singleOrDoubleBond = new boolean[bondCount];
            if (this.ligandsNeeded) {
                if (this.mode == 2) {
                    this.bc = new BondClassifier();
                    this.bc.classify(this.mol);
                    for (int i3 = 0; i3 < this.mol.getAtomCount(); ++i3) {
                        ringAtoms[i3] = this.bc.isRingAtom(i3);
                    }
                }
                MolBond b = null;
                for (i = 0; i < bondCount; ++i) {
                    b = this.mol.getBond(i);
                    int type = b.getType();
                    MolAtom a1 = b.getAtom1();
                    MolAtom a2 = b.getAtom2();
                    int node1 = this.mol.indexOf(a1);
                    int node2 = this.mol.indexOf(a2);
                    if ((this.mode != 2 || this.bc.isRingBond(node1, node2)) && (this.mode != 1 || ringBonds[i])) continue;
                    this.findExtraVagueBonds(i, type, a1, a2, node1, node2, ringAtoms[node1], ringAtoms[node2]);
                }
                if (this.hasBondsChangingToSA() && this.molAr == null) {
                    this.molAr = this.getAromatizedMolecule(this.mol);
                }
            }
        }
        if (!found) {
            this.ambigRings = null;
            this.ambigRingsNo = 0;
            this.bt = null;
            if (this.mode != 2 && (this.mode == 0 || this.singleLigands.size() == 0 && this.bridgeBonds.size() == 0)) {
                this.first = false;
            }
        }
    }

    private Molecule getAromatizedMolecule(Molecule mol2) {
        Integer aromMeth = (Integer)this.mol.getPropertyObject("AROMATIZATION_METHOD");
        if (aromMeth == null) {
            aromMeth = 2;
        }
        if (aromMeth == 2) {
            mol2.getSSSR();
        }
        Molecule arom = mol2.cloneMolecule();
        arom.aromatize(aromMeth);
        return arom;
    }

    private final void findExtraVagueBonds(int bond, int bondType, MolAtom a1, MolAtom a2, int node1, int node2, boolean isRingAtom1, boolean isRingAtom2) {
        if (this.arePossibleAromaticAtoms(a1, a2)) {
            if (this.isEnumerableBridgeBond(bondType, a1, node1, node2, isRingAtom1, isRingAtom2, a2)) {
                this.bridgeBonds.add(new int[]{bond, node1, node2});
                this.setSorDBond(bond, bondType);
            } else if (this.isEnumerableSingleLigand(bondType, a1, a2, isRingAtom1)) {
                this.singleLigands.add(new int[]{bond, node1});
                this.setSorDBond(bond, bondType);
            } else if (this.isEnumerableSingleLigand(bondType, a2, a1, isRingAtom2)) {
                this.singleLigands.add(new int[]{bond, node2});
                this.setSorDBond(bond, bondType);
            }
        }
    }

    private boolean isEnumerableSingleLigand(int bondType, MolAtom a1, MolAtom a2, boolean isRingAtom1) {
        return isRingAtom1 && a1.getBondCount() < 4 && a2.getBondCount() == 1 && (bondType == 1 || bondType == 5) && this.isPossibleAromaticAtom(a2);
    }

    private boolean arePossibleAromaticAtoms(MolAtom a1, MolAtom a2) {
        return this.isPossibleAromaticAtom(a1) && this.isPossibleAromaticAtom(a2);
    }

    private boolean isPossibleAromaticAtom(MolAtom a1) {
        boolean isAromaticAtomType;
        boolean bl = isAromaticAtomType = MolAtom.isAromaticSMILESSubset(a1.getAtno()) || a1.getAtno() > 109;
        if (!isAromaticAtomType) {
            return false;
        }
        int sProp = a1.getQPropAsInt("s");
        if (sProp == 0 || sProp == 1 || sProp == -2 && a1.getBondCount() == 1) {
            return false;
        }
        return a1.getQueryAromaticity() != 2;
    }

    private boolean isEnumerableBridgeBond(int bondType, MolAtom a1, int node1, int node2, boolean isRingAtom1, boolean isRingAtom2, MolAtom a2) {
        return isRingAtom1 && isRingAtom2 && a1.getBondCount() < 4 && a2.getBondCount() < 4 && bondType == 1 && !this.isAtropStereo(node1, node2);
    }

    private boolean isAtropStereo(int node1, int node2) {
        if (this.stereoDefinitions == null) {
            StereoRecognizer stereoRecognizer = new StereoRecognizer();
            stereoRecognizer.calculateStereoAtoms(this.mol);
            this.stereoDefinitions = stereoRecognizer.getStereoDefinitions();
        }
        for (int[] def : this.stereoDefinitions) {
            if (def.length < 6 || def[0] != 3 || def[2] != node1 && def[2] != node2 || def[3] != node1 && def[3] != node2) continue;
            return true;
        }
        return false;
    }

    private void setSorDBond(int bond, int bondType) {
        this.singleOrDoubleBond[bond] = bondType == 5;
    }

    private final boolean removeFusedToAromatic() {
        int[] ambigCount = new int[this.mol.getBondCount()];
        for (int i = 0; i < this.ambigRingsNo; ++i) {
            int[] ringBonds = this.ambigRingBonds[i];
            for (int j = 0; j < ringBonds.length; ++j) {
                int n = ringBonds[j];
                ambigCount[n] = ambigCount[n] + 1;
            }
        }
        boolean hasRingAllBondsRemoved = false;
        IntArray toDelete = new IntArray(5);
        for (int i = 0; i < this.ambigRingsNo; ++i) {
            int[] ringBonds = this.ambigRingBonds[i];
            toDelete.clear();
            for (int j = 0; j < ringBonds.length; ++j) {
                int b = ringBonds[j];
                MolBond bondAr = this.molAr.getBond(b);
                if (ambigCount[b] != 1 || !this.isAromaticFuseBond(bondAr, this.molAr, ringBonds)) continue;
                toDelete.add(b);
            }
            if (toDelete.size() == 0) continue;
            int newL = ringBonds.length - toDelete.size();
            hasRingAllBondsRemoved |= newL == 1;
            int[] newRingBonds = new int[newL];
            int k = 0;
            for (int j = 0; j < ringBonds.length; ++j) {
                if (toDelete.contains(ringBonds[j])) continue;
                newRingBonds[k++] = ringBonds[j];
            }
            this.ambigRingBonds[i] = newRingBonds;
        }
        if (hasRingAllBondsRemoved) {
            ArrayList<int[]> nonRemovedRings = new ArrayList<int[]>();
            ArrayList<int[]> nonRemovedRingBonds = new ArrayList<int[]>();
            for (int i = 0; i < this.ambigRingsNo; ++i) {
                if (this.ambigRingBonds[i].length <= 1) continue;
                nonRemovedRings.add(this.ambigRings[i]);
                nonRemovedRingBonds.add(this.ambigRingBonds[i]);
            }
            this.ambigRingsNo = nonRemovedRings.size();
            this.ambigRings = this.listToArray(nonRemovedRings);
            this.ambigRingBonds = this.listToArray(nonRemovedRingBonds);
        }
        return this.ambigRingsNo != 0;
    }

    private int[][] listToArray(List<int[]> list) {
        int[][] ret = new int[list.size()][];
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    private boolean isAromaticFuseBond(MolBond bondAr, Molecule molAr, int[] ringBonds) {
        if (bondAr.getType() != 4) {
            return false;
        }
        MolAtom atom1 = bondAr.getAtom1();
        MolAtom atom2 = bondAr.getAtom2();
        return this.isAromaticFusedAtom(atom1, bondAr, molAr, ringBonds) && this.isAromaticFusedAtom(atom2, bondAr, molAr, ringBonds);
    }

    private boolean isAromaticFusedAtom(MolAtom atom1, MolBond bondAr, Molecule molAr, int[] ringBonds) {
        boolean r = true;
        if (atom1.getBondCount() != 3) {
            r = false;
        }
        for (int i = 0; i < atom1.getBondCount(); ++i) {
            int bi;
            MolBond otherBond = atom1.getBond(i);
            if (otherBond == bondAr || ArrayTools.foundInArray(ringBonds, bi = molAr.indexOf(otherBond)) || otherBond.getType() == 4) continue;
            r = false;
        }
        return r;
    }

    private int[][] filterRings(int[][] rings) {
        Object ret;
        if (rings == null || rings.length == 0) {
            return null;
        }
        int ambigs = 0;
        for (int i = 0; i < rings.length; ++i) {
            int[] ring = rings[i];
            boolean isAmbig = true;
            if (ring.length != 5 || this.hasAromatic(ring) || this.containsNonAromaticAtomType(ring) || !this.isAmbigRing(ring)) {
                isAmbig = false;
            }
            if (isAmbig) {
                ++ambigs;
                continue;
            }
            rings[i] = null;
        }
        if (ambigs == rings.length) {
            ret = rings;
        } else if (ambigs == 0) {
            ret = null;
        } else {
            ret = new int[ambigs][];
            int retI = 0;
            for (int i = 0; i < rings.length; ++i) {
                if (rings[i] == null) continue;
                ret[retI] = rings[i];
                ++retI;
            }
        }
        return ret;
    }

    private boolean isAmbigRing(int[] ring) {
        int idx = -1;
        int d = 100;
        for (int i = 0; i < 5; ++i) {
            int d1;
            if (!this.hasCorSInAtom0(ring, i) || !this.hasAmbigBondTypes(this.bondTypes, this.bondTypesAr, i) || (d1 = this.mol.getAtom(ring[i]).getBondCount()) >= d) continue;
            d = d1;
            idx = i;
        }
        if (idx > 0) {
            this.shift(ring, idx);
        }
        return idx >= 0;
    }

    private void setBondTypes(int[] ring) {
        BondTable btab = this.mol.getBondTable();
        for (int i = 0; i < ring.length; ++i) {
            int bondIdx = btab.getBondIndex(ring[i], ring[(i + 1) % ring.length]);
            if (this.preCheck) {
                this.bondTypes[i] = this.mol.getBond(bondIdx).getType();
                continue;
            }
            this.bondTypes[i] = this.mol.getBond(bondIdx).getType();
            this.bondTypesAr[i] = this.molAr.getBond(bondIdx).getType();
        }
    }

    private int[] getBondIndexes(int[] ring) {
        int[] idxs = new int[ring.length];
        BondTable btab = this.mol.getBondTable();
        for (int i = 0; i < ring.length; ++i) {
            idxs[i] = btab.getBondIndex(ring[i], ring[(i + 1) % ring.length]);
        }
        return idxs;
    }

    private boolean hasAmbigBondTypes(int[] bondTypesP, int[] bondTypesArP, int shift) {
        int ll = 5;
        return Search.areMatchingBondTypes(1, bondTypesP[shift]) && Search.areMatchingBondTypes(1, bondTypesP[(4 + shift) % ll]) && this.matchingOrArom(bondTypesArP, bondTypesP, (1 + shift) % ll, 7) && this.matchingOrArom(bondTypesArP, bondTypesP, (3 + shift) % ll, 7) && this.matchingOrArom(bondTypesArP, bondTypesP, (2 + shift) % ll, 6);
    }

    private boolean matchingOrArom(int[] bondTypesArP, int[] bondTypesP, int i, int qBondType) {
        return this.preCheck || bondTypesArP[i] == 4 || Search.areMatchingBondTypes(qBondType, bondTypesP[i]);
    }

    private boolean hasAromatic(int[] ring) {
        this.setBondTypes(ring);
        if (!this.preCheck) {
            return false;
        }
        for (int i = 0; i < 5; ++i) {
            if (!this.canBeAromaticBond(this.bondTypes[i], false)) continue;
            return true;
        }
        return false;
    }

    private boolean hasCorSInAtom0(int[] ring, int shift) {
        MolAtom ma = this.mol.getAtom(ring[shift]);
        switch (ma.getAtno()) {
            case 16: 
            case 131: 
            case 132: 
            case 134: {
                return true;
            }
            case 6: {
                return ma.getBondCount() <= 3;
            }
            case 128: {
                int[] list = ma.getList();
                return ArrayTools.foundInArray(list, 6) || ArrayTools.foundInArray(list, 16);
            }
            case 129: {
                int[] list = ma.getList();
                return !ArrayTools.foundInArray(list, 6) || !ArrayTools.foundInArray(list, 16);
            }
        }
        return false;
    }

    private void shift(int[] ring, int idx) {
        if (idx == 0) {
            return;
        }
        int[] ac = (int[])ring.clone();
        for (int i = 0; i < ring.length; ++i) {
            ring[i] = ac[(i + idx) % ring.length];
        }
    }

    private boolean containsNonAromaticAtomType(int[] ring) {
        if (!this.preCheck) {
            return false;
        }
        for (int i = 0; i < ring.length; ++i) {
            MolAtom ma = this.mol.getAtom(ring[i]);
            int atno = ma.getAtno();
            if (!FindAllRings.aromElements(atno) && atno < 128) {
                return true;
            }
            if (ma.getQueryAromaticity() != 2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMoreElements() {
        if (this.mode < 2) {
            if (this.ambigRingsNo != 0 && this.ambigRingsNo < 5) {
                return this.bt.hasMoreElements();
            }
            if (this.ambigRingsNo >= 5 || this.hasBondsChangingToSA()) {
                return this.first;
            }
            return false;
        }
        return this.first && this.ligandsNeeded && this.hasBondsChangingToSA();
    }

    private boolean hasBondsChangingToSA() {
        return this.singleLigands != null && this.singleLigands.size() != 0 || this.bridgeBonds != null && this.bridgeBonds.size() != 0;
    }

    @Override
    public Molecule nextElement() {
        Molecule r;
        block12: {
            r = null;
            if (this.hasMoreElements()) {
                if (this.bt != null && this.ambigRingsNo < 5) {
                    int[] nextConfig = (int[])this.bt.nextElement();
                    r = this.generateOutMol(nextConfig);
                } else if (this.ambigRingsNo >= 5) {
                    this.first = false;
                    r = this.createCommon();
                } else {
                    this.first = false;
                    if (this.molAr == null) {
                        this.molAr = this.getAromatizedMolecule(this.mol);
                    }
                    Molecule molecule = r = this.mode < 2 ? this.molAr.cloneMolecule() : this.mol.cloneMolecule();
                }
            }
            if (this.mode <= 0 || !this.ligandsNeeded) break block12;
            int[] indices = null;
            if (this.mode == 2) {
                int i;
                for (i = 0; i < this.singleLigands.size(); ++i) {
                    indices = this.singleLigands.get(i);
                    this.changeBondToOrAromatic(r, indices[0]);
                    this.changeOtherAtomToOrAromatic(r, indices[1], indices[0]);
                }
                for (i = 0; i < this.bridgeBonds.size(); ++i) {
                    this.changeBondToOrAromatic(r, this.bridgeBonds.get(i)[0]);
                }
            } else {
                int i;
                for (i = 0; i < this.singleLigands.size(); ++i) {
                    indices = this.singleLigands.get(i);
                    if (!this.canBeAromaticAtom(r, indices[1], indices[0])) continue;
                    this.changeBondToOrAromatic(r, indices[0]);
                    this.changeOtherAtomToOrAromatic(r, indices[1], indices[0]);
                }
                for (i = 0; i < this.bridgeBonds.size(); ++i) {
                    indices = this.bridgeBonds.get(i);
                    if (!this.canBeAromaticAtom(r, indices[1], indices[0]) || !this.canBeAromaticAtom(r, indices[2], indices[0])) continue;
                    this.changeBondToOrAromatic(r, this.bridgeBonds.get(i)[0]);
                }
            }
        }
        return r;
    }

    private void changeOtherAtomToOrAromatic(Molecule m, int atom, int ligandIndex) {
        MolAtom otherAtom = m.getBond(ligandIndex).getOtherAtom(m.getAtom(atom));
        if (otherAtom.getAtno() == 134) {
            return;
        }
        int aromaticity = otherAtom.getQueryAromaticity();
        switch (aromaticity) {
            case 0: {
                otherAtom.setQueryAromaticity(3);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                return;
            }
            default: {
                throw new IllegalArgumentException("Invalid aromaticity: " + aromaticity);
            }
        }
    }

    private void changeBondToOrAromatic(Molecule r, int index) {
        if (this.singleOrDoubleBond[index]) {
            this.insertQueryBond(r, index);
        } else {
            this.addAromToBond(r.getBond(index), true);
        }
    }

    private final void insertQueryBond(Molecule r, int bondIndex) {
        MolBond bond = r.getBond(bondIndex);
        QueryBond qb = new QueryBond(bond.getAtom1(), bond.getAtom2(), bond.getFlags());
        qb.setType(0);
        String qstr = bond.getQuerystr();
        if (qstr == null) {
            qb.setQuerystr("-,=,:");
        } else {
            qb.setQuerystr(qstr + ";-,=,:");
        }
        r.removeBond(bondIndex);
        r.add(qb);
    }

    private final boolean canBeAromaticAtom(Molecule m, int atom, int ligandIndex) {
        MolAtom a = m.getAtom(atom);
        for (int i = 0; i < a.getBondCount(); ++i) {
            MolBond b = a.getBond(i);
            if (m.indexOf(b) == ligandIndex || !this.canBeAromaticBond(b.getType(), true)) continue;
            return true;
        }
        return false;
    }

    private final boolean canBeAromaticBond(int type, boolean isValidANY) {
        if (type == 4 || type == 6 || type == 7) {
            return true;
        }
        return isValidANY && type == 0;
    }

    private Molecule generateOutMol(int[] nextConfig) {
        return this.generateOutMolFast(nextConfig);
    }

    private Molecule generateOutMolFast(int[] nextConfig) {
        Molecule r = (Molecule)this.molAr.clone();
        r.setValenceCheckEnabled(false);
        if (this.ambigRingsNo != 0) {
            int i;
            for (i = 0; i < this.ambigRingsNo; ++i) {
                int[] ring = this.ambigRings[i];
                int[] ringBonds = this.ambigRingBonds[i];
                if (nextConfig[i] != 0) continue;
                r.getAtom(ring[0]).putProperty("DO_NOT_AROMATIZE", 1);
                this.changeToOriginal(r, ringBonds);
            }
            for (i = 0; i < this.ambigRingsNo; ++i) {
                int[] ringBonds = this.ambigRingBonds[i];
                if (nextConfig[i] == 0) continue;
                this.changeToAromaticByBonds(r, ringBonds, false);
            }
        }
        return r;
    }

    private Molecule createCommon() {
        Molecule mol1 = (Molecule)this.mol.clone();
        if (this.ambigRingBonds != null) {
            for (int i = 0; i < this.ambigRingBonds.length; ++i) {
                int[] ringBonds = this.ambigRingBonds[i];
                this.changeToAromaticByBonds(mol1, ringBonds, true);
            }
        }
        return mol1;
    }

    private void changeToOriginal(Molecule mol1, int[] ringBonds) {
        for (int j = 0; j < ringBonds.length; ++j) {
            int origBt = this.mol.getBond(ringBonds[j]).getType();
            MolBond b = mol1.getBond(ringBonds[j]);
            int flags = b.getFlags();
            int otherFlags = flags & 0xFFFFFFF0;
            b.setFlags(otherFlags | origBt);
        }
    }

    private void changeToAromaticByBonds(Molecule mol1, int[] ringBonds, boolean or) {
        for (int b : ringBonds) {
            this.addAromToBond(mol1.getBond(b), or);
        }
    }

    private final void addAromToBond(MolBond b, boolean or) {
        int newBt;
        int flags = b.getFlags();
        if (!or) {
            newBt = 4;
        } else {
            newBt = flags & 0xF;
            switch (newBt) {
                case 1: {
                    newBt = 6;
                    break;
                }
                case 2: {
                    newBt = 7;
                    break;
                }
                case 3: {
                    newBt = 0;
                    break;
                }
                case 5: {
                    newBt = 0;
                    break;
                }
            }
        }
        b.setFlags(flags & 0xFFFFFFF0 | newBt);
    }

    @Override
    public void setFeatures(int features) {
        this.ligandsNeeded = true;
        this.mode = features & 0x4044;
        switch (this.mode) {
            case 4: {
                this.mode = 0;
                break;
            }
            case 16388: {
                this.mode = 1;
                break;
            }
            case 16452: {
                this.mode = 2;
                break;
            }
            case 68: {
                this.mode = 2;
                this.ligandsNeeded = false;
            }
        }
    }
}

