/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.util.MolImportUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.util.ShortestPath;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class AromUtil {
    private static final String AMBIG_RING = "AMBIG_RING";
    private static final int AMBIG_RING_LEN = "AMBIG_RING".length();
    private static final Integer MARKER = new Integer(1);
    private static final String SHORTEST_PATH = "SHORTEST_PATH";

    public static String createAmbigAromRingMarker(int k) {
        return AMBIG_RING + k;
    }

    public static int getAmbigAromRingMarkerIndex(String marker) {
        assert (marker.startsWith(AMBIG_RING));
        return marker.length() > AMBIG_RING_LEN ? Integer.parseInt(marker.substring(AMBIG_RING_LEN)) : -1;
    }

    public static void markAtom(MolAtom atom, String marker) {
        atom.putProperty(marker, MARKER);
    }

    public static boolean isMarkedAtom(MolAtom atom, String marker) {
        return atom.containsPropertyKey(marker);
    }

    public static void unmarkAtom(MolAtom atom, String marker) {
        atom.removeProperty(marker);
    }

    public static String getFirstAmbigAromRingMarker(MolAtom atom) {
        Set<String> props = atom.propertyKeySet();
        for (String prop : props) {
            if (!prop.startsWith(AMBIG_RING)) continue;
            return prop;
        }
        return null;
    }

    public static boolean hasAmbigAromRingMarker(MolAtom atom) {
        return AromUtil.getFirstAmbigAromRingMarker(atom) != null;
    }

    public static boolean haveCommonAmbigAromRingMarker(MolAtom atom1, MolAtom atom2) {
        Set<String> props = atom1.propertyKeySet();
        for (String prop : props) {
            if (!prop.startsWith(AMBIG_RING) || !atom2.containsPropertyKey(prop)) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getAmbigAromRingMarkers(MolAtom atom) {
        Set<String> props = atom.propertyKeySet();
        HashSet<String> markers = new HashSet<String>();
        for (String prop : props) {
            if (!prop.startsWith(AMBIG_RING)) continue;
            markers.add(prop);
        }
        return markers;
    }

    public static Set<String> getCommonAmbigAromRingMarkers(MolAtom atom1, MolAtom atom2) {
        Set<String> props = atom1.propertyKeySet();
        HashSet<String> markers = new HashSet<String>();
        for (String prop : props) {
            if (!prop.startsWith(AMBIG_RING) || !atom2.containsPropertyKey(prop)) continue;
            markers.add(prop);
        }
        return markers;
    }

    private static void setShortestPath(Molecule mol, ShortestPath shortestPath) {
        mol.setPropertyObject(SHORTEST_PATH, shortestPath);
    }

    private static ShortestPath getShortestPath(Molecule mol) {
        return (ShortestPath)mol.getPropertyObject(SHORTEST_PATH);
    }

    private static void clearShortestPath(Molecule mol) {
        mol.setPropertyObject(SHORTEST_PATH, null);
    }

    public static void markAmbigAromPathsInRgroupMembers(RgMolecule rgmol) {
        if (!AromUtil.initAromatize(rgmol)) {
            return;
        }
        MoleculeGraph union = rgmol.getGraphUnion();
        int count = union.getAtomCount();
        for (int i = 0; i < count; ++i) {
            int rgindex;
            MolAtom atom = union.getAtom(i);
            if (atom.getAtno() != 134 || atom.getBondCount() < 2 || (rgindex = rgmol.findRgroupIndex(atom.getRgroup())) == -1) continue;
            int memberCount = rgmol.getRgroupMemberCount(rgindex);
            for (int j = 0; j < memberCount; ++j) {
                Molecule rgroup = rgmol.getRgroupMember(rgindex, j);
                AromUtil.markShortestPaths(rgmol, atom, rgroup);
            }
        }
        AromUtil.finishAromatize(rgmol);
    }

    private static void markShortestPaths(RgMolecule rgmol, MolAtom ratom, Molecule rgroup) {
        ShortestPath shortestPath = AromUtil.getShortestPath(rgroup);
        if (shortestPath == null) {
            return;
        }
        MolAtom[] rligands = MolImportUtil.getLigandsInOrder(ratom);
        MolAtom[] attachments = MolImportUtil.getAttachments(rgroup);
        int[] path = new int[rgroup.getAtomCount()];
        for (int i = 0; i < attachments.length; ++i) {
            for (int j = i + 1; j < attachments.length; ++j) {
                Set<String> markers = AromUtil.getCommonAmbigAromRingMarkers(rligands[i], rligands[j]);
                if (markers.isEmpty()) continue;
                int a1 = rgroup.indexOf(attachments[i]);
                int a2 = rgroup.indexOf(attachments[j]);
                int count = shortestPath.getPath(a1, a2, path);
                AromUtil.markShortestPath(rgmol, rgroup, path, count, markers);
            }
        }
    }

    private static void markShortestPath(RgMolecule rgmol, Molecule rgroup, int[] path, int count, Set<String> markers) {
        for (int k = 0; k < count; ++k) {
            int rgindex;
            MolAtom patom = rgroup.getAtom(path[k]);
            for (String marker : markers) {
                AromUtil.markAtom(patom, marker);
            }
            if (patom.getAtno() != 134 || (rgindex = rgmol.findRgroupIndex(patom.getRgroup())) == -1) continue;
            int[] pair = new int[]{patom.getLigandOrder(rgroup.getAtom(path[k - 1])) - 1, patom.getLigandOrder(rgroup.getAtom(path[k + 1])) - 1};
            AromUtil.markShortestPathsInRgroupMembers(rgmol, rgindex, pair, markers);
        }
    }

    private static void markShortestPathsInRgroupMembers(RgMolecule rgmol, int rgindex, int[] pair, Set<String> markers) {
        int memberCount = rgmol.getRgroupMemberCount(rgindex);
        for (int j = 0; j < memberCount; ++j) {
            Molecule rgroup = rgmol.getRgroupMember(rgindex, j);
            int[] path = new int[rgroup.getAtomCount()];
            ShortestPath shortestPath = AromUtil.getShortestPath(rgroup);
            MolAtom[] attachments = MolImportUtil.getAttachments(rgroup);
            int a1 = rgroup.indexOf(attachments[pair[0]]);
            int a2 = rgroup.indexOf(attachments[pair[1]]);
            int count = shortestPath.getPath(a1, a2, path);
            AromUtil.markShortestPath(rgmol, rgroup, path, count, markers);
        }
    }

    static void copyAmbigAromRingMarkers(MolAtom to, MolAtom from1, MolAtom from2) {
        Set<String> commonMarkers = AromUtil.getCommonAmbigAromRingMarkers(from1, from2);
        for (String marker : commonMarkers) {
            AromUtil.markAtom(to, marker);
        }
    }

    public static void clearAmbigAromRingMarkers(Molecule mol) {
        MoleculeGraph union = mol.getGraphUnion();
        int count = union.getAtomCount();
        for (int i = 0; i < count; ++i) {
            AromUtil.clearAmbigAromRingMarkers(union.getAtom(i));
        }
    }

    private static void clearAmbigAromRingMarkers(MolAtom atom) {
        Set<String> markers = AromUtil.getAmbigAromRingMarkers(atom);
        for (String marker : markers) {
            AromUtil.unmarkAtom(atom, marker);
        }
    }

    public static int[] getMarkedRing(Molecule mol) {
        for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom = mol.getAtom(i);
            if (!AromUtil.isMarkedAtom(atom, AMBIG_RING)) continue;
            return AromUtil.getMarkedRing(mol, atom);
        }
        return null;
    }

    private static int[] getMarkedRing(Molecule mol, MolAtom atom) {
        IntVector v = new IntVector();
        v.addElement(mol.indexOf(atom));
        MolAtom head = atom;
        MolAtom prev = null;
        MolAtom next = null;
        while ((next = AromUtil.getNextMarkedAtom(atom, prev)) != head) {
            prev = atom;
            atom = next;
            v.addElement(mol.indexOf(atom));
        }
        return v.toArray();
    }

    private static MolAtom getNextMarkedAtom(MolAtom atom, MolAtom prev) {
        for (int i = atom.getBondCount() - 1; i >= 0; --i) {
            MolAtom next = atom.getLigand(i);
            if (next == prev || !AromUtil.isMarkedAtom(next, AMBIG_RING)) continue;
            return next;
        }
        return null;
    }

    public static void markAtoms(MoleculeGraph union, int[] indexes) {
        AromUtil.markAtoms(union, indexes, AMBIG_RING);
    }

    public static void markAtoms(MoleculeGraph union, int[] indexes, int markerIndex) {
        AromUtil.markAtoms(union, indexes, AromUtil.createAmbigAromRingMarker(markerIndex));
    }

    private static void markAtoms(MoleculeGraph union, int[] indexes, String marker) {
        for (int i = 0; i < indexes.length; ++i) {
            AromUtil.markAtom(union.getAtom(indexes[i]), marker);
        }
    }

    public static void unmarkAtoms(MoleculeGraph union, int[] indexes, String marker) {
        for (int i = 0; i < indexes.length; ++i) {
            AromUtil.unmarkAtom(union.getAtom(indexes[i]), marker);
        }
    }

    public static void unmarkMol(MoleculeGraph union) {
        AromUtil.unmarkMol(union, AMBIG_RING);
    }

    public static void unmarkMol(MoleculeGraph union, String marker) {
        for (int i = union.getAtomCount() - 1; i >= 0; --i) {
            AromUtil.unmarkAtom(union.getAtom(i), marker);
        }
    }

    public static boolean initAromatize(RgMolecule rgmol) {
        boolean multiattach = false;
        block0: for (int i = rgmol.getRgroupCount() - 1; i >= 0; --i) {
            for (int j = rgmol.getRgroupMemberCount(i) - 1; j >= 0; --j) {
                Molecule rgroup = rgmol.getRgroupMember(i, j);
                if (AromUtil.getShortestPath(rgroup) != null) {
                    return true;
                }
                if (AromUtil.hasMultipleAttachments(rgroup)) {
                    multiattach = true;
                    ShortestPath shortestPath = new ShortestPath();
                    shortestPath.calculate(rgroup);
                    AromUtil.setShortestPath(rgroup, shortestPath);
                    continue;
                }
                if (rgroup.getAtomCount() > 1) continue block0;
            }
        }
        return multiattach;
    }

    private static boolean hasMultipleAttachments(MoleculeGraph m) {
        int count = 0;
        for (int i = m.getAtomCount() - 1; i >= 0; --i) {
            if (m.getAtom(i).getAtno() != 138 || ++count <= 1) continue;
            return true;
        }
        return false;
    }

    public static int[][] getSSSR(MoleculeGraph mol) {
        if (!mol.isLargeMolecule()) {
            return mol.getSSSR();
        }
        String ATOMINDEX = "ATOMINDEX";
        for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            mol.getAtom(i).putProperty("ATOMINDEX", i);
        }
        MoleculeGraph[] frags = mol.findBasicFrags(SelectionMolecule.class);
        ArrayList<int[]> sssrList = new ArrayList<int[]>();
        for (MoleculeGraph frag : frags) {
            int[][] sssr;
            for (int[] r : sssr = frag.getSSSR()) {
                for (int i = 0; i < r.length; ++i) {
                    r[i] = (Integer)frag.getAtom(r[i]).getProperty("ATOMINDEX");
                }
                sssrList.add(r);
            }
        }
        for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            mol.getAtom(i).removeProperty("ATOMINDEX");
        }
        return (int[][])sssrList.toArray((T[])new int[sssrList.size()][]);
    }

    public static void finishAromatize(Molecule mol) {
        if (mol instanceof RgMolecule) {
            RgMolecule rgmol = (RgMolecule)mol;
            for (int i = rgmol.getRgroupCount() - 1; i >= 0; --i) {
                for (int j = rgmol.getRgroupMemberCount(i) - 1; j >= 0; --j) {
                    AromUtil.clearShortestPath(rgmol.getRgroupMember(i, j));
                }
            }
        }
    }

    private static int[] getAtomIndexes(MoleculeGraph mol, MolAtom[] atoms) {
        int[] indexes = new int[atoms.length];
        for (int i = 0; i < atoms.length; ++i) {
            if (atoms[i] == null) {
                return null;
            }
            indexes[i] = mol.indexOf(atoms[i]);
        }
        return indexes;
    }

    public static void aromatize(MolAtom ratom, Molecule rgroup) {
        ShortestPath shortestPath = AromUtil.getShortestPath(rgroup);
        if (shortestPath == null) {
            return;
        }
        int[][] attachmentPairs = AromUtil.getAromaticAttachmentPairs(ratom, rgroup);
        if (attachmentPairs == null) {
            return;
        }
        MolAtom[] attachments = MolImportUtil.getAttachments(rgroup);
        int[] path = new int[rgroup.getAtomCount()];
        for (int[] pair : attachmentPairs) {
            int a1 = rgroup.indexOf(attachments[pair[0]]);
            int a2 = rgroup.indexOf(attachments[pair[1]]);
            int count = shortestPath.getPath(a1, a2, path);
            for (int k = count - 1; k >= 1; --k) {
                MolBond bond = rgroup.getAtom(path[k]).getBondTo(rgroup.getAtom(path[k - 1]));
                bond.setType(4);
            }
        }
    }

    private static int[][] getAromaticAttachmentPairs(MolAtom ratom, Molecule rgroup) {
        if (rgroup.getBondCount() == 0) {
            return null;
        }
        if (!AromUtil.hasAromaticBond(ratom)) {
            return null;
        }
        MolAtom[] rligands = MolImportUtil.getLigandsInOrder(ratom);
        IntVector aromAttachments = new IntVector();
        for (int i = 0; i < rligands.length; ++i) {
            MolBond bond = ratom.getBondTo(rligands[i]);
            if (bond.getType() != 4) continue;
            aromAttachments.add(i);
        }
        int size = aromAttachments.size();
        if (size < 2) {
            return null;
        }
        if (size == 2) {
            return new int[][]{{aromAttachments.get(0), aromAttachments.get(1)}};
        }
        ArrayList<int[]> pairs = new ArrayList<int[]>();
        MoleculeGraph mol = ratom.getParent();
        assert (mol != null);
        int[][] sssr = mol.getSSSR();
        for (int i = 0; i < size; ++i) {
            int attach1 = aromAttachments.get(i);
            int a = mol.indexOf(rligands[attach1]);
            for (int j = i + 1; j < size; ++j) {
                int attach2 = aromAttachments.get(j);
                int b = mol.indexOf(rligands[attach2]);
                if (!AromUtil.sameRing(a, b, sssr)) continue;
                pairs.add(new int[]{attach1, attach2});
            }
        }
        return (int[][])pairs.toArray((T[])new int[pairs.size()][]);
    }

    private static boolean sameRing(int a, int b, int[][] sssr) {
        for (int[] r : sssr) {
            int k = 0;
            for (int x : r) {
                if (x == a) {
                    ++k;
                }
                if (x != b) continue;
                ++k;
            }
            if (k != 2) continue;
            return true;
        }
        return false;
    }

    public static void markushAromatize(MolAtom ratom, Molecule rgroup) {
        if (!AromUtil.isMarkedAtom(ratom, AMBIG_RING)) {
            return;
        }
        if (rgroup.getAtomCount() == 1) {
            AromUtil.markAtom(rgroup.getAtom(0), AMBIG_RING);
            return;
        }
        MolAtom[] attachments = MolImportUtil.getAttachments(rgroup);
        MolAtom[] rligands = MolImportUtil.getLigandsInOrder(ratom);
        int a1 = -1;
        int a2 = -1;
        for (int i = 0; i < rligands.length; ++i) {
            if (!AromUtil.isMarkedAtom(rligands[i], AMBIG_RING)) continue;
            if (a1 == -1) {
                a1 = rgroup.indexOf(attachments[i]);
                continue;
            }
            a2 = rgroup.indexOf(attachments[i]);
            break;
        }
        assert (a1 != -1);
        assert (a2 != -1);
        ShortestPath shortestPath = AromUtil.getShortestPath(rgroup);
        int[] path = new int[shortestPath.minDist(a1, a2) + 1];
        shortestPath.getPath(a1, a2, path);
        for (int k = 0; k < path.length; ++k) {
            AromUtil.markAtom(rgroup.getAtom(path[k]), AMBIG_RING);
        }
    }

    private static boolean hasAromaticBond(MolAtom atom) {
        for (int i = atom.getBondCount() - 1; i >= 0; --i) {
            if (atom.getBond(i).getType() != 4) continue;
            return true;
        }
        return false;
    }
}

