/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration;

import chemaxon.enumeration.ExpansionUtil;
import chemaxon.enumeration.MolEnumerator;
import chemaxon.enumeration.SelectionUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.Arrays;

public class AtomListEnumerator
extends MolEnumerator {
    private Molecule mol = null;
    private int listNode = -1;
    private int listIndex = -1;
    private int[] listAtnos = null;

    private static int findAtomListNode(Molecule molP) {
        int count = molP.getAtomCount();
        for (int i = 0; i < count; ++i) {
            MolAtom ma = molP.getAtom(i);
            if (!SelectionUtil.isSelected(ma) || ma.getAtno() != 128) continue;
            return i;
        }
        return -1;
    }

    public AtomListEnumerator() {
    }

    public AtomListEnumerator(Molecule molP) {
        this.setMol(molP);
    }

    @Override
    public void setMol(Molecule molP) {
        this.mol = molP;
        this.init();
    }

    @Override
    public Object clone() {
        AtomListEnumerator ale = (AtomListEnumerator)super.clone();
        ale.mol = this.mol;
        ale.listNode = this.listNode;
        ale.listIndex = this.listIndex;
        ale.listAtnos = this.listAtnos;
        ale.randomPossibilities = this.randomPossibilities;
        return ale;
    }

    private void init() {
        this.listNode = AtomListEnumerator.findAtomListNode(this.mol);
        if (this.listNode != -1) {
            this.listAtnos = this.mol.getAtom(this.listNode).getList();
            this.listIndex = 0;
            this.randomPossibilities = new double[this.getBranchCount()];
            Arrays.fill(this.randomPossibilities, 1.0);
        } else {
            this.listAtnos = null;
            this.listIndex = -1;
            this.randomPossibilities = null;
        }
    }

    @Override
    protected boolean hasMoreElements0() {
        boolean retVal;
        boolean bl = retVal = this.listNode != -1 && this.listIndex < this.listAtnos.length;
        if (this.random && this.numOfEnums - this.numOfGeneratedEnumerates <= 0) {
            retVal = false;
        }
        return retVal;
    }

    @Override
    protected Molecule nextElement0() {
        assert (this.random == this.random);
        if (this.hasMoreElements0()) {
            Molecule mol1 = this.generateOutMol(this.random);
            return mol1;
        }
        return null;
    }

    @Override
    protected int getBranchIndex() {
        return this.listIndex;
    }

    @Override
    protected int getBranchCount() {
        return this.listAtnos.length;
    }

    @Override
    protected int getRandomBranchIndex() {
        return this.randomGenerator.generate(this.randomPossibilities);
    }

    @Override
    protected int incrementAndGetBranchIndex() {
        return ++this.listIndex;
    }

    private Molecule generateOutMol(boolean random) {
        int select;
        Molecule outmol = ExpansionUtil.cloneMolecule(this.mol);
        if (random) {
            if (this.numOfEnumsFromBranch == null) {
                this.initNumOfEnumsFromBranch();
            }
            select = this.getIndexOfBranchToEnumerateFrom();
        } else {
            select = this.listIndex++;
        }
        MolAtom atom = outmol.getAtom(this.listNode);
        atom.setList(null);
        atom.setAtno(this.listAtnos[select]);
        if (this.getEnumCodeNeeded()) {
            this.addMarkushCodeToMolecule(outmol, "A" + ((Integer)this.mol.getAtom(this.listNode).getProperty("EnumIndex") + 1) + ":" + (select + 1));
        }
        return outmol;
    }
}

