/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration;

import chemaxon.enumeration.ExpansionUtil;
import chemaxon.enumeration.MolEnumerator;
import chemaxon.enumeration.SelectionUtil;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.Arrays;

public class BondListEnumerator
extends MolEnumerator {
    static final int[][] BOND_TYPES = ExpansionUtil.BOND_TYPES;
    Molecule mol = null;
    int listBond = -1;
    int typeIndex = -1;
    int[] bondTypes = null;

    int findBondList(Molecule molP) {
        int count = molP.getBondCount();
        for (int i = 0; i < count; ++i) {
            MolBond mb = molP.getBond(i);
            if (!SelectionUtil.isSelected(mb.getAtom1()) || !SelectionUtil.isSelected(mb.getAtom2()) || !BondListEnumerator.isQuery(mb)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isQuery(MolBond mb) {
        int type = mb.getType();
        return (type < 1 || type > 4) && type != 9;
    }

    public BondListEnumerator() {
    }

    public BondListEnumerator(Molecule molP) {
        this.setMol(molP);
    }

    @Override
    public void setMol(Molecule molP) {
        this.mol = molP;
        this.init();
    }

    @Override
    public Object clone() {
        BondListEnumerator ble = (BondListEnumerator)super.clone();
        ble.mol = this.mol;
        ble.listBond = this.listBond;
        ble.typeIndex = this.typeIndex;
        ble.bondTypes = this.bondTypes;
        ble.randomPossibilities = this.randomPossibilities;
        return ble;
    }

    void init() {
        this.listBond = this.findBondList(this.mol);
        if (this.listBond != -1) {
            this.bondTypes = this.getBondTypes(this.mol.getBond(this.listBond));
            this.typeIndex = 0;
            this.randomPossibilities = new double[this.getBranchCount()];
            Arrays.fill(this.randomPossibilities, 1.0);
        } else {
            this.bondTypes = null;
            this.typeIndex = -1;
            this.randomPossibilities = null;
        }
    }

    @Override
    protected int getBranchIndex() {
        return this.typeIndex;
    }

    @Override
    protected int getBranchCount() {
        return this.bondTypes.length;
    }

    @Override
    protected int getRandomBranchIndex() {
        return this.randomGenerator.generate(this.randomPossibilities);
    }

    @Override
    protected int incrementAndGetBranchIndex() {
        return ++this.typeIndex;
    }

    @Override
    protected boolean hasMoreElements0() {
        boolean retVal;
        boolean bl = retVal = this.listBond != -1 && this.typeIndex < this.bondTypes.length;
        if (this.random && this.numOfEnums - this.numOfGeneratedEnumerates <= 0) {
            retVal = false;
        }
        return retVal;
    }

    @Override
    protected Molecule nextElement0() {
        if (this.hasMoreElements0()) {
            Molecule mol1 = this.generateOutMol(this.random);
            return mol1;
        }
        return null;
    }

    Molecule generateOutMol(boolean random) {
        int select;
        Molecule outmol = ExpansionUtil.cloneMolecule(this.mol);
        if (random) {
            if (this.numOfEnumsFromBranch == null) {
                this.initNumOfEnumsFromBranch();
            }
            select = this.getIndexOfBranchToEnumerateFrom();
        } else {
            select = this.typeIndex++;
        }
        outmol.getBond(this.listBond).setType(this.bondTypes[select]);
        if (this.getEnumCodeNeeded()) {
            MolBond b = this.mol.getBond(this.listBond);
            String enumCode = "B" + ((Integer)b.getAtom1().getProperty("EnumIndex") + 1) + "-" + ((Integer)b.getAtom2().getProperty("EnumIndex") + 1) + ":" + (select + 1);
            this.addMarkushCodeToMolecule(outmol, enumCode);
        }
        return outmol;
    }

    int[] getBondTypes(MolBond bond) {
        return BOND_TYPES[bond.getType()];
    }
}

