/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration;

import chemaxon.enumeration.ExpansionCounter;
import chemaxon.enumeration.MarkushEnumeratorFactory;
import chemaxon.enumeration.MolEnumerator;
import chemaxon.enumeration.SearchEnumerator;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;
import chemaxon.util.CLQ;
import chemaxon.util.ConfigTools;
import chemaxon.util.MolFilter;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Enumerator {
    private static final String NL = System.getProperty("line.separator");
    private static final String HELPTEXT = "MolEnumerator , (C) 1999-2012 ChemAxon Ltd." + NL + "Molecule enumerator." + NL + "Usage:" + NL + "  enumerate [input file(s)] -e <enumeration-code> [options]" + NL + "  count     [input file(s)] [options]" + NL + NL + "Options: " + NL + "  -h, --help                           this help message" + NL + "  -a, --atom-indexes <list>            enumerate atom list specified by" + NL + "                                       a comma separated list of 1-based" + NL + "                                       union atom indexes" + NL + NL + "Enumeration options:" + NL + "  -e, --enumerate [lrabmtA]            enumerate a combination of:" + NL + "                                       l - link nodes and repeating units" + NL + "                                       r - R-groups" + NL + "                                       a - atom lists" + NL + "                                       b - bond lists" + NL + "                                       m - multiple position bonds" + NL + "                                       t - tautomers" + NL + "                                       A - ambiguous aromaticity" + NL + "                                       (default: count lrabm)" + NL + "  -r, --random                         random enumeration" + NL + "  -o, --code                           generate enumeration code" + NL + "  -i, --structureid <ID or tag name>   Markush structure ID" + NL + "                                       or SDF/MRV tag name storing the ID" + NL + "                                       to be used in the enumeration code" + NL + "                                       (default: no structure ID)" + NL + "  -m, --max <count>                    max number of structures" + NL + "                                       (default: 1 for random enumeration," + NL + "                                       otherwise returns all enumerations)" + NL + "  -f, --format <format>                output file format (default: smiles)" + NL + "  -C, --clean <dim[:opts]>             clean output molecules (dim: 2 or 3)" + NL + "                                       with options" + NL + "                                       (default: t2000 - time limit: 2 sec)" + NL + "            (see http://www.chemaxon.com/marvin/help/sci/cleanoptions.html)" + NL + "  -n, --no-valence-check               no valence check, all enumerations," + NL + "                                       including molecules with valence errors" + NL + "                                       ('count' always counts all enumerations)" + NL + NL + "Count options:" + NL + "  -m, --mode [small|large|magnitude]   count mode:" + NL + "                                       small - counts if less than 2^63" + NL + "                                       large - counts always" + NL + "                                       magnitude - number of digits" + NL + "                                       (default: large)" + NL + NL + "Output options:" + NL + "  -o, --output <filepath>              output file (default: standard output)" + NL + NL + "Examples:" + NL + "  enumerate mols.sdf -e lrabm -f sdf -C 2 -o out.sdf" + NL + "  enumerate mols.sdf -e rab -a 2,5,10" + NL + "  count mols.sdf" + NL;

    public static void main(String[] args) throws Exception {
        PrintStream out;
        CLQ clq = new CLQ(args, null);
        if (args.length == 0 || clq.lookup("-h", "--help", "", 1, false, false) != null) {
            System.out.println(HELPTEXT);
            return;
        }
        CLQ.Parameter pAtoms = clq.lookup("-a", "--atom-indexes", "", 2, false, false);
        String atoms = pAtoms == null ? null : pAtoms.getString();
        int[] indexes = Enumerator.getAtomIndexes(atoms);
        CLQ.Parameter pCode = clq.lookup("-e", "--enumerate", "", 2, false, false);
        String commands = pCode == null ? null : pCode.getString();
        CLQ.Parameter pOutput = clq.lookup("-o", "--output", "", 2, false, false);
        PrintStream printStream = out = pOutput == null ? new PrintStream(new BufferedOutputStream(System.out)) : new PrintStream(new BufferedOutputStream(new FileOutputStream(pOutput.getString())));
        if (commands != null) {
            String cleanStr;
            int len;
            boolean random = clq.lookup("-r", "--random", "", 1, false, false) != null;
            boolean enumCodeNeeded = clq.lookup("-o", "--code", "", 1, false, false) != null;
            CLQ.Parameter pStructureID = clq.lookup("-i", "--structureid", "", 2, false, false);
            String structureID = pStructureID == null ? null : pStructureID.getString();
            CLQ.Parameter pMax = clq.lookup("-m", "--max", "", 2, false, false);
            int max = pMax == null ? (random ? 1 : -1) : pMax.getInt();
            CLQ.Parameter pFormat = clq.lookup("-f", "--format", "", 2, false, false);
            String format2 = pFormat == null ? "smiles" : pFormat.getString();
            CLQ.Parameter pClean = clq.lookup("-C", "--clean", "", 2, false, false);
            int cleanDim = 0;
            String cleanOpts = "t2000";
            if (pClean != null && (len = (cleanStr = pClean.getString()).length()) > 0) {
                cleanDim = Integer.parseInt(cleanStr.substring(0, 1));
                if (len > 2) {
                    cleanOpts = cleanStr.substring(2);
                } else if (len == 2) {
                    cleanOpts = null;
                }
            }
            boolean checkValence = clq.lookup("-n", "--no-valence-check", "", 1, false, false) == null;
            MolFilter filter = checkValence ? MarkushEnumeratorFactory.FILTER_VALENCE : null;
            MolImporter[] importers = ConfigTools.getTargetMolImporters(clq);
            MolExporter exporter = new MolExporter(out, format2);
            Enumerator.enumerate(commands, importers, random, max, indexes, exporter, cleanDim, cleanOpts, filter, enumCodeNeeded, structureID);
        } else {
            CLQ.Parameter pMode = clq.lookup("-m", "--mode", "", 2, false, false);
            String mode = pMode == null ? "large" : pMode.getString();
            MolImporter[] importers = ConfigTools.getTargetMolImporters(clq);
            Enumerator.count(mode, importers, indexes, out);
        }
    }

    private static int[] getAtomIndexes(String list) throws NumberFormatException {
        if (list == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(list, ", ");
        int[] inds = new int[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            inds[i++] = Integer.parseInt(st.nextToken()) - 1;
        }
        return inds;
    }

    private static void enumerate(String commands, MolImporter[] importers, boolean random, int max, int[] indexes, MolExporter exporter, int cleanDim, String cleanOpts, MolFilter filter, boolean enumCodeNeeded, String structureID) throws Exception {
        Hashtable<String, Integer> enumCommands = new Hashtable<String, Integer>();
        enumCommands.put("l", new Integer(4097));
        enumCommands.put("r", new Integer(8));
        enumCommands.put("a", new Integer(16));
        enumCommands.put("b", new Integer(32));
        enumCommands.put("m", new Integer(2048));
        enumCommands.put("t", new Integer(2));
        enumCommands.put("A", new Integer(4));
        enumCommands.put("v1", new Integer(64));
        enumCommands.put("v2", new Integer(192));
        enumCommands.put("v3", new Integer(320));
        int features = 0;
        for (int i = 0; i < commands.length(); ++i) {
            Integer code = null;
            String c = null;
            for (int cl = 2; cl >= 1; --cl) {
                if (i + cl > commands.length() || (code = (Integer)enumCommands.get(c = commands.substring(i, i + cl))) == null) continue;
                features |= code.intValue();
                i += cl - 1;
                break;
            }
            if (code != null) continue;
            throw new IllegalArgumentException("Invalid command: " + c);
        }
        int markushFeatures = SearchEnumerator.getMarkushFeatures(features);
        int queryFeatures = SearchEnumerator.getQueryFeatures(features);
        MarkushEnumeratorFactory factory = new MarkushEnumeratorFactory(markushFeatures);
        factory.setFilter(filter);
        factory.setRandom(random);
        factory.setEnumCodeNeeded(enumCodeNeeded);
        factory.setStructureID(structureID);
        Molecule mol = null;
        for (int i = 0; i < importers.length; ++i) {
            while ((mol = importers[i].read()) != null) {
                MolEnumerator me = factory.createEnumerator(mol, indexes);
                SearchEnumerator se = new SearchEnumerator(me, queryFeatures);
                while (se.hasMoreElements() && (max == -1 || max-- > 0)) {
                    Molecule eMol = se.nextElement();
                    if (cleanDim != 0) {
                        eMol.clean(cleanDim, cleanOpts);
                    }
                    exporter.write(eMol);
                }
            }
            importers[i].close();
        }
        exporter.close(2);
    }

    private static void count(String mode, MolImporter[] importers, int[] indexes, PrintStream out) throws Exception {
        ExpansionCounter counter = new ExpansionCounter();
        char m = mode.toUpperCase().charAt(0);
        String result = null;
        Molecule mol = null;
        for (int i = 0; i < importers.length; ++i) {
            while ((mol = importers[i].read()) != null) {
                counter.setMolecule(mol, indexes);
                switch (m) {
                    case 'S': {
                        result = String.valueOf(counter.countExpansions());
                        break;
                    }
                    default: {
                        result = counter.countExpansionsString();
                        break;
                    }
                    case 'M': {
                        result = String.valueOf(counter.countExpansionsMagnitude());
                    }
                }
                out.println(result);
            }
            importers[i].close();
        }
        out.flush();
        if (out != System.out) {
            out.close();
        }
    }
}

