/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration;

import chemaxon.common.util.IntVector;
import chemaxon.enumeration.AromUtil;
import chemaxon.enumeration.ExpansionCounter;
import chemaxon.enumeration.ExpansionException;
import chemaxon.enumeration.bracket.PolymerUtil;
import chemaxon.enumeration.homology.HomologyConstants;
import chemaxon.markush.graph.ExpansionGraphUtil;
import chemaxon.markush.graph.UnsupportedMarkushException;
import chemaxon.markush.properties.EnumerationCountAssembler;
import chemaxon.marvin.util.MolImportUtil;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.struc.sgroup.MulticenterSgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;

public class ExpansionUtil {
    private static final Logger logger = Logger.getLogger(ExpansionUtil.class.getName());
    public static final int MAX_ENUM_COUNT = 10;
    private static final String ORIGINDEX = "ORIGINDEX";
    private static final String LINKNODE_ALLBONDS = "LINKNODE_ALLBONDS";
    private static final String LINKNODE_OUTERBONDS = "LINKNODE_OUTERBONDS";
    private static final String LINKNODE_REPETITIONS = "LINKNODE_REPETITIONS";
    private static final String HELPER = "HELPER";
    public static final int[][] BOND_TYPES = new int[16][];

    public static Molecule cloneMolecule(Molecule mol) {
        Molecule cloned = mol.cloneMolecule();
        cloned.setValenceCheckEnabled(false);
        return cloned;
    }

    public static MolBond cloneBond(MolBond bond, MolAtom atom, MolAtom newAtom, MolAtom newOtherAtom) {
        return bond.getAtom1() == atom ? bond.cloneBond(newAtom, newOtherAtom) : bond.cloneBond(newOtherAtom, newAtom);
    }

    public static int countAttachments(Molecule rgroup) {
        return MolImportUtil.countAttachments(rgroup);
    }

    public static int countAttachments(MolAtom atom) {
        int count = 0;
        for (int i = atom.getBondCount() - 1; i >= 0; --i) {
            if (atom.getLigand(i).getAtno() != 138) continue;
            ++count;
        }
        return count;
    }

    public static void insertRgroupMember(Molecule mol, MolAtom atom, Molecule rgroup, boolean transform) throws IllegalArgumentException {
        if (ExpansionUtil.getMulticenterSgroups(mol, atom).length > 0) {
            throw new IllegalArgumentException("R-atom in multicenter group: " + (mol.getGraphUnion().indexOf(atom) + 1));
        }
        MolBond[] linkBonds = new MolBond[atom.getBondCount()];
        MolAtom[] outerAtoms = new MolAtom[linkBonds.length];
        MolAtom[][] outerLigands = new MolAtom[linkBonds.length][];
        for (int i = 0; i < linkBonds.length; ++i) {
            int index = atom.getLigandOrder(atom.getLigand(i)) - 1;
            linkBonds[index] = atom.getBond(i);
            outerAtoms[index] = atom.getLigand(i);
            if (outerAtoms[index].getAtno() == 134) {
                outerLigands[index] = MolImportUtil.getLigandsInOrder(outerAtoms[index]);
            }
            ExpansionUtil.storeData(mol, outerAtoms[i]);
        }
        Sgroup sgroup = mol.findSgroupOf(atom);
        if (sgroup instanceof DataSgroup) {
            sgroup = null;
        }
        mol.removeAtom(atom);
        ExpansionUtil.insertRgroupMember(mol, atom, rgroup, linkBonds, outerLigands, transform, sgroup);
        for (int i = 0; i < outerAtoms.length; ++i) {
            if (outerAtoms[i] == null) continue;
            ExpansionUtil.restoreData(mol, outerAtoms[i]);
        }
    }

    public static void insertRgroupMember(Molecule mol, MolAtom atom, Molecule rgroup, MolBond[] linkBonds, MolAtom[][] outerLigands, boolean transform, Sgroup sgroup) throws IllegalArgumentException {
        int i;
        MolAtom[] attachments;
        MolAtom[] outerAtoms = new MolAtom[linkBonds.length];
        for (int i2 = 0; i2 < outerAtoms.length; ++i2) {
            outerAtoms[i2] = linkBonds[i2].getOtherAtom(atom);
        }
        for (MolAtom attachment : attachments = MolImportUtil.getAttachments(rgroup)) {
            if (attachment.getBondCount() != 1) {
                throw new IllegalArgumentException("R-group attachments should have exactly one ligand.");
            }
            if (attachment.getLigand(0).getAtno() != 138) continue;
            throw new IllegalArgumentException("Bond with both end-atoms being attachment is not allowed.");
        }
        Object[] innerAtoms = new MolAtom[outerAtoms.length];
        if (attachments.length >= outerAtoms.length) {
            for (i = 0; i < outerAtoms.length; ++i) {
                innerAtoms[i] = attachments[i].getLigand(0);
            }
            for (i = outerAtoms.length; i < attachments.length; ++i) {
                rgroup.removeAtom(attachments[i]);
            }
        } else if (rgroup.getAtomCount() - attachments.length == 1) {
            for (i = 0; i < attachments.length; ++i) {
                rgroup.removeAtom(attachments[i]);
            }
            MolAtom innerAtom = rgroup.getAtom(0);
            Arrays.fill(innerAtoms, innerAtom);
            attachments = new MolAtom[innerAtoms.length];
            for (int i3 = 0; i3 < attachments.length; ++i3) {
                attachments[i3] = innerAtom.addRgroupAttachmentPoint(i3 + 1, 1);
            }
        } else {
            throw new IllegalArgumentException("Inconsistent R-group attachment data for R" + atom.getRgroup() + "\n" + "attachments.length = " + attachments.length + "\n" + "innerAtoms.length = " + innerAtoms.length + "\n" + "outerAtoms.length = " + outerAtoms.length);
        }
        if (transform && innerAtoms.length != 0 && outerAtoms.length != 0) {
            ExpansionUtil.transformRgroupMember(mol, atom, rgroup, (MolAtom[])innerAtoms, outerAtoms);
        }
        mol.fuse(rgroup, false);
        if (sgroup != null) {
            for (int i4 = rgroup.getAtomCount() - 1; i4 >= 0; --i4) {
                mol.setSgroupParent(rgroup.getAtom(i4), sgroup, true);
            }
        }
        for (int i5 = 0; i5 < linkBonds.length; ++i5) {
            boolean success;
            MolAtom[] innerLigands = ((MolAtom)innerAtoms[i5]).getAtno() == 134 ? MolImportUtil.getLigandsInOrder((MolAtom)innerAtoms[i5]) : null;
            mol.removeAtom(attachments[i5]);
            MolBond newLinkBond = ExpansionUtil.cloneBond(linkBonds[i5], outerAtoms[i5], outerAtoms[i5], (MolAtom)innerAtoms[i5]);
            mol.add(newLinkBond);
            if (innerLigands != null) {
                ExpansionUtil.replace(innerLigands, attachments[i5], outerAtoms[i5]);
                success = MolImportUtil.setLigandOrders((MolAtom)innerAtoms[i5], innerLigands);
                assert (success);
            }
            if (outerLigands == null || outerLigands[i5] == null) continue;
            ExpansionUtil.replace(outerLigands[i5], atom, (MolAtom)innerAtoms[i5]);
            success = MolImportUtil.setLigandOrders(outerAtoms[i5], outerLigands[i5]);
            assert (success);
        }
        if (innerAtoms.length >= 2 && innerAtoms[0].equals(innerAtoms[1]) && ExpansionUtil.isSpecialAromatic((MolAtom)innerAtoms[0])) {
            ((MolAtom)innerAtoms[0]).setImplicitHcount(Math.max(((MolAtom)innerAtoms[0]).getImplicitHcount() - 1, 0));
        }
    }

    public static int replace(MolAtom[] atoms, MolAtom from, MolAtom to) {
        for (int i = 0; i < atoms.length; ++i) {
            if (atoms[i] != from) continue;
            atoms[i] = to;
            return i;
        }
        return -1;
    }

    public static boolean isSpecialAromatic(MolAtom a) {
        int atno = a.getAtno();
        int arom = 0;
        if (atno == 7 || atno == 15 || atno == 6 && a.getCharge() == -1) {
            for (int j = a.getBondCount() - 1; j >= 0; --j) {
                if (a.getBond(j).getType() != 4) continue;
                ++arom;
            }
        }
        return arom >= 2;
    }

    private static void transformRgroupMember(Molecule mol, MolAtom atom, Molecule rgroup, MolAtom[] innerAtoms, MolAtom[] outerAtoms) {
        SuperatomSgroup attachSgroup = MolImportUtil.getContainingSuperatomSgroup(innerAtoms[0]);
        MolAtom attachAtom = attachSgroup != null ? attachSgroup.getSuperAtom() : innerAtoms[0];
        CTransform3D rgroupTransform = new CTransform3D();
        rgroupTransform.setTranslation(atom.getX() - attachAtom.getX(), atom.getY() - attachAtom.getY(), atom.getZ() - attachAtom.getZ());
        rgroup.transform(rgroupTransform);
        if (outerAtoms.length > 1) {
            int k;
            int[] fragIds = mol.getFragIds(1);
            for (k = 0; k < outerAtoms.length && outerAtoms[k] == null; ++k) {
            }
            if (k == outerAtoms.length) {
                return;
            }
            int fragId0 = fragIds[mol.indexOf(outerAtoms[k])];
            for (int i = k + 1; i < outerAtoms.length; ++i) {
                int fragId;
                if (outerAtoms[i] == null || (fragId = fragIds[mol.indexOf(outerAtoms[i])]) == fragId0) continue;
                SelectionMolecule frag = new SelectionMolecule();
                mol.findFragById(fragId, 1, frag);
                CTransform3D fragTransform = new CTransform3D();
                fragTransform.setTranslation(innerAtoms[i].getX() - atom.getX(), innerAtoms[i].getY() - atom.getY(), innerAtoms[i].getZ() - atom.getZ());
                frag.transform(fragTransform);
            }
        }
    }

    public static MolBond[] getLinkBonds(Molecule mol, MolAtom atom) {
        MolBond outer0Bond = atom.getBond(atom.getLinkNodeOuterAtom(0));
        MolBond outer1Bond = atom.getBond(atom.getLinkNodeOuterAtom(1));
        MolBond linkerBond = outer0Bond;
        if (linkerBond.getType() > outer1Bond.getType()) {
            linkerBond = outer1Bond;
        }
        return new MolBond[]{outer0Bond, outer1Bond, linkerBond};
    }

    public static void insertLinkPart(Molecule mol, MolAtom atom, int repetitions) throws IllegalArgumentException {
        ExpansionUtil.insertLinkPart(mol, atom, repetitions, null);
    }

    public static void insertLinkPart(Molecule mol, MolAtom atom, int repetitions, boolean colored) throws IllegalArgumentException {
        ExpansionUtil.insertLinkPart(mol, atom, repetitions, null, colored);
    }

    public static void insertLinkPart(Molecule mol, MolAtom atom, int repetitions, SelectionMolecule outPart) throws IllegalArgumentException {
        ExpansionUtil.insertLinkPart(mol, atom, repetitions, outPart, false);
    }

    public static void insertLinkPart(Molecule mol, MolAtom atom, int repetitions, SelectionMolecule outPart, boolean colored) throws IllegalArgumentException {
        String LIGAND_INDEX = "LIGAND_INDEX";
        MolBond[] linkBonds = ExpansionUtil.getLinkBonds(mol, atom);
        MolBond outer0Bond = linkBonds[0];
        MolBond outer1Bond = linkBonds[1];
        MolBond linkerBond = linkBonds[2];
        MolAtom outer0Atom = outer0Bond.getOtherAtom(atom);
        MolAtom outer1Atom = outer1Bond.getOtherAtom(atom);
        int index = mol.indexOf(atom);
        int index0 = mol.indexOf(outer0Atom);
        int index1 = mol.indexOf(outer1Atom);
        MolAtom[] outer0Ligands = outer0Atom.getAtno() == 134 ? MolImportUtil.getLigandsInOrder(outer0Atom) : null;
        MolAtom[] outer1Ligands = outer1Atom.getAtno() == 134 ? MolImportUtil.getLigandsInOrder(outer1Atom) : null;
        MolAtom[] innerLigands = atom.getAtno() == 134 ? MolImportUtil.getLigandsInOrder(atom) : null;
        int outer0Index = -1;
        int outer1Index = -1;
        if (innerLigands != null) {
            for (int j = 0; j < innerLigands.length; ++j) {
                if (innerLigands[j] == outer0Atom) {
                    outer0Index = j;
                    continue;
                }
                if (innerLigands[j] == outer1Atom) {
                    outer1Index = j;
                    continue;
                }
                innerLigands[j].putProperty("LIGAND_INDEX", j);
            }
        }
        atom.setMaxRepetitions(1);
        atom.setMinRepetitions(1);
        atom.setLinkNodeOuterAtom(0, -1);
        atom.setLinkNodeOuterAtom(1, -1);
        ExpansionUtil.storeData(mol, outer0Atom);
        ExpansionUtil.storeData(mol, outer1Atom);
        mol.removeBond(outer0Bond);
        mol.removeBond(outer1Bond);
        MulticenterSgroup[] sgroups = ExpansionUtil.getMulticenterSgroups(mol, atom);
        boolean[] isInnerGroup = new boolean[sgroups.length];
        Molecule molClone = mol.cloneMolecule();
        MolAtom atomClone = molClone.getAtom(index);
        MulticenterSgroup[] sgroupClones = ExpansionUtil.getMulticenterSgroups(molClone, atomClone);
        for (int i = 0; i < sgroups.length; ++i) {
            sgroups[i].removeAtom(atom);
            sgroupClones[i].removeAtom(atomClone);
        }
        Sgroup sgroup = mol.findSgroupOf(atom);
        if (sgroup instanceof DataSgroup) {
            sgroup = null;
        }
        int[] fragIds = mol.getFragIds(1);
        int fragId = fragIds[index];
        int fragId0 = fragIds[index0];
        int fragId1 = fragIds[index1];
        if (fragId == fragId0 || fragId == fragId1) {
            throw new IllegalArgumentException("Link-node repetition fragment is not well defined.");
        }
        Molecule innerClone = new Molecule();
        molClone.findFrag(index, 1, innerClone);
        if (sgroup != null && ExpansionUtil.containedInMolecule(sgroup, innerClone)) {
            sgroup = null;
        }
        ArrayList<Sgroup> invalidSgroups = new ArrayList<Sgroup>();
        for (int i = innerClone.getSgroupCount() - 1; i >= 0; --i) {
            if (ExpansionUtil.containedInMolecule(innerClone.getSgroup(i), innerClone)) continue;
            invalidSgroups.add(innerClone.getSgroup(i));
        }
        for (Sgroup invalidSgroup : invalidSgroups) {
            innerClone.ungroupSgroup(invalidSgroup);
        }
        if (colored) {
            int i;
            int color = atom.getSetSeq();
            for (i = innerClone.getAtomCount() - 1; i >= 0; --i) {
                if (innerClone.getAtom(i).getSetSeq() != 0) continue;
                innerClone.getAtom(i).setSetSeq(color);
            }
            for (i = innerClone.getBondCount() - 1; i >= 0; --i) {
                innerClone.getBond(i).setSetSeq(63);
            }
            for (i = innerClone.getSgroupCount() - 1; i >= 0; --i) {
                Sgroup sg = innerClone.getSgroup(i);
                if (!(sg instanceof SuperatomSgroup)) continue;
                ((SuperatomSgroup)sg).getSuperAtom().setSetSeq(color);
            }
        }
        boolean outerGroupExists = false;
        for (int i = 0; i < sgroupClones.length; ++i) {
            boolean isOuterGroup = false;
            for (int j = sgroupClones[i].getAtomCount() - 1; j >= 0; --j) {
                if (innerClone.indexOf(sgroupClones[i].getAtom(j)) != -1) {
                    isInnerGroup[i] = true;
                    continue;
                }
                isOuterGroup = true;
            }
            if (isOuterGroup && isInnerGroup[i]) {
                throw new IllegalArgumentException("Illegal multicenter sgroup: contains both link fragment atom and outer atom.");
            }
            if (isInnerGroup[i]) continue;
            outerGroupExists = true;
        }
        SelectionMolecule innerPart = null;
        if (outerGroupExists || outPart != null) {
            innerPart = new SelectionMolecule();
            mol.findFrag(index, 1, innerPart);
        }
        int linkIdxInInner = innerClone.indexOf(atomClone);
        MolAtom nextToLink = atom;
        for (int j = 0; j < sgroups.length; ++j) {
            sgroups[j].add(atom);
            sgroupClones[j].add(atomClone);
        }
        if (outPart != null) {
            outPart.fuse(innerPart, false);
        }
        mol.add(outer0Bond);
        if (outer0Ligands != null) {
            MolImportUtil.setLigandOrders(outer0Atom, outer0Ligands);
        }
        for (int i = 1; i < repetitions; ++i) {
            int j;
            Molecule newInner = i < repetitions - 1 ? innerClone.cloneMolecule() : innerClone;
            MolAtom newLink = newInner.getAtom(linkIdxInInner);
            MolBond newLinkBond = linkerBond.cloneBond(newLink, nextToLink);
            newLinkBond.setFlags(0, 48);
            if (outPart != null) {
                outPart.fuse(newInner, false);
            }
            mol.fuse(newInner, false);
            mol.add(newLinkBond);
            if (innerLigands != null) {
                innerLigands[outer1Index] = newLink;
                MolImportUtil.setLigandOrders(nextToLink, innerLigands);
            }
            if (sgroup != null) {
                for (j = newInner.getAtomCount() - 1; j >= 0; --j) {
                    mol.setSgroupParent(newInner.getAtom(j), sgroup, true);
                }
            }
            for (j = 0; j < sgroups.length; ++j) {
                if (isInnerGroup[j]) continue;
                sgroups[j].add(newLink);
            }
            if (innerLigands != null) {
                innerLigands[outer0Index] = nextToLink;
                for (j = newLink.getBondCount() - 1; j >= 0; --j) {
                    MolAtom ligand = newLink.getLigand(j);
                    if (ligand == nextToLink) continue;
                    int ligandIndex = (Integer)ligand.getProperty("LIGAND_INDEX");
                    innerLigands[ligandIndex] = ligand;
                }
            }
            nextToLink = newLink;
        }
        MolBond newOuter1 = ExpansionUtil.cloneBond(outer1Bond, outer1Atom, outer1Atom, nextToLink);
        mol.add(newOuter1);
        if (innerLigands != null) {
            innerLigands[outer1Index] = outer1Atom;
            MolImportUtil.setLigandOrders(nextToLink, innerLigands);
            for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
                mol.getAtom(i).removeProperty("LIGAND_INDEX");
            }
        }
        if (outer1Ligands != null) {
            ExpansionUtil.replace(outer1Ligands, atom, nextToLink);
            MolImportUtil.setLigandOrders(outer1Atom, outer1Ligands);
        }
        ExpansionUtil.restoreData(mol, outer0Atom);
        ExpansionUtil.restoreData(mol, outer1Atom);
    }

    public static MolBond[][] getXBonds(RepeatingUnitSgroup repeatingUnit) {
        MolBond[] xbonds1 = null;
        MolBond[] xbonds2 = repeatingUnit.getBondCorrespondence();
        if (xbonds2 == null) {
            MolBond[] bonds = repeatingUnit.findCrossingBonds();
            if (bonds.length == 2) {
                if (repeatingUnit.getConnectivity() == 1) {
                    xbonds1 = new MolBond[]{bonds[1], bonds[1]};
                    xbonds2 = new MolBond[]{bonds[0], bonds[0]};
                } else {
                    xbonds1 = new MolBond[]{bonds[0], bonds[1]};
                    xbonds2 = new MolBond[]{bonds[0], bonds[1]};
                }
            }
        } else {
            MolBond[] headBonds = repeatingUnit.getHeadCrossingBonds();
            MolBond[] tailBonds = repeatingUnit.getTailCrossingBonds();
            xbonds1 = xbonds2[1] == headBonds[0] ? new MolBond[]{tailBonds[0], tailBonds[0], tailBonds[1], tailBonds[1]} : (xbonds2[1] == headBonds[1] ? new MolBond[]{tailBonds[0], tailBonds[1], tailBonds[1], tailBonds[0]} : new MolBond[]{xbonds2[0], xbonds2[1], xbonds2[2], xbonds2[3]});
        }
        return new MolBond[][]{xbonds1, xbonds2};
    }

    private static boolean containedInMolecule(Sgroup sgroup, Molecule mol) {
        for (int i = sgroup.getAtomCount() - 1; i >= 0; --i) {
            if (mol.indexOf(sgroup.getAtom(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public static void insertRepeatingPart(Molecule mol, RepeatingUnitSgroup repeatingUnit, int repetitions) throws IllegalArgumentException {
        ExpansionUtil.insertRepeatingPart(mol, repeatingUnit, repetitions, null);
    }

    public static void insertRepeatingPart(Molecule mol, RepeatingUnitSgroup repeatingUnit, int repetitions, SelectionMolecule outPart) throws IllegalArgumentException {
        MolBond[][] xbonds = ExpansionUtil.getXBonds(repeatingUnit);
        MolBond[] xbonds1 = xbonds[0];
        MolBond[] xbonds2 = xbonds[1];
        SelectionMolecule repeatingGraph = repeatingUnit.getSgroupGraph();
        MolAtom[] xatoms1 = xbonds1 != null ? repeatingUnit.getCrossingAtoms(xbonds1) : null;
        MolAtom[] xatoms2 = xbonds2 != null ? repeatingUnit.getCrossingAtoms(xbonds2) : null;
        mol.ungroupSgroup(repeatingUnit, 0);
        ExpansionUtil.insertRepeatingPart(mol, repeatingGraph, repetitions, outPart, xbonds1, xatoms1, xbonds2, xatoms2);
    }

    public static void insertRepeatingPart(Molecule mol, MoleculeGraph repeatingGraph, int repetitions, SelectionMolecule outPart, MolBond[] xbonds1, MolAtom[] xatoms1, MolBond[] xbonds2, MolAtom[] xatoms2) throws IllegalArgumentException {
        int i;
        for (int i2 = repeatingGraph.getAtomCount() - 1; i2 >= 0; --i2) {
            repeatingGraph.getAtom(i2).putProperty(ORIGINDEX, i2);
        }
        int[] xindexes1 = null;
        int[] xindexes2 = null;
        int[] indexes = new int[repeatingGraph.getAtomCount()];
        boolean moiety = xbonds1 == null;
        boolean ladder = !moiety && xbonds1.length == 4;
        ArrayList<MolAtom> inners = new ArrayList<MolAtom>();
        if (repetitions > 0) {
            if (!moiety) {
                ExpansionUtil.storeData(mol, xatoms2[0]);
                inners.add(xatoms2[0]);
                ExpansionUtil.storeData(mol, xatoms1[1]);
                inners.add(xatoms1[1]);
            }
            if (ladder) {
                ExpansionUtil.storeData(mol, xatoms2[2]);
                inners.add(xatoms2[2]);
                ExpansionUtil.storeData(mol, xatoms1[3]);
                inners.add(xatoms1[3]);
            }
        }
        MolAtom outer1 = null;
        if (!moiety) {
            outer1 = xbonds1[1].getOtherAtom(xatoms1[1]);
            ExpansionUtil.storeData(mol, outer1);
            mol.removeBond(xbonds1[1]);
        }
        MolAtom outer2 = null;
        if (ladder) {
            outer2 = xbonds1[3].getOtherAtom(xatoms1[3]);
            ExpansionUtil.storeData(mol, outer2);
            mol.removeBond(xbonds1[3]);
        }
        if (repetitions > 0 && outPart != null) {
            outPart.fuse(repeatingGraph, false);
        }
        Molecule newGraph = null;
        boolean asFirst = true;
        MolAtom link1 = !moiety ? xatoms1[1] : null;
        MolAtom link2 = ladder ? xatoms1[3] : null;
        MolAtom newLink1 = null;
        MolAtom newLink2 = null;
        MolBond newLinkBond1 = null;
        MolBond newLinkBond2 = null;
        int[] old2new = null;
        if (repetitions == 0) {
            for (i = repeatingGraph.getAtomCount() - 1; i >= 0; --i) {
                mol.removeAtom(repeatingGraph.getAtom(i));
            }
            if (!moiety) {
                link1 = xbonds1[0].getOtherAtom(xatoms1[0]);
                newLink1 = outer1;
                if (ladder) {
                    link2 = xbonds1[2].getOtherAtom(xatoms1[2]);
                    newLink2 = outer2;
                }
                if (!(link1 == newLink1 || ladder && link2 == newLink1)) {
                    newLinkBond1 = xbonds1[1].cloneBond(link1, newLink1);
                    newLinkBond1.setFlags(0, 48);
                }
                if (link2 != newLink2 && link2 != newLink1) {
                    newLinkBond2 = xbonds1[3].cloneBond(link2, newLink2);
                    newLinkBond2.setFlags(0, 48);
                }
                if (newLinkBond1 != null) {
                    mol.add(newLinkBond1);
                }
                if (ladder && newLinkBond2 != null) {
                    mol.add(newLinkBond2);
                }
            }
        }
        for (i = repetitions; i > 0; --i) {
            if (i > 1) {
                ExpansionUtil.getAtomIndexes(indexes, repeatingGraph, mol);
                newGraph = new Molecule();
                Molecule root = mol instanceof RgMolecule ? ((RgMolecule)mol).getRoot() : mol;
                root.clonecopy(indexes, newGraph);
                if (!moiety && xindexes1 == null) {
                    old2new = new int[newGraph.getAtomCount()];
                    int j = newGraph.getAtomCount() - 1;
                    while (j >= 0) {
                        int index = (Integer)newGraph.getAtom(j).getProperty(ORIGINDEX);
                        old2new[index] = j--;
                    }
                    xindexes1 = ExpansionUtil.getAtomIndexes(xatoms1, (MoleculeGraph)newGraph, old2new);
                    xindexes2 = ExpansionUtil.getAtomIndexes(xatoms2, (MoleculeGraph)newGraph, old2new);
                }
                if (!moiety) {
                    newLink1 = asFirst ? newGraph.getAtom((int)xindexes1[0]) : newGraph.getAtom((int)xindexes2[0]);
                }
            } else {
                newLink1 = outer1;
            }
            if (!moiety) {
                MolBond newLinkBond1Sample = asFirst ? xbonds1[1] : xbonds2[1];
                newLinkBond1 = newLinkBond1Sample.cloneBond(link1, newLink1);
                newLinkBond1.setFlags(0, 48);
            }
            if (ladder) {
                newLink2 = i > 1 ? (asFirst ? newGraph.getAtom((int)xindexes1[2]) : newGraph.getAtom((int)xindexes2[2])) : outer2;
                MolBond newLinkBond2Sample = asFirst ? xbonds1[3] : xbonds2[3];
                newLinkBond2 = newLinkBond2Sample.cloneBond(link2, newLink2);
                newLinkBond2.setFlags(0, 48);
            }
            if (i > 1) {
                if (!moiety) {
                    MolAtom molAtom = link1 = asFirst ? newGraph.getAtom((int)xindexes2[1]) : newGraph.getAtom((int)xindexes1[1]);
                    link2 = ladder ? (asFirst ? newGraph.getAtom((int)xindexes2[3]) : newGraph.getAtom((int)xindexes1[3])) : null;
                    ExpansionUtil.updateData(xatoms2[0], repeatingGraph, newGraph.getAtom((int)xindexes2[0]), newGraph, old2new, inners);
                    ExpansionUtil.updateData(xatoms1[1], repeatingGraph, newGraph.getAtom(xindexes1[1]), newGraph, old2new, inners);
                    if (ladder) {
                        ExpansionUtil.updateData(xatoms2[2], repeatingGraph, newGraph.getAtom(xindexes2[2]), newGraph, old2new, inners);
                        ExpansionUtil.updateData(xatoms1[3], repeatingGraph, newGraph.getAtom(xindexes1[3]), newGraph, old2new, inners);
                    }
                }
                mol.fuse(newGraph, false);
                if (outPart != null) {
                    outPart.fuse(newGraph, false);
                }
            }
            if (!moiety) {
                mol.add(newLinkBond1);
                if (ladder) {
                    mol.add(newLinkBond2);
                }
            }
            asFirst = !asFirst;
        }
        if (!moiety) {
            for (MolAtom inner : inners) {
                ExpansionUtil.restoreData(mol, inner);
            }
            ExpansionUtil.restoreData(mol, outer1);
            if (outer2 != null) {
                ExpansionUtil.restoreData(mol, outer2);
            }
        }
        for (int i3 = mol.getAtomCount() - 1; i3 >= 0; --i3) {
            MolAtom a = mol.getAtom(i3);
            if (a == null) continue;
            a.removeProperty(ORIGINDEX);
        }
    }

    private static int[] getAtomIndexes(MolAtom[] atoms, MoleculeGraph graph, int[] old2new) {
        int[] indexes = new int[atoms.length];
        for (int i = 0; i < atoms.length; ++i) {
            int oind = (Integer)atoms[i].getProperty(ORIGINDEX);
            indexes[i] = old2new[oind];
        }
        return indexes;
    }

    public static void getAtomIndexes(int[] indexes, MoleculeGraph graph, Molecule mol) {
        for (int i = graph.getAtomCount() - 1; i >= 0; --i) {
            indexes[i] = mol.indexOf(graph.getAtom(i));
        }
    }

    private static MolAtom getOtherLigand(MolAtom atom, MolAtom ligand) {
        MolAtom ligand0 = atom.getLigand(0);
        return ligand0 != ligand ? ligand0 : atom.getLigand(1);
    }

    public static MolAtom createHelperAtom(int set) {
        MolAtom helper = ExpansionUtil.createHelperAtom();
        helper.setSetSeq(set);
        return helper;
    }

    public static MolAtom createHelperAtom() {
        MolAtom helper = new MolAtom(131);
        helper.putProperty(HELPER, "true");
        return helper;
    }

    public static boolean isHelperAtom(MolAtom atom) {
        return atom.containsPropertyKey(HELPER);
    }

    public static void splitBond(Molecule mol, MolBond bond, MolAtom middle, RgMolecule rgmol) {
        MolAtom atom1 = bond.getAtom1();
        MolAtom atom2 = bond.getAtom2();
        AromUtil.copyAmbigAromRingMarkers(middle, atom1, atom2);
        int order1 = atom1.getLigandOrder(atom2);
        int order2 = atom2.getLigandOrder(atom1);
        middle.setXYZ((atom1.getX() + atom2.getX()) / 2.0, (atom1.getY() + atom2.getY()) / 2.0, (atom1.getZ() + atom2.getZ()) / 2.0);
        MolBond bond1 = ExpansionUtil.cloneBond(bond, atom1, atom1, middle);
        int seq = bond1.getSetSeq();
        if (seq != 2) {
            bond1.setSetSeq(1);
            seq = 1;
        }
        MolBond bond2 = ExpansionUtil.cloneBond(bond, atom2, atom2, middle);
        bond2.setSetSeq(3 - seq);
        MolAtom[] ligands1 = MolImportUtil.getLigandsInOrder(atom1);
        MolAtom[] ligands2 = MolImportUtil.getLigandsInOrder(atom2);
        mol.removeBond(bond);
        mol.add(bond1);
        mol.add(bond2);
        ExpansionUtil.replace(ligands1, atom2, middle);
        ExpansionUtil.replace(ligands2, atom1, middle);
        MolImportUtil.setLigandOrders(atom1, ligands1);
        MolImportUtil.setLigandOrders(atom2, ligands2);
    }

    public static void unsplitBond(Molecule mol, MolAtom middle, RgMolecule rgmol) {
        assert (middle.getBondCount() == 2);
        MolAtom atom1 = middle.getLigand(0);
        MolAtom atom2 = middle.getLigand(1);
        int order1 = atom1.getLigandOrder(middle);
        int order2 = atom2.getLigandOrder(middle);
        MolBond bond = middle.getBond(0);
        mol.removeAtom(middle);
        bond = bond.cloneBond(atom1, atom2);
        bond.setSetSeq(0);
        mol.add(bond);
        atom1.setLigandOrder(order1, atom2);
        atom2.setLigandOrder(order2, atom1);
    }

    private static int[] getImpliedRgroupIDs(int rid, RgMolecule rgmol) {
        if (rgmol == null) {
            return new int[]{rid};
        }
        IntVector rids = new IntVector();
        rids.add(rid);
        ExpansionUtil.getImpliedRgroupIDs(rids, rid, rgmol);
        return rids.toArray();
    }

    private static void getImpliedRgroupIDs(IntVector rids, int rid, RgMolecule rgmol) {
        int index = rgmol.findRgroupIndex(rid);
        if (index != -1) {
            for (int j = rgmol.getRgroupMemberCount(index) - 1; j >= 0; --j) {
                Molecule m = rgmol.getRgroupMember(index, j);
                for (int k = m.getAtomCount() - 1; k >= 0; --k) {
                    MolAtom a = m.getAtom(k);
                    if (a.getAtno() != 134) continue;
                    int r = a.getRgroup();
                    rids.add(r);
                    ExpansionUtil.getImpliedRgroupIDs(rids, r, rgmol);
                }
            }
        }
    }

    private static void storeData(Molecule mol, MolAtom atom) {
        if (atom.isLinkNode()) {
            atom.putProperty(LINKNODE_ALLBONDS, ExpansionUtil.getBonds(atom));
            atom.putProperty(LINKNODE_OUTERBONDS, new MolBond[]{atom.getBond(atom.getLinkNodeOuterAtom(0)), atom.getBond(atom.getLinkNodeOuterAtom(1))});
            atom.putProperty(LINKNODE_REPETITIONS, new int[]{atom.getMinRepetitions(), atom.getMaxRepetitions()});
        }
    }

    private static void updateData(MolAtom oldAtom, MoleculeGraph oldGraph, MolAtom newAtom, MoleculeGraph newGraph, int[] old2new, ArrayList<MolAtom> atoms) {
        MolBond[] oldBonds = (MolBond[])oldAtom.getProperty(LINKNODE_OUTERBONDS);
        if (oldBonds != null) {
            MolBond[] allOldBonds = (MolBond[])oldAtom.getProperty(LINKNODE_ALLBONDS);
            MolBond[] newBonds = ExpansionUtil.transformBondData(oldBonds, oldGraph, newGraph, old2new);
            MolBond[] allNewBonds = ExpansionUtil.transformBondData(allOldBonds, oldGraph, newGraph, old2new);
            newAtom.putProperty(LINKNODE_OUTERBONDS, newBonds);
            newAtom.putProperty(LINKNODE_ALLBONDS, allNewBonds);
        }
        if (oldAtom.containsPropertyKey(LINKNODE_REPETITIONS)) {
            newAtom.putProperty(LINKNODE_REPETITIONS, oldAtom.getProperty(LINKNODE_REPETITIONS));
        } else {
            newAtom.removeProperty(LINKNODE_REPETITIONS);
        }
        atoms.add(newAtom);
    }

    private static MolBond[] transformBondData(MolBond[] oldBonds, MoleculeGraph oldGraph, MoleculeGraph newGraph, int[] old2new) {
        MolBond[] newBonds = new MolBond[oldBonds.length];
        for (int i = 0; i < newBonds.length; ++i) {
            int i2;
            int i1 = oldGraph.indexOf(oldBonds[i].getAtom1());
            if (i1 == -1 || (i2 = oldGraph.indexOf(oldBonds[i].getAtom2())) == -1) continue;
            newBonds[i] = newGraph.getAtom(old2new[i1]).getBondTo(newGraph.getAtom(old2new[i2]));
        }
        return newBonds;
    }

    private static void restoreData(Molecule mol, MolAtom atom) {
        MolBond[] oldBonds = (MolBond[])atom.getProperty(LINKNODE_OUTERBONDS);
        if (oldBonds != null) {
            MolBond[] allOldBonds = (MolBond[])atom.getProperty(LINKNODE_ALLBONDS);
            int newBondIndex = -1;
            atom.setLinkNodeOuterAtom(0, -1);
            atom.setLinkNodeOuterAtom(1, -1);
            for (int i = atom.getBondCount() - 1; i >= 0; --i) {
                MolBond bond = atom.getBond(i);
                if (bond == oldBonds[0]) {
                    atom.setLinkNodeOuterAtom(0, i);
                    continue;
                }
                if (bond == oldBonds[1]) {
                    atom.setLinkNodeOuterAtom(1, i);
                    continue;
                }
                if (ExpansionUtil.indexOf(allOldBonds, bond) != -1) continue;
                newBondIndex = i;
            }
            if (newBondIndex != -1) {
                if (atom.getLinkNodeOuterAtom(0) == -1) {
                    atom.setLinkNodeOuterAtom(0, newBondIndex);
                } else if (atom.getLinkNodeOuterAtom(1) == -1) {
                    atom.setLinkNodeOuterAtom(1, newBondIndex);
                }
            }
            int[] repetitions = (int[])atom.getProperty(LINKNODE_REPETITIONS);
            atom.setMinRepetitions(repetitions[0]);
            atom.setMaxRepetitions(repetitions[1]);
            atom.removeProperty(LINKNODE_OUTERBONDS);
            atom.removeProperty(LINKNODE_ALLBONDS);
            atom.removeProperty(LINKNODE_REPETITIONS);
        }
    }

    private static <T> int indexOf(T[] array, T element) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    private static boolean containsBond(MolBond[] bonds, MolBond bond) {
        for (int i = 0; i < bonds.length; ++i) {
            if (bond != bonds[i]) continue;
            return true;
        }
        return false;
    }

    private static MolBond[] getBonds(MolAtom atom) {
        int count = atom.getBondCount();
        MolBond[] bonds = new MolBond[count];
        for (int i = 0; i < count; ++i) {
            bonds[i] = atom.getBond(i);
        }
        return bonds;
    }

    public static Molecule fixRgroupDefs(RgMolecule rgmol) {
        return ExpansionUtil.addRgroupDefs(rgmol.getRoot(), rgmol);
    }

    public static Molecule addRgroupDefs(Molecule root, RgMolecule rgmol) {
        if (rgmol.getRgroupCount() == 0) {
            return root;
        }
        IntVector r = new IntVector();
        for (int i = root.getAtomCount() - 1; i >= 0; --i) {
            int rgindex;
            MolAtom atom = root.getAtom(i);
            if (atom.getAtno() != 134 || (rgindex = rgmol.findRgroupIndex(atom.getRgroup())) == -1 || r.contains(rgindex)) continue;
            r.addElement(rgindex);
        }
        int size = r.size();
        if (size == 0) {
            return root;
        }
        for (int i = 0; i < size; ++i) {
            ExpansionUtil.addReferencedRgroupIndexes(r.elementAt(i), r, rgmol);
        }
        RgMolecule mol = (RgMolecule)rgmol.newInstance();
        mol.setRoot(root);
        mol.setName(null);
        size = r.size();
        for (int i = 0; i < size; ++i) {
            int rgindex = r.elementAt(i);
            int rgid = rgmol.getRgroupId(rgindex);
            int count = rgmol.getRgroupMemberCount(rgindex);
            int newRgindex = -1;
            for (int j = 0; j < count; ++j) {
                Molecule m = rgmol.getRgroupMember(rgindex, j);
                newRgindex = mol.addRgroup(rgid, m.cloneMolecule());
            }
            assert (newRgindex != -1);
            mol.setRlogic(newRgindex, rgmol.getRlogic(rgindex));
            mol.setRlogicRange(newRgindex, rgmol.getRlogicRange(rgindex));
        }
        return mol.getSimplifiedMolecule();
    }

    private static void addReferencedRgroupIndexes(int rgindex, IntVector r, RgMolecule rgmol) {
        for (int i = rgmol.getRgroupMemberCount(rgindex) - 1; i >= 0; --i) {
            Molecule m = rgmol.getRgroupMember(rgindex, i);
            for (int j = m.getAtomCount() - 1; j >= 0; --j) {
                int subindex;
                MolAtom atom = m.getAtom(j);
                if (atom.getAtno() != 134 || (subindex = rgmol.findRgroupIndex(atom.getRgroup())) == -1 || r.contains(subindex)) continue;
                r.addElement(subindex);
                ExpansionUtil.addReferencedRgroupIndexes(subindex, r, rgmol);
            }
        }
    }

    public static MulticenterSgroup[] getMulticenterSgroups(Molecule mol) {
        return ExpansionUtil.getMulticenterSgroups(mol, null);
    }

    public static MulticenterSgroup[] getMulticenterSgroups(Molecule mol, MolAtom atom) {
        ArrayList<MulticenterSgroup> sglist = new ArrayList<MulticenterSgroup>(mol.getSgroupCount());
        for (int i = mol.getSgroupCount() - 1; i >= 0; --i) {
            Sgroup sg = mol.getSgroup(i);
            if (sg.getType() != 14 || atom != null && !sg.hasAtom(atom) && ((MulticenterSgroup)sg).getCentralAtom() != atom) continue;
            sglist.add((MulticenterSgroup)sg);
        }
        MulticenterSgroup[] res = new MulticenterSgroup[sglist.size()];
        sglist.toArray(res);
        return res;
    }

    public static boolean isSearchable(Molecule m) {
        boolean useNewCountMethod = true;
        try {
            ExpansionGraphUtil.checkMarkush(m);
        }
        catch (UnsupportedMarkushException e) {
            logger.fine("Markush " + m.getName() + " is not supported by ExpansionGraph: " + e);
            useNewCountMethod = false;
        }
        if (!ExpansionUtil.containsRepeatingUnit(m) && !ExpansionUtil.containsLinkNode(m)) {
            return true;
        }
        String countString = null;
        if (useNewCountMethod) {
            EnumerationCountAssembler enumCount = new EnumerationCountAssembler();
            BigInteger count = null;
            try {
                count = (BigInteger)enumCount.calculate(m);
            }
            catch (UnsupportedMarkushException e) {
                assert (false);
                return false;
            }
            countString = count.toString();
        } else {
            ExpansionCounter counter = new ExpansionCounter();
            counter.setMolecule(m);
            try {
                countString = counter.countExpansionsString();
            }
            catch (ExpansionException e) {
                logger.fine("Markush " + m.getName() + " is not supported by ExpansionCounter: " + e);
                return false;
            }
        }
        return countString.length() < 101;
    }

    public static boolean isMarkushMolecule(Molecule m) {
        return ExpansionUtil.isMarkushMoleculeExceptHomology(m) || HomologyConstants.containsHomology(m);
    }

    public static boolean isMarkushMoleculeExceptHomology(Molecule m) {
        return ExpansionUtil.containsRgroup(m) || ExpansionUtil.isMarkushMoleculeExceptHomologyAndRgroup(m);
    }

    public static boolean isMarkushMoleculeExceptHomologyAndRgroup(Molecule m) {
        return ExpansionUtil.containsAtomList(m) || ExpansionUtil.containsLinkNode(m) || ExpansionUtil.containsBondList(m) || ExpansionUtil.containsMulticenter(m) || ExpansionUtil.containsRepeatingUnit(m);
    }

    public static boolean containsRgroup(Molecule m) {
        RgMolecule rgm;
        return m instanceof RgMolecule && (rgm = (RgMolecule)m).getRgroupCount() > 0;
    }

    public static boolean containsAtomList(Molecule m) {
        int ac = m.getAtomCount();
        for (int i = 0; i < ac; ++i) {
            MolAtom atom = m.getAtom(i);
            if (atom.getAtno() != 128) continue;
            return true;
        }
        return false;
    }

    public static boolean containsLinkNode(Molecule m) {
        int ac = m.getAtomCount();
        for (int i = 0; i < ac; ++i) {
            MolAtom atom = m.getAtom(i);
            if (!atom.isLinkNode()) continue;
            return true;
        }
        return false;
    }

    public static boolean containsBondList(Molecule m) {
        int bc = m.getBondCount();
        for (int i = 0; i < bc; ++i) {
            MolBond bond = m.getBond(i);
            int t = bond.getType();
            if (BOND_TYPES[t].length == 1) continue;
            return true;
        }
        return false;
    }

    public static boolean containsMulticenter(Molecule m) {
        int bc = m.getBondCount();
        for (int i = 0; i < bc; ++i) {
            MolBond bond = m.getBond(i);
            int t = bond.getType();
            if (t == 9 || bond.getAtom1().getAtno() != 137 && bond.getAtom2().getAtno() != 137) continue;
            return true;
        }
        return false;
    }

    public static boolean containsRepeatingUnit(Molecule m) {
        for (int i = m.getSgroupCount() - 1; i >= 0; --i) {
            Sgroup sgroup = m.getSgroup(i);
            if (!(sgroup instanceof RepeatingUnitSgroup) || PolymerUtil.isPolymerSgroup(sgroup) || sgroup.findCrossingBonds().length > 4) continue;
            return true;
        }
        return false;
    }

    static {
        ExpansionUtil.BOND_TYPES[0] = new int[]{1, 2, 3};
        ExpansionUtil.BOND_TYPES[5] = new int[]{1, 2};
        ExpansionUtil.BOND_TYPES[6] = new int[]{4, 1};
        ExpansionUtil.BOND_TYPES[7] = new int[]{4, 2};
        for (int i = 0; i < 16; ++i) {
            if (BOND_TYPES[i] != null) continue;
            ExpansionUtil.BOND_TYPES[i] = new int[]{i};
        }
    }
}

