/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration;

import chemaxon.common.util.IntVector;
import chemaxon.enumeration.ExpansionCounter;
import chemaxon.enumeration.ExpansionException;
import chemaxon.enumeration.ExpansionUtil;
import chemaxon.enumeration.MolEnumerator;
import chemaxon.enumeration.SelectionUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.sgroup.MulticenterSgroup;

public class LinkAtomEnumerator
extends MolEnumerator {
    private ExpansionCounter ec = new ExpansionCounter();
    protected Molecule mol = null;
    private int linkNode = -1;
    private int nextRepetitions;
    private int maxRepetitions;
    private int enumLabel;
    private int[] dep_array = null;

    private int findLinkNode(Molecule molP) {
        int i;
        if (molP == null) {
            return -1;
        }
        int[] linkIndexes = LinkAtomEnumerator.getLinkNodes(molP);
        int index = -1;
        for (i = linkIndexes.length - 1; i >= 0; --i) {
            if (this.dep_array[linkIndexes[i]] != 0) continue;
            if (index != -1) {
                index = -2;
                break;
            }
            index = linkIndexes[i];
        }
        if (index == -1) {
            return -1;
        }
        if (index != -2) {
            return index;
        }
        this.getDependentAtomsFromLinkNodes(molP, linkIndexes);
        for (i = linkIndexes.length - 1; i >= 0; --i) {
            if (this.dep_array[linkIndexes[i]] != 0) continue;
            return linkIndexes[i];
        }
        return -1;
    }

    private static int[] getLinkNodes(Molecule molP) {
        IntVector v = new IntVector();
        int count = molP.getAtomCount();
        for (int i = 0; i < count; ++i) {
            MolAtom atom = molP.getAtom(i);
            if (!atom.isLinkNode() || !SelectionUtil.isSelected(atom)) continue;
            v.add(i);
        }
        return v.toArray();
    }

    private void getDependentAtomsFromLinkNodes(Molecule molP, int[] linkIndexes) {
        for (int index = 0; index < linkIndexes.length; ++index) {
            MolAtom ma = molP.getAtom(linkIndexes[index]);
            int bCount = ma.getBondCount();
            if (!SelectionUtil.isSelected(ma) || bCount <= 2) continue;
            MolAtom idx0 = ma.getLigand(ma.getLinkNodeOuterAtom(0));
            MolAtom idx1 = ma.getLigand(ma.getLinkNodeOuterAtom(1));
            for (int j = 0; j < bCount; ++j) {
                MolAtom root = ma.getLigand(j);
                if (root == idx0 || root == idx1) continue;
                int state = this.dep_array[linkIndexes[index]];
                this.dep_array[linkIndexes[index]] = -1;
                this.getDependentAtomsFromLinkNodes(molP, root);
                this.dep_array[linkIndexes[index]] = state;
            }
        }
    }

    private void getDependentAtomsFromLinkNodes(Molecule molP, MolAtom ma) {
        int d = molP.indexOf(ma);
        if (this.dep_array[d] != 0) {
            return;
        }
        this.dep_array[d] = 1;
        for (int i = ma.getBondCount() - 1; i >= 0; --i) {
            this.getDependentAtomsFromLinkNodes(molP, ma.getLigand(i));
        }
        MulticenterSgroup[] sgroups = ExpansionUtil.getMulticenterSgroups(molP, ma);
        for (int i = 0; i < sgroups.length; ++i) {
            MulticenterSgroup sg = sgroups[i];
            this.getDependentAtomsFromLinkNodes(molP, sg.getCentralAtom());
            for (int j = sg.getAtomCount() - 1; j >= 0; --j) {
                this.getDependentAtomsFromLinkNodes(molP, sg.getAtom(j));
            }
        }
    }

    public LinkAtomEnumerator() {
    }

    public LinkAtomEnumerator(Molecule molP) {
        this.setMol(molP);
    }

    @Override
    public void setMol(Molecule molP) {
        this.setMol(molP, (int[])null);
    }

    public void setMol(Molecule molP, int[] dependencies) {
        this.dep_array = new int[molP.getAtomCount()];
        if (dependencies != null) {
            System.arraycopy(dependencies, 0, this.dep_array, 0, dependencies.length);
        }
        this.mol = molP;
        this.init();
    }

    private Molecule assembleMol(int repetitions) {
        Molecule outMol = (Molecule)this.mol.clone();
        outMol.setValenceCheckEnabled(false);
        MolAtom linkAtom = outMol.getAtom(this.linkNode);
        boolean colored = (this.coloring & 1) != 0 && linkAtom.getSetSeq() != 0;
        ExpansionUtil.insertLinkPart(outMol, linkAtom, repetitions, colored);
        return outMol;
    }

    private static void restoreLinkData(MolAtom atom, MolBond[] bonds, int[] repetitions) {
        for (int i = atom.getBondCount() - 1; i >= 0; --i) {
            MolBond bond = atom.getBond(i);
            if (bond == bonds[0]) {
                atom.setLinkNodeOuterAtom(0, i);
                continue;
            }
            if (bond != bonds[1]) continue;
            atom.setLinkNodeOuterAtom(1, i);
        }
        atom.setMinRepetitions(repetitions[0]);
        atom.setMaxRepetitions(repetitions[1]);
    }

    @Override
    public Object clone() {
        LinkAtomEnumerator lae = (LinkAtomEnumerator)super.clone();
        lae.mol = this.mol;
        lae.linkNode = this.linkNode;
        lae.nextRepetitions = this.nextRepetitions;
        lae.maxRepetitions = this.maxRepetitions;
        lae.enumLabel = this.enumLabel;
        return lae;
    }

    private void init() {
        this.linkNode = this.findLinkNode(this.mol);
        if (this.linkNode != -1) {
            this.nextRepetitions = this.mol.getAtom(this.linkNode).getMinRepetitions();
            this.maxRepetitions = this.mol.getAtom(this.linkNode).getMaxRepetitions();
        }
        this.enumLabel = this.linkNode == -1 ? -1 : (this.mol.getAtom(this.linkNode).containsPropertyKey("randomlabel") ? (Integer)this.mol.getAtom(this.linkNode).getProperty("randomlabel") : -1);
    }

    @Override
    protected boolean hasMoreElements0() {
        boolean retVal;
        boolean bl = retVal = this.linkNode != -1 && this.nextRepetitions <= this.maxRepetitions;
        if (this.random && this.numOfEnums - this.numOfGeneratedEnumerates <= 0) {
            retVal = false;
        }
        return retVal;
    }

    @Override
    protected Molecule nextElement0() {
        assert (this.random == this.random);
        if (this.hasMoreElements0()) {
            Molecule mol1 = this.generateOutMol(this.random);
            return mol1;
        }
        return null;
    }

    private int offset() {
        return this.mol.getAtom(this.linkNode).getMinRepetitions();
    }

    @Override
    protected int getBranchIndex() {
        return this.nextRepetitions - this.offset();
    }

    @Override
    protected int getBranchCount() {
        return this.maxRepetitions - this.offset() + 1;
    }

    @Override
    protected int getRandomBranchIndex() {
        return this.randomGenerator.generate(this.randomPossibilities);
    }

    @Override
    protected int incrementAndGetBranchIndex() {
        return ++this.nextRepetitions - this.offset();
    }

    private Molecule generateOutMol(boolean random) {
        int select = 0;
        if (!random) {
            select = this.nextRepetitions++;
        } else {
            int min_rep = this.mol.getAtom(this.linkNode).getMinRepetitions();
            int repeat = this.maxRepetitions - min_rep + 1;
            if (this.randomPossibilities == null) {
                this.ec.setEnumerateHomology(this.isHomologyEnumerated());
                this.ec.setMolecule(this.mol);
                this.randomPossibilities = new double[repeat];
                double multi = 1.0;
                try {
                    multi = this.ec.countChildrenExpansionsLarge(this.linkNode).doubleValue();
                }
                catch (ExpansionException e) {
                    multi = 1.0;
                }
                this.randomPossibilities[0] = multi > 1.5 ? Math.pow(multi, min_rep) : 1.0;
                for (int i = 1; i < this.randomPossibilities.length; ++i) {
                    this.randomPossibilities[i] = this.randomPossibilities[i - 1] * multi;
                }
            }
            if (this.numOfEnumsFromBranch == null) {
                this.initNumOfEnumsFromBranch();
            }
            select = this.getIndexOfBranchToEnumerateFrom() + this.offset();
        }
        Molecule outmol = this.assembleMol(select);
        if (this.getEnumCodeNeeded()) {
            this.addMarkushCodeToMolecule(outmol, "L" + ((Integer)this.mol.getAtom(this.linkNode).getProperty("EnumIndex") + 1) + ":" + select);
        }
        return outmol;
    }

    @Override
    protected int getEnumeratorLabel() {
        return this.enumLabel;
    }
}

