/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration;

import chemaxon.enumeration.ExpansionUtil;
import chemaxon.enumeration.MolEnumerator;
import chemaxon.enumeration.SelectionUtil;
import chemaxon.marvin.util.MolImportUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.sgroup.MulticenterSgroup;
import java.util.Arrays;
import java.util.Enumeration;

public class MultiBondEnumerator
extends MolEnumerator {
    private Molecule mol = null;
    private MultiBond multiBond = null;
    private int branchIndex = 0;

    private static MultiBond findMultiBond(Molecule molP) {
        int count = molP.getBondCount();
        for (int i = 0; i < count; ++i) {
            MulticenterSgroup msg2;
            boolean isM2;
            MolBond mb = molP.getBond(i);
            MolAtom a1 = mb.getAtom1();
            MolAtom a2 = mb.getAtom2();
            boolean isM1 = a1.getAtno() == 137;
            boolean bl = isM2 = a2.getAtno() == 137;
            if (!isM1 && !isM2 || !SelectionUtil.isSelected(a1) || !SelectionUtil.isSelected(a2) || mb.getType() == 9) continue;
            MulticenterSgroup msg1 = isM1 ? molP.findContainingMulticenterSgroup(a1) : null;
            MulticenterSgroup multicenterSgroup = msg2 = isM2 ? molP.findContainingMulticenterSgroup(a2) : null;
            if (msg1 == null && msg2 == null) continue;
            return new MultiBond(molP, a1, msg1, a2, msg2, i);
        }
        return null;
    }

    public MultiBondEnumerator() {
    }

    public MultiBondEnumerator(Molecule molP) {
        this.setMol(molP);
    }

    @Override
    public void setMol(Molecule molP) {
        this.mol = molP;
        this.multiBond = MultiBondEnumerator.findMultiBond(this.mol);
        if (this.multiBond != null) {
            this.randomPossibilities = new double[this.getBranchCount()];
            Arrays.fill(this.randomPossibilities, 1.0);
        } else {
            this.randomPossibilities = null;
        }
    }

    @Override
    public Object clone() {
        MultiBondEnumerator mbe = (MultiBondEnumerator)super.clone();
        mbe.mol = this.mol;
        mbe.multiBond = this.multiBond;
        mbe.randomPossibilities = this.randomPossibilities;
        return mbe;
    }

    @Override
    protected int getBranchIndex() {
        return this.branchIndex;
    }

    @Override
    protected int getBranchCount() {
        return this.multiBond.getBranchCount();
    }

    @Override
    protected int getRandomBranchIndex() {
        return this.randomGenerator.generate(this.randomPossibilities);
    }

    @Override
    protected int incrementAndGetBranchIndex() {
        return ++this.branchIndex;
    }

    @Override
    protected boolean hasMoreElements0() {
        if (this.multiBond == null) {
            return false;
        }
        if (!this.random) {
            return this.multiBond.hasMoreElements();
        }
        return this.numOfEnums - this.numOfGeneratedEnumerates > 0;
    }

    @Override
    protected Molecule nextElement0() {
        if (this.hasMoreElements0()) {
            Molecule mol1 = this.generateOutMol(this.random);
            return mol1;
        }
        return null;
    }

    private Molecule generateOutMol(boolean random) {
        MulticenterSgroup msg;
        Molecule outmol = ExpansionUtil.cloneMolecule(this.mol);
        if (random && this.numOfEnumsFromBranch == null) {
            this.initNumOfEnumsFromBranch();
        }
        int[] data = random ? this.multiBond.branchElement(this.getIndexOfBranchToEnumerateFrom()) : (int[])this.multiBond.nextElement();
        MolBond newBond = new MolBond(outmol.getAtom(data[0]), outmol.getAtom(data[1]));
        newBond.setType(data[2]);
        MolBond oldBond = outmol.getBond(this.multiBond.bondIndex);
        MolAtom atom1 = oldBond.getAtom1();
        MolAtom atom2 = oldBond.getAtom2();
        boolean isMSG1 = atom1.getAtno() == 137;
        boolean isMSG2 = atom2.getAtno() == 137;
        MolAtom[] ligands1 = !isMSG1 ? MolImportUtil.getLigandsInOrder(atom1) : null;
        MolAtom[] ligands2 = !isMSG2 ? MolImportUtil.getLigandsInOrder(atom2) : null;
        outmol.removeBond(oldBond);
        outmol.add(newBond);
        if (isMSG1) {
            msg = outmol.findContainingMulticenterSgroup(atom1);
            outmol.ungroupSgroup(msg);
            outmol.removeAtom(atom1);
        } else {
            ExpansionUtil.replace(ligands1, atom2, newBond.getOtherAtom(atom1));
            MolImportUtil.setLigandOrders(atom1, ligands1);
        }
        if (isMSG2) {
            msg = outmol.findContainingMulticenterSgroup(atom2);
            outmol.ungroupSgroup(msg);
            outmol.removeAtom(atom2);
        } else {
            ExpansionUtil.replace(ligands2, atom1, newBond.getOtherAtom(atom2));
            MolImportUtil.setLigandOrders(atom2, ligands2);
        }
        if (this.getEnumCodeNeeded()) {
            String enumCode = isMSG1 ? (isMSG2 ? "PV" + ((Integer)oldBond.getAtom1().getProperty("EnumIndex") + 1) + "-" + ((Integer)oldBond.getAtom2().getProperty("EnumIndex") + 1) + ":" + ((Integer)newBond.getAtom1().getProperty("EnumIndex") + 1) + "-" + ((Integer)newBond.getAtom2().getProperty("EnumIndex") + 1) : "PV" + ((Integer)oldBond.getAtom1().getProperty("EnumIndex") + 1) + ":" + ((Integer)newBond.getAtom1().getProperty("EnumIndex") + 1)) : "PV" + ((Integer)oldBond.getAtom2().getProperty("EnumIndex") + 1) + ":" + ((Integer)newBond.getAtom2().getProperty("EnumIndex") + 1);
            this.addMarkushCodeToMolecule(outmol, enumCode);
        }
        return outmol;
    }

    private static class MultiBond
    implements Enumeration {
        int[] atomIndexes1 = null;
        int[] atomIndexes2 = null;
        int[] types = null;
        int bondIndex = -1;
        private int index1 = 0;
        private int index2 = 0;
        private int typeIndex = 0;

        MultiBond(Molecule mol, MolAtom a1, MulticenterSgroup msg1, MolAtom a2, MulticenterSgroup msg2, int i) {
            MolAtom[] molAtomArray;
            MolAtom[] atoms1;
            MolAtom[] molAtomArray2;
            if (msg1 == null) {
                MolAtom[] molAtomArray3 = new MolAtom[1];
                molAtomArray2 = molAtomArray3;
                molAtomArray3[0] = a1;
            } else {
                molAtomArray2 = atoms1 = msg1.getAtomArray();
            }
            if (msg2 == null) {
                MolAtom[] molAtomArray4 = new MolAtom[1];
                molAtomArray = molAtomArray4;
                molAtomArray4[0] = a2;
            } else {
                molAtomArray = msg2.getAtomArray();
            }
            MolAtom[] atoms2 = molAtomArray;
            this.atomIndexes1 = MultiBond.getAtomIndexes(mol, atoms1);
            this.atomIndexes2 = MultiBond.getAtomIndexes(mol, atoms2);
            this.types = ExpansionUtil.BOND_TYPES[mol.getBond(i).getType()];
            this.bondIndex = i;
        }

        private static int[] getAtomIndexes(Molecule mol, MolAtom[] atoms) {
            int[] indexes = new int[atoms.length];
            for (int i = 0; i < atoms.length; ++i) {
                indexes[i] = mol.indexOf(atoms[i]);
            }
            return indexes;
        }

        @Override
        public boolean hasMoreElements() {
            return this.index1 < this.atomIndexes1.length;
        }

        public Object nextElement() {
            if (this.index1 == this.atomIndexes1.length) {
                return null;
            }
            int[] res = new int[]{this.atomIndexes1[this.index1], this.atomIndexes2[this.index2], this.types[this.typeIndex]};
            ++this.typeIndex;
            if (this.typeIndex == this.types.length) {
                this.typeIndex = 0;
                ++this.index2;
                if (this.index2 == this.atomIndexes2.length) {
                    this.index2 = 0;
                    ++this.index1;
                }
            }
            return res;
        }

        private int[] branchElement(int n) {
            int jmax = this.atomIndexes2.length;
            int kmax = this.types.length;
            int jkm = jmax * kmax;
            int i = n / jkm;
            int jkm_i = jkm * i;
            int j = (n - jkm_i) / kmax;
            int k = n - jkm_i - kmax * j;
            return new int[]{this.atomIndexes1[i], this.atomIndexes2[j], this.types[k]};
        }

        private int getBranchCount() {
            return this.atomIndexes1.length * this.atomIndexes2.length * this.types.length;
        }
    }
}

