/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration;

import chemaxon.enumeration.ExpansionUtil;
import chemaxon.enumeration.QueryMolEnumerator;
import chemaxon.enumeration.SelectionUtil;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.QueryBond;

public class QueryBondListEnumerator
extends QueryMolEnumerator {
    private static final int[][] BOND_TYPES = ExpansionUtil.BOND_TYPES;
    private Molecule mol = null;
    private int listBond = -1;
    private int typeIndex = -1;
    private int[] bondTypes = null;

    private static int findBondList(Molecule molP) {
        int count = molP.getBondCount();
        for (int i = 0; i < count; ++i) {
            MolBond mb = molP.getBond(i);
            if (!SelectionUtil.isSelected(mb.getAtom1()) || !SelectionUtil.isSelected(mb.getAtom2()) || !mb.isQuery() || mb.getQuerystr() != null) continue;
            return i;
        }
        return -1;
    }

    public QueryBondListEnumerator() {
    }

    public QueryBondListEnumerator(Molecule molP) {
        this.setMol(molP);
    }

    @Override
    public void setMol(Molecule molP) {
        this.mol = molP;
        this.init();
    }

    @Override
    public Object clone() {
        QueryBondListEnumerator qble = (QueryBondListEnumerator)super.clone();
        qble.mol = this.mol;
        qble.listBond = this.listBond;
        qble.typeIndex = this.typeIndex;
        qble.bondTypes = this.bondTypes;
        return qble;
    }

    private void init() {
        this.listBond = QueryBondListEnumerator.findBondList(this.mol);
        if (this.listBond != -1) {
            this.bondTypes = QueryBondListEnumerator.getBondTypes(this.mol.getBond(this.listBond));
            this.typeIndex = 0;
        }
    }

    @Override
    public boolean hasMoreElements() {
        return this.listBond != -1 && this.typeIndex < this.bondTypes.length;
    }

    @Override
    public Molecule nextElement() {
        if (this.hasMoreElements()) {
            Molecule mol1 = this.generateOutMol();
            return mol1;
        }
        return null;
    }

    private Molecule generateOutMol() {
        Molecule outmol = this.mol.cloneMolecule();
        outmol.setValenceCheckEnabled(false);
        int select = this.typeIndex++;
        MolBond mb = outmol.getBond(this.listBond);
        QueryBond qb = new QueryBond(mb.getAtom1(), mb.getAtom2(), mb.getFlags());
        qb.setType(this.bondTypes[select]);
        qb.setQuerystr("NONAROMATIC");
        outmol.removeBond(mb);
        outmol.add(qb);
        return outmol;
    }

    private static int[] getBondTypes(MolBond bond) {
        int t = bond.getType();
        if (t == 0) {
            return new int[]{1, 2, 3, 4, 9};
        }
        return BOND_TYPES[t];
    }
}

