/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration;

import chemaxon.enumeration.AromUtil;
import chemaxon.enumeration.QueryEnumeratorFactory;
import chemaxon.enumeration.QueryMolEnumerator;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import java.util.Stack;
import java.util.logging.Level;

public class QueryCombinationEnumerator
extends QueryMolEnumerator {
    private QueryEnumeratorFactory factory = null;
    private int features = 0;
    private Stack<Molecule> mols = new Stack();
    private Stack<QueryMolEnumerator> enumerators = new Stack();
    private Molecule mol = null;

    protected QueryCombinationEnumerator() {
    }

    protected QueryCombinationEnumerator(Molecule molP) {
        this.setMol(molP);
    }

    @Override
    protected void setFeatures(int features) {
        this.features = features;
    }

    @Override
    public Object clone() {
        QueryCombinationEnumerator ce = (QueryCombinationEnumerator)super.clone();
        ce.factory = this.factory;
        ce.mol = this.mol;
        ce.mols = (Stack)this.mols.clone();
        ce.enumerators = new Stack();
        return ce;
    }

    @Override
    public boolean hasMoreElements() {
        return !this.mols.empty();
    }

    @Override
    public Molecule nextElement() {
        if (!this.hasMoreElements()) {
            return null;
        }
        this.addEnumerators();
        if (!this.hasMoreElements()) {
            return null;
        }
        Molecule result = this.mols.pop();
        if (this.origNeeded) {
            result.setPropertyObject("nonEnumeratedMol", this.mol.cloneMolecule());
        }
        this.step();
        AromUtil.finishAromatize(result);
        result.setValenceCheckEnabled(true);
        result.valenceCheck();
        return result;
    }

    private void addEnumerators() {
        Molecule lastMol;
        QueryMolEnumerator me;
        if (logger.isLoggable(Level.FINER)) {
            this.logEnumerators();
        }
        if ((me = this.factory.getFirstEnumeratorClone(lastMol = this.mols.peek(), this.enumerators, this.features, this.markushSearch, this.licenseEnvironment)) == null) {
            return;
        }
        Molecule m = QueryCombinationEnumerator.getNextMol(me);
        if (m != null) {
            this.enumerators.push(me);
            this.mols.push(m);
            this.addEnumerators();
        } else {
            if (this.hasMoreElements()) {
                this.mols.pop();
            }
            this.step();
            if (this.hasMoreElements()) {
                this.addEnumerators();
            }
        }
    }

    private void step() {
        int size = this.enumerators.size();
        QueryMolEnumerator lastEnum = size == 0 ? null : (QueryMolEnumerator)this.enumerators.get(size - 1);
        Molecule m = null;
        while (size != 0 && (m = QueryCombinationEnumerator.getNextMol(lastEnum)) == null) {
            this.mols.pop();
            this.enumerators.pop();
            lastEnum = --size == 0 ? null : this.enumerators.peek();
        }
        if (m != null) {
            this.mols.push(m);
        }
    }

    private static Molecule getNextMol(QueryMolEnumerator me) {
        return me.hasMoreElements() ? me.nextElement() : null;
    }

    @Override
    public void setMol(Molecule molP) {
        this.mols.clear();
        this.enumerators.clear();
        molP.setGUIContracted(false);
        if (molP instanceof RgMolecule) {
            molP = molP.cloneMolecule();
            AromUtil.initAromatize((RgMolecule)molP);
        }
        this.mol = molP;
        this.mols.push(this.mol);
    }

    protected void setFactory(QueryEnumeratorFactory f) {
        this.factory = f;
    }

    private void logEnumerators() {
        StringBuffer b = new StringBuffer();
        int size = this.enumerators.size();
        b.append("" + size + " enumerators:\n");
        for (int i = 0; i < size; ++i) {
            b.append(this.enumerators.get(i));
        }
        logger.finer(new String(b));
    }
}

