/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration;

import chemaxon.enumeration.ExpansionCounter;
import chemaxon.enumeration.ExpansionException;
import chemaxon.enumeration.ExpansionUtil;
import chemaxon.enumeration.MolEnumerator;
import chemaxon.enumeration.SelectionUtil;
import chemaxon.enumeration.bracket.PolymerUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import chemaxon.util.IntRange;
import java.util.Arrays;

public class RepeatingUnitEnumerator
extends MolEnumerator {
    private ExpansionCounter ec = new ExpansionCounter();
    private Molecule mol = null;
    private int repeatingUnitIndex = -1;
    private IntRange range = null;
    private int nextRepetition = -1;
    private int[] randomValues = null;
    private int unitIndex = 0;

    public static boolean getDependentAtomsFromRepeatingUnits(int[] dependencies, Molecule mol) {
        boolean depset = false;
        Molecule parent = mol instanceof RgMolecule ? ((RgMolecule)mol).getRoot() : mol;
        for (int i = mol.getSgroupCount() - 1; i >= 0; --i) {
            Sgroup sgroup = mol.getSgroup(i);
            if (!(sgroup instanceof RepeatingUnitSgroup) || sgroup.getParentMolecule() != parent || !SelectionUtil.isSelected(sgroup)) continue;
            for (int j = sgroup.getAtomCount() - 1; j >= 0; --j) {
                dependencies[mol.indexOf((MolAtom)sgroup.getAtom((int)j))] = 1;
                depset = true;
            }
        }
        return depset;
    }

    public static int findRepeatingUnit(Molecule molP) {
        int index = -1;
        Molecule parent = molP instanceof RgMolecule ? ((RgMolecule)molP).getRoot() : molP;
        for (int i = molP.getSgroupCount() - 1; i >= 0; --i) {
            int x;
            Sgroup sgroup = molP.getSgroup(i);
            if (!(sgroup instanceof RepeatingUnitSgroup) || PolymerUtil.isPolymerSgroup(sgroup) || sgroup.getParentMolecule() != parent || !SelectionUtil.isSelected(sgroup) || (x = sgroup.findCrossingBonds().length) > 4 || index != -1 && molP.getSgroup(index).getAtomCount() >= sgroup.getAtomCount()) continue;
            index = i;
        }
        return index;
    }

    public RepeatingUnitEnumerator() {
    }

    public RepeatingUnitEnumerator(Molecule molP) {
        this.setMol(molP);
    }

    @Override
    public void setMol(Molecule molP) {
        this.mol = molP;
        this.init();
    }

    private void init() {
        this.repeatingUnitIndex = RepeatingUnitEnumerator.findRepeatingUnit(this.mol);
        if (this.repeatingUnitIndex != -1) {
            Sgroup sgroup = this.mol.getSgroup(this.repeatingUnitIndex);
            int x = sgroup.findCrossingBonds().length;
            if (x > 1) {
                this.range = new IntRange(sgroup.getSubscript());
                this.range.setMaxCount(10);
            } else {
                this.range = new IntRange("1");
            }
            this.nextRepetition = this.getNextRepetition();
        } else {
            this.range = null;
            this.nextRepetition = -1;
        }
    }

    private int getNextRepetition() {
        return this.range != null && this.range.hasNext() ? this.range.next() : -1;
    }

    @Override
    protected boolean hasMoreElements0() {
        boolean retVal;
        boolean bl = retVal = this.nextRepetition != -1;
        if (this.random && this.numOfEnums - this.numOfGeneratedEnumerates <= 0) {
            retVal = false;
        }
        return retVal;
    }

    @Override
    protected Molecule nextElement0() {
        Molecule mol1 = null;
        if (this.hasMoreElements0()) {
            mol1 = this.generateOutMol(this.random);
            if (!this.random) {
                this.nextRepetition = this.getNextRepetition();
            }
        }
        return mol1;
    }

    private Molecule generateOutMol(boolean random) {
        int select = random ? this.getRandomRepetition() : this.nextRepetition;
        Molecule outMol = (Molecule)this.mol.clone();
        outMol.setValenceCheckEnabled(false);
        boolean colored = (this.coloring & 1) != 0 && outMol.getSgroup(this.repeatingUnitIndex).getAtom(0).getSetSeq() != 0;
        RepeatingUnitSgroup repeatingUnit = (RepeatingUnitSgroup)outMol.getSgroup(this.repeatingUnitIndex);
        ExpansionUtil.insertRepeatingPart(outMol, repeatingUnit, select);
        if (select == 0 && outMol instanceof RgMolecule) {
            outMol = ExpansionUtil.fixRgroupDefs((RgMolecule)outMol);
        }
        if (this.getEnumCodeNeeded()) {
            this.addMarkushCodeToMolecule(outMol, "RU" + this.repeatingUnitIndex + ":" + select);
        }
        return outMol;
    }

    @Override
    protected int getBranchIndex() {
        return this.unitIndex;
    }

    @Override
    protected int getBranchCount() {
        return this.range.size();
    }

    @Override
    protected int getRandomBranchIndex() {
        return this.randomGenerator.generate(this.randomPossibilities);
    }

    @Override
    protected int incrementAndGetBranchIndex() {
        return ++this.unitIndex;
    }

    private int getRandomRepetition() {
        if (this.randomPossibilities == null) {
            this.randomValues = new int[this.range.size()];
            this.randomValues[0] = this.nextRepetition;
            int i = 0;
            while (this.range.hasNext()) {
                this.randomValues[++i] = this.range.next();
            }
            this.randomPossibilities = new double[this.randomValues.length];
            double multi = 1.0;
            try {
                this.ec.setEnumerateHomology(this.isHomologyEnumerated());
                this.ec.setMolecule(this.mol);
                multi = this.ec.countRepUnitChildrenExpansionsLarge(this.repeatingUnitIndex).doubleValue();
            }
            catch (ExpansionException e) {
                e.printStackTrace();
                multi = 1.0;
            }
            if (multi < 1.5) {
                Arrays.fill(this.randomPossibilities, 1.0);
            } else {
                for (i = 0; i < this.randomPossibilities.length; ++i) {
                    this.randomPossibilities[i] = Math.pow(multi, this.randomValues[i]);
                }
            }
        }
        if (this.numOfEnumsFromBranch == null) {
            this.initNumOfEnumsFromBranch();
        }
        int branchIndex = this.getIndexOfBranchToEnumerateFrom();
        return this.randomValues[branchIndex];
    }

    @Override
    public Object clone() {
        RepeatingUnitEnumerator rue = (RepeatingUnitEnumerator)super.clone();
        rue.mol = this.mol;
        rue.repeatingUnitIndex = this.repeatingUnitIndex;
        rue.nextRepetition = this.nextRepetition;
        rue.range = this.range;
        return rue;
    }
}

