/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration;

import chemaxon.enumeration.MarkushEnumeratorFactory;
import chemaxon.enumeration.MolEnumerator;
import chemaxon.enumeration.QueryEnumeratorFactory;
import chemaxon.enumeration.QueryMolEnumerator;
import chemaxon.enumeration.SelectionUtil;
import chemaxon.enumeration.SimpleEnumerator;
import chemaxon.struc.Molecule;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.WeakHashMap;

public class SearchEnumerator
implements Enumeration<Molecule>,
Cloneable {
    private MolEnumerator markushEnumerator = null;
    private QueryMolEnumerator queryEnumerator = null;
    private int queryFeatures = 0;
    private boolean markushSearch = false;
    private static WeakHashMap<Integer, WeakReference<MarkushEnumeratorFactory>> markushFactoryStore = null;
    private static WeakHashMap<Integer, WeakReference<QueryEnumeratorFactory>> queryFactoryStore = null;

    public SearchEnumerator(int features, Molecule mol) {
        int markushFeatures = SearchEnumerator.getMarkushFeatures(features);
        this.markushEnumerator = markushFeatures != 0 ? SearchEnumerator.createMarkushEnumerator(markushFeatures, mol) : new SimpleEnumerator(mol);
        this.queryFeatures = SearchEnumerator.getQueryFeatures(features);
    }

    public SearchEnumerator(MolEnumerator markushEnumerator, int queryFeatures) {
        this.markushEnumerator = markushEnumerator;
        this.queryFeatures = queryFeatures;
    }

    public Object clone() {
        SearchEnumerator se = null;
        try {
            se = (SearchEnumerator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
        se.markushEnumerator = (MolEnumerator)this.markushEnumerator.clone();
        if (this.queryEnumerator != null) {
            se.queryEnumerator = (QueryMolEnumerator)this.queryEnumerator.clone();
        }
        se.queryFeatures = this.queryFeatures;
        return se;
    }

    public void setMarkushSearch(boolean markushSearch) {
        this.markushSearch = markushSearch;
    }

    public void setOrigNeeded(boolean b) {
        this.markushEnumerator.setOrigNeeded(b);
    }

    public boolean isOrigNeeded() {
        return this.markushEnumerator.isOrigNeeded();
    }

    @Override
    public boolean hasMoreElements() {
        if (this.queryEnumerator != null && this.queryEnumerator.hasMoreElements()) {
            return true;
        }
        return this.markushEnumerator.hasMoreElements();
    }

    @Override
    public Molecule nextElement() {
        if (this.queryEnumerator != null && this.queryEnumerator.hasMoreElements()) {
            return SearchEnumerator.nextElement(this.queryEnumerator);
        }
        if (this.markushEnumerator.hasMoreElements()) {
            Molecule m = this.markushEnumerator.nextElement();
            if (this.queryFeatures == 0) {
                SelectionUtil.select(m);
                return m;
            }
            this.queryEnumerator = SearchEnumerator.createQueryEnumerator(this.queryFeatures, m);
            this.queryEnumerator.setOrigNeeded(this.markushEnumerator.isOrigNeeded());
            this.queryEnumerator.setMarkushSearch(this.markushSearch);
            if (this.queryEnumerator.hasMoreElements()) {
                return SearchEnumerator.nextElement(this.queryEnumerator);
            }
        }
        return null;
    }

    private static Molecule nextElement(QueryMolEnumerator enumerator) {
        Molecule m = enumerator.nextElement();
        SelectionUtil.select(m);
        return m;
    }

    public static boolean isEnumerable(Molecule molP, int features) {
        return SearchEnumerator.isEnumerable(molP, null, features);
    }

    public static boolean isEnumerable(Molecule molP, int[] indexes, int features) {
        Molecule mol = molP;
        if (indexes != null) {
            mol = mol.cloneMolecule();
            SelectionUtil.select(mol, indexes);
        }
        int markushFeatures = SearchEnumerator.getMarkushFeatures(features);
        int queryFeatures = SearchEnumerator.getQueryFeatures(features);
        boolean enumerable = false;
        if (markushFeatures != 0) {
            MarkushEnumeratorFactory markushFactory = SearchEnumerator.getMarkushFactory(markushFeatures);
            boolean bl = enumerable = markushFactory.getFirstEnumeratorClone(mol, markushFeatures, "FreeMarkushEnumerationForInternalUseLicenseEnvironment") != null;
        }
        if (enumerable) {
            return true;
        }
        if (queryFeatures != 0) {
            QueryEnumeratorFactory queryFactory = SearchEnumerator.getQueryFactory(queryFeatures);
            enumerable = queryFactory.getFirstEnumeratorClone(mol, null, queryFeatures & 0xFFFFFDFF, (markushFeatures & 8) > 0, "FreeMarkushEnumerationForInternalUseLicenseEnvironment") != null;
        }
        return enumerable;
    }

    public static int getMarkushFeatures(int f) {
        return f & 0x1839;
    }

    public static int getQueryFeatures(int f) {
        return f & 0x47C6;
    }

    public static MolEnumerator createMarkushEnumerator(int markushFeatures, Molecule mol) {
        return SearchEnumerator.getMarkushFactory(markushFeatures).createEnumerator(mol);
    }

    public static QueryMolEnumerator createQueryEnumerator(int queryFeatures, Molecule mol) {
        return SearchEnumerator.getQueryFactory(queryFeatures).createEnumerator(mol);
    }

    private static synchronized MarkushEnumeratorFactory getMarkushFactory(int features) {
        WeakReference<MarkushEnumeratorFactory> ref;
        if (markushFactoryStore == null) {
            markushFactoryStore = new WeakHashMap();
        }
        MarkushEnumeratorFactory factory = null;
        if (markushFactoryStore.containsKey(features) && (ref = markushFactoryStore.get(features)) != null) {
            factory = (MarkushEnumeratorFactory)ref.get();
        }
        if (factory == null) {
            factory = new MarkushEnumeratorFactory(features);
            factory.setLicenseEnvironment("FreeMarkushEnumerationForInternalUseLicenseEnvironment");
            factory.setKeepSelectionMarkers(true);
            markushFactoryStore.put(features, new WeakReference<MarkushEnumeratorFactory>(factory));
        }
        return factory;
    }

    private static synchronized QueryEnumeratorFactory getQueryFactory(int features) {
        WeakReference<QueryEnumeratorFactory> ref;
        if (queryFactoryStore == null) {
            queryFactoryStore = new WeakHashMap();
        }
        QueryEnumeratorFactory factory = null;
        if (queryFactoryStore.containsKey(features) && (ref = queryFactoryStore.get(features)) != null) {
            factory = (QueryEnumeratorFactory)ref.get();
        }
        if (factory == null) {
            factory = new QueryEnumeratorFactory(features);
            factory.setLicenseEnvironment("FreeMarkushEnumerationForInternalUseLicenseEnvironment");
            queryFactoryStore.put(features, new WeakReference<QueryEnumeratorFactory>(factory));
        }
        return factory;
    }
}

