/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration;

import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.Sgroup;

public class SelectionUtil {
    private static final String MARKER = "MARKER";
    private static final Object NOT_SELECTED = new Object();

    public static void select(Molecule mol, int[] indexes) {
        int i;
        MoleculeGraph union = mol.getGraphUnion();
        int count = union.getAtomCount();
        for (i = count - 1; i >= 0; --i) {
            SelectionUtil.unselect(union.getAtom(i));
        }
        for (i = 0; i < indexes.length; ++i) {
            if (indexes[i] >= count || indexes[i] < 0) {
                throw new IllegalArgumentException("Selected atom index is out of range [1," + count + "]: " + (indexes[i] + 1));
            }
            SelectionUtil.select(union.getAtom(indexes[i]));
        }
    }

    public static void select(MolAtom a) {
        a.removeProperty(MARKER);
    }

    public static void unselect(MolAtom a) {
        a.putProperty(MARKER, NOT_SELECTED);
    }

    public static void select(Molecule mol) {
        MoleculeGraph union = mol.getGraphUnion();
        for (int i = union.getAtomCount() - 1; i >= 0; --i) {
            SelectionUtil.select(union.getAtom(i));
        }
    }

    public static void setSelected(MolAtom a, boolean selected) {
        if (selected) {
            SelectionUtil.select(a);
        } else {
            SelectionUtil.unselect(a);
        }
    }

    public static boolean isSelected(MolAtom atom) {
        return atom.getProperty(MARKER) != NOT_SELECTED;
    }

    public static boolean isSelected(Sgroup sgroup) {
        for (int j = sgroup.getAtomCount() - 1; j >= 0; --j) {
            if (SelectionUtil.isSelected(sgroup.getAtom(j))) continue;
            return false;
        }
        return true;
    }
}

