/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration;

import chemaxon.enumeration.QueryMolEnumerator;
import chemaxon.marvin.calculations.TautomerizationPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.sss.search.TautomerUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;

public class TautomerEnumerator
extends QueryMolEnumerator {
    protected Molecule mol = null;
    private boolean hasRun = false;
    private TautomerizationPlugin p;
    private int resultCount = 0;
    private int actual = 0;
    private static final int BT_SHIFT = 100;

    public TautomerEnumerator() {
    }

    public TautomerEnumerator(Molecule molP) {
        this.setMol(molP);
    }

    @Override
    public void setMol(Molecule molP) {
        this.mol = molP.getSimplifiedMolecule();
        this.init();
    }

    public Molecule getCommonSubstructure() {
        if (this.mol.isQuery()) {
            return this.generify(this.mol);
        }
        this.doRun();
        Molecule merged = this.p.getStructure(0);
        for (int i = 1; i < this.resultCount; ++i) {
            this.merge(merged, this.p.getStructure(i));
        }
        return merged;
    }

    private Molecule generify(Molecule mol) {
        int i;
        Molecule clone = (Molecule)mol.clone();
        for (i = 0; i < clone.getBondCount(); ++i) {
            MolBond b = clone.getBond(i);
            b.setType(0);
        }
        for (i = 0; i < clone.getAtomCount(); ++i) {
            clone.getAtom(i).setCharge(0);
            clone.getAtom(i).setRadical(0);
        }
        return clone;
    }

    private void merge(Molecule merged, Molecule result) {
        int i;
        for (i = 0; i < merged.getBondCount(); ++i) {
            int bt2;
            MolBond mergedBond = merged.getBond(i);
            int bt1 = mergedBond.getType();
            int newBondType = this.mergeBondTypes(bt1, bt2 = result.getBond(i).getType());
            if (newBondType == bt1) continue;
            mergedBond.setType(newBondType);
        }
        for (i = 0; i < merged.getAtomCount(); ++i) {
            MolAtom mergedAtom = merged.getAtom(i);
            MolAtom otherAtom = result.getAtom(i);
            if (mergedAtom.getCharge() != otherAtom.getCharge()) {
                mergedAtom.setCharge(0);
            }
            if (mergedAtom.getRadical() == otherAtom.getRadical()) continue;
            mergedAtom.setRadical(0);
        }
    }

    private int mergeBondTypes(int bt1, int bt2) {
        if (bt1 < bt2) {
            int temp = bt1;
            bt1 = bt2;
            bt2 = temp;
        }
        if (bt1 == bt2 || bt2 == 0) {
            return bt2;
        }
        switch (bt1 * 100 + bt2) {
            case 201: 
            case 501: 
            case 502: {
                return 5;
            }
            case 401: 
            case 601: 
            case 604: {
                return 6;
            }
            case 402: 
            case 702: 
            case 704: {
                return 7;
            }
        }
        return 0;
    }

    @Override
    public Object clone() {
        TautomerEnumerator en = (TautomerEnumerator)super.clone();
        en.mol = this.mol;
        en.init();
        return en;
    }

    private void init() {
        if (this.mol != null) {
            this.p = new TautomerizationPlugin();
            this.hasRun = false;
        }
    }

    @Override
    public boolean hasMoreElements() {
        this.doRun();
        return this.resultCount > this.actual;
    }

    private void doRun() {
        if (!this.hasRun) {
            this.hasRun = true;
            this.p.setLicenseEnvironment("LicenseEnvironmentForFreeIsomersInternalUsage");
            if (!TautomerUtil.isTautomerizable(this.p, this.mol)) {
                this.actual = 0;
                this.resultCount = 0;
                return;
            }
            try {
                this.p.setSymmetryFiltering(true);
                this.p.setExcludeAntiAromaticCompounds(false);
                this.p.setProtectAllTetrahedralStereoCenters(true);
                this.p.setProtectAromaticity(false);
                this.p.setRingChainTautomerizationAllowed(false);
                Molecule tauMol = this.mol.cloneMolecule();
                tauMol.aromatize(2);
                this.p.setMolecule(tauMol, false);
                this.p.run();
                this.resultCount = this.p.getStructureCount();
                if (this.resultCount > 1) {
                    ++this.resultCount;
                }
                this.actual = 0;
            }
            catch (PluginException e) {
                throw new RuntimeException(e.toString(), e);
            }
        }
    }

    @Override
    public Molecule nextElement() {
        if (this.hasMoreElements()) {
            if (this.actual == 0) {
                ++this.actual;
                return this.mol;
            }
            if (this.resultCount > 1) {
                Molecule nextMol = this.p.getStructure(this.actual - 1);
                ++this.actual;
                return nextMol;
            }
            throw new IllegalStateException("Tautomer enumerator has tried to access more tautomers than possible.");
        }
        return null;
    }

    @Override
    public void setLicenseEnvironment(String env) {
        if (this.p != null) {
            this.p.setLicenseEnvironment(env);
        }
    }
}

