/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration.bracket;

import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.IntVector;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;

public class PolymerUtil {
    private static final int[] polymerSgroupTypes = new int[]{11, 5, 15, 4, 3, 2, 7, 6, 12};
    private static final int[] notNeededBrackets = new int[]{4};

    private PolymerUtil() {
        throw new AssertionError((Object)"PolymerUtil is not allowed to be instantiated.");
    }

    public static void getRelevantTypes(IntVector neededTypes) {
        if (neededTypes == null) {
            neededTypes = new IntVector();
        }
        for (int type : polymerSgroupTypes) {
            if (ArrayTools.foundInArray(notNeededBrackets, type)) continue;
            neededTypes.add(type);
        }
    }

    public static boolean isPolymerSgroup(Sgroup sg) {
        int type = sg.getType();
        boolean typeOK = ArrayTools.foundInArray(polymerSgroupTypes, type);
        if (type == 2) {
            String subScript = sg.getSubscript();
            for (char c : subScript.toCharArray()) {
                if (!Character.isLetter(c)) continue;
                return true;
            }
            return false;
        }
        return typeOK;
    }

    public static int getFlipping(Sgroup sg) {
        if (sg instanceof RepeatingUnitSgroup) {
            RepeatingUnitSgroup rusg = (RepeatingUnitSgroup)sg;
            return rusg.isFlipped() ? 1 : 0;
        }
        return -1;
    }

    public static boolean hasPolymerSgroup(Molecule q) {
        int nSg = q.getSgroupCount();
        for (int i = 0; i < nSg; ++i) {
            if (!PolymerUtil.isPolymerSgroup(q.getSgroup(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isEndGroupH(MolAtom atom) {
        if (atom.getAtno() != 1) {
            return false;
        }
        int nb = atom.getBondCount();
        MoleculeGraph mg = atom.getParent();
        if (mg instanceof Molecule) {
            Molecule mol = (Molecule)mg;
            for (int i = 0; i < nb; ++i) {
                Sgroup neighSg;
                MolAtom neigh = atom.getLigand(i);
                for (neighSg = mol.findSgroupOf(neigh); neighSg != null && !PolymerUtil.isPolymerSgroup(neighSg); neighSg = neighSg.getParentSgroup()) {
                }
                if (neighSg == null || !PolymerUtil.isPolymerSgroup(neighSg)) continue;
                Sgroup sg = mol.findSgroupOf(atom);
                if (sg == null) {
                    return true;
                }
                for (Sgroup parentSg = neighSg.getParentSgroup(); parentSg != null; parentSg = parentSg.getParentSgroup()) {
                    if (parentSg != sg) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

