/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration.homology;

import chemaxon.common.util.ArrayTools;
import chemaxon.enumeration.SelectionUtil;
import chemaxon.enumeration.homology.HomologyConversionUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.util.DotfileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class HomologyConstants {
    private static final String[] ALKYL = new String[]{"alkyl", "chk"};
    private static final String[] ARYL = new String[]{"carboaryl", "aryl", "ary"};
    private static final String[] CYCLO_ALKYL = new String[]{"carboalicyclyl", "cycloalkyl", "cyc"};
    private static final String[] ALKENYL = new String[]{"alkenyl", "che"};
    private static final String[] ALKYNYL = new String[]{"alkynyl", "chy"};
    private static final String[] CARBON_TREE = new String[]{"carbontree", "acycliccarbon"};
    private static final String[] HETERO_ARYL = new String[]{"heteromonoaryl", "heteroaryl", "hea"};
    private static final String[] HETERO_CYC = new String[]{"heteromonoalicyclyl", "aliphaticheterocyclyl", "het", "heterocycle", "heterocyclyl"};
    private static final String[] FUSED_HETERO = new String[]{"fusedheterocyclyl", "fusedhetero", "hef"};
    private static final String[] ANY_CYCLE = new String[]{"cyclyl", "anyring", "anycyclyl"};
    private static final String[] RING_SEGMENT = new String[]{"ringsegment"};
    private static final String[] UNKNOWN = new String[]{"unknown", "unk"};
    private static final String[] METAL = new String[]{"metal", "mx"};
    private static final String[] ALKALI_METAL = new String[]{"alkalimetal", "amx"};
    private static final String[] OTHER_METAL = new String[]{"othermetal", "a35"};
    private static final String[] TRANSITION_METAL = new String[]{"transitionmetal", "trm"};
    private static final String[] LANTHANIDE = new String[]{"lanthanide", "lan"};
    private static final String[] ACTINIDE = new String[]{"actinide", "act"};
    private static final String[] ANYATOM = new String[]{"anyatom"};
    private static final String[] ANYGROUP = new String[]{"any", "xx"};
    private static final String[] ACYL = new String[0];
    private static final String[] HALOGEN = new String[]{"halogen", "hal"};
    private static final String[] FLUOR_CHROM = new String[0];
    private static final String[] PROTECTING = new String[]{"protecting", "prt"};
    private static final String[][] handledHomologies = new String[][]{ALKYL, ARYL, CYCLO_ALKYL, ALKENYL, ALKYNYL, CARBON_TREE, HETERO_ARYL, HETERO_CYC, FUSED_HETERO, ANY_CYCLE, RING_SEGMENT, UNKNOWN, METAL, ALKALI_METAL, OTHER_METAL, TRANSITION_METAL, LANTHANIDE, ACTINIDE, ANYATOM};
    private static final String[][] translatedToHomology = new String[][]{ACYL, ANYGROUP};
    private static final String[][] convertedHomologies = new String[][]{ACYL, HALOGEN, FLUOR_CHROM, PROTECTING, ANYGROUP};
    private static String[] homologiesInDir = null;
    private static final String[][] atomicHomologies = new String[][]{HALOGEN, ANYATOM, METAL, ALKALI_METAL, OTHER_METAL, TRANSITION_METAL, LANTHANIDE, ACTINIDE};
    private static final String[][] metallicHomologies = new String[][]{METAL, ALKALI_METAL, OTHER_METAL, TRANSITION_METAL, LANTHANIDE, ACTINIDE};
    public static final int ANYATOM_TYPE = 0;
    public static final int ALKYL_TYPE = 1;
    public static final int ARYL_TYPE = 2;
    public static final int CYCLO_ALKYL_TYPE = 3;
    public static final int ALKENYL_TYPE = 4;
    public static final int ALKYNYL_TYPE = 5;
    public static final int CARBON_TREE_TYPE = 6;
    public static final int HETERO_ARYL_TYPE = 7;
    public static final int HETERO_CYC_TYPE = 8;
    public static final int FUSED_HETERO_TYPE = 9;
    public static final int ANY_CYCLE_TYPE = 10;
    public static final int RING_SEGMENT_TYPE = 11;
    public static final int UNKNOWN_TYPE = 12;
    public static final int METAL_TYPE = 13;
    public static final int ALKALI_METAL_TYPE = 14;
    public static final int OTHER_METAL_TYPE = 15;
    public static final int TRANSITION_METAL_TYPE = 16;
    public static final int LANTHANIDE_TYPE = 17;
    public static final int ACTINIDE_TYPE = 18;
    public static final int ANYGROUP_TYPE = 19;
    public static final int HALOGEN_TYPE = 20;
    public static final int PROTECTING_TYPE = 21;
    public static final int NUMBER_OF_TYPES = 22;
    public static final int[] ACYCLIC_CARBONS = new int[]{1, 4, 5};
    public static final int[] CYCLIC_GROUPS = new int[]{2, 3, 7, 8, 9};
    public static final int[] METALLIC_GROUPS = new int[]{18, 14, 17, 13, 16, 15};
    private static final HashMap<String, Integer> homologyGroupTypeMap = new HashMap();
    public static final String enumDefPath = "homology/enumeration_only";
    public static final String convDefPath = "homology/user_def_groups";
    public static final String protectingName = "protecting";

    private HomologyConstants() {
        throw new AssertionError((Object)"HomologyConstants is not allowed to be instantiated.");
    }

    public static String getAliasStr(String homologyName, int rgID) {
        if (homologyName == null) {
            return "";
        }
        return homologyName + " (R" + rgID + ")";
    }

    public static String aliasToHomology(String aliasStr) {
        if (aliasStr == null) {
            return null;
        }
        int pos = aliasStr.lastIndexOf(32);
        if (pos < 0) {
            return null;
        }
        String subStr = aliasStr.substring(0, pos);
        if (HomologyConstants.isConvertibleHomology(subStr) || HomologyConstants.isHandledHomology(subStr)) {
            return subStr;
        }
        return null;
    }

    public static boolean isHomologyRAtom(MolAtom atom) {
        if (atom.getAliasstr() == null || atom.getAtno() != 134) {
            return false;
        }
        return HomologyConstants.aliasToHomology(atom.getAliasstr()) != null;
    }

    public static boolean isConvertibleHomology(String alias) {
        String[][] arrayToSearch;
        if (alias == null) {
            return false;
        }
        boolean preDef = false;
        for (String[] convHomology : arrayToSearch = convertedHomologies) {
            preDef |= ArrayTools.foundInArray(convHomology, HomologyConstants.getUniformAlias(alias));
        }
        if (homologiesInDir == null) {
            HomologyConstants.getHomologiesInDir();
        }
        boolean foundInDir = homologiesInDir != null ? ArrayTools.foundInArray(homologiesInDir, HomologyConstants.getUniformAlias(alias)) : false;
        boolean ret = preDef || foundInDir;
        return ret;
    }

    private static void getHomologiesInDir() {
        String f;
        String[] name;
        homologiesInDir = new String[0];
        File dir = DotfileUtil.getDotFile(convDefPath);
        if (dir == null) {
            return;
        }
        String[] files = dir.list();
        if (files == null) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        String[] arr$ = files;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (name = (f = arr$[i$]).split("\\.")).length == 2 && name[1].equals("mrv"); ++i$) {
            names.add(name[0]);
        }
        if (names.size() > 0) {
            homologiesInDir = new String[names.size()];
            for (int i = 0; i < names.size(); ++i) {
                HomologyConstants.homologiesInDir[i] = (String)names.get(i);
            }
        }
    }

    public static boolean isHandledHomology(String alias) {
        if (alias == null) {
            return false;
        }
        for (String[] handledHomology : handledHomologies) {
            if (!ArrayTools.foundInArray(handledHomology, HomologyConstants.getUniformAlias(alias))) continue;
            return true;
        }
        return false;
    }

    public static boolean isHomology(String alias) {
        if (alias == null) {
            return false;
        }
        return HomologyConstants.isHandledHomology(alias) || HomologyConstants.isConvertibleHomology(alias);
    }

    public static boolean isAtomicHomology(String alias) {
        if (alias == null) {
            return false;
        }
        for (String[] homology : atomicHomologies) {
            if (!ArrayTools.foundInArray(homology, HomologyConstants.getUniformAlias(alias))) continue;
            return true;
        }
        return false;
    }

    public static boolean isMetallicHomology(String alias) {
        if (alias == null) {
            return false;
        }
        for (String[] homology : metallicHomologies) {
            if (!ArrayTools.foundInArray(homology, HomologyConstants.getUniformAlias(alias))) continue;
            return true;
        }
        return false;
    }

    public static boolean isFullCyclicHomology(String pseudoStr) {
        if (pseudoStr == null) {
            return false;
        }
        return HomologyConstants.isCycloAlkyl(pseudoStr) || HomologyConstants.isAryl(pseudoStr) || HomologyConstants.isHeteroAryl(pseudoStr) || HomologyConstants.isAliphaticHeteroCyclyl(pseudoStr) || HomologyConstants.isFusedHetero(pseudoStr) || HomologyConstants.isAnyCycle(pseudoStr);
    }

    public static boolean isCyclicHomology(String pseudoStr) {
        if (pseudoStr == null) {
            return false;
        }
        return HomologyConstants.isFullCyclicHomology(pseudoStr) || HomologyConstants.isRingSegment(pseudoStr);
    }

    public static boolean isAromaticHomology(String pseudoStr) {
        if (pseudoStr == null) {
            return false;
        }
        return HomologyConstants.isAryl(pseudoStr) || HomologyConstants.isHeteroAryl(pseudoStr);
    }

    public static boolean isTranslatedToHomology(String alias) {
        if (alias == null) {
            return false;
        }
        for (String[] t : translatedToHomology) {
            if (!ArrayTools.foundInArray(t, HomologyConstants.getUniformAlias(alias))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasRgMolHomology(RgMolecule target) {
        if (HomologyConstants.hasMolHomology(target.getRoot())) {
            return true;
        }
        int rgroupCount = target.getRgroupCount();
        for (int i = 0; i < rgroupCount; ++i) {
            int rgroupMemberCount = target.getRgroupMemberCount(i);
            for (int j = 0; j < rgroupMemberCount; ++j) {
                if (!HomologyConstants.hasMolHomology(target.getRgroupMember(i, j))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasMolHomology(Molecule target) {
        if (target == null) {
            return false;
        }
        for (int i = 0; i < target.getAtomCount(); ++i) {
            MolAtom atom = target.getAtom(i);
            String alias = atom.getAliasstr();
            if (!atom.isPseudo() || alias == null || !HomologyConstants.isHomology(alias) || !SelectionUtil.isSelected(atom)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsHomology(Molecule target) {
        if (target == null) {
            return false;
        }
        if (target instanceof RgMolecule) {
            return HomologyConstants.hasRgMolHomology((RgMolecule)target);
        }
        return HomologyConstants.hasMolHomology(target);
    }

    public static boolean isAlkyl(String pseudoStr) {
        return ArrayTools.foundInArray(ALKYL, HomologyConstants.getUniformAlias(pseudoStr));
    }

    public static boolean isAryl(String pseudoStr) {
        return ArrayTools.foundInArray(ARYL, HomologyConstants.getUniformAlias(pseudoStr));
    }

    public static boolean isCycloAlkyl(String pseudoStr) {
        return ArrayTools.foundInArray(CYCLO_ALKYL, HomologyConstants.getUniformAlias(pseudoStr));
    }

    public static boolean isAlkenyl(String pseudoStr) {
        return ArrayTools.foundInArray(ALKENYL, HomologyConstants.getUniformAlias(pseudoStr));
    }

    public static boolean isAlkynyl(String pseudoStr) {
        return ArrayTools.foundInArray(ALKYNYL, HomologyConstants.getUniformAlias(pseudoStr));
    }

    public static boolean isCarbonTree(String pseudoStr) {
        return ArrayTools.foundInArray(CARBON_TREE, HomologyConstants.getUniformAlias(pseudoStr));
    }

    public static boolean isHeteroAryl(String pseudoStr) {
        return ArrayTools.foundInArray(HETERO_ARYL, HomologyConstants.getUniformAlias(pseudoStr));
    }

    public static boolean isAliphaticHeteroCyclyl(String pseudoStr) {
        return ArrayTools.foundInArray(HETERO_CYC, HomologyConstants.getUniformAlias(pseudoStr));
    }

    public static boolean isFusedHetero(String pseudoStr) {
        return ArrayTools.foundInArray(FUSED_HETERO, HomologyConstants.getUniformAlias(pseudoStr));
    }

    public static boolean isAnyCycle(String pseudoStr) {
        return ArrayTools.foundInArray(ANY_CYCLE, HomologyConstants.getUniformAlias(pseudoStr));
    }

    public static boolean isRingSegment(String pseudoStr) {
        return ArrayTools.foundInArray(RING_SEGMENT, HomologyConstants.getUniformAlias(pseudoStr));
    }

    public static boolean isUnknown(String pseudoStr) {
        return ArrayTools.foundInArray(UNKNOWN, HomologyConstants.getUniformAlias(pseudoStr));
    }

    public static boolean isMetal(String pseudoStr) {
        return ArrayTools.foundInArray(METAL, HomologyConstants.getUniformAlias(pseudoStr));
    }

    public static boolean isAlkaliMetal(String pseudoStr) {
        return ArrayTools.foundInArray(ALKALI_METAL, HomologyConstants.getUniformAlias(pseudoStr));
    }

    public static boolean isOtherMetal(String pseudoStr) {
        return ArrayTools.foundInArray(OTHER_METAL, HomologyConstants.getUniformAlias(pseudoStr));
    }

    public static boolean isTransitionMetal(String pseudoStr) {
        return ArrayTools.foundInArray(TRANSITION_METAL, HomologyConstants.getUniformAlias(pseudoStr));
    }

    public static boolean isLanthanide(String pseudoStr) {
        return ArrayTools.foundInArray(LANTHANIDE, HomologyConstants.getUniformAlias(pseudoStr));
    }

    public static boolean isActinide(String pseudoStr) {
        return ArrayTools.foundInArray(ACTINIDE, HomologyConstants.getUniformAlias(pseudoStr));
    }

    public static boolean isAnyAtom(String pseudoStr) {
        return ArrayTools.foundInArray(ANYATOM, HomologyConstants.getUniformAlias(pseudoStr));
    }

    public static boolean isAnyGroup(String pseudoStr) {
        return ArrayTools.foundInArray(ANYGROUP, HomologyConstants.getUniformAlias(pseudoStr));
    }

    public static boolean isProtecting(String hgName) {
        return ArrayTools.foundInArray(PROTECTING, HomologyConstants.getUniformAlias(hgName));
    }

    public static String getStandardHomologyName(String hgName) {
        String lowerHgName = HomologyConstants.getUniformAlias(hgName);
        for (String[] groupName : handledHomologies) {
            if (!ArrayTools.foundInArray(groupName, lowerHgName)) continue;
            return groupName[0];
        }
        for (String[] groupName : convertedHomologies) {
            if (!ArrayTools.foundInArray(groupName, lowerHgName)) continue;
            return groupName[0];
        }
        return lowerHgName;
    }

    public static String[] getAlternativeHomologyNames(String hgName) {
        String lowerHgName = HomologyConstants.getUniformAlias(hgName);
        for (String[] groupName : handledHomologies) {
            if (!ArrayTools.foundInArray(groupName, lowerHgName)) continue;
            return groupName;
        }
        for (String[] groupName : convertedHomologies) {
            if (!ArrayTools.foundInArray(groupName, lowerHgName)) continue;
            return groupName;
        }
        String[] ret = new String[]{lowerHgName};
        return ret;
    }

    private static String getUniformAlias(String alias) {
        if (alias == null) {
            return alias;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(alias.toLowerCase());
        for (int index = sb.length() - 1; index >= 0; --index) {
            if (sb.charAt(index) != ' ') continue;
            sb.deleteCharAt(index);
        }
        return sb.toString();
    }

    public static boolean containsQueryConvertibleHomology(Molecule query) {
        MoleculeGraph union = query.getGraphUnion();
        int n = union.getAtomCount();
        for (int i = 0; i < n; ++i) {
            MolAtom atom = union.getAtom(i);
            if (!atom.isPseudo() || HomologyConversionUtil.hasEqualTranslationProperty(atom) || !HomologyConstants.isConvertibleHomology(atom.getAliasstr())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasHomologyRAtom(Molecule mol) {
        int n = mol.getGraphUnion().getAtomCount();
        for (int i = 0; i < n; ++i) {
            if (!HomologyConstants.isHomologyRAtom(mol.getAtom(i))) continue;
            return true;
        }
        return false;
    }

    private static void addGroupToMap(String[] hgs, Integer type) {
        for (int index = 0; index < hgs.length; ++index) {
            homologyGroupTypeMap.put(hgs[index], type);
        }
    }

    public static int getHomologyTypeIndex(String alias) {
        String key = HomologyConstants.getUniformAlias(alias.toLowerCase());
        if (homologyGroupTypeMap.containsKey(key)) {
            return homologyGroupTypeMap.get(key);
        }
        return -1;
    }

    static {
        HomologyConstants.addGroupToMap(ALKYL, 1);
        HomologyConstants.addGroupToMap(ARYL, 2);
        HomologyConstants.addGroupToMap(CYCLO_ALKYL, 3);
        HomologyConstants.addGroupToMap(ALKENYL, 4);
        HomologyConstants.addGroupToMap(ALKYNYL, 5);
        HomologyConstants.addGroupToMap(CARBON_TREE, 6);
        HomologyConstants.addGroupToMap(HETERO_ARYL, 7);
        HomologyConstants.addGroupToMap(HETERO_CYC, 8);
        HomologyConstants.addGroupToMap(FUSED_HETERO, 9);
        HomologyConstants.addGroupToMap(ANY_CYCLE, 10);
        HomologyConstants.addGroupToMap(RING_SEGMENT, 11);
        HomologyConstants.addGroupToMap(UNKNOWN, 12);
        HomologyConstants.addGroupToMap(METAL, 13);
        HomologyConstants.addGroupToMap(ALKALI_METAL, 14);
        HomologyConstants.addGroupToMap(OTHER_METAL, 15);
        HomologyConstants.addGroupToMap(TRANSITION_METAL, 16);
        HomologyConstants.addGroupToMap(LANTHANIDE, 17);
        HomologyConstants.addGroupToMap(ACTINIDE, 18);
        HomologyConstants.addGroupToMap(ANYATOM, 0);
        HomologyConstants.addGroupToMap(ANYGROUP, 19);
        HomologyConstants.addGroupToMap(HALOGEN, 20);
        HomologyConstants.addGroupToMap(PROTECTING, 21);
    }
}

