/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration.homology;

import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.IntVector;
import chemaxon.core.calculations.BondClassifier;
import chemaxon.enumeration.ExpansionUtil;
import chemaxon.enumeration.SelectionUtil;
import chemaxon.enumeration.homology.HomologyConstants;
import chemaxon.enumeration.homology.HomologyProperties;
import chemaxon.enumeration.homology.HomologyPropertyChecker;
import chemaxon.enumeration.homology.HomologyPropertyEnumerationClassifier;
import chemaxon.enumeration.homology.HomologyPropertyStructureClassifier;
import chemaxon.enumeration.homology.HomologyPropertyTypes;
import chemaxon.enumeration.homology.StaticRgMoleculeUtil;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.calculations.MarkushEnumerationPlugin;
import chemaxon.marvin.modelling.struc.Substructure3DSearch;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.util.MolImportUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.util.ConfigUtils;
import chemaxon.util.DotfileUtil;
import chemaxon.util.RgMoleculeBondClassifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HomologyConversionUtil {
    private RgMolecule convMol = null;
    private int indexOfAtomToProcess;
    private int origAtomCount = 0;
    private int origRgCount = 0;
    private boolean converted = false;
    private int[] oldIndices = null;
    private final String toSearchAlias = "protectingDefinitionSearch";
    private boolean enumerateAll = false;
    private boolean queryMode = false;
    private HashMap<String, Integer> hgRgIdMap = null;
    private int rgIDforHG = -1;
    private HashMap<String, ArrayList<Molecule>> hgDefMap = null;
    private ArrayList<MolAtom> atomsToRemove = null;
    private int maxRgID = -1;
    private String postfixForNotHadled = "_notHandled";
    private RgMoleculeBondClassifier bondClassifier;
    private int atomCountAtClassification;
    private StaticRgMoleculeUtil srgm;
    private final boolean markConvertedAtoms;
    private static final Logger logger = Logger.getLogger(HomologyConversionUtil.class.getName());
    private static final String NL = System.getProperty("line.separator");
    private static final String HELP = "Usage:" + NL + "  java chemaxon.enumeration.homology.HomologyConversionUtil" + NL + "       [options] <mol file/string>" + NL + "          options: " + NL + "                   e: do enumeration, convert all homologies" + NL + "                   q: the molecule to convert is a query molecule";
    private static final String ATTACH_PSEUDO = "ATTACH_PSEUDO";
    private static final String ENUMERATION_CLASSIFIER_OBJECT = "enumeration_classifier";
    public static final String PROPERTY_ENUMERATION_FAILURE = "homology_property_enumeration_failure";
    private static final String EQUAL_TRANSLATION_ATOM = "equal_translation_atom";
    private static final String CONVERSION_RESULT_ATOM = "conversion_result_atom";

    public HomologyConversionUtil() {
        this.markConvertedAtoms = true;
    }

    public HomologyConversionUtil(Molecule mol) {
        this(mol, false, false, true);
    }

    public HomologyConversionUtil(Molecule mol, boolean enumerate, boolean isQuery) {
        this(mol, enumerate, false, true);
    }

    public HomologyConversionUtil(Molecule mol, boolean enumerate, boolean isQuery, boolean markConvertedAtoms) {
        this.markConvertedAtoms = markConvertedAtoms;
        this.setMol(mol, enumerate, false);
    }

    private void convert() {
        this.init();
        this.convertMol(this.convMol.getRoot());
        for (int rgInd = 0; rgInd < this.convMol.getRgroupCount(); ++rgInd) {
            if (rgInd >= this.srgm.getMemberFirstAtomIndexes().length) {
                this.srgm = new StaticRgMoleculeUtil(this.convMol);
            }
            int rgroupMemberCount = this.srgm.getRgroupMemberCount(rgInd);
            for (int rgMemberInd = 0; rgMemberInd < rgroupMemberCount; ++rgMemberInd) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Converting Rgroup:" + this.convMol.getRgroupId(rgInd) + " def:" + rgMemberInd);
                }
                this.convertMol(this.convMol.getRgroupMember(rgInd, rgMemberInd));
            }
        }
        this.removeDefinitionlessHG();
        if (this.queryMode) {
            try {
                this.convMol = HomologyConversionUtil.enumerateNestedRgr(this.convMol, true);
            }
            catch (PluginException e) {
                throw new IllegalArgumentException("The user-defined homology group definition is not markush enumerable.", e);
            }
        }
        this.calculateMapping();
    }

    private void removeDefinitionlessHG() {
        if (this.atomsToRemove == null) {
            return;
        }
        for (MolAtom a : this.atomsToRemove) {
            this.convMol.removeAtom(a);
        }
        this.atomsToRemove.clear();
    }

    private void init() {
        this.hgRgIdMap = new HashMap();
        this.hgDefMap = new HashMap();
        this.atomsToRemove = new ArrayList();
        this.maxRgID = -1;
        this.bondClassifier = null;
        this.atomCountAtClassification = 0;
        this.indexOfAtomToProcess = 0;
        this.srgm = new StaticRgMoleculeUtil(this.convMol);
    }

    private void calculateMapping() {
        MoleculeGraph union = this.convMol.getGraphUnion();
        int newNum = union.getAtomCount();
        this.oldIndices = new int[newNum];
        this.srgm = new StaticRgMoleculeUtil(this.convMol);
        for (int atomInd = 0; atomInd < newNum; ++atomInd) {
            if (atomInd < this.origAtomCount) {
                this.oldIndices[atomInd] = atomInd;
                continue;
            }
            int parentIndex = atomInd;
            while (parentIndex >= this.origAtomCount) {
                IntVector parents = this.srgm.getParentIndexes(parentIndex);
                if (parents.size() == 0) {
                    parentIndex = -1;
                    break;
                }
                parentIndex = parents.get(0);
            }
            this.oldIndices[atomInd] = parentIndex;
        }
    }

    private void convertMol(Molecule mol) {
        int atomCount = mol.getAtomCount();
        for (int i = 0; i < atomCount; ++i) {
            String alias;
            MolAtom a = mol.getAtom(i);
            if (a.getAtno() == 136 && (HomologyConstants.isConvertibleHomology(alias = a.getAliasstr()) && !HomologyConversionUtil.hasEqualTranslationProperty(a) || this.enumerateAll && HomologyConstants.isHandledHomology(alias)) && (!this.enumerateAll || SelectionUtil.isSelected(a))) {
                this.convertAtom(a);
            }
            ++this.indexOfAtomToProcess;
        }
    }

    private void convertAtom(MolAtom a) {
        String homologyName = a.getAliasstr();
        int rgID = this.getMaxRgroupID() + 1;
        this.rgIDforHG = -1;
        Molecule[][] rgDefs = this.readHomologyRepresentation(a, rgID);
        if (this.rgIDforHG != -1) {
            rgID = this.rgIDforHG;
        } else {
            if (rgDefs == null) {
                if (!this.enumerateAll) {
                    a.setAliasstr(a.getAliasstr() + this.postfixForNotHadled);
                }
                return;
            }
            this.converted = true;
            for (int rgIdOffset = 0; rgIdOffset < rgDefs.length; ++rgIdOffset) {
                for (int rgMemberInd = 0; rgMemberInd < rgDefs[rgIdOffset].length; ++rgMemberInd) {
                    int memberAtomCount = rgDefs[rgIdOffset][rgMemberInd].getAtomCount();
                    for (int memberAtomInd = 0; memberAtomInd < memberAtomCount; ++memberAtomInd) {
                        SelectionUtil.select(rgDefs[rgIdOffset][rgMemberInd].getAtom(memberAtomInd));
                        if (!this.markConvertedAtoms) continue;
                        HomologyConversionUtil.setConvertedProperty(rgDefs[rgIdOffset][rgMemberInd].getAtom(memberAtomInd));
                    }
                    this.convMol.addRgroup(rgID + rgIdOffset, rgDefs[rgIdOffset][rgMemberInd]);
                }
                ++this.maxRgID;
                if (rgIdOffset != 0 || this.enumerateAll || this.indexOfAtomToProcess >= this.origAtomCount) continue;
                this.addHomologyAtomAsRgMember(a, rgID);
            }
        }
        a.setAtno(134);
        a.setRgroup(rgID);
        a.setAliasstr(HomologyConstants.getAliasStr(homologyName, rgID));
    }

    private void addHomologyAtomAsRgMember(MolAtom a, int rgID) {
        Molecule rgMember = new Molecule();
        MolAtom newPseudoAtom = new MolAtom(136);
        newPseudoAtom.set(a);
        rgMember.add(newPseudoAtom);
        this.removeSuperflAtt(new Molecule[]{rgMember}, a);
        HomologyConversionUtil.setEqualTranslationProperty(newPseudoAtom);
        this.convMol.addRgroup(rgID, rgMember);
    }

    private static void setEqualTranslationProperty(MolAtom newPseudoAtom) {
        newPseudoAtom.putProperty(EQUAL_TRANSLATION_ATOM, Boolean.TRUE);
    }

    public static boolean hasEqualTranslationProperty(MolAtom a) {
        return Boolean.TRUE.equals(a.getProperty(EQUAL_TRANSLATION_ATOM));
    }

    private static void setConvertedProperty(MolAtom newPseudoAtom) {
        newPseudoAtom.putProperty(CONVERSION_RESULT_ATOM, Boolean.TRUE);
    }

    public static boolean hasConvertedProperty(MolAtom a) {
        return Boolean.TRUE.equals(a.getProperty(CONVERSION_RESULT_ATOM));
    }

    private int getMaxRgroupID() {
        if (this.maxRgID == -1) {
            int i;
            int n = this.convMol.getRgroupCount();
            for (i = 0; i < n; ++i) {
                if (this.maxRgID >= this.convMol.getRgroupId(i)) continue;
                this.maxRgID = this.convMol.getRgroupId(i);
            }
            n = this.convMol.getGraphUnion().getAtomCount();
            for (i = 0; i < n; ++i) {
                int r = this.convMol.getAtom(i).getRgroup();
                if (this.maxRgID >= r) continue;
                this.maxRgID = r;
            }
        }
        return this.maxRgID;
    }

    private Molecule[][] readHomologyRepresentation(MolAtom a, int rgID) {
        String hgName = a.getAliasstr();
        Molecule[][] ret = null;
        boolean enumerating = false;
        try {
            enumerating = this.enumerateAll;
            ret = this.readContextSensitiveRepresentation(a, rgID, enumerating);
            if (ret == null || ret[0] == null) {
                return null;
            }
            ret[0] = this.removeSuperflAtt(ret[0], a);
            return ret;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unhandled homology used:" + hgName);
        }
    }

    private Molecule[] removeSuperflAtt(Molecule[] ret, MolAtom hgAtom) {
        int bondCount = MolImportUtil.countBondsAndAttachments(hgAtom);
        for (int j = 0; j < ret.length; ++j) {
            MolAtom[] attachAtoms;
            Molecule mol = ret[j];
            for (MolAtom a : attachAtoms = MolImportUtil.getAtomsWithAttachments(mol)) {
                MolImportUtil.clearAttachments(a);
            }
            for (int i = 0; i < bondCount && i < attachAtoms.length; ++i) {
                attachAtoms[i].addRgroupAttachmentPoint(i + 1, 1);
            }
            if (bondCount > attachAtoms.length) {
                ret[j] = HomologyConversionUtil.addRandomAttachmentPoints(mol, bondCount, hgAtom.getAliasstr(), attachAtoms.length);
                continue;
            }
            if (bondCount != 0) continue;
            ret[j] = HomologyConversionUtil.addRandomAttachmentPoints(mol, 1, hgAtom.getAliasstr(), 0);
        }
        ArrayList<Molecule> nonNullElements = new ArrayList<Molecule>();
        for (Molecule m : ret) {
            if (m == null) continue;
            nonNullElements.add(m);
        }
        Molecule[] ret2 = new Molecule[nonNullElements.size()];
        for (int i = 0; i < ret2.length; ++i) {
            ret2[i] = (Molecule)nonNullElements.get(i);
        }
        ret = ret2;
        if (ret.length == 0) {
            if (this.isInDefinitionOfHg(hgAtom)) {
                this.atomsToRemove.add(hgAtom);
            } else {
                throw new IllegalArgumentException("No suitable definition with enough free valence sites (" + bondCount + ") is found for atom: " + hgAtom.getAliasstr() + " atom index:" + this.convMol.indexOf(hgAtom));
            }
        }
        return ret;
    }

    private boolean isInDefinitionOfHg(MolAtom hgAtom) {
        return this.convMol.rgroupIndexOf(hgAtom) >= this.origRgCount;
    }

    public static Molecule addRandomAttachmentPoints(Molecule mol, int bondCount, String hgAlias, int length) {
        boolean isCyclic = HomologyConstants.isFullCyclicHomology(hgAlias);
        boolean isAromatic = HomologyConstants.isAromaticHomology(hgAlias);
        BondClassifier bc = null;
        if (isCyclic) {
            bc = new BondClassifier();
            bc.classify(mol);
        }
        int atInd = -1;
        mol.valenceCheck();
        int atCount = mol.getAtomCount();
        for (int i = length + 1; i < bondCount + 1; ++i) {
            boolean found = false;
            int firstAtInd = (atInd + atCount) % atCount;
            while (!found) {
                atInd = (atInd + 1) % atCount;
                MolAtom currAtom = mol.getAtom(atInd);
                if ((!isCyclic || bc != null && bc.isRingAtom(atInd)) && (!isAromatic || currAtom.hasAromaticBond()) && (currAtom.getImplicitHcount() > 0 || HomologyConstants.isAtomicHomology(hgAlias) || currAtom.isPseudo()) && currAtom.getAtno() != 138) {
                    found = true;
                }
                if (firstAtInd != atInd) continue;
                break;
            }
            if (!found) {
                return null;
            }
            mol.getAtom(atInd).addRgroupAttachmentPoint(i, 1);
            mol.valenceCheck();
        }
        return mol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Molecule[][] readContextSensitiveRepresentation(MolAtom a, int rgID, boolean isEnumeration) throws IOException {
        String hgName = a.getAliasstr();
        InputStream file = this.getDirName(hgName, isEnumeration);
        if (file == null) {
            throw new IllegalArgumentException("Unhandled homology used:" + hgName);
        }
        try {
            this.readDefinitionsForHg(file, hgName);
            Molecule m = null;
            int defInd = -1;
            while ((m = this.getNextDefinition(hgName, ++defInd)) != null) {
                if (!(m instanceof RgMolecule)) continue;
                RgMolecule rgm = (RgMolecule)m;
                if (!this.hasSameContext(rgm.getRoot(), a)) continue;
                if (rgm.getRgroupCount() == 0 || rgm.getAtomCount() == 0) {
                    Molecule[][] moleculeArray = null;
                    return moleculeArray;
                }
                if (this.isRgIDStoredInMap(a, defInd, rgID)) {
                    Molecule[][] moleculeArray = null;
                    return moleculeArray;
                }
                RgMolecule rgmClone = (RgMolecule)rgm.cloneMolecule();
                Molecule[][] ret = this.readRgroupDefinitions(rgmClone, rgID);
                if (ret != null) {
                    ret[0] = this.enforceHomologyProperties(ret[0], a, rgm, rgmClone);
                }
                Molecule[][] moleculeArray = ret;
                return moleculeArray;
            }
        }
        finally {
            file.close();
        }
        return null;
    }

    private Molecule[] enforceHomologyProperties(Molecule[] molecules, MolAtom homologyAtom, RgMolecule rgm, RgMolecule rgmClone) {
        if (homologyAtom.propertyCount() == 0) {
            return molecules;
        }
        if (HomologyConstants.isConvertibleHomology(homologyAtom.getAliasstr())) {
            HomologyConversionUtil.copyPropertiesToDefinitions(homologyAtom, molecules);
            return molecules;
        }
        ArrayList<Molecule> filtered = new ArrayList<Molecule>();
        for (int i = 0; i < molecules.length; ++i) {
            HomologyPropertyEnumerationClassifier hpec;
            Molecule m = molecules[i];
            long id = rgmClone.getRgroupMemberID(m.getAtom(0));
            Molecule origDef = rgm.getRgroupMember(rgmClone.getRgroupIndex(id), rgmClone.getRgroupMemberIndex(id));
            Object classif = origDef.getPropertyObject(ENUMERATION_CLASSIFIER_OBJECT);
            if (classif instanceof HomologyPropertyEnumerationClassifier) {
                hpec = (HomologyPropertyEnumerationClassifier)classif;
            } else {
                hpec = new HomologyPropertyEnumerationClassifier(m, HomologyConstants.isFullCyclicHomology(homologyAtom.getAliasstr()));
                origDef.setPropertyObject(ENUMERATION_CLASSIFIER_OBJECT, hpec);
            }
            HomologyProperties hproperties = new HomologyProperties(homologyAtom);
            if (!HomologyPropertyChecker.isBranchingOK(hproperties, hpec, 0) || !HomologyPropertyChecker.isRingPropOK(hproperties, hpec, 0) || !HomologyPropertyChecker.isDTCountOK(hproperties, hpec, 0, false) || !HomologyPropertyChecker.isSizeOK(hproperties, hpec, 0) || !HomologyPropertyChecker.isTextNoteOK(hproperties, hpec, 0)) continue;
            m.setPropertyObject(ENUMERATION_CLASSIFIER_OBJECT, null);
            filtered.add(m);
        }
        if (filtered.size() == 0) {
            StringBuffer sb = new StringBuffer();
            HomologyConversionUtil.addHomologyPropertyStrings(sb, homologyAtom);
            String rgroupID = this.convMol.rgroupIdOf(homologyAtom) > -1 ? String.valueOf(this.convMol.rgroupIdOf(homologyAtom)) : "root";
            String errorStr = "No enumeration definitions fulfill the properties of homology atom " + homologyAtom.getAliasstr() + ", atom index: " + (this.convMol.indexOf(homologyAtom) + 1) + ", rgroup id: " + rgroupID + ", properties: " + sb.toString();
            logger.warning(errorStr);
            homologyAtom.putProperty(PROPERTY_ENUMERATION_FAILURE, errorStr);
            return null;
        }
        return filtered.toArray(new Molecule[0]);
    }

    private static void copyPropertiesToDefinitions(MolAtom homologyAtom, Molecule[] molecules) {
        Set<String> keySet = homologyAtom.propertyKeySet();
        for (Molecule m : molecules) {
            int n = m.getAtomCount();
            for (int i = 0; i < n; ++i) {
                MolAtom atom = m.getAtom(i);
                if (!HomologyConstants.isHomology(atom.getAliasstr())) continue;
                for (String key : keySet) {
                    atom.putProperty(key, homologyAtom.getProperty(key));
                }
            }
        }
    }

    private static RgMolecule enumerateNestedRgr(RgMolecule rgm, boolean onlyUserdefHg) throws PluginException {
        RgMolecule generatorMol = (RgMolecule)rgm.cloneMolecule();
        generatorMol.getRoot().removeAll();
        IntVector processedR = new IntVector();
        int rN = rgm.getRoot().getAtomCount();
        for (int rI = 0; rI < rN; ++rI) {
            MolAtom rootAtom = rgm.getRoot().getAtom(rI);
            int rgID = rootAtom.getRgroup();
            if (rootAtom.getAtno() != 134 || processedR.contains(rgID) || HomologyConstants.aliasToHomology(rootAtom.getAliasstr()) == null) continue;
            int rgInd = rgm.findRgroupIndex(rgID);
            for (int mI = rgm.getRgroupMemberCount(rgInd) - 1; mI >= 0; --mI) {
                Molecule r;
                Molecule member = rgm.getRgroupMember(rgInd, mI);
                if (!HomologyConversionUtil.hasRAtom(member)) continue;
                Molecule memberClone = member.cloneMolecule();
                HomologyConversionUtil.addAttachPseudoAtoms(memberClone);
                generatorMol.setRoot(memberClone);
                MarkushEnumerationPlugin mep = new MarkushEnumerationPlugin();
                mep.setLicenseEnvironment("FreeMarkushEnumerationForInternalUseLicenseEnvironment");
                mep.setEnumerateHomology(false);
                mep.setFilter(null);
                mep.setMolecule(generatorMol);
                mep.run();
                while ((r = mep.getNextStructure()) != null) {
                    HomologyConversionUtil.removeAttachPseudoAtoms(r);
                    rgm.addRgroup(rgID, r);
                }
                for (int i = member.getAtomCount() - 1; i >= 0; --i) {
                    rgm.removeAtom(member.getAtom(i));
                }
                rgm = (RgMolecule)ExpansionUtil.fixRgroupDefs(rgm);
            }
        }
        return rgm;
    }

    private static void removeAttachPseudoAtoms(Molecule mol) {
        for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom = mol.getAtom(i);
            String alias = atom.getAliasstr();
            if (atom.getAtno() != 136 || !alias.startsWith(ATTACH_PSEUDO)) continue;
            int attachNum = Integer.parseInt(alias.substring(ATTACH_PSEUDO.length()));
            MolAtom neigh = atom.getLigand(0);
            neigh.addRgroupAttachmentPoint(attachNum, 1);
            mol.removeAtom(atom);
        }
    }

    private static void addAttachPseudoAtoms(Molecule member) {
        MolAtom[] attachAtoms = MolImportUtil.getAtomsWithAttachments(member);
        for (int i = 0; i < attachAtoms.length; ++i) {
            MolAtom pseudo = new MolAtom(136);
            pseudo.setAliasstr(ATTACH_PSEUDO + String.valueOf(i + 1));
            MolBond bond = new MolBond(attachAtoms[i], pseudo);
            member.add(pseudo);
            member.add(bond);
            MolImportUtil.clearAttachments(attachAtoms[i]);
        }
    }

    private static boolean hasRAtom(Molecule mol) {
        int n = mol.getAtomCount();
        for (int i = 0; i < n; ++i) {
            MolAtom atom = mol.getAtom(i);
            if (atom.getAtno() != 134) continue;
            return true;
        }
        return false;
    }

    private Molecule getNextDefinition(String hgName, int defInd) {
        if (this.hgDefMap.get(hgName = HomologyConstants.getStandardHomologyName(hgName)) == null) {
            throw new IllegalArgumentException("Definition data is not cached for homology: " + hgName);
        }
        ArrayList<Molecule> hgDef = this.hgDefMap.get(hgName);
        if (defInd < hgDef.size()) {
            return hgDef.get(defInd);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDefinitionsForHg(InputStream file, String hgName) throws MolFormatException, IOException {
        if (this.hgDefMap.containsKey(HomologyConstants.getStandardHomologyName(hgName = HomologyConstants.getStandardHomologyName(hgName)))) {
            return;
        }
        MolImporter imp = new MolImporter(file);
        try {
            Molecule m = null;
            ArrayList<Molecule> molArray = new ArrayList<Molecule>();
            while ((m = imp.read()) != null) {
                molArray.add(m);
            }
            this.hgDefMap.put(hgName, molArray);
        }
        finally {
            imp.close();
        }
    }

    private boolean isRgIDStoredInMap(MolAtom a, int defInd, int rgID) {
        if (!this.enumerateAll) {
            return false;
        }
        String hgName = a.getAliasstr();
        int bondCount = MolImportUtil.countBondsAndAttachments(a);
        StringBuffer sb = new StringBuffer();
        sb.append(hgName);
        sb.append(bondCount);
        sb.append("_");
        sb.append(defInd);
        HomologyConversionUtil.addHomologyPropertyStrings(sb, a);
        String key = sb.toString();
        Integer value = this.hgRgIdMap.get(key);
        if (value != null) {
            this.rgIDforHG = value;
            return true;
        }
        this.hgRgIdMap.put(key, rgID);
        this.rgIDforHG = -1;
        return false;
    }

    private static void addHomologyPropertyStrings(StringBuffer sb, MolAtom a) {
        String[] propertyNames;
        for (String name : propertyNames = HomologyPropertyTypes.getApplicableReservedPropertyNames(a)) {
            Object value = a.getProperty(name);
            if (!(value instanceof String)) continue;
            sb.append((String)value);
            sb.append(" ");
        }
    }

    private Molecule[][] readRgroupDefinitions(RgMolecule rgm, int rgID) {
        int i;
        if (rgm.getRgroupCount() <= 0) {
            return null;
        }
        Molecule root = rgm.getRoot();
        int rootRgID = -1;
        for (int i2 = 0; i2 < root.getAtomCount() && rootRgID == -1; ++i2) {
            MolAtom a = root.getAtom(i2);
            if (a.getAtno() != 134) continue;
            rootRgID = a.getRgroup();
        }
        if (rootRgID == -1) {
            return null;
        }
        int lineNum = 1;
        int rgNum = rgm.getRgroupCount();
        int[] map = new int[rgNum];
        Molecule[][] ret = new Molecule[rgNum][];
        for (i = 0; i < rgNum; ++i) {
            int currLine;
            int id = rgm.getRgroupId(i);
            int n = currLine = id == rootRgID ? 0 : lineNum;
            if (id != rootRgID) {
                ++lineNum;
            }
            ret[currLine] = new Molecule[rgm.getRgroupMemberCount(i)];
            for (int j = 0; j < rgm.getRgroupMemberCount(i); ++j) {
                ret[currLine][j] = rgm.getRgroupMember(i, j);
            }
            map[i] = rgID + currLine;
        }
        if (rgNum > 1) {
            for (i = 0; i < ret.length; ++i) {
                for (int j = 0; j < ret[i].length; ++j) {
                    for (int k = 0; k < ret[i][j].getAtomCount(); ++k) {
                        MolAtom a = ret[i][j].getAtom(k);
                        if (a.getAtno() != 134) continue;
                        a.setRgroup(map[rgm.findRgroupIndex(a.getRgroup())]);
                    }
                }
            }
        }
        return ret;
    }

    private boolean hasSameContext(Molecule root, MolAtom a) {
        Molecule rootQuery = root.cloneMolecule();
        MolAtom rAtom = null;
        int n = rootQuery.getAtomCount();
        for (int i = 0; i < n; ++i) {
            if (rootQuery.getAtom(i).getAtno() != 134) continue;
            rAtom = rootQuery.getAtom(i);
            break;
        }
        if (rAtom == null) {
            throw new IllegalArgumentException("Missing R-atom in homology definition file of atom: " + a.getAliasstr());
        }
        if (!this.isRingpropOK(rAtom, a)) {
            return false;
        }
        rAtom.setAtno(136);
        rAtom.setAliasstr("protectingDefinitionSearch");
        String hgName = a.getAliasstr();
        MolAtom[] changedRAtom = new MolAtom[2];
        Molecule target = this.getMolAroundHomology(a, changedRAtom);
        int j = 0;
        for (j = 0; j < target.getAtomCount() && target.getAtom(j).getAliasstr() != "protectingDefinitionSearch"; ++j) {
        }
        Substructure3DSearch sss3D = new Substructure3DSearch();
        sss3D.setMolecules(rootQuery, target);
        int[] frozenHits = null;
        frozenHits = ArrayTools.initArrayAndFill(frozenHits, rootQuery.getAtomCount(), -1);
        frozenHits[i] = j;
        sss3D.setFrozenMatch(frozenHits);
        boolean match = sss3D.findFirst();
        a.setAliasstr(hgName);
        if (changedRAtom[0] != null && changedRAtom[1] != null) {
            changedRAtom[1].setAtno(134);
            changedRAtom[1].setAliasstr(changedRAtom[0].getAliasstr());
        }
        return match;
    }

    private boolean isRingpropOK(MolAtom rAtom, MolAtom a) {
        boolean isRingRatom;
        boolean bl = isRingRatom = rAtom.getQPropAsInt("R") > 0 || rAtom.getQPropAsInt("r") > 0;
        if (!isRingRatom) {
            return true;
        }
        int atomIndex = this.convMol.indexOf(a);
        if (this.bondClassifier == null || this.atomCountAtClassification <= atomIndex) {
            this.atomCountAtClassification = this.convMol.getGraphUnion().getAtomCount();
            this.bondClassifier = new RgMoleculeBondClassifier();
            this.bondClassifier.classify(this.convMol);
        }
        return this.bondClassifier.isRingAtom(atomIndex);
    }

    private Molecule getMolAroundHomology(MolAtom a, MolAtom[] changedRAtom) {
        String origName = a.getAliasstr();
        a.setAliasstr("protectingDefinitionSearch");
        StaticRgMoleculeUtil.RgroupMemberShip rgroupMemberShip = this.srgm.getRgroupMemberShip(this.indexOfAtomToProcess);
        int rInd = rgroupMemberShip.rgIndex;
        if (rInd == -1) {
            return this.convMol.getRoot();
        }
        int rgMemInd = rgroupMemberShip.rgMemberIndex;
        Molecule target = this.convMol.getRgroupMember(rInd, rgMemInd);
        if (target.getAtomCount() == 2 && a.getLigand(0).getAtno() == 138) {
            int parentAtomIndex = this.srgm.getParentIndexes(this.indexOfAtomToProcess).get(0);
            StaticRgMoleculeUtil.RgroupMemberShip parentMembership = this.srgm.getRgroupMemberShip(parentAtomIndex);
            MolAtom parentRAtom = this.findParentRAtom(parentAtomIndex, parentMembership);
            changedRAtom[0] = (MolAtom)parentRAtom.clone();
            parentRAtom.setAtno(136);
            parentRAtom.setAliasstr("protectingDefinitionSearch");
            changedRAtom[1] = parentRAtom;
            int parentRgIndex = parentMembership.rgIndex;
            if (parentRgIndex == -1) {
                return this.convMol.getRoot();
            }
            int parentRgMemberIndex = parentMembership.rgMemberIndex;
            target = this.convMol.getRgroupMember(parentRgIndex, parentRgMemberIndex);
        }
        if (target instanceof RgMolecule) {
            target = ((RgMolecule)target).getRoot();
        }
        return target;
    }

    private MolAtom findParentRAtom(int parentAtomIndex, StaticRgMoleculeUtil.RgroupMemberShip parentMembership) {
        MolAtom parentRAtom;
        if (parentMembership.rgIndex == -1) {
            parentRAtom = this.convMol.getRoot().getAtom(parentAtomIndex);
        } else {
            Molecule member = this.convMol.getRgroupMember(parentMembership.rgIndex, parentMembership.rgMemberIndex);
            int parentIndexInMember = parentAtomIndex - this.srgm.getMemberFirstAtomIndex(parentMembership.rgIndex, parentMembership.rgMemberIndex);
            parentRAtom = member.getAtom(parentIndexInMember);
        }
        return parentRAtom;
    }

    private InputStream getDirName(String hgName, boolean enumerating) {
        int i;
        int i2;
        hgName = hgName.toLowerCase();
        String[] hgNames = HomologyConstants.getAlternativeHomologyNames(hgName);
        File file = null;
        String[] extensions = new String[]{".mrv", ".mrv.gz"};
        if (enumerating) {
            for (String extension : extensions) {
                for (i2 = 0; !(i2 >= hgNames.length || file != null && file.exists()); ++i2) {
                    file = DotfileUtil.getDotFile("homology/enumeration_only/" + hgNames[i2] + extension);
                }
            }
        }
        for (String extension : extensions) {
            for (i2 = 0; !(i2 >= hgNames.length || file != null && file.exists()); ++i2) {
                file = DotfileUtil.getDotFile("homology/user_def_groups/" + hgNames[i2] + extension);
            }
        }
        if (file != null && file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        InputStream stream = null;
        if (enumerating) {
            for (String extension : extensions) {
                for (i = 0; i < hgNames.length && stream == null; ++i) {
                    stream = HomologyConversionUtil.class.getResourceAsStream("/chemaxon/enumeration/homology/enumeration_only/" + hgNames[i] + extension);
                }
            }
        }
        for (String extension : extensions) {
            for (i = 0; i < hgNames.length && stream == null; ++i) {
                stream = HomologyConversionUtil.class.getResourceAsStream("/chemaxon/enumeration/homology/user_def_groups/" + hgNames[i] + extension);
            }
        }
        if (stream != null) {
            return stream;
        }
        return null;
    }

    public void setMol(Molecule mol, boolean enumerate, boolean isQuery) {
        this.origAtomCount = mol instanceof RgMolecule ? mol.getGraphUnion().getAtomCount() : mol.getAtomCount();
        this.origRgCount = mol instanceof RgMolecule ? ((RgMolecule)mol).getRgroupCount() : 0;
        this.converted = false;
        this.enumerateAll = enumerate;
        this.queryMode = isQuery;
        if (mol instanceof RgMolecule) {
            this.convMol = (RgMolecule)mol;
        } else {
            this.convMol = new RgMolecule();
            this.convMol.setRoot(mol);
        }
        this.convMol = (RgMolecule)this.convMol.cloneMolecule();
        this.convert();
    }

    public void setMol(Molecule mol) {
        this.setMol(mol, false, false);
    }

    public void setConvertedMol(Molecule convertedMol) {
        RgMolecule rgMol = null;
        if (convertedMol instanceof RgMolecule) {
            rgMol = (RgMolecule)convertedMol;
        } else {
            rgMol = new RgMolecule();
            rgMol.setRoot(convertedMol);
        }
        this.convMol = rgMol;
        this.oldIndices = HomologyConversionUtil.calculateMapFromConverted(rgMol);
    }

    public Molecule getConvertedMol() {
        return this.convMol;
    }

    public int[] getMap() {
        return this.oldIndices;
    }

    public static int getAdditionalBondsFromAromatic(int strIndex, int type, HomologyPropertyStructureClassifier hpsc) {
        if (type == 2) {
            return hpsc.getQuantityOfBonds(strIndex, 4) >> 1;
        }
        if (type == 1) {
            int aromNum = hpsc.getQuantityOfBonds(strIndex, 4);
            return (aromNum >> 1) + (aromNum & 1);
        }
        return 0;
    }

    public static int[] calculateMapFromConverted(RgMolecule convertedMol) {
        StaticRgMoleculeUtil srgm = new StaticRgMoleculeUtil(convertedMol);
        MoleculeGraph union = convertedMol.getGraphUnion();
        int[] map = null;
        int unionAtomCount = union.getAtomCount();
        map = ArrayTools.initArrayAndFill(map, unionAtomCount, -1);
        for (int i = 0; i < unionAtomCount; ++i) {
            String homologyName;
            if (map[i] != -1) continue;
            map[i] = i;
            MolAtom atom = union.getAtom(i);
            if (atom.getAtno() != 134 || (homologyName = HomologyConstants.aliasToHomology(atom.getAliasstr())) == null) continue;
            int[] defInd = HomologyConversionUtil.getRgroupDefinition(atom, convertedMol, srgm);
            for (int j = 0; j < defInd.length; ++j) {
                map[defInd[j]] = i;
            }
        }
        return map;
    }

    private static int[] getRgroupDefinition(MolAtom rgAtom, RgMolecule convertedMol, StaticRgMoleculeUtil srgm) {
        int rgInd = srgm.getRgIndexFromId(rgAtom.getRgroup());
        IntVector ret = new IntVector();
        int rgGroupMemberCount = srgm.getRgroupMemberCount(rgInd);
        for (int i = 0; i < rgGroupMemberCount; ++i) {
            Molecule member = convertedMol.getRgroupMember(rgInd, i);
            int atomInd = srgm.getMemberFirstAtomIndex(rgInd, i);
            int memberAtomCount = member.getAtomCount();
            for (int j = 0; j < memberAtomCount; ++j) {
                MolAtom atom = member.getAtom(j);
                ret.add(atomInd + j);
                if (atom.getAtno() != 134) continue;
                int[] defInd = HomologyConversionUtil.getRgroupDefinition(atom, convertedMol, srgm);
                for (int k = 0; k < defInd.length; ++k) {
                    ret.add(defInd[k]);
                }
            }
        }
        return ret.toArray();
    }

    public static void deconvertHomologies(Molecule mol, boolean removeDef) {
        IntVector homologyAtoms = new IntVector();
        MoleculeGraph molUnion = mol.getGraphUnion();
        int unionAtomCount = molUnion.getAtomCount();
        MolAtom[] atoms = molUnion.getAtomArray();
        for (int i = unionAtomCount - 1; i >= 0; --i) {
            MolAtom atom = atoms[i];
            if (!HomologyConstants.isHomologyRAtom(atom)) continue;
            int rgNum = atom.getRgroup();
            HomologyConversionUtil.deconvertAtom(atom);
            IntVector rg2remove = new IntVector();
            rg2remove.add(rgNum);
            if (!removeDef || !(mol instanceof RgMolecule)) continue;
            while (rg2remove.size() > 0) {
                RgMolecule rgm = (RgMolecule)mol;
                int rgInd = rgm.findRgroupIndex(rg2remove.removeLast());
                if (rgInd == -1) continue;
                for (int m = rgm.getRgroupMemberCount(rgInd) - 1; m >= 0; --m) {
                    Molecule mmbr = rgm.getRgroupMember(rgInd, m);
                    for (int a = mmbr.getAtomCount() - 1; a >= 0; --a) {
                        int rgID;
                        MolAtom memberAtom = mmbr.getAtom(a);
                        if (memberAtom.getAtno() == 134 && !rg2remove.contains(rgID = memberAtom.getRgroup())) {
                            rg2remove.add(rgID);
                        }
                        if (a != 0) {
                            mmbr.removeAtom(memberAtom);
                            continue;
                        }
                        rgm.removeAtom(memberAtom);
                    }
                }
            }
        }
    }

    public static void deconvertAtom(MolAtom atom) {
        String hgName;
        String alias = atom.getAliasstr();
        if (alias != null && (hgName = HomologyConstants.aliasToHomology(alias)) != null) {
            atom.setAtno(136);
            atom.setAliasstr(hgName);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.print(HELP);
            return;
        }
        int optStrNum = 0;
        boolean enumerate = false;
        boolean query = false;
        if (args[0].indexOf(".") == -1) {
            optStrNum = 1;
            args[0].toLowerCase();
            enumerate = args[0].indexOf("e") != -1;
            query = args[0].indexOf("q") != -1;
        }
        for (int argI = optStrNum; argI < args.length; ++argI) {
            Molecule mol = ConfigUtils.getQueryMolecule(args[argI]);
            HomologyConversionUtil hcu = new HomologyConversionUtil();
            hcu.setMol(mol, enumerate, query);
            Molecule convMol = hcu.getConvertedMol();
            int[] conv2Old = hcu.getMap();
            System.out.println(MolExporter.exportToFormat(convMol, "mrv"));
            System.out.println("\nMap:\n");
            for (int i : conv2Old) {
                System.out.print("\t" + i);
            }
            System.out.println();
        }
    }
}

