/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration.homology;

import chemaxon.common.util.IntVector;
import chemaxon.enumeration.homology.HomologyConversionUtil;
import chemaxon.enumeration.homology.HomologyPropertyRingClassifier;
import chemaxon.enumeration.homology.HomologyPropertyStructureClassifier;
import chemaxon.enumeration.homology.HomologyRingClassifier;
import chemaxon.marvin.util.MolImportUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.Arrays;

class HomologyPropertyEnumerationClassifier
implements HomologyPropertyRingClassifier,
HomologyPropertyStructureClassifier {
    HomologyRingClassifier hrc = null;
    Molecule mol = null;
    private int[] atNoV;
    private int[] attachAtomIndexes;
    private int[][] hgMappableNeighbours;
    private int[] isotopeV;
    private int[] matchableAtoms;
    private int[] atomNumV;
    private int[] bondNumV;

    public HomologyPropertyEnumerationClassifier(Molecule m, boolean classifyRings) {
        this.mol = m;
        if (classifyRings) {
            this.hrc = new HomologyRingClassifier(m);
            int[][] rings = this.hrc.getRings();
            if (rings == null || rings.length == 0) {
                this.hrc = null;
            }
        }
    }

    @Override
    public boolean getFused(int ringIndex) {
        if (this.hrc != null) {
            return this.hrc.getFused(ringIndex);
        }
        return false;
    }

    @Override
    public int getNumberOfRingAtoms(int ringIndex) {
        if (this.hrc != null) {
            return this.hrc.getNumberOfRingAtoms(ringIndex);
        }
        return 0;
    }

    @Override
    public int getNumberOfRings(int ringIndex) {
        if (this.hrc != null) {
            return this.hrc.getNumberOfRings(ringIndex);
        }
        return 0;
    }

    @Override
    public boolean getSaturated(int ringIndex) {
        if (this.hrc != null) {
            return this.hrc.getSaturated(ringIndex);
        }
        return false;
    }

    @Override
    public boolean getUnsaturated(int ringIndex) {
        if (this.hrc != null) {
            return this.hrc.getUnsaturated(ringIndex);
        }
        return false;
    }

    @Override
    public int getAtNoOfAtom(int m) {
        if (this.atNoV == null) {
            this.atNoV = new int[this.mol.getGraphUnion().getAtomCount()];
        }
        if (this.atNoV[m] == 0) {
            this.atNoV[m] = this.mol.getAtom(m).getAtno();
        }
        return this.atNoV[m];
    }

    @Override
    public int[] getAttachAtoms(int strIndex) {
        if (this.attachAtomIndexes == null) {
            MolAtom[] attachAtoms = MolImportUtil.getAtomsWithAttachments(this.mol);
            this.attachAtomIndexes = new int[attachAtoms.length];
            for (int i = 0; i < attachAtoms.length; ++i) {
                this.attachAtomIndexes[i] = this.mol.indexOf(attachAtoms[i]);
            }
        }
        return this.attachAtomIndexes;
    }

    @Override
    public int[] getHgMappableNeighbours(int m) {
        if (this.hgMappableNeighbours == null) {
            this.hgMappableNeighbours = new int[this.mol.getGraphUnion().getAtomCount()][];
        }
        if (this.hgMappableNeighbours[m] == null) {
            MolAtom[] neighs = this.mol.getAtom(m).getLigands();
            IntVector mappableNeighs = new IntVector();
            for (MolAtom neigh : neighs) {
                if (neigh.getAtno() == 138) continue;
                mappableNeighs.add(this.mol.indexOf(neigh));
            }
            this.hgMappableNeighbours[m] = mappableNeighs.toArray();
        }
        return this.hgMappableNeighbours[m];
    }

    @Override
    public int getIsotopeOfAtom(int m) {
        if (this.isotopeV == null) {
            this.isotopeV = new int[this.mol.getGraphUnion().getAtomCount()];
            Arrays.fill(this.isotopeV, -1);
        }
        if (this.isotopeV[m] == -1) {
            this.isotopeV[m] = this.mol.getAtom(m).getMassno();
        }
        return this.isotopeV[m];
    }

    @Override
    public int[] getMatchableAtoms(int strInd) {
        if (this.hrc != null) {
            return this.hrc.getMatchableAtoms(strInd);
        }
        if (this.matchableAtoms == null) {
            this.matchableAtoms = new int[this.mol.getGraphUnion().getAtomCount()];
            for (int i = 0; i < this.matchableAtoms.length; ++i) {
                this.matchableAtoms[i] = i;
            }
        }
        return this.matchableAtoms;
    }

    @Override
    public int[] getNeighbours(int m) {
        return this.getHgMappableNeighbours(m);
    }

    @Override
    public int getQuantityOfAtomType(int strInd, int type) {
        if (this.hrc != null) {
            return this.hrc.getQuantityOfAtomType(strInd, type);
        }
        if (this.atomNumV == null) {
            this.atomNumV = new int[139];
            for (MolAtom atom : this.mol.getAtomArray()) {
                int n = atom.getAtno();
                this.atomNumV[n] = this.atomNumV[n] + 1;
            }
        }
        return this.atomNumV[type];
    }

    @Override
    public int getQuantityOfBonds(int strIndex, int type) {
        if (this.bondNumV == null) {
            this.bondNumV = new int[10];
            for (MolBond bond : this.mol.getBondArray()) {
                int btype = bond.getType();
                if (btype >= 10) continue;
                int n = btype;
                this.bondNumV[n] = this.bondNumV[n] + 1;
            }
        }
        int n = type;
        this.bondNumV[n] = this.bondNumV[n] + HomologyConversionUtil.getAdditionalBondsFromAromatic(strIndex, type, this);
        return this.bondNumV[type];
    }
}

